
/*******************************************************************************
* font
* filename: unsaved
* name: system16
* family: Terminal
* size: 16
* style: Normal
* included characters: !"#$%&'()*+,-./0123456789:;<=>?(a)ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~
* antialiasing: no
* type: proportional
* encoding: CP1250
* unicode bom: no
*
* preset name: Monochrome
* data block size: 8 bit(s), uint8_t
* RLE compression enabled: no
* conversion type: Monochrome, Diffuse Dither 128
* bits per pixel: 1
*
* preprocess:
* main scan direction: left_to_right
* line scan direction: forward
* inverse: yes
*******************************************************************************/

#include <stdint.h>

static const uint8_t image_data_system16_0x20[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x21[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x33, 0xff, 0x33, 0xff, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x22[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x23[24+1] = {
  12, 0x00, 0x00, 0x02, 0x00, 0x1e, 0x10, 0x1f, 0x90, 0x03, 0xf0, 0x02, 0x7e, 0x1e, 0x1e, 0x1f, 0x90, 0x03, 0xf0, 0x02, 0x7e, 0x00, 0x1e, 0x00, 0x10
};

static const uint8_t image_data_system16_0x24[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x04, 0x78, 0x0c, 0xfc, 0x0c, 0xcc, 0x3f, 0xff, 0x3f, 0xff, 0x0c, 0xcc, 0x0f, 0xcc, 0x07, 0x88, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x25[24+1] = {
  12, 0x00, 0x00, 0x30, 0x00, 0x38, 0x38, 0x1c, 0x38, 0x0e, 0x38, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x38, 0xe0, 0x38, 0x70, 0x38, 0x38, 0x00, 0x1c
};

static const uint8_t image_data_system16_0x26[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x3f, 0xb8, 0x31, 0xfc, 0x21, 0xc6, 0x37, 0xe2, 0x1e, 0x3e, 0x1c, 0x1c, 0x36, 0x00, 0x22, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x27[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x3f, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x28[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x0f, 0xfc, 0x1f, 0xfe, 0x38, 0x07, 0x20, 0x01, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x29[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x20, 0x01, 0x38, 0x07, 0x1f, 0xfe, 0x0f, 0xfc, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x2a[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x98, 0x0e, 0xb8, 0x03, 0xe0, 0x0f, 0xf8, 0x0f, 0xf8, 0x03, 0xe0, 0x0e, 0xb8, 0x0c, 0x98, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x2b[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x0f, 0xf0, 0x0f, 0xf0, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x2c[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0x00, 0xf8, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x2d[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x2e[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x2f[24+1] = {
  12, 0x00, 0x00, 0x18, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x00, 0xe0, 0x00, 0x70, 0x00, 0x38, 0x00, 0x1c, 0x00, 0x0e
};

static const uint8_t image_data_system16_0x30[24+1] = {
  12, 0x00, 0x00, 0x07, 0xf8, 0x1f, 0xfe, 0x1e, 0x06, 0x33, 0x03, 0x31, 0x83, 0x30, 0xc3, 0x30, 0x63, 0x30, 0x33, 0x18, 0x1e, 0x1f, 0xfe, 0x07, 0xf8
};

static const uint8_t image_data_system16_0x31[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x30, 0x0c, 0x30, 0x0e, 0x3f, 0xff, 0x3f, 0xff, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x32[24+1] = {
  12, 0x00, 0x00, 0x30, 0x1c, 0x38, 0x1e, 0x3c, 0x07, 0x3e, 0x03, 0x37, 0x03, 0x33, 0x83, 0x31, 0xc3, 0x30, 0xe3, 0x30, 0x77, 0x30, 0x3e, 0x30, 0x1c
};

static const uint8_t image_data_system16_0x33[24+1] = {
  12, 0x00, 0x00, 0x0c, 0x0c, 0x1c, 0x0e, 0x38, 0x07, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x39, 0xe7, 0x1f, 0x7e, 0x0e, 0x3c
};

static const uint8_t image_data_system16_0x34[24+1] = {
  12, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xe0, 0x03, 0x70, 0x03, 0x38, 0x03, 0x1c, 0x03, 0x0e, 0x03, 0x07, 0x3f, 0xff, 0x3f, 0xff, 0x03, 0x00, 0x03, 0x00
};

static const uint8_t image_data_system16_0x35[24+1] = {
  12, 0x00, 0x00, 0x0c, 0x3f, 0x1c, 0x7f, 0x38, 0x63, 0x30, 0x63, 0x30, 0x63, 0x30, 0x63, 0x30, 0x63, 0x30, 0x63, 0x38, 0xe3, 0x1f, 0xc3, 0x0f, 0x83
};

static const uint8_t image_data_system16_0x36[24+1] = {
  12, 0x00, 0x00, 0x0f, 0xc0, 0x1f, 0xf0, 0x39, 0xf8, 0x30, 0xdc, 0x30, 0xce, 0x30, 0xc7, 0x30, 0xc3, 0x30, 0xc3, 0x39, 0xc3, 0x1f, 0x80, 0x0f, 0x00
};

static const uint8_t image_data_system16_0x37[24+1] = {
  12, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x30, 0x03, 0x3c, 0x03, 0x0f, 0x03, 0x03, 0xc3, 0x00, 0xf3, 0x00, 0x3f, 0x00, 0x0f, 0x00, 0x03
};

static const uint8_t image_data_system16_0x38[24+1] = {
  12, 0x00, 0x00, 0x0f, 0x00, 0x1f, 0xbc, 0x39, 0xfe, 0x30, 0xe7, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xe7, 0x39, 0xfe, 0x1f, 0xbc, 0x0f, 0x00
};

static const uint8_t image_data_system16_0x39[24+1] = {
  12, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x7e, 0x30, 0xe7, 0x30, 0xc3, 0x30, 0xc3, 0x38, 0xc3, 0x1c, 0xc3, 0x0e, 0xc3, 0x07, 0xe7, 0x03, 0xfe, 0x00, 0xfc
};

static const uint8_t image_data_system16_0x3a[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x3b[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x70, 0xfc, 0x70, 0x7c, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x3c[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0xe0, 0x03, 0xf0, 0x07, 0x38, 0x0e, 0x1c, 0x1c, 0x0e, 0x38, 0x07, 0x30, 0x03, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x3d[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x00, 0x00
};

static const uint8_t image_data_system16_0x3e[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x30, 0x03, 0x38, 0x07, 0x1c, 0x0e, 0x0e, 0x1c, 0x07, 0x38, 0x03, 0xf0, 0x01, 0xe0, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x3f[24+1] = {
  12, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1e, 0x00, 0x07, 0x00, 0x03, 0x37, 0x83, 0x37, 0xc3, 0x00, 0xe3, 0x00, 0x77, 0x00, 0x3e, 0x00, 0x1c, 0x00, 0x00
};

static const uint8_t image_data_system16_0x40[24+1] = {
  12, 0x00, 0x00, 0x0f, 0xf8, 0x1f, 0xfe, 0x18, 0x07, 0x33, 0xf3, 0x37, 0xfb, 0x36, 0x1b, 0x37, 0xfb, 0x37, 0xfb, 0x36, 0x07, 0x03, 0xfe, 0x01, 0xf8
};

static const uint8_t image_data_system16_0x41[24+1] = {
  12, 0x00, 0x00, 0x38, 0x00, 0x3f, 0x00, 0x07, 0xe0, 0x06, 0xfc, 0x06, 0x1f, 0x06, 0x1f, 0x06, 0xfc, 0x07, 0xe0, 0x3f, 0x00, 0x38, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x42[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xe7, 0x39, 0xfe, 0x1f, 0xbc, 0x0f, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x43[24+1] = {
  12, 0x00, 0x00, 0x03, 0xf0, 0x0f, 0xfc, 0x1c, 0x0e, 0x38, 0x07, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x38, 0x07, 0x1c, 0x0e, 0x0c, 0x0c, 0x00, 0x00
};

static const uint8_t image_data_system16_0x44[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x38, 0x07, 0x1c, 0x0e, 0x0f, 0xfc, 0x03, 0xf0, 0x00, 0x00
};

static const uint8_t image_data_system16_0x45[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0x03, 0x30, 0x03, 0x00, 0x00
};

static const uint8_t image_data_system16_0x46[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0xc3, 0x00, 0xc3, 0x00, 0xc3, 0x00, 0xc3, 0x00, 0xc3, 0x00, 0xc3, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00
};

static const uint8_t image_data_system16_0x47[24+1] = {
  12, 0x00, 0x00, 0x03, 0xf0, 0x0f, 0xfc, 0x1c, 0x0e, 0x38, 0x07, 0x30, 0x03, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x3f, 0xc7, 0x3f, 0xc6, 0x00, 0x00
};

static const uint8_t image_data_system16_0x48[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0x00
};

static const uint8_t image_data_system16_0x49[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x03, 0x30, 0x03, 0x3f, 0xff, 0x3f, 0xff, 0x30, 0x03, 0x30, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x4a[24+1] = {
  12, 0x00, 0x00, 0x0e, 0x00, 0x1e, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0x00, 0x1f, 0xff, 0x07, 0xff, 0x00, 0x00
};

static const uint8_t image_data_system16_0x4b[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0xc0, 0x01, 0xe0, 0x03, 0xf0, 0x07, 0x38, 0x0e, 0x1c, 0x1c, 0x0e, 0x38, 0x07, 0x30, 0x03, 0x00, 0x00
};

static const uint8_t image_data_system16_0x4c[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x4d[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0x1e, 0x00, 0x78, 0x01, 0xe0, 0x01, 0xe0, 0x00, 0x78, 0x00, 0x1e, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0x00
};

static const uint8_t image_data_system16_0x4e[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0x0e, 0x00, 0x38, 0x00, 0xf0, 0x03, 0xc0, 0x07, 0x00, 0x1c, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0x00
};

static const uint8_t image_data_system16_0x4f[24+1] = {
  12, 0x00, 0x00, 0x03, 0xf0, 0x0f, 0xfc, 0x1c, 0x0e, 0x38, 0x07, 0x30, 0x03, 0x30, 0x03, 0x38, 0x07, 0x1c, 0x0e, 0x0f, 0xfc, 0x03, 0xf0, 0x00, 0x00
};

static const uint8_t image_data_system16_0x50[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x01, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01, 0xc7, 0x00, 0xfe, 0x00, 0x7c, 0x00, 0x00
};

static const uint8_t image_data_system16_0x51[24+1] = {
  12, 0x00, 0x00, 0x03, 0xf0, 0x0f, 0xfc, 0x1c, 0x0e, 0x38, 0x07, 0x30, 0x03, 0x36, 0x03, 0x3e, 0x07, 0x1c, 0x0e, 0x3f, 0xfc, 0x33, 0xf0, 0x00, 0x00
};

static const uint8_t image_data_system16_0x52[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x01, 0x83, 0x01, 0x83, 0x03, 0x83, 0x07, 0x83, 0x0f, 0x83, 0x1d, 0xc7, 0x38, 0xfe, 0x30, 0x7c, 0x00, 0x00
};

static const uint8_t image_data_system16_0x53[24+1] = {
  12, 0x00, 0x00, 0x0c, 0x3c, 0x1c, 0x7e, 0x38, 0xe7, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x30, 0xc3, 0x39, 0xc7, 0x1f, 0x8e, 0x0f, 0x0c, 0x00, 0x00
};

static const uint8_t image_data_system16_0x54[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x55[24+1] = {
  12, 0x00, 0x00, 0x07, 0xff, 0x1f, 0xff, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0x00, 0x1f, 0xff, 0x07, 0xff, 0x00, 0x00
};

static const uint8_t image_data_system16_0x56[24+1] = {
  12, 0x00, 0x00, 0x00, 0x07, 0x00, 0x3f, 0x01, 0xf8, 0x0f, 0xc0, 0x3e, 0x00, 0x3e, 0x00, 0x0f, 0xc0, 0x01, 0xf8, 0x00, 0x3f, 0x00, 0x07, 0x00, 0x00
};

static const uint8_t image_data_system16_0x57[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x1c, 0x00, 0x06, 0x00, 0x03, 0x80, 0x03, 0x80, 0x06, 0x00, 0x1c, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0x00
};

static const uint8_t image_data_system16_0x58[24+1] = {
  12, 0x00, 0x00, 0x30, 0x03, 0x3c, 0x0f, 0x0e, 0x1c, 0x03, 0x30, 0x01, 0xe0, 0x01, 0xe0, 0x03, 0x30, 0x0e, 0x1c, 0x3c, 0x0f, 0x30, 0x03, 0x00, 0x00
};

static const uint8_t image_data_system16_0x59[24+1] = {
  12, 0x00, 0x00, 0x00, 0x03, 0x00, 0x0f, 0x00, 0x3c, 0x00, 0xf0, 0x3f, 0xc0, 0x3f, 0xc0, 0x00, 0xf0, 0x00, 0x3c, 0x00, 0x0f, 0x00, 0x03, 0x00, 0x00
};

static const uint8_t image_data_system16_0x5a[24+1] = {
  12, 0x00, 0x00, 0x30, 0x03, 0x3c, 0x03, 0x3e, 0x03, 0x33, 0x03, 0x31, 0xc3, 0x30, 0xe3, 0x30, 0x33, 0x30, 0x1f, 0x30, 0x0f, 0x30, 0x03, 0x00, 0x00
};

static const uint8_t image_data_system16_0x5b[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x5c[24+1] = {
  12, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x18, 0x00
};

static const uint8_t image_data_system16_0x5d[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x5e[24+1] = {
  12, 0x00, 0x00, 0x00, 0x60, 0x00, 0x70, 0x00, 0x38, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00, 0x60
};

static const uint8_t image_data_system16_0x5f[24+1] = {
  12, 0x00, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00
};

static const uint8_t image_data_system16_0x60[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x7e, 0x00, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x61[24+1] = {
  12, 0x00, 0x00, 0x1c, 0x00, 0x3e, 0x40, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x3f, 0xe0, 0x3f, 0xc0, 0x00, 0x00
};

static const uint8_t image_data_system16_0x62[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x30, 0xc0, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x38, 0xe0, 0x1f, 0xc0, 0x0f, 0x80, 0x00, 0x00
};

static const uint8_t image_data_system16_0x63[24+1] = {
  12, 0x00, 0x00, 0x0f, 0x80, 0x1f, 0xc0, 0x38, 0xe0, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x18, 0xc0, 0x08, 0x80, 0x00, 0x00
};

static const uint8_t image_data_system16_0x64[24+1] = {
  12, 0x00, 0x00, 0x0f, 0x80, 0x1f, 0xc0, 0x38, 0xe0, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0xe0, 0x30, 0xc0, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0x00
};

static const uint8_t image_data_system16_0x65[24+1] = {
  12, 0x00, 0x00, 0x0f, 0x80, 0x1f, 0xc0, 0x3b, 0xe0, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x13, 0xc0, 0x01, 0x80, 0x00, 0x00
};

static const uint8_t image_data_system16_0x66[24+1] = {
  12, 0x00, 0x00, 0x00, 0xc0, 0x00, 0xc0, 0x3f, 0xfc, 0x3f, 0xfe, 0x00, 0xc7, 0x00, 0xc3, 0x00, 0xc3, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x67[24+1] = {
  12, 0x00, 0x00, 0x03, 0x80, 0xc7, 0xc0, 0xce, 0xe0, 0xcc, 0x60, 0xcc, 0x60, 0xcc, 0x60, 0xcc, 0x60, 0xe6, 0x60, 0x7f, 0xe0, 0x3f, 0xe0, 0x00, 0x00
};

static const uint8_t image_data_system16_0x68[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x00, 0xc0, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xe0, 0x3f, 0xc0, 0x3f, 0x80, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x69[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x60, 0x3f, 0xec, 0x3f, 0xec, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x6a[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xe0, 0x00, 0xc0, 0x00, 0xc0, 0x60, 0xff, 0xec, 0x7f, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x6b[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff, 0x03, 0x00, 0x07, 0x80, 0x0f, 0xc0, 0x1c, 0xe0, 0x38, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x6c[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x03, 0x3f, 0xff, 0x3f, 0xff, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x6d[24+1] = {
  12, 0x00, 0x00, 0x3f, 0xe0, 0x3f, 0xc0, 0x00, 0xe0, 0x00, 0xe0, 0x3f, 0xc0, 0x3f, 0xc0, 0x00, 0xe0, 0x00, 0xe0, 0x3f, 0xc0, 0x3f, 0x80, 0x00, 0x00
};

static const uint8_t image_data_system16_0x6e[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xe0, 0x3f, 0xe0, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xe0, 0x3f, 0xc0, 0x3f, 0x80, 0x00, 0x00
};

static const uint8_t image_data_system16_0x6f[24+1] = {
  12, 0x00, 0x00, 0x0f, 0x80, 0x1f, 0xc0, 0x38, 0xe0, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x38, 0xe0, 0x1f, 0xc0, 0x0f, 0x80, 0x00, 0x00
};

static const uint8_t image_data_system16_0x70[24+1] = {
  12, 0x00, 0x00, 0xff, 0xe0, 0xff, 0xe0, 0x0c, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x1c, 0xe0, 0x0f, 0xc0, 0x07, 0x80, 0x00, 0x00
};

static const uint8_t image_data_system16_0x71[24+1] = {
  12, 0x00, 0x00, 0x07, 0x80, 0x0f, 0xc0, 0x1c, 0xe0, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x0c, 0x60, 0xff, 0xe0, 0xff, 0xe0, 0x00, 0x00
};

static const uint8_t image_data_system16_0x72[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xe0, 0x3f, 0xe0, 0x00, 0xc0, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xe0, 0x00, 0xc0, 0x00, 0x00
};

static const uint8_t image_data_system16_0x73[24+1] = {
  12, 0x00, 0x00, 0x11, 0xc0, 0x33, 0xe0, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x3f, 0x60, 0x1e, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x74[24+1] = {
  12, 0x00, 0x00, 0x00, 0x60, 0x00, 0x60, 0x1f, 0xfe, 0x3f, 0xfe, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x75[24+1] = {
  12, 0x00, 0x00, 0x0f, 0xe0, 0x1f, 0xe0, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x18, 0x00, 0x3f, 0xe0, 0x3f, 0xe0, 0x00, 0x00
};

static const uint8_t image_data_system16_0x76[24+1] = {
  12, 0x00, 0x00, 0x00, 0x60, 0x01, 0xe0, 0x07, 0x80, 0x1e, 0x00, 0x38, 0x00, 0x38, 0x00, 0x1e, 0x00, 0x07, 0x80, 0x01, 0xe0, 0x00, 0x60, 0x00, 0x00
};

static const uint8_t image_data_system16_0x77[24+1] = {
  12, 0x00, 0x00, 0x07, 0xe0, 0x1f, 0xe0, 0x38, 0x00, 0x1c, 0x00, 0x0f, 0xe0, 0x0f, 0xe0, 0x1c, 0x00, 0x38, 0x00, 0x1f, 0xe0, 0x07, 0xe0, 0x00, 0x00
};

static const uint8_t image_data_system16_0x78[24+1] = {
  12, 0x00, 0x00, 0x30, 0x60, 0x38, 0xe0, 0x1d, 0xc0, 0x0f, 0x80, 0x07, 0x00, 0x0f, 0x80, 0x1d, 0xc0, 0x38, 0xe0, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x79[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x81, 0xe0, 0xe7, 0x80, 0x7e, 0x00, 0x1e, 0x00, 0x07, 0x80, 0x01, 0xe0, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x7a[24+1] = {
  12, 0x00, 0x00, 0x30, 0x60, 0x38, 0x60, 0x3c, 0x60, 0x36, 0x60, 0x33, 0x60, 0x31, 0xe0, 0x30, 0xe0, 0x30, 0x60, 0x30, 0x20, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x7b[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0xc0, 0x1f, 0xfc, 0x3f, 0x7e, 0x70, 0x07, 0x60, 0x03, 0x60, 0x03, 0x60, 0x03, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x7c[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xbf, 0x3f, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x7d[24+1] = {
  12, 0x00, 0x00, 0x00, 0x00, 0x60, 0x03, 0x60, 0x03, 0x60, 0x03, 0x70, 0x07, 0x3f, 0x7e, 0x1f, 0xfc, 0x01, 0xc0, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00
};

static const uint8_t image_data_system16_0x7e[24+1] = {
  12, 0x00, 0x00, 0x00, 0x10, 0x00, 0x18, 0x00, 0x0c, 0x00, 0x04, 0x00, 0x0c, 0x00, 0x18, 0x00, 0x10, 0x00, 0x18, 0x00, 0x0c, 0x00, 0x04, 0x00, 0x00
};


const uint8_t* const system16_array[] = {(const uint8_t *)16, (const uint8_t *)95,

 image_data_system16_0x20,  // character: ' '

 image_data_system16_0x21,  // character: '!'

 image_data_system16_0x22,  // character: '"'

 image_data_system16_0x23,  // character: '#'

 image_data_system16_0x24,  // character: '$'

 image_data_system16_0x25,  // character: '%'

 image_data_system16_0x26,  // character: '&'

 image_data_system16_0x27,  // character: '''

 image_data_system16_0x28,  // character: '('

 image_data_system16_0x29,  // character: ')'

 image_data_system16_0x2a,  // character: '*'

 image_data_system16_0x2b,  // character: '+'

 image_data_system16_0x2c,  // character: ','

 image_data_system16_0x2d,  // character: '-'

 image_data_system16_0x2e,  // character: '.'

 image_data_system16_0x2f,  // character: '/'

 image_data_system16_0x30,  // character: '0'

 image_data_system16_0x31,  // character: '1'

 image_data_system16_0x32,  // character: '2'

 image_data_system16_0x33,  // character: '3'

 image_data_system16_0x34,  // character: '4'

 image_data_system16_0x35,  // character: '5'

 image_data_system16_0x36,  // character: '6'

 image_data_system16_0x37,  // character: '7'

 image_data_system16_0x38,  // character: '8'

 image_data_system16_0x39,  // character: '9'

 image_data_system16_0x3a,  // character: ':'

 image_data_system16_0x3b,  // character: ';'

 image_data_system16_0x3c,  // character: '<'

 image_data_system16_0x3d,  // character: '='

 image_data_system16_0x3e,  // character: '>'

 image_data_system16_0x3f,  // character: '?'

 image_data_system16_0x40,  // character: '(a)'

 image_data_system16_0x41,  // character: 'A'

 image_data_system16_0x42,  // character: 'B'

 image_data_system16_0x43,  // character: 'C'

 image_data_system16_0x44,  // character: 'D'

 image_data_system16_0x45,  // character: 'E'

 image_data_system16_0x46,  // character: 'F'

 image_data_system16_0x47,  // character: 'G'

 image_data_system16_0x48,  // character: 'H'

 image_data_system16_0x49,  // character: 'I'

 image_data_system16_0x4a,  // character: 'J'

 image_data_system16_0x4b,  // character: 'K'

 image_data_system16_0x4c,  // character: 'L'

 image_data_system16_0x4d,  // character: 'M'

 image_data_system16_0x4e,  // character: 'N'

 image_data_system16_0x4f,  // character: 'O'

 image_data_system16_0x50,  // character: 'P'

 image_data_system16_0x51,  // character: 'Q'

 image_data_system16_0x52,  // character: 'R'

 image_data_system16_0x53,  // character: 'S'

 image_data_system16_0x54,  // character: 'T'

 image_data_system16_0x55,  // character: 'U'

 image_data_system16_0x56,  // character: 'V'

 image_data_system16_0x57,  // character: 'W'

 image_data_system16_0x58,  // character: 'X'

 image_data_system16_0x59,  // character: 'Y'

 image_data_system16_0x5a,  // character: 'Z'

 image_data_system16_0x5b,  // character: '['

 image_data_system16_0x5c,  // character: '\'

 image_data_system16_0x5d,  // character: ']'

 image_data_system16_0x5e,  // character: '^'

 image_data_system16_0x5f,  // character: '_'

 image_data_system16_0x60,  // character: '`'

 image_data_system16_0x61,  // character: 'a'

 image_data_system16_0x62,  // character: 'b'

 image_data_system16_0x63,  // character: 'c'

 image_data_system16_0x64,  // character: 'd'

 image_data_system16_0x65,  // character: 'e'

 image_data_system16_0x66,  // character: 'f'

 image_data_system16_0x67,  // character: 'g'

 image_data_system16_0x68,  // character: 'h'

 image_data_system16_0x69,  // character: 'i'

 image_data_system16_0x6a,  // character: 'j'

 image_data_system16_0x6b,  // character: 'k'

 image_data_system16_0x6c,  // character: 'l'

 image_data_system16_0x6d,  // character: 'm'

 image_data_system16_0x6e,  // character: 'n'

 image_data_system16_0x6f,  // character: 'o'

 image_data_system16_0x70,  // character: 'p'

 image_data_system16_0x71,  // character: 'q'

 image_data_system16_0x72,  // character: 'r'

 image_data_system16_0x73,  // character: 's'

 image_data_system16_0x74,  // character: 't'

 image_data_system16_0x75,  // character: 'u'

 image_data_system16_0x76,  // character: 'v'

 image_data_system16_0x77,  // character: 'w'

 image_data_system16_0x78,  // character: 'x'

 image_data_system16_0x79,  // character: 'y'

 image_data_system16_0x7a,  // character: 'z'

 image_data_system16_0x7b,  // character: '{'

 image_data_system16_0x7c,  // character: '|'

 image_data_system16_0x7d,  // character: '}'

 image_data_system16_0x7e  // character: '~'

};

