/* 
 * Program, ktory zapala diode LED po nacisnieciu przycisku.
 * Zawiera softwarowy debouncing przycisku.
 * Autor: Miguel Garcia-Ruiz. 
 * Kod bazuje na tej stronie: https://www.arduino.cc/en/Tutorial/BuiltInExamples/Debounce
 * Wersja: 1.0
 * Data: October 19, 2020
 
 
 * PROGRAM JEST OFEROWANY “TAK JAK JEST”, BEZ JAKICHKOLWIEK GWARANCJI WYRAZONYCH
 * WPROST LUB DOROZUMIANYCH, W TYM BEZ GWARANCJI WARTOSCI HANDLOWEJ I PRZYDATNOSCI
 * DO OKRESLONEGO CELU ORAZ BEZ GWARANCJI NIENARUSZENIA PRAW AUTORSKICH.
 * AUTRZY LUB POSIADACZE PRAW AUTORSKICH NIE PONOSZA ZADNEJ
 * ODPOWIEDZIALNOSCI ZA JAKIEKOLWIEK ROSZCZENIA, SZKODY LUB INNE PROBLEMY
 * WYNIKAJACE Z NARUSZENIA KONTRAKTU, KODEKSU CYWILNEGO CZY INNYCH PRAW,
 * A MAJACE ZWIAZEK Z PROGRAMEM LUB JEGO UZYCIEM.
 
 
*/
#define PinLED PB12
#define Pinprzycisku PB0
void setup() {
  pinMode(PinLED, OUTPUT);
  pinMode(Pinprzycisku, INPUT_PULLUP);
}
int odczyt_przycisku;
int stanLED = HIGH;         // obecny stan pinu wyjsciowego
int stanprzycisku;             // obecny odczyt z pinu wejsciowego
int ostatnistanprzycisku = LOW;   // poprzedni odczyt z pinu wejsciowego
unsigned long ostatniczasdebouncingu = 0;  // ostatni raz, gdy pin wyjsciowy zostal zmieniony
unsigned long opoznieniedebouncingu = 50;    // czas debouncingu; zwieksz w przypadku wahan na wyjsciu
  
void loop() {

odczyt_przycisku=digitalRead(Pinprzycisku);
// sprawdz, czy przycisk zostal nacisniety
// (np. czy wejscie zmienilo sie z LOW na HIGH) i czy odczekales odpowiednio dlugo
// od ostatniego nacisniecia zeby zignorowac wszelki szum:

// Jesli stan sie zmienil z powodu nacisniecia lub szumu:
if (odczyt_przycisku!= ostatnistanprzycisku) {
// zresetuj timer debouncingu
    ostatniczasdebouncingu = millis();
}
if ((millis() - ostatniczasdebouncingu) > opoznieniedebouncingu) {
// niezaleznie od stanu jest on obecny dluzej niz opoznienie
// debouncingu, wiec przyjmij go jako obecny stan:

// jesli stan przycisku sie zmienil:
    if (odczyt_przycisku!=stanprzycisku) {
      stanprzycisku = odczyt_przycisku;
      // zmien stan LED tylko wtedy, gdy nowy stan przycisku to HIGH
      if (stanprzycisku == HIGH) {
        stanLED = !stanLED;
      }
    }
  }

// ustaw LED:
digitalWrite(PinLED, stanLED);
// zapisz odczyt. Przy nastepnym przejsciu przez petle, bedzie to ostatnistanprzycisku:
ostatnistanprzycisku = odczyt_przycisku;
}
