/**
  Kreatywny projekt mikrokontrolerowy w C, opublikowany przez Packt
  Rozdzial 13: Alarm dystansu spolecznego.
  Kod uruchamiajacy dzwiek brzeczyka za pomoca
  STM32 Blue Pill
  Autor: Pedro Santana
  Wersja 1.
  Kwiecien 2021 
*/

const int pinTrig = PC14;
const int pinEcho = PC13;
const int pinBrzeczyka = PB12;
const int bezpDystans = 200;

long czasFali;
long zmierzonaOdleglosc;

void setup() {
  Serial.begin(9600);
  pinMode(pinTrig, OUTPUT);
  pinMode(pinEcho, INPUT);
  digitalWrite(pinTrig, LOW);
}

void loop()
{
  digitalWrite(pinTrig, HIGH);
  delayMicroseconds(10); 
  digitalWrite(pinTrig, LOW);
  
  czasFali = pulseIn(pinEcho, HIGH);
  zmierzonaOdleglosc = czasFali/59;

  Serial.print("Odleglosc: ");
  Serial.print(zmierzonaOdleglosc);
  Serial.println("cm");
  delay(500);

  if (zmierzonaOdleglosc < bezpDystans) {
    Serial.println("Alarm dzwiekowy");
    tone(pinBrzeczyka, 1200);
    delay(250);
  
    noTone(pinBrzeczyka);
    delay(500);
  
    tone(pinBrzeczyka, 800);
    delay(250);
  
    noTone(pinBrzeczyka);
    delay(500);
  }
}
