/**
  Kreatywny projekt mikrokontrolerowy DIY w języku C, opublikowany przez Packt
  Rozdzial 7.: Przelacznik akustyczny: wykrywanie prostym mikrofonem dwoch klasniec z rzedu.
  Cwiczenie 1.: Dioda zaswieci sie na chwile po wykryciu klasniecia przez mikrofon.
  Wersja: 2
  Maj 2021
*/

const int MicPinAnalogowy = 0;                   // analogowy pin wejściowy
const int LedPinCyfrowy = PC13;               // cyfrowy pin wyjściowy
const int ProgKlasniecia = 300;                // minimalna wykrywana glosnosc

void setup() {
  Serial.begin(9600);                         // inicjuje transmisję szeregowa, ustawia predkosc 9600 bps
  pinMode(LedPinCyfrowy, OUTPUT);             // ustawia pin cyfrowy jako wyjscie
  pinMode(MicPinAnalogowy, INPUT);               // ustawia pin analogowy jako wejscie
}

void loop() {
  int SilaDzwieku = analogRead(MicPinAnalogowy);  // odczytuje dane z pinu analogowego
  Serial.print("Sila dzwieku: ");              // informacja debugujaca
  Serial.println(SilaDzwieku);
  if (SilaDzwieku > ProgKlasniecia) {           // wykryto klasniecie?
    Serial.println("Wykryto klasniecie");    // informacja debugujaca
    digitalWrite(LedPinCyfrowy, HIGH);        // wlacza diode LED
    delay(1000);                               // sekunda przerwy
  } else {
    Serial.println("Brak klasniecia");       // informacja debugujaca
    digitalWrite(LedPinCyfrowy, LOW);         // wylacza diode LED    
  }
}
