/*
 * Kod, ktory odczytuje dane o temperaturze z Arduino Uno (urzadzenia peryferyjnego) i wyswietla je na
 * wyswietlaczu LCD, wykorzystujac magistrale I2C
 * To jest kod dla Blue Pill (kontrolera).
 * Autor: Miguel Garcia-Ruiz
 * 3 luty 2021
 * Wersja 1.
 * 
* PROGRAM JEST OFEROWANY “TAK JAK JEST”, BEZ JAKICHKOLWIEK GWARANCJI WYRAZONYCH
 * WPROST LUB DOROZUMIANYCH, W TYM BEZ GWARANCJI WARTOSCI HANDLOWEJ I PRZYDATNOSCI
 * DO OKRESLONEGO CELU ORAZ BEZ GWARANCJI NIENARUSZENIA PRAW AUTORSKICH.
 * AUTRZY LUB POSIADACZE PRAW AUTORSKICH NIE PONOSZA ZADNEJ
 * ODPOWIEDZIALNOSCI ZA JAKIEKOLWIEK ROSZCZENIA, SZKODY LUB INNE PROBLEMY
 * WYNIKAJACE Z NARUSZENIA KONTRAKTU, KODEKSU CYWILNEGO CZY INNYCH PRAW,
 * A MAJACE ZWIAZEK Z PROGRAMEM LUB JEGO UZYCIEM.
 */
#include <LiquidCrystal_I2C.h> //biblioteka kontrolujaca wyswietlacz LCD na magistrali I2C
LiquidCrystal_I2C lcd(0x27, 16, 2);// Ustawia adres LCD jako 0x27 oraz 16 znakow and 2 linijki
//Biblioteke znajdziesz pod adresem: https://github.com/fdebrabander/Arduino-LiquidCrystal-I2C-library

#include <Wire.h> //biblioteka kontrolujaca protokol I2C
#define ADRESSLAVE 0x8  //adres Arduino Uno jako urzadzenia peryferyjnego (slave)
void setup() {
  Wire.begin(ADRESSLAVE); //inicjuje polaczenie I2C wykorzystujac adres urzadzenia peryferyjnego (slave). 
  Serial.begin(9600); //dane o temperaturze beda takze wyswieltane w monitorze portu szeregowego Arduino IDE
  lcd.begin();  //inicjuje LCD
  lcd.backlight(); // wlacza podswietlenie LCD
}

void loop() {
   Wire.requestFrom(8, 4);//Urzadzenie master prosi o bajty z urzadzenia peryferyjnego (slave), czyli z Arduino Uno.
                          //Bajty sa nastepnie wydobywane za pomoca funkcji read(). 
                          //Skladnia: Wire.requestFrom(adres, ilosc); 
   
   uint8_t index = 0;

//Ponizszy fragment kodu bazuje na: https://medium.com/@sandhan.sarma/sending-floats-over-the-i2c-bus-between-two-arduinos-part-2-486db6dc479f
//Ponizej deklarujemy wlasna strukture danych (unie) o nazwie floatNaBajty.
//Deklarujemy takze nazwe tej unii (konwerter). 
//Unia floatNaBajty zawiera dwie zmienne: jedna jest tablica znakow char, a druga to float.
//Zarowno odczytTemp, jak i bufor zajmuja to samo miejsce w pamieci, 4 elementy bufora wskazuja na te same 4 bajty naszej zmiennej float o nazwie odczytTemp:
   union floatNaBajty {
       char bufor[4];
       float odczytTemp; 
   } konwerter;

   while (Wire.available()){ //Zwraca # bajtow dostepnych do odczytu za pomoca funkcji read()
      konwerter.bufor[index] = Wire.read(); //odbiera zmienna bufor jako argument funkcji Wire.write()
      index++;
   }

   Serial.println(konwerter.odczytTemp); //pokazuje temperature w monitorze portu szeregowego
   lcd.setCursor(0, 0); // ustawia kursor LCD w kolumnie 0 i rzedzie 0 
   lcd.print("Temp. ciala:"); 
   lcd.print(konwerter.odczytTemp); //wyswietla temperature na LCD w stopniach Celsjusza
   delay(500);
}
