/**
  Kreatywny projekt mikrokontrolerowy DIY w jezyku C, opublikowany przez Packt
  Rozdzial 10: IoT - czujnik nawilzenia rosliny.
  Odczyt wartosci czujnika z Blue Pill
  i stworzenie serwera na NodeMCU do wyswietlenia danych.
  Autor: Pedro Santana
  Wersja 1.
  Kwiecien 2021
*/
#include <ESP8266WiFi.h>

const char* ssid = "SSID";
const char* haslo = "Twoje_haslo";
WiFiServer server(80);

const int PinZBluePill = 4; //D2 GPIO4
int wartoscCzujnika = 2; // 0: Wilgotno, 1: Sucho, 2: Bez odczytu
String header;
unsigned long aktualnyCzas = millis();
unsigned long poprzedniCzas = 0; 
const long czasPrzedawnienia = 2000;

void setup() {
  Serial.begin(115200);
  pinMode(PinZBluePill, INPUT);
  Serial.print("Laczenie z siecia Wi-Fi: ");
  Serial.println(ssid);
  WiFi.begin(ssid, haslo);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.println("Polaczono z Wi-Fi.");
  Serial.println("Adres IP: ");
  Serial.println(WiFi.localIP());
  server.begin();
}

void loop(){
  WiFiClient client = server.available();

  if (client) {
    Serial.println("Nowy klient.");
    String currentLine = "";
    aktualnyCzas = millis();
    poprzedniCzas = aktualnyCzas;
    while (client.connected() && aktualnyCzas - poprzedniCzas <= czasPrzedawnienia) {
      aktualnyCzas = millis();         
      if (client.available()) {
        char c = client.read();
        Serial.write(c);
        header += c;
        if (c == '\n') {
          if (currentLine.length() == 0) {
            client.println("HTTP/1.1 200 OK");
            client.println("Content-type:text/html");
            client.println("Connection: close");
            client.println();

            if (header.indexOf("GET /4/read") >= 0) {
              Serial.println("Odczyt czujnika");
              wartoscCzujnika = digitalRead(PinZBluePill);
            }

            client.println("<!DOCTYPE html><html>");
            client.println("<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
            client.println("<title>IoT - pomiar wilgotnosci gleby</title>");
            client.println("<link rel=\"stylesheet\" href=\"https://use.fontawesome.com/releases/v5.7.2/css/all.css\" crossorigin=\"anonymous\">");
            client.println("<link rel=\"icon\" href=\"data:,\">");
            client.println("<style>html { font-family: Helvetica; display: inline-block; margin: 0px auto; text-align: center;}");
            client.println(".sensorButton { background-color:#f9f9f9; border-radius:6px; border:1px solid #dcdcdc; display:inline-block;");
            client.println("cursor:pointer; color:#666666; font-size:24px; padding:12px 30px; text-decoration:none; }");
            client.println(".sensorButton:hover { background-color:#e9e9e9; }");
            client.println(".sensorButton:active { position:relative; top:1px; }");
            client.println("</style></head>");

            client.println("<body><h1>IoT - pomiar wilgotnosci gleby</h1>");

            if (wartoscCzujnika == 1) {
              client.println("<p>Ziemia jest zbyt sucha</p>");
              client.println("<p><img width=\"50\" height=\"60\" src=\"https://raw.githubusercontent.com/PacktPublishing/Creative-DIY-Microcontroller-Projects/master/Chapter10/images/dry_plant.png\"></p>");
            } else if (wartoscCzujnika == 0)  {
              client.println("<p>Ziemia jest odpowiednio wilgotna</p>");
              client.println("<p><img width=\"50\" height=\"60\" src=\"https://raw.githubusercontent.com/PacktPublishing/Creative-DIY-Microcontroller-Projects/master/Chapter10/images/green_plant.png\"></p>");
            } else {
              client.println("<p>Kliknij przycisk, by odczytac czujnik</p>");
            }

            client.println("<p><a href=\"/4/read\"><button class=\"sensorButton\"><i class=\"fas fa-satellite-dish\"></i> Odczytaj czujnik</button></a></p>");

            client.println("</body></html>");

            client.println();
            break;
          } else {
            currentLine = "";
          }
        } else if (c != '\r') {
          currentLine += c;
        }
      }
    }
    header = "";
    client.stop();
    Serial.println("Klient sie rozlaczyl.");
    Serial.println("");
  }
}
