/* program odczytujacy temperature i wilgotnosc z czujnika DHT11.
 * Autor: Miguel Garcia-Ruiz
 * 7 listopada 2020
 * Wersja 1.
 * Aby otworzyc monitor portu szeregowego, kliknij Narzedzia/Monitor Portu Szeregowego
 * na pasku menu Arduino IDE. Upewnij sie, ze port jest ustawiony na 9600 Baudow.

* PROGRAM JEST OFEROWANY “TAK JAK JEST”, BEZ JAKICHKOLWIEK GWARANCJI WYRAZONYCH
 * WPROST LUB DOROZUMIANYCH, W TYM BEZ GWARANCJI WARTOSCI HANDLOWEJ I PRZYDATNOSCI
 * DO OKRESLONEGO CELU ORAZ BEZ GWARANCJI NIENARUSZENIA PRAW AUTORSKICH.
 * AUTRZY LUB POSIADACZE PRAW AUTORSKICH NIE PONOSZA ZADNEJ
 * ODPOWIEDZIALNOSCI ZA JAKIEKOLWIEK ROSZCZENIA, SZKODY LUB INNE PROBLEMY
 * WYNIKAJACE Z NARUSZENIA KONTRAKTU, KODEKSU CYWILNEGO CZY INNYCH PRAW,
 * A MAJACE ZWIAZEK Z PROGRAMEM LUB JEGO UZYCIEM.

*/
#include <DHT.h> //biblioteka do odczytywania wartosci z DHT11
#define DHT11_pin_danych PB12 /* Pin danych (sygnalowy) DHT11 jest podlaczony do pinu B12 Blue Pill*/
DHT dht(DHT11_pin_danych, DHT11); // Ustawia DHT11
void setup() {
    Serial.begin(9600); //Inicjalizuje port szeregowy
    while (!Serial);
    Serial.println("Otwieram port szer.");

    dht.begin(); //Inicjalizuje bibliotekę DHT11
}

void loop() {
    float wilgotnosc = dht.readHumidity(); //odbiera wartosc wilgotnosci z DHT11
    float temperatura=dht.readTemperature(); //odbiera wartosc temperatury z DHT11
    Serial.println("Wilgotnosc: "+String(wilgotnosc)); //wyswietla wilgotnosc w oknie monitora portu szeregowego Arduino IDE
    Serial.println("Temperatura: "+String(temperatura)); //wyswietla temperature w oknie monitora portu szeregowego Arduino IDE
    delay(1000); //czeka 1 sekunde przed ponownym odczytem wilgotnosci i temperatury
}
