/**
  Kreatywny projekt mikrokontrolerowy DIY w jezyku C, opublikowany przez Packt
  Rozdzial 9: IoT - system rejestrujacy temperature.
  Odczyt wartosci z czujnika za pomoca SMT32 Blue Pill 
  and stworzenie na ESP-01 serwera do wyswietlania danych.
  Autor: Pedro Santana
  Wersja 2.
  Maj 2021
*/

#include <DallasTemperature.h>
#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
 
const char* ssid = "ssid";
const char* haslo = "haslo";

#define pinJednoprzewodowy 0
OneWire pinCzujnika(pinJednoprzewodowy);
DallasTemperature sensors(&pinCzujnika);
 
String strFrm = "<form action='read'><input type='submit' value='Odczytaj czujnik'></form>";
 
ESP8266WebServer server(80);
 
void odczyt_czujnika() {
  Serial.print("Odczytuje czujnik: ");
  sensors.requestTemperatures();
  int temp = sensors.getTempCByIndex(0);
  Serial.println(temp);
  server.send(200, "text/plain", String("Temperatura: ") + String(temp));
}
 
void setup(void) {
  Serial.begin(115200);
  sensors.begin();
  WiFi.softAP(ssid, haslo);
  Serial.print("Polaczono, adres IP: ");
  Serial.println(WiFi.localIP());
  
  server.on("/", [](){
    Serial.println("Polaczenie przychodzace z serwerem");
    server.send(200, "text/html", strFrm);
  });
  
  server.on("/read", odczyt_czujnika);
  
  server.begin();
}
 
void loop(void) {
  server.handleClient();
}
