/* program odczytujacy temperature i wilgotnosc z czujnika DHT11.
 * Wilgotnosc i temperatura sa wyswietlane na ekranie LCD 1602 16x2 
 * Autor: Miguel Garcia-Ruiz
 * 17 listopada 2020
 * Wersja 1.

* PROGRAM JEST OFEROWANY “TAK JAK JEST”, BEZ JAKICHKOLWIEK GWARANCJI WYRAZONYCH
 * WPROST LUB DOROZUMIANYCH, W TYM BEZ GWARANCJI WARTOSCI HANDLOWEJ I PRZYDATNOSCI
 * DO OKRESLONEGO CELU ORAZ BEZ GWARANCJI NIENARUSZENIA PRAW AUTORSKICH.
 * AUTRZY LUB POSIADACZE PRAW AUTORSKICH NIE PONOSZA ZADNEJ
 * ODPOWIEDZIALNOSCI ZA JAKIEKOLWIEK ROSZCZENIA, SZKODY LUB INNE PROBLEMY
 * WYNIKAJACE Z NARUSZENIA KONTRAKTU, KODEKSU CYWILNEGO CZY INNYCH PRAW,
 * A MAJACE ZWIAZEK Z PROGRAMEM LUB JEGO UZYCIEM.

*/
#include <DHT.h> //biblioteka do odczytywania danych z DHT11
#include <math.h> //biblioteka dla funkcji round()
#include <LiquidCrystal.h> /biblioteka do korzystania z LCD 1602
/*
* Pin VSS LCD do GND
* Pin VDD LCD do 5V
* Pin VO LCD do potencjometru (rezystora o zmiennej rezystancji)
* Pin RS LCD do pinu wejscia cyfrowego PB11
* Pin RW LCD do GND
* Pin EN LCD do pinu wejscia cyfrowego PB10
* Piny LCD od D0 to D3 sa nieuzywane
* Pin D4 LCD do pinu wejscia cyfrowego PB0
* Pin D5 LCD do pinu wejscia cyfrowego PA7
* Pin D6 LCD do pinu wejscia cyfrowego PA6
* Pin D7 LCD do pinu wejscia cyfrowego PA5
* Pin BL+ LCD do 5V
* Pin BL- LCD do GND
*/
const int rs = PB11, en = PB10, d4 = PB0, d5 = PA7,
    d6 = PA6, d7 = PA5;
LiquidCrystal lcd(rs, en, d4, d5, d6, d7); //definiuje piny danych wyswietlacza LCD
#define DHT11_pin_danych PB12 /* nozka sygnalowa (danych cyfrowych) DHT11 jest podlaczona do pinu B12*/
DHT dht(DHT11_pin_danych, DHT11); //ustawia DHT11

void setup() {
    dht.begin(); //inicjalizuje biblioteke DHT11
    lcd.begin(16, 2); //inicjalizuje LCD
}
void loop() {
    float wilgotnosc = dht.readHumidity(); //pobiera wilgotnosc z czujnika DHT11
    float temperatura=dht.readTemperature(); //pobiera temperature z czujnika DHT11
    lcd.setCursor(0, 0); //kolumna 0, rzad 0 na LCD
    lcd.print("Wilgotnosc: "+String(round(wilgotnosc))+"%   "); //wyswietla wilgotnosc na ekranie LCD 
    lcd.setCursor(0,1); //kolumna 0, rzad 1 na LCD
    lcd.print("Temp.: "+String(temperatura)+"C   "); //wyswietla temperature na ekranie LCD
    delay(1000); //czeka 1 sekunde przed pobraniem nowych danych o wilgotnosci i temperaturze
}
