/* Program, ktory demonstruje, jak nadac sygnal SOS kodem Morse’a za pomocą superjasnej diody LED podlaczonej do portu wyjsciowego Curiosity Nano
 * Autor: Miguel Garcia-Ruiz
 * 10 grudnia 2020
 * Wersja: 1.0
 */

#include "mcc_generated_files/mcc.h"

const int czas_kropki=150; //czas trwania kropki w milisekundach
const int czas_kreski=czas_kropki*3; //czas kreski w milisekundach. Kreska trwa trzy razy dluzej niz kropka.
const int czas_malej_spacji=150; // odstep miedzy literami
const int czas_spacji=czas_kropki*7;//slowa sa oddzielone przerwa o dlugosci siedmiu kropek
         
void malaspacja() {
          __delay_ms(czas_malej_spacji);
} // krotka spacja miedzy literami

void spacja() {
         __delay_ms(czas_spacji);
} //spacja miedzy slowami

void kropka() { //zdefiniowanie kropki jako krotkiej jednostki sygnalowej
          IO_RD3_SetHigh(); 
          __delay_ms(czas_kropki); 
          IO_RD3_SetLow(); 
          __delay_ms(czas_kropki); 
}
           
void kreska() { //zdefiniowanie kreski zlozonej z trzech jednostek sygnalowych
          IO_RD3_SetHigh();  
          __delay_ms(czas_kreski); 
          IO_RD3_SetLow();
          __delay_ms(czas_kreski); 
}

void S() { // zdefiniowanie litery S
          kropka();
          kropka();
          kropka();
          malaspacja();
}
         
void O() { // zdefiniowanie litery O
          kreska();
          kreska();
          kreska();
          malaspacja();
}

void main(void)
{
    // inicjalizacja urzadzenia
    SYSTEM_Initialize();
    IO_RD3_SetLow(); //inicjalizacja portu RD3 z niskim sygnalem.
    while (1) //petla nieskonczona
    {
      S(); O(); S(); //komunikat SOS ("Save Our Souls") 
      spacja();  // odstep miedzy poszczegolnymi komunikatami zlozony z siedmiu kropek       
    }
}
/**
 Koniec pliku
*/