{*************************************************************}
{                     Modul ROROLIP                           }
{  PROCEDURY ROZWIAZYWANIA UKLADU N ROWNAN ROZNICZKOWYCH      }
{            LINIOWYCH O STALYCH WSPOLCZYNNIKACH              }
{                zapis rozwiazania do pliku                   }
{                 Turbo Pascal  wersja 7.0                    }
{                   autor Bernard Baron                       }
{*************************************************************}
UNIT ROROLIP;
  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
  {$F+}
 INTERFACE
   USES CRT,TFLOAT,ALGELIN,PLIK_ZO;

  TYPE  WEK8    =ARRAY[0..8] OF WEK;
        PROCWYM =PROCEDURE(VAR U  :WEK;
                               t1 :REAL;
                               N  :BYTE);
        PROCXT =PROCEDURE(VAR F:WEK;
                              X:WEK;
                              t:FLOAT;
                              N:BYTE);



  PROCEDURE RURRLIN(    P        :BYTE;
                        WU       :PROCWYM;
                    VAR A,B      :MAC;
                        N,W      :BYTE;
                        T,t0,t1,
                        eps,epsw :REAL;
                        X0       :WEK;
                    VAR M        :WORD;
                    VAR N_PLIK   :DANE_NAZWY_PLIKU;
                    VAR BLAD     :BYTE;
                        LICZNIK  :WORD);
{------------------------------------------------------------}
{ P=1     - z przedzialami stala aproksymacja przebiegu      }
{           na wejsciu wedlug wzoru rekurencyjnego (6.33)    }
{ P=2     - z przedzialami liniowa aproksymacja przebiegu    }
{           na wejsciu wedlug wzoru rekurencyjnego (6.36)    }
{ P=3     - z przedzialami kwadratowa aproksymacja przebiegu }
{           na wejsciu wedlug wzoru rekurencyjnego (6.44)    }
{ WU      - okresla wektor wymuszen w postai WU(t)           }
{ A,B     - macierze o stalych wspolczynnikach ukladu        }
{           rownan rozniczkowych  dX/dt = A*X + B*U          }
{ N       - rzad macierzy A                                  }
{ W       - ilosc kolumn macierzy B                          }
{ T       - krok calkowania                                  }
{ t0,t1   - poczatek i koniec przedzialu calkowania          }
{ eps     - gorna granica bledu przyblizenia macierzy (6.30) }
{ epsw    - blad wyznaczenia najwiekszej co do modulu        }
{           wartosci wlasnej macierzy (6.30)                 }
{ X0      - wektor wartosci poczatkowych                     }
{ M       - ilosc krokow calkowania                          }
{ N_PLIK  - nazwa pliku do zapisania rozwiazania             }
{ BLAD    - nr bledu; 0 - brak bledu                         }
{ LICZNIK - parametr wyswietlania numeru iteracji:           }
{           0       - brak wyswietlania,                     }
{           X*256+Y - wyswietlenie piecio-znakowe            }
{                     w wierszu X i kolumnie Y.              }
{------------------------------------------------------------}

  PROCEDURE MET_FEHLB_LIN(    ST,K,N,W          :BYTE;
                              WU                :PROCWYM;
                          VAR A,B               :MAC;
                              h0,t0,t1,
                              epsw,epswmin,epsa :REAL;
                          VAR X0                :WEK;
                          VAR M                 :WORD;
                          VAR N_PLIK            :DANE_NAZWY_PLIKU;
                          VAR BLAD              :BYTE;
                              LICZNIK           :WORD);
{------------------------------------------------------------------}
{   Metoda Fehlberga tworzona z par wlozonych rzedu K i K+1        }
{ rozwiazywania liniowego ukladu N rownan rozniczkowych            }
{ z automatycznym doborem kroku calkowania do z gory zalozonej     }
{ dokladnosci wzglednej epsw oraz absolutnej epsa                  }
{ WU      - okresla wektor wymuszen w postai WU(t)                 }
{ A,B     - macierze o stalych wspolczynnikach ukladu              }
{           rownan rozniczkowych  dX/dt = A*X + B*U                }
{ N       - rzad macierzy A                                        }
{ W       - ilosc kolumn macierzy B                                }
{ K       - rzad metody                                            }
{ ST      - parametr pomocniczy                                    }
{      ST=1 staly krok calkowania przy automatycznym doborze rzedu }
{      ST=2 automatyczny dobor kroku i rzedu                       }
{ t0,t1   - poczatek i koniec przedzialu calkowania <t0,t1>        }
{ epsw    - tolerancja bledu wzglednego                            }
{ epswmin - najmniejsza tolerancja bledu wzglednego jakiego        }
{           dopuszczamy w obliczeniach (np. 1E-12)                 }
{ epsa    - tolerancja bledu absolutnego                           }
{ X0      - wektor wartosci poczatkowych;                          }
{ M       - ilosc iteracji obliczona i zapisana na dysku;          }
{ N_PLIK - nazwa pliku do zapisania rozwiazania;                   }
{ BLAD    - nr bledu; 0 - brak bledu                               }
{ LICZNIK - parametr wyswietlania numeru iteracji:                 }
{           0       - brak wyswietlania,                           }
{           X*256+Y - wyswietlenie piecio-znakowe                  }
{                     w wierszu X i kolumnie Y.                    }
{------------------------------------------------------------------}

  PROCEDURE MET_GEAR_LIN(    ST,N,W            :BYTE;
                             WU                :PROCWYM;
                         VAR A,B               :MAC;
                             h0,t0,t1,
                             epsw,epswmin,epsa :REAL;
                             X0                :WEK;
                         VAR M                 :WORD;
                         VAR N_PLIK            :DANE_NAZWY_PLIKU;
                         VAR BLAD              :BYTE;
                             LICZNIK           :WORD);
{------------------------------------------------------------------}
{  Metoda Geara rozwiazywania liniowego ukladu N rownan            }
{ rozniczkowych z automatycznym doborem kroku calkowania           }
{ i rzedu dla z gory zalozonej  dokladnosci wzglednej epsw         }
{ oraz absolutnej epsa                                             }
{ WU      - okresla wektor wymuszen w postai WU(t)                 }
{ A,B     - macierze o stalych wspolczynnikach ukladu              }
{           rownan rozniczkowych  dX/dt = A*X + B*U                }
{ N       - rzad macierzy A                                        }
{ W       - ilosc kolumn macierzy B                                }
{ ST      - parametr pomocniczy                                    }
{      ST=1 staly krok calkowania przy automatycznym doborze rzedu }
{      ST=2 automatyczny dobor kroku i rzedu                       }
{ h0      - krok calkowania ustalany dla ST=1                      }
{ t0,t1   - poczatek i koniec przedzialu calkowania <t0,t1>        }
{ epsw    - tolerancja bledu wzglednego                            }
{ epswmin - najmniejsza tolerancja bledu wzglednego jakiego        }
{           dopuszczamy w obliczeniach (np. 1E-12)                 }
{ epsa    - tolerancja bledu absolutnego                           }
{ X0      - wektor wartosci poczatkowych;                          }
{ M       - ilosc iteracji obliczona i zapisana na dysku;          }
{ N_PLIK  - nazwa pliku do zapisania rozwiazania;                  }
{ BLAD    - nr bledu; 0 - brak bledu                               }
{ LICZNIK - parametr wyswietlania numeru iteracji:                 }
{           0       - brak wyswietlania,                           }
{           X*256+Y - wyswietlenie piecio-znakowe                  }
{                     w wierszu X i kolumnie Y.                    }
{------------------------------------------------------------------}

  IMPLEMENTATION


  PROCEDURE MACPOM1(VAR A,B,F,G1   :MAC;
                        T,eps,epsw :REAL;
                        N,W        :BYTE;
                    VAR BLAD       :BYTE);
  {------------------------------------------------------------}
  { Formowanie macierzy pomocniczych F,G1 wg (6.30) (6.31)     }
  { A ,B -macierze ukladu rownan rozniczkowych                 }
  {    dX/dt = A*X + B*U                                       }
  { N - rzad macierzy A                                        }
  { W - liczba kolumn macierzy B                               }
  { T - wybrany krok calkowania                                }
  { eps  - gorna granica bledu przyblizenia macierzy F i G1    }
  { epsw - blad wyznaczenia najwiekszej co do modulu wartosci  }
  {        wlasnej macierzy F                                  }
  { BLAD - nr bledu; 0 - brak bledu                            }
  {------------------------------------------------------------}
    VAR K                 :WORD;
        I,J               :BYTE;
        S,S1,NAT,TETA,MWA :REAL;
        AX,AY,AT          :^MAC;
    BEGIN
      BLAD:=0;
      NEW(AT); NEW(AX); NEW(AY);
      MULMACR(AT^,A,T,N,N);
      MACJEDEN(AX^,N);
      NAT:=NORMAC(AT^,N);
      K:=0; S:=1; S1:=1;
      TETA:=NAT/(1-NAT); F:=AX^; G1:=AX^;
      REPEAT
        INC(K);
        MULMAC(AY^,AX^,AT^,N,N,N);
        S:=S/K;       MULMACR(AX^,AY^,S,N,N);  ADDMAC(F,F,AX^,N,N);
        S1:=S1/(K+1); MULMACR(AX^,AY^,S1,N,N);
        ADDMAC(G1,G1,AX^,N,N);
        AX^:=AY^;
        TETA:=TETA*NAT/(K+1)
      UNTIL TETA<eps;
      MWA:=MWWM(F,N,epsw,800,BLAD);
      IF BLAD<>0 THEN
      BEGIN
        IF MWA>=1.05 THEN
          BLAD:=120;
        DISPOSE(AY); DISPOSE(AX); DISPOSE(AT);
        EXIT
      END;
      MULMACR(AT^,B,T,N,W);
      AX^:=G1;
      MULMAC(G1,AX^,AT^,N,W,N);
      DISPOSE(AY); DISPOSE(AX); DISPOSE(AT)
    END  { MACPOM1 };

   PROCEDURE MACPOM2(VAR A,B,F,G2,H :MAC;
                         T,eps,epsw :REAL;
                         N,W        :BYTE;
                     VAR BLAD       :BYTE);
{---------------------------------------------------------------}
{ Formowanie macierzy pomocniczych F,G2,H wg (6.30)(6.37)(6.38) }
{ A ,B -macierze ukladu rownan rozniczkowych dX/dt = A*X + B*U  }
{ N    - rzad macierzy A i F                                    }
{ W    - liczba kolumn macierzy B , G2 , H                      }
{ T    - wybrany krok calkowania                                }
{ eps  - gorna granica bledu przyblizenia macierzy F,G2,H       }
{ epsw - blad wyznaczenia najwiekszej co do modulu wartosci     }
{        wlasnej macierzy F                                     }
{ BLAD - nr bledu; 0 - brak bledu                               }
{---------------------------------------------------------------}
    VAR K                     :WORD;
        I,J                   :BYTE;
        SS,S1,S2,NAT,TETA,MWA :REAL;
        AX,AY,AT              :^MAC;
    BEGIN
      BLAD:=0;
      NEW(AX); NEW(AY); NEW(AT);
      MACJEDEN(AX^,N);
      MULMACR(AT^,A,T,N,N);
      NAT:=NORMAC(AT^,N);
      K:=0; SS:=1; S1:=0.5; S2:=0.5;
      TETA:=NAT/(1-NAT);
      MACJEDEN(F,N); MULMACR(G2,AX^,0.5,N,N); H:=G2;
      REPEAT
        INC(K);
        MULMAC(AY^,AX^,AT^,N,N,N);
        SS:=SS/K;               MULMACR(AX^,AY^,SS,N,N); ADDMAC(F,F,AX^,N,N);
        S1:=S1*(K+1)/((K+2)*K); MULMACR(AX^,AY^,S1,N,N); ADDMAC(G2,G2,AX^,N,N);
        S2:=S2/(K+2);           MULMACR(AX^,AY^,S2,N,N); ADDMAC(H,H,AX^,N,N);
        AX^:=AY^;
        TETA:=TETA*NAT/(K+1)
      UNTIL TETA<eps;
      MWA:=MWWM(F,N,epsw,800,BLAD);
      IF BLAD<>0 THEN
      BEGIN
        IF MWA>=1.05 THEN
          BLAD:=120;
        DISPOSE(AT); DISPOSE(AY); DISPOSE(AX);
        EXIT
      END;
      MULMACR(AT^,B,T,N,W);
      AX^:=G2;  MULMAC(G2,AX^,AT^,N,W,N);
      AX^:=H;  MULMAC(H,AX^,AT^,N,W,N);
      DISPOSE(AT); DISPOSE(AY); DISPOSE(AX)
    END { MACPOM2 };

   PROCEDURE MACPOM3(VAR A,B,F,G,H,R :MAC;
                         T,eps,epsw  :REAL;
                         N,W         :BYTE;
                     VAR BLAD        :BYTE);
{---------------------------------------------------------------}
{ Formowanie macierzy pomocniczych F,G,H,R wg (6.30) (6.45)     }
{                                             (6.46) (6.47)     }
{ N    - rzad macierzy A i F                                    }
{ W    - liczba kolumn macierzy B,G,H,R                         }
{ T    - wybrany krok calkowania                                }
{ eps  - gorna granica bledu przyblizenia macierzy F,G,H,R      }
{ epsw - blad wyznaczenia najwiekszej co do modulu              }
{        wartosci wlasnej macierzy F                            }
{ BLAD - nr bledu; 0 - brak bledu                               }
{---------------------------------------------------------------}
    VAR K,K23                    :WORD;
        I,J                      :BYTE;
        SS,S1,S2,S3,NAT,TETA,MWA :REAL;
        AX,AY,AT                 :^MAC;
    BEGIN
      BLAD:=0;
      NEW(AX); NEW(AY); NEW(AT);
      MACJEDEN(AX^,N); MULMACR(AT^,A,T,N,N);
      NAT:=NORMAC(AT^,N); K:=0; SS:=1;
      S1:=1; S2:=1/2; S3:=1/6; TETA:=NAT/(1-NAT);
      MACJEDEN(F,N);         MULMACR(G,AX^,S1,N,N);
      MULMACR(H,AX^,S2,N,N); MULMACR(R,AX^,S3,N,N);
      REPEAT
        INC(K);
        MULMAC(AY^,AX^,AT^,N,N,N);
        SS:=SS/K;      MULMACR(AX^,AY^,SS,N,N); ADDMAC(F,F,AX^,N,N);
        S1:=SS/(K+1);  MULMACR(AX^,AY^,S1,N,N); ADDMAC(G,G,AX^,N,N);
        S2:=S1/(K+2);  MULMACR(AX^,AY^,S2,N,N); ADDMAC(H,H,AX^,N,N);
        S3:=S2/(K+3);  MULMACR(AX^,AY^,S3,N,N); ADDMAC(R,R,AX^,N,N);
        AX^:=AY^;
        TETA:=TETA*NAT/(K+1)
      UNTIL TETA<eps;
      MWA:=MWWM(F,N,epsw,800,BLAD);
      IF BLAD<>0 THEN
      BEGIN
        IF MWA>=1.05 THEN
          BLAD:=120;
        DISPOSE(AT); DISPOSE(AY); DISPOSE(AX);
        EXIT
      END;
      MULMACR(AX^,H,-3,N,N); MULMACR(AY^,R,4,N,N);
      ADDMAC(G,G,AX^,N,N);   ADDMAC(G,G,AY^,N,N);
      MULMACR(AX^,H,4,N,N);  MULMACR(AY^,R,-8,N,N);
      AT^:=H; ADDMAC(H,AX^,AY^,N,N);
      MULMACR(AX^,AT^,-1,N,N); MULMACR(AY^,R,4,N,N);
      ADDMAC(R,AX^,AY^,N,N);
      MULMACR(AT^,B,T,N,W);
      AX^:=G;  MULMAC(G,AX^,AT^,N,W,N);
      AX^:=H;  MULMAC(H,AX^,AT^,N,W,N);
      AX^:=R;  MULMAC(R,AX^,AT^,N,W,N);
      DISPOSE(AT); DISPOSE(AY); DISPOSE(AX)
    END { MACPOM3 };

  PROCEDURE RURRLIN;
    VAR Y,E,F,G,H,R        :^MAC; { Macierze pomocnicze }
        NA,S,tt,t12,t2,MWA :REAL;
        L,I,J              :BYTE;
        X1,X2,U,U1,U2,U12  :WEK;
    BEGIN
      BLAD:=0;
      NA:=NORMAC(A,N);
      IF T>1/NA THEN
      BEGIN
        BLAD:=121;
        EXIT
      END;
      X1:=X0; X1[0]:=t0; M:=0; tt:=t0;
      ZAPIS_D(X1,N,M,'B',N_PLIK,BLAD); { zapis na pliku }
      IF BLAD=0 THEN
      BEGIN
        CASE P OF
          1: BEGIN
               NEW(F); NEW(G);
               MACPOM1(A,B,F^,G^,T,eps,epsw,N,W,BLAD);
               IF BLAD=0 THEN
               REPEAT
                 WU(U,tt,W);
                 FOR l:=1 TO N DO
                 BEGIN
                   S:=0;
                   FOR i:=1 TO N DO
                     S:=S+F^[l,i]*X1[i];
                   FOR i:=1 TO W DO
                     S:=S+G^[l,i]*U[i];
                   X2[l]:=S
                 END;
                 tt:=tt+T; X2[0]:=tt; INC(M);
                 ZAPIS_D(X2,N,M,'C',N_PLIK,BLAD); { zapis na pliku }
                 IF LICZNIK<>0 THEN
                 BEGIN
                   GOTOXY(HI(LICZNIK),LO(LICZNIK));
                   WRITE(M:5)
                 END;
                 X1:=X2
               UNTIL (tt>=t1) OR (BLAD<>0);
               DISPOSE(F); DISPOSE(G);
             END; { koniec P=1 }
          2: BEGIN
               NEW(F); NEW(G); NEW(H);
               MACPOM2(A,B,F^,G^,H^,T,eps,epsw,N,W,BLAD);
               IF BLAD=0 THEN
               BEGIN
                 WU(U1,tt,W);
                 REPEAT
                   tt:=tt+T; WU(U2,tt,W);
                   FOR l:=1 TO N DO
                   BEGIN
                     S:=0;
                     FOR i:=1 TO N DO
                       S:=S+F^[l,i]*X1[i];
                     FOR i:=1 TO W DO
                       S:=S+G^[l,i]*U1[i];
                     FOR i:=1 TO W DO
                       S:=S+H^[l,i]*U2[i];
                     X2[l]:=S
                   END;
                   X2[0]:=tt; INC(M);
                   ZAPIS_D(X2,N,M,'C',N_PLIK,BLAD); { zapis na pliku }
                   IF LICZNIK<>0 THEN
                   BEGIN
                     GOTOXY(HI(LICZNIK),LO(LICZNIK));
                     WRITE(M:5)
                   END;
                   X1:=X2; U1:=U2
                 UNTIL (tt>=t1) OR (BLAD<>0)
               END;
               DISPOSE(H) ; DISPOSE(G); DISPOSE(F)
             END; { koniec P=2 }
          3: BEGIN
               NEW(F); NEW(G); NEW(H); NEW(R);
               MACPOM3(A,B,F^,G^,H^,R^,T,eps,epsw,N,W,BLAD);
               IF BLAD=0 THEN
               BEGIN
                 WU(U1,tt,W);
                 REPEAT
                   tt :=tt+T;   WU(U2,tt,W);
                   t12:=tt-T/2; WU(U12,t12,W);
                   FOR l:=1 TO N DO
                   BEGIN
                     S:=0;
                     FOR i:=1 TO N DO
                       S:=S+F^[l,i]*X1[i];
                     FOR i:=1 TO W DO
                       S:=S+G^[l,i]*U1[i];
                     FOR i:=1 TO W DO
                       S:=S+H^[l,i]*U12[i];
                     FOR i:=1 TO W DO
                       S:=S+R^[l,i]*U2[i];
                     X2[l]:=S
                   END;
                   X2[0]:=tt; INC(M);
                   ZAPIS_D(X2,N,M,'C',N_PLIK,BLAD); { zapis na pliku }
                   IF LICZNIK<>0 THEN
                   BEGIN
                     GOTOXY(HI(LICZNIK),LO(LICZNIK));
                     WRITE(M:5)
                   END;
                   X1:=X2; U1:=U2
                 UNTIL (tt>=t1) OR (BLAD<>0)
               END;
               DISPOSE(F); DISPOSE(G); DISPOSE(H);DISPOSE(R)
             END; { koniec P=3 }
          ELSE BLAD:=122
        END;
        ZAPIS_D(X2,N,M,'E',N_PLIK,BLAD) { zapis na pliku N,M }
      END
    END { RURRLIN };

  FUNCTION POTEGA(N:INTEGER; X:REAL):REAL;
  { Calkowita potega N liczby rzeczywistej X }
    VAR W:REAL; i:INTEGER;
    BEGIN
      IF N=0
        THEN W:=1.0
        ELSE BEGIN
               W:=X;
               FOR i:=2 TO N DO
                 W:=W*X
             END;
      POTEGA:=W
    END { POTEGA };

  PROCEDURE MULRW(VAR Y :WEK;
                      a :REAL;
                      X :WEK;
                      N :BYTE);
    { Iloczyn wektora przez liczbe Y[i] = a*X[i] ; i = 1,2,...,N }
    VAR i:BYTE;
    BEGIN
      FOR i:=1 TO N DO
        Y[i]:=a*X[i]
    END { MULRW };

  PROCEDURE ADDWEK(VAR X:WEK; X1,X2:WEK; N:BYTE);
  { Suma wektorow X = X1 + X2 }
    VAR i:BYTE;
    BEGIN
      FOR i:=1 TO N DO
        X[i]:=X1[i]+X2[i]
    END { ADDWEK };

  PROCEDURE SUBWEK(VAR X:WEK; X1,X2:WEK; N:BYTE);
  { Roznica wektorow X = X1 - X2 }
    VAR i:BYTE;
    BEGIN
      FOR i:=1 TO N DO
        X[i]:=X1[i]-X2[i]
    END { SUBWEK };

  FUNCTION NORMAX(N:BYTE; E:WEK):REAL;
  { Norma wektora E, ||E|| = max E[i] }
  {                           i       }
    VAR i:BYTE; S,W:REAL;
    BEGIN
      S:=0;
      FOR i:=1 TO N DO
      BEGIN
        W:=ABS(E[i]);
        IF W>S THEN
          S:=W
      END;
      NORMAX:=S
    END { NORMAX };

  PROCEDURE FEHLBERG_LIN(    K,N,W :BYTE;
                             WU    :PROCWYM;
                         VAR A,B   :MAC;
                             h,t0  :REAL;
                             X0    :WEK;
                         VAR X,E   :WEK;
                         VAR BLAD  :BYTE);
    VAR i,j,l:INTEGER;
        t,dX:REAL;
        K1,K2,K3,K4,K5,K6,X1:WEK;

    PROCEDURE LIN(VAR Y:WEK; X:WEK; t:REAL; N:BYTE);
      VAR k,l :BYTE;
          S   :REAL;
          U   :WEK;
      BEGIN
        WU(U,t,W);
        FOR k:=1 TO N DO
        BEGIN
          S:=0;
          FOR l:=1 TO N DO
            S:=S+A[k,l]*X[l];
          FOR l:=1 TO W DO
            S:=S+B[k,l]*U[l];
          Y[k]:=S
        END
      END { LIN };

    BEGIN  { Blok glowny procedury FEHLBERG_LIN }
      BLAD:=0;
      CASE K OF
        1: BEGIN
             { para metod wlozonych 1 i 2 rzedu wzory (5.37) }
             LIN(K1,X0,t0,N);   MULRW(K1,h,K1,N);
             t:=t0+h/2;
             FOR l:=1 TO N DO
               X1[l]:=X0[l]+K1[l]/2;
             LIN(K2,X1,t,N);    MULRW(K2,h,K2,N);
             t:=t0+h;
             FOR l:=1 TO N DO
               X1[l]:=X0[l]+K1[l]/256+255*K2[l]/256;
             LIN(K3,X1,t,N);    MULRW(K3,h,K3,N);
             FOR j:=1 TO N DO
             BEGIN
               dX:=(K1[j]+510*K2[j]+K3[j])/512;
               X[j]:=X0[j]+dX;
               E[j]:=(-K1[j]+K3[j])/512
             END
           END {1};
        2: BEGIN
             { para metod wlozonych 2 i 3 rzedu wzory (5.38) }
             LIN(K1,X0,t0,N);   MULRW(K1,h,K1,N);
             t:=t0+h/4;
             FOR l:=1 TO N DO
               X1[l]:=X0[l]+K1[l]/4;
             LIN(K2,X1,t,N);    MULRW(K2,h,K2,N);
             t:=t0+27*h/40;
             FOR l:=1 TO N DO
               X1[l]:=X0[l]+(-189*K1[l]+729*K2[l])/800;
             LIN(K3,X1,t,N);    MULRW(K3,h,K3,N);
             t:=t0+h;
             FOR l:=1 TO N DO
               X1[l]:=X0[l]+(214*K1[l]+27*K2[l]+650*K3[l])/891;
             LIN(K4,X1,t,N);    MULRW(K4,h,K4,N);
             FOR j:=1 TO N DO
             BEGIN
               dX:=(533*K1[j]+1600*K3[j]-27*K4[j])/2106;
               X[j]:=X0[j]+dX;
               E[j]:=23*K1[j]/1782-K2[j]/33+350*K3[j]/11583-K4[j]/78
             END
           END {2};
        4: BEGIN
           { para metod wlozonych 4 i 5 rzedu wzory (5.40) }
             LIN(K1,X0,t0,N);   MULRW(K1,h,K1,N);
             t:=t0+h/4;
             FOR l:=1 TO N DO
               X1[l]:=X0[l]+K1[l]/4;
             LIN(K2,X1,t,N);    MULRW(K2,h,K2,N);
             t:=t0+3*h/8;
             FOR l:=1 TO N DO
               X1[l]:=X0[l]+(3*K1[l]+9*K2[l])/32;
             LIN(K3,X1,t,N);    MULRW(K3,h,K3,N);
             t:=t0+12*h/13;
             FOR l:=1 TO N DO
               X1[l]:=X0[l]+(1932*K1[l]-7200*K2[l]+7296*K3[l])/2197;
             LIN(K4,X1,t,N);    MULRW(K4,h,K4,N);
             t:=t0+h;
             FOR l:=1 TO N DO
               X1[l]:=X0[l]+(8341*K1[l]-32832*K2[l]+
                      29440*K3[l]-845*K4[l])/4104;
             LIN(K5,X1,t,N);    MULRW(K5,h,K5,N);
             t:=t0+h/2;
             FOR l:=1 TO N DO
               X1[l]:=X0[l]+(-6080*K1[l]+41040*K2[l]-
                      28352*K3[l]+9295*K4[l]-5643*K5[l])/20520;
             LIN(K6,X1,t,N);    MULRW(K6,h,K6,N);
             FOR j:=1 TO N DO
             BEGIN
               dX:=16*K1[j]/135+6656*K3[j]/12825+28561*K4[j]/56430-
                   9*K5[j]/50+2*K6[j]/55;
               X[j]:=X0[j]+dX;
               E[j]:=K1[j]/360-128*K3[j]/4275-2197*K4[j]/75240+
                     K5[j]/50+2*K6[j]/55
             END
           END {4};
        ELSE BLAD:=123
      END
    END { FEHLBERG_LIN };

  PROCEDURE MET_FEHLB_LIN;
    VAR KK,j,l             :BYTE;
        t,ee,s1,Hh,Hh1,h1,Hph,Hmin,
        epsm,epsm1,epsw1,
        ALFA,A26,xt,mxt    :REAL;
        E,X1,Y             :WEK;
    BEGIN
      BLAD:=0;
      IF ST<>1
        THEN Hh:=(t1-t0)/100
        ELSE Hh:=h0;
      { Wyznaczanie wzglednej dokladnosci maszynowej epsm }
      epsm:=1.0;
      REPEAT
        epsm:=epsm/2; epsm1:=epsm+1.0
      UNTIL epsm1<=1;
      {Sprawdzenie dopuszczalnej tolerancji wzglednej wg (5.52)}
      IF epsw>=2*epsm+epswmin
        THEN epsw1:=epsw
        ELSE epsw1:=2*epsm+epswmin;
      A26:=26*epsm;
      IF ABS(t1-t0)<A26 THEN
      BEGIN
        BLAD:=101;
        EXIT
      END;
      t:=t0; Y:=X0;  Y[0]:=t0; M:=0; KK:=0;
      ZAPIS_D(Y,N,M,'B',N_PLIK,BLAD); { zapis na pliku }
      IF BLAD<>0 THEN
        EXIT;
      REPEAT
        FEHLBERG_LIN(K,N,W,WU,A,B,Hh,t,Y,X1,E,BLAD); { pkt 6.3 }
        IF BLAD<>0 THEN
          EXIT;
        { Wyznaczanie normy ee wektora bledu E (5.42) oraz }
        { normy mxt wektora stanu o wsp. (5.46) wg (5.47)  }
        ee:=0; mxt:=0;
        FOR j:=1 TO N DO
        BEGIN
          s1:=ABS(E[j]);
          IF ee < s1 THEN
            ee:=s1;
          xt:=(ABS(Y[j])+ABS(X1[j]))/2;
          IF mxt < xt THEN
            mxt:=xt;
        END;
        ee:=ee/(mxt*epsw1+epsa);
        Hph:=EXP(LN(ee)/(K+1)); { wzor (5.49) }
        h1:=Hh/Hph;
        ALFA:=0.9/Hph;
        Hmin:=A26*ABS(t);       { wzor (5.51) }
        IF (ABS(h1) < Hmin) AND (ST<>1) THEN
        BEGIN
          BLAD:=102;
          EXIT
        END;
        IF Hph<=1
          THEN BEGIN { wzory (5.50) }
                 Y:=X1; t:=t+Hh ; X1[0]:=t; INC(M);
                 IF LICZNIK<>0 THEN
                 BEGIN
                   GOTOXY(HI(LICZNIK),LO(LICZNIK));
                   WRITE(M:5)
                 END;
                 ZAPIS_D(X1,N,M,'C',N_PLIK,BLAD); { zapis na pliku }
                 IF BLAD<>0 THEN { blad zapisu }
                   EXIT;
                 IF (KK=0) AND (ST<>1)
                   THEN IF (ALFA<5) AND (ALFA>=0.9)
                          THEN Hh:=ALFA*Hh
                          ELSE IF ALFA>=5
                                 THEN Hh:=5*Hh
                                 ELSE
                   ELSE IF (KK>0) AND (ALFA<1) AND (ST<>1) THEN
                          Hh:=ALFA*Hh;
                 KK:=0
               END
          ELSE BEGIN
                 INC(KK);
                 IF ST<>1
                   THEN Hh:=ALFA*Hh
                   ELSE BEGIN
                          BLAD:=103;
                          EXIT
                        END
               END;
        Hh1:=t1-t;
        IF (Hh1<Hh) AND (Hh>0) AND (ST<>1)
          THEN Hh:=Hh1
          ELSE IF (Hh1>Hh) AND (Hh<0) AND (ST<>1) THEN
                 Hh:=Hh1
      UNTIL ((t>=t1)AND(t1>t0)) OR ((t<=t1)AND(t0>t1));
      ZAPIS_D(X1,N,M,'E',N_PLIK,BLAD) { zapis na pliku N,M }
  END { MET_FEHLB_LIN };

  PROCEDURE MET_GEAR_LIN;
    VAR K,K1,K2,P2,KKR,j,l :BYTE;
        Q,t,ee,s1,h1,h2,h,Hmin,
        epsm,epsm1,eps,
        ALFA,A26,xt,mxt,rr :REAL;
        C,X1               :WEK;
        i,ii               :WORD;
        F,FP               :WEK8;
        A1                 :MAC; { Zmienna globalna dla procedury KOREKTOR_GEARA }
        PIERWSZY           :BOOLEAN;

    PROCEDURE LIN(VAR Y:WEK; X:WEK; t:REAL; N:BYTE);
    { Generacja prawej strony ukladu rownan rozniczkowych }
    { liniowych  dX/dt=A*X+B*U                            }
      VAR k,l :BYTE;
          S   :REAL;
          U   :WEK;
      BEGIN
        WU(U,t,W);
        FOR k:=1 TO N DO
        BEGIN
          S:=0;
          FOR l:=1 TO N DO
            S:=S+A[k,l]*X[l];
          FOR l:=1 TO W DO
            S:=S+B[k,l]*U[l];
          Y[k]:=S
        END
      END { LIN };

    PROCEDURE PODSTAW(VAR C:WEK);
    { Podstawienie wspolczynnikow wystepujacych przy bledzie }
    { obciecia dla algorytmu Geara wg wzoru (5.130)          }
    { pod wektor C wg.  C[k]:=C[k]*(k+1)!                    }
      BEGIN
       C[0]:=1; C[1]:=1.0; C[2]:=4/3; C[3]:=36/11;
       C[4]:=288/25; C[5]:=7200/137; C[6]:=14400/49
      END { PODSTAW };

  PROCEDURE GENMACTG(VAR T:MAC; K:BYTE; VAR BLAD:BYTE);
  { Generacja macierzy Tk (5.124) transformacji Zn=Tk*Yn (5.118)}
    VAR i,j :BYTE;
        S   :REAL;
        D   :MAC;
    BEGIN
      { Formowanie macierzy T ukladu rownan (5.121) }
      FOR i:=1 TO K-1 DO
        FOR j:=1 TO K-1 DO
          D[i,j]:=POTEGA(j+1,-i);
      { Odwracanie macierzy T }
      ODWMAC1(D,K-1,1E-10,BLAD);
      IF BLAD=0 THEN
      BEGIN
        MACZERO(T,K+1,K+1); T[1,1]:=1; T[2,K+1]:=1;
        FOR i:=1 TO K-1 DO
        BEGIN  { Formowanie macierzy Tk (5.124) }
          S:=0;
          FOR j:=1 TO K-1 DO
            S:=S-D[i,j];
          T[i+2,1]:=S;
          S:=0;
          FOR j:=1 TO K-1 DO
            S:=S+j*D[i,j];
          T[i+2,K+1]:=S;
          FOR j:=1 TO K-1 DO
            T[i+2,j+1]:=D[i,j]
        END
      END
    END { GENMACTG };

    PROCEDURE START_MWG(    ST,N,K            :BYTE;
                            X0                :WEK;
                        VAR F                 :WEK8;
                        VAR h,t,A26           :REAL;
                            t0,t1:REAL;
                        VAR epsw,epswmin,epsa :REAL;
                        VAR M                 :WORD;
                        VAR N_PLIK            :DANE_NAZWY_PLIKU;
                        VAR BLAD              :BYTE);
{-------------------------------------------------------------}
{ Faza wstepna obliczen metody wielokrokowej z zastosowaniem  }
{ transformacji (5.118) do wstepnego sformulowania macierzy   }
{ Nordsiecka                                                  }
{ Opis parametrow jak w procedurze START_MW                   }
{-------------------------------------------------------------}
      VAR i,j                :BYTE;
          NE,epsm,epsm1,eps1 :REAL;
          Y,X1,WK,WK1,E      :WEK;
          F0                 :WEK8;
          TK                 :MAC;

      PROCEDURE TRANSFORMACJA; { wg wzoru (5.118) }
        VAR i,j:BYTE;
        BEGIN
          FOR i:=2 TO K DO
          BEGIN
            FOR j:=1 TO N DO
              Y[j]:=0;
            FOR j:=0 TO K DO
            BEGIN
              MULRW(X1,TK[i+1,j+1],F0[j],N);
              ADDWEK(Y,Y,X1,N)
            END;
            F[i]:=Y
          END
         END { TRANSFORMACJA };

      BEGIN
        { Wyznaczanie wzglednej dokladnosci maszynowej epsm }
        BLAD:=0;
        epsm:=1.0;
        REPEAT
          epsm:=epsm/2; epsm1:=epsm+1.0
        UNTIL epsm1<=1;
        {Sprawdzenie dopuszczalnej tolerancji wzglednej wg (5.52)}
        IF epsw<2*epsm+epswmin THEN
          epsw:=2*epsm+epswmin;
        A26:=26*epsm;
        IF ABS(t1-t0)<A26 THEN
        BEGIN
          BLAD:=101;
          EXIT
        END;
        { Generacja macierzy (5.124) pkt 5.8.4 }
        GENMACTG(TK,K,BLAD);
        IF BLAD<>0 THEN
          EXIT;
        i:=1;
        F0[K-1]:=X0;
        IF ST<>1 THEN
        BEGIN
          FEHLBERG_LIN(4,N,W,WU,A,B,h,t0,X0,Y,E,BLAD);
          IF BLAD<>0 THEN
            EXIT;
          NE:=NORMAX(N,E)/(epsw*NORMAX(N,Y)+epsa);
          h:=0.9*h/EXP(LN(NE)/5)
        END;
        Y:=X0; t:=t0;
        REPEAT
          INC(i);
          FEHLBERG_LIN(4,N,W,WU,A,B,h,t,Y,X1,E,BLAD);
          IF BLAD=0 THEN
          BEGIN
            NE:=NORMAX(N,E); eps1:=epsw*NORMAX(N,Y)+epsa;
            IF NE<eps1
              THEN BEGIN
                     Y:=X1; t:=t+h; F0[K-i]:=X1;
                     X1[0]:=t; INC(M);
                     ZAPIS_D(X1,N,M,'C',N_PLIK,BLAD) { zapis na pliku }
                   END
              ELSE IF ST<>1
                     THEN BEGIN
                            h:=h/2; i:=0; t:=t0; Y:=X0;
                            M:=0;
                            X1:=X0;  X1[0]:=t0;
                            { Zerowanie otwartego pliku }
                            ZAPIS_D(X1,N,M,'R',N_PLIK,BLAD)
                          END
                     ELSE BLAD:=105;

            IF ABS(h) < A26*ABS(t) THEN
              BLAD:=106
          END
        UNTIL (i=K) OR (BLAD<>0);
        IF BLAD=0 THEN
        BEGIN
          F[0]:=F0[0];
          LIN(F0[K],X1,t,N);
          MULRW(F0[K],h,F0[K],N);
          F[1]:=F0[K];
          TRANSFORMACJA
        END
      END { START_MWG };

    PROCEDURE DOBORKROKUIRZEDU(    N,Kmax :BYTE;
                               VAR K      :BYTE;
                               VAR ALFA   :REAL;
                                   C      :WEK;
                               VAR F      :WEK8;
                                   eps    :REAL);
  { Dobor kroku alfa*h poprzez wyznaczenie parametru alfa }
  { oraz rzedu K wg wzorow (5.115) (5.116) (5.117)        }
  { N - ilosc rownan                                      }
  { K - wstepnie zadany rzad metody wielokrokowej         }
  { C - wektor wspolczynnikow bledu obciecia metody wielo-}
  {     krokowej np. (5.65) Adamsa-Multona                }
  { F - macierz Norsiecka typu (5.78)                     }
  { eps - tolerancja bledu (5.114)                        }
    VAR A1,A2,A3:REAL;
    BEGIN
      A1:=ALFA; { ALFA obliczone w procedurze DOBORKROKU  }
      IF K<Kmax
        THEN BEGIN
               A2:=eps/(C[K-1]*NORMAX(N,F[K]));
               A3:=eps/(C[K+1]*NORMAX(N,F[K+2]));
               A2:=EXP(LN(A2)/K)/1.3;     { wzor (5.116) }
               A3:=EXP(LN(A3)/(K+2))/1.4  { wzor (5.117) }
             END
        ELSE BEGIN
               A2:=eps/(C[K-1]*NORMAX(N,F[K]));
               A2:=EXP(LN(A1)/(K))/1.3;
               A3:=0
             END;
      { Dobor rzedu K=1..6 i kroku ALFA*h poprzez wybor }
      { maksimum z posrod A1,A2,A3                      }
      IF (A1>=A2) AND (A1>=A3)
        THEN ALFA:=A1
        ELSE IF (A2>A1) AND (A2>=A3)
               THEN IF K>1
                      THEN BEGIN
                             ALFA:=A2;
                             DEC(K)
                           END
                      ELSE ALFA:=A1
               ELSE IF (A3>A1) AND (A3>A2)
                      THEN IF K<Kmax
                             THEN BEGIN
                                    ALFA:=A3;
                                    INC(K)
                                  END
                             ELSE
                      ELSE ALFA:=A1
    END { DOBORKROKUIRZEDU };

  PROCEDURE DOBORKROKU(    N    :BYTE;
                       VAR K    :BYTE;
                       VAR ALFA :REAL;
                           C    :WEK;
                       VAR F    :WEK8;
                           eps  :REAL);
  { Dobor kroku alfa*h poprzez wyznaczenie parametru alfa }
  { wg wzoru (5.115)                                      }
  { N - ilosc rownan                                      }
  { K - zadany rzad metody wielokrokowej                  }
  { C - wektor wspolczynnikow bledu obciecia metody wielo-}
  {     krokowej np. (5.65) Adamsa-Multona                }
  { F - macierz Norsiecka typu (5.78)                     }
  { eps - tolerancja bledu (5.114)                        }
    VAR A1:REAL;
    BEGIN
      A1:=eps/(C[K]*NORMAX(N,F[K+1]));
      A1:=EXP(LN(A1)/(K+1))/1.2; { wzor (5.115) }
      ALFA:=A1
    END { DOBORKROKU };

  PROCEDURE ZMIANAMACNOR(    N,K  :BYTE;
                         VAR F    :WEK8;
                             ALFA :REAL);
  { Transformacja macierzy Nordsiecka wg (5.82) przy zmianie }
  { kroku danym parametrem ALFA                              }
  { N - ilosc rownan                                         }
  { K - zadany rzad metody wielokrokowej                     }
  { F - macierz Norsiecka typu (5.78)                        }
    VAR i :BYTE;
        A :REAL;
    BEGIN
      A:=1;
      FOR i:=1 TO K+2 DO
      BEGIN
        A:=A*ALFA;
        MULRW(F[i],A,F[i],N)
      END
    END { ZMIANAMACNOR };

  PROCEDURE PREDYKTOR_MW(    N,K :BYTE;
                         VAR F   :WEK8);
  { Zastosowanie macierzy trojkatnej Pascala (5.98) w czlonie }
  { przewidywania (5.93) dla macierzy Norsiecka F typu (5.78) }
    VAR i,j,l:BYTE;
    BEGIN
      FOR i:=1 TO K DO
        FOR j:=i TO K DO
        BEGIN
          l:=K-j+i-1;
          ADDWEK(F[l],F[l],F[l+1],N)
        END
    END { PREDYKTOR_MW };

    PROCEDURE KOREKTOR_GEARA(    ST,N,K               :BYTE;
                             VAR t,h,Hmin,epsw1,epsa1 :REAL;
                             VAR F                    :WEK8;
                             VAR BLAD                 :BYTE);
    { Realizacja czlonu korekcji GEARA w postaci macierzowej }
    { Nordsiecka F typu (5.78) wg iteracji (5.147)           }
    { K - rzad czlonu korekcji                               }
    { t - chwila czasu w ktorej dokonuje sie korekcji        }
    {     jezeli zachodzi zbieznosc korektora to t:=t+h      }
    { h - krok calkowania - jezeli nie zachodzi zbieznosc    }
    {     korektora po trzech probach  to h:=h/4             }
    { Hmin - minimalny krok calkowania przy ktorym nalezy    }
    {        przerwac obliczanie                             }
    { epsw1,epsa1 - tolerancja wzgledna i absolutna obliczen }
    { F - macierz Norsiecka typu (5.78)                      }
      VAR KZ,i,j                     :BYTE;
          NFz,r,eps                  :REAL;
          Y,Cz,Fa,Fz,FK,FK1,Fm,F0,F1 :WEK;

      PROCEDURE POWTORZ;
      { Realizuje powtorzenie predykcji (5.93) jezeli po   }
      { trzech probach nie osiaga sie zbieznosci korektora }
      { Geara z zadana tolerancja przyjmujac h:=h/4        }
        VAR i:BYTE;
        BEGIN
          h:=0.25*h; F:=FP;
          ZMIANAMACNOR(N,K,F,0.25);
          FK:=F[K]; FK1:=F[K+1]; F0:=F[0]; F1:=F[1];
          PREDYKTOR_MW(N,K,F);
          FOR i:=1 TO N DO
            Fm[i]:=0
        END { POWTORZ };

      BEGIN { Blok glowny procedury KOREKTOR_GEARA }
        BLAD:=0;
        IF (K>=1) AND (K<=6)
          THEN BEGIN
                 { Wybor rzedu metody Geara wraz z podstawieniem za }
                 { wektor Cz wektora obliczonego wg (5.149) (5.150) }
                 { dla rzedu K rozpatrywanej metody                 }
                 CASE K OF
                   1: BEGIN
                        Cz[1]:=1.0;  Cz[2]:=1.0
                      END {1};
                   2: BEGIN
                        Cz[1]:=2/3;  Cz[2]:=1.0;  Cz[3]:=1/3
                      END {2};
                   3: BEGIN
                        Cz[1]:=6/11; Cz[2]:=1;    Cz[3]:=6/11; Cz[4]:=1/11
                      END {3};
                   4: BEGIN
                        Cz[1]:=12/25; Cz[2]:=1;   Cz[3]:=0.7;
                        Cz[4]:=0.2;   Cz[5]:=0.02
                      END {4};
                   5: BEGIN
                        Cz[1]:=60/137; Cz[2]:=1;      Cz[3]:=225/274;
                        Cz[4]:=85/274; Cz[5]:=15/274; Cz[6]:=1/274
                      END {5};
                   6: BEGIN
                        Cz[1]:=20/49; Cz[2]:=1;       Cz[3]:=58/63;
                        Cz[4]:=5/12;  Cz[5]:=25/252;  Cz[6]:=1/84;
                        Cz[7]:=1/1764
                      END {6}
                 END;
                 FK:=F[K];   FK1:=F[K+1];  F0:=F[0]; F1:=F[1];
                 eps:=epsw1*NORMAX(N,F[0])+epsa1;
                 FOR i:=1 TO N DO
                   Fm[i]:=0;
                 KZ:=0;
                 { Iteracja pierwszych dwoch wierszy F[0] i F[1]  }
                 { macierzy Nordsiecka wg (5.147)                 }
                 REPEAT
                   INC(KZ);
                   IF (KZ>3) AND (ST<>1) THEN
                   BEGIN
                     POWTORZ;
                     KZ:=1
                   END;
                   { Formowanie wektora Fz wg wzoru (5.148) }
                   LIN(Fa,F0,t+h,N);
                   MULRW(Fa,h,Fa,N);
                   SUBWEK(Fa,Fa,F1,N);
                   r:=h*Cz[1];
                   IF r<>rr THEN
                   BEGIN
                     FOR i:=1 TO N DO
                       FOR j:=1 TO N DO
                         IF i=j
                           THEN A1[i,i]:=1-r*A[i,i]
                           ELSE A1[i,j]:=-r*A[i,j];
                         { Macierz odwrotna A1 macierzy A2   }
                         { procedura ODWMAC z modulu ALGELIN }
                     ODWMAC1(A1,N,1E-12,BLAD);
                     rr:=r
                   END;
                   IF BLAD=0
                     THEN BEGIN
                            FOR i:=1 TO N DO
                            BEGIN
                              r:=0;
                              FOR j:=1 TO N DO
                                r:=r+A1[i,j]*Fa[j];
                              Fz[i]:=r
                            END;
                            MULRW(Y,Cz[1],Fz,N); ADDWEK(F0,F0,Y,N);
                            MULRW(Y,Cz[2],Fz,N); ADDWEK(F1,F1,Y,N);
                            ADDWEK(Fm,Fm,Fz,N); { Suma wektorowa (5.103) }
                            NFz:=NORMAX(N,Fz)
                          END
                     ELSE IF ST<>1
                            THEN BEGIN
                                   POWTORZ;
                                   KZ:=0
                                 END
                            ELSE BLAD:=124;
                   IF ABS(h) < Hmin THEN
                     BLAD:=102
                 UNTIL ((NFz<eps) AND (KZ<=3) AND (ST<>1)) OR
                       ((NFz<eps) AND (ST=1)) OR (KZ>25) OR (BLAD<>0);
                 IF KZ>25
                   THEN BLAD:=111
                   ELSE BEGIN
                          F[0]:=F0; F[1]:=F1;
                          { Wyznaczanie pozostalych wierszy macierzy }
                          { Nordsiecka  wg wzoru (5.104)             }
                          FOR i:=2 TO K DO
                          BEGIN
                            MULRW(Y,Cz[i+1],Fm,N);
                            ADDWEK(F[i],F[i],Y,N)
                          END;
                          { Oszacowanie pochodnych rzedu K+1 i K+2 tj F[K+1] }
                          { F[K+2] jako wektorow roznicy wstecznej wg wzorow }
                          { (5.80)i (5.81)                                   }
                          SUBWEK(F[K+1],F[K],FK,N); r:=1/(K+1);
                          MULRW(F[K+1],r,F[K+1],N);
                          SUBWEK(F[K+2],F[K+1],FK1,N); r:=1/(K+2);
                          MULRW(F[K+2],r,F[K+2],N);
                          {t:=t+h}
                        END
               END
          ELSE BLAD:=112
      END { KOREKTOR_GEARA };

    BEGIN { Blok glowny macierzy MET_GEAR_LIN }
      BLAD:=0;
      IF ST<>1
        THEN h:=(t1-t0)/100
        ELSE h:=h0;
      t:=t0;  X1:=X0;  X1[0]:=t0;  M:=0;
      ZAPIS_D(X1,N,M,'B',N_PLIK,BLAD); { zapis do pliku }
      IF BLAD<>0 THEN
        EXIT;
      PODSTAW(C);{ Podstawienie wspolczynnikow bledu (5.130) }
                 { pod wektor C                              }
      START_MWG(ST,N,4,X0,F,h,t,A26,t0,t1,epsw,epswmin,epsa,M,N_PLIK,BLAD);
      IF BLAD<>0 THEN
        EXIT;
      { Faza wstepna obliczen metody wielokrokowej z zastoso-  }
      { waniem transformacji (5.118) do wstepnego sformulowania}
      { macierzy Nordsiecka F  pkt 5.8.4                       }
      KKR:=0; K:=3;
      PIERWSZY:=TRUE; FP:=F; h2:=h; K2:=K; rr:=0; ii:=0;
      eps:=epsw*NORMAX(N,F[0])+epsa;
      DOBORKROKU(N,K,ALFA,C,F,eps);
      REPEAT
        IF (ST=1) AND (ALFA<1) THEN
        BEGIN
          BLAD:=103;
          EXIT
        END;
        IF PIERWSZY
          THEN BEGIN
                 IF ST<>1 THEN
                 BEGIN
                   h:=ALFA*h;
                   ZMIANAMACNOR(N,K,F,ALFA)
                 END;
                 PIERWSZY:=FALSE
               END
          ELSE IF (ALFA<1) OR ((ALFA>1) AND (KKR=K+1))
                 THEN BEGIN
                        K1:=K;
                        DOBORKROKUIRZEDU(N,6,K,ALFA,C,F,eps);
                        IF ST<>1 THEN
                        BEGIN
                          h:=ALFA*h;
                          ZMIANAMACNOR(N,K1,F,ALFA)
                        END;
                        KKR:=0
                      END
                 ELSE IF (ALFA>=2) AND (ST<>1) THEN
                      BEGIN
                        h:=ALFA*h;
                        ZMIANAMACNOR(N,K,F,ALFA)
                      END;
        { Dobor ostatniego kroku calkowania h1 celem }
        { trafienia do punktu koncowego  t1          }
        h1:=t1-t;
        IF (h1<h) AND (h>0) AND (ST<>1)
          THEN BEGIN
                 ALFA:=ABS(h1/h);
                 h:=h1;
                 ZMIANAMACNOR(N,K,F,ALFA)
               END
          ELSE IF (h1>h) AND (h<0) AND (ST<>1) THEN
               BEGIN
                 ALFA:=ABS(h1/h);
                 h:=h1;
                 ZMIANAMACNOR(N,K,F,ALFA)
               END;
        Hmin:=A26*ABS(t);
        IF (ABS(h) < Hmin) AND (ST<>1) THEN
        BEGIN
          BLAD:=102;
          EXIT
        END;
        REPEAT
          PREDYKTOR_MW(N,K,F);
          KOREKTOR_GEARA(ST,N,K,t,h,Hmin,epsw,epsa,F,BLAD);
          IF BLAD<>0 THEN
            EXIT;
          { Sprawdzenie kryterium bledu (5.114) rownowazne }
          { warunkowi ALFA>=1 po korekcie Geara            }
          eps:=epsw*NORMAX(N,F[0])+epsa;
          DOBORKROKU(N,K,ALFA,C,F,eps);
          ee:=1.2*ALFA;
          IF ee<1 THEN
          BEGIN
            h:=h2/2; K:=K2; F:=FP;
            ZMIANAMACNOR(N,K,F,0.5);
            FP:=F; h2:=h
          END
        UNTIL ee>=1; { Warunek dopuszczalnego bledu }
        INC(M); t:=t+h;  X1:=F[0]; X1[0]:=t;
        ZAPIS_D(X1,N,M,'C',N_PLIK,BLAD); { zapis do pliku }
        IF BLAD<>0 THEN
          EXIT;
        IF LICZNIK<>0 THEN
        BEGIN
          GOTOXY(HI(LICZNIK),LO(LICZNIK));
          WRITE(M:5)
        END;
        INC(KKR);
        FP:=F; h2:=h; K2:=K;
      UNTIL ((t>=t1)AND(t1>t0)) OR ((t<=t1)AND(t0>t1)) ;
      ZAPIS_D(X1,N,M,'E',N_PLIK,BLAD) { zapis do pliku N,M }
    END; { MET_GEAR_LIN }


END.
