PROGRAM PRZ8_3;
 {$F+}
 {$IFDEF CPU87} {$N+}
        {$ELSE} {$N-}
 {$ENDIF}
  USES  CRT,TFLOAT,LAPLACE,WYKRESY,KOM_BLAD;
  CONST TE1='Wybierz punkt linii w metrach w ktorym chcesz znac przebieg ';
        TE2='Wartosc x z poza przedzialu';
        TE3='Wybierz chwile czasowa w mikro sekundach w ktorej chcesz znac rozkld fali';
        TE4='Wartosc t z poza przedzialu';
  VAR   k,i,N,N2                  :WORD;
        Um,u,S0,t2,t1,dt,L,R,C,G,
        d,x,dx1,SX,T,w,i20,u20    :FLOAT;
        TX,UT                     :WEKD1;
        W1,W2                     :WEKI;
        WYB,CH                    :CHAR;
        LAN,LAN1,LAN2             :STRING;
        TAK                       :BOOLEAN;
        BLAD                      :BYTE;

  PROCEDURE DANE;
    BEGIN
      L:=2.48E-6;   { Indukcyjnosc jednostkowa llini w [H/m] }
      C:=1.9E-12;   { Pojemnosc jednostkowa linii w [F/m]    }
      R:=4E-3;      { Rezystancja jednostkowa linii w [OM/m] }
      G:=0.0;       { Konduktancja jednostkowa linii [1/OMm] }
      Um:=100.0;    { Amplituda impulsu napieciowego         }
      T:=5E-6;      { Czas trwania impulsu  w [sek]          }
      w:=2*PI/T;
      d:=2000;       { Dlugosc linii w [m]                   }
      i20:=0; u20:=0 { Wartosci poczatkowe pradu i napiecia  }
   END { DANE };

  FUNCTION SINH(X:FLOAT):FLOAT;
    VAR Y:FLOAT;
    BEGIN
      Y:=EXP(X);
      SINH:=(Y-1/Y)/2
    END { SINH };

  FUNCTION COSH(X:FLOAT):FLOAT;
    VAR Y:FLOAT;
    BEGIN
      Y:=EXP(X);
      COSH:=(Y+1/Y)/2
    END { COSH };

  FUNCTION TRAN_NAP_LIN(s:FLOAT):FLOAT;
    VAR  U0,ga:FLOAT;
    BEGIN
     { Transformata impulsu napieciowego wymuszonego  }
     { na poczatku linii wg wzoru (8.65)              }
      U0:= Um*0.5*(1-EXP(-s*T))*(1/s - s/(SQR(s)+SQR(w)));
      { Transformat fali napieciowej linii zwartej na koncu  }
      { linii wg.  wzoru (8.66)                              }
      ga:=SQRT((L*s+R)*(C*s+G));
      TRAN_NAP_LIN:=U0*SINH((d-x)*ga)/SINH(d*ga)
    END { TRAN_NAP_LIN };

  FUNCTION TRAN_PRAD_LIN(s:FLOAT):FLOAT;
    VAR  U0,ga:FLOAT;
    BEGIN
    { Transformata impulsu napieciowego wymuszonego  }
    { na poczatku linii wg wzoru (8.65)              }
      U0:= Um*0.5*(1-EXP(-S*T))*(1/S - S/(SQR(S)+SQR(w)));
    { Transformat fali pradowej  linii zwartej na koncu  }
    { linii wg.  wzoru (8.67)                            }
      ga:=SQRT((L*S+R)*(C*S+G));
      TRAN_PRAD_LIN:=U0*SQRT((C*S+G)/(L*S+R))*COSH((d-x)*ga)/SINH(d*ga)
    END { TRAN_PRAD_LIN };

  PROCEDURE MENU;
    BEGIN
      CLRSCR;
      WRITELN;
      WRITELN('Rozklad fali napieciowej i pradowej linii dlugiej');
      WRITELN('oraz przebiegi napiecia i pradu w wybranym punkcie');
      WRITELN;
      WRITELN('   U - przebieg napiecia w wybranym punkcie');
      WRITELN('       linii x z przedzialu (0,'+LAN1+') w [m]');
      WRITELN;
      WRITELN('   I - przebieg pradu w wybranym punkcie');
      WRITELN('       linii x z przedzialu (0,'+LAN1+') w [m]');
      WRITELN;
      WRITELN('   G - rozklad fali napieciowej w wybranej');
      WRITELN('       chwili t z przedzialu (0,'+LAN2+') w [miksek]');
      WRITELN;
      WRITELN('   F - rozklad fali pradowej w wybranej');
      WRITELN('       chwili t z przedzialu (0,'+LAN2+') w [miksek]');
      WRITELN;
      WRITELN('   K - koniec wyboru')
   END { MENU };

BEGIN
  NEW(TX); NEW(UT); { Inicjacja wektorow dynamicznych }
  DANE;
  N:=100;   N2:=300;
  t1:=10*T; { t1 - koncowy punkt czasowy przedzialu obliczen }
  dt:=t1/N2;  dx1:=d/N;
  STR(d:6:1,LAN1);  STR(t1*1E+6:3:0,LAN2);
  FOR k:=0 TO N2 DO TX^[k]:=k*dt;
  REPEAT
    MENU;
    WYB:=UPCASE(READKEY);
    CLRSCR;
    CASE WYB OF
      'I': BEGIN
             REPEAT
               WRITELN;
               WRITE(TE1+' pradu x='); READ(x);
               TAK:=(x>=0) AND (x<=d);
               IF NOT TAK THEN
                 BEGIN
                   CLRSCR; WRITE(TE2+' (0,',LAN1,') w [m]')
                 END
             UNTIL TAK;
             STR(x:5,LAN);   S0:=LN2P2/TX^[N2];
             OBORMSF(TRAN_PRAD_LIN,TX,UT,N2,24,i20,S0,0,BLAD);
             IF BLAD=0 THEN
             BEGIN
               FOR i:=0 TO N2 DO
               BEGIN
                 W1[i]:=TX^[i]*1E+6;
                 W2[i]:=UT^[i]
               END;
               WYKRESXYG(W1,W2,N2,' Przebieg pradu w wybranym punkcie linii  x= '+
                         LAN,'','t[miksek]','i(t) [A]')
             END
           END {I};
      'U': BEGIN
             REPEAT
               WRITELN;
               WRITE(TE1+' napiecia x='); READ(x);
               TAK:=(x>=0) AND (x<d);
               IF NOT TAK THEN
                 BEGIN
                   CLRSCR; WRITE(TE2+' (0,',LAN1,') w [m]')
                 END
             UNTIL TAK;
             STR(x:5,LAN);   S0:=LN2P2/TX^[N2];
             OBORMSF(TRAN_NAP_LIN,TX,UT,N2,24,u20,S0,0,BLAD);
             IF BLAD=0 THEN
             BEGIN
               FOR i:=0 TO N2 DO
               BEGIN
                 W1[i]:=TX^[i]*1E+6;
                 W2[i]:=UT^[i]
               END;
               WYKRESXYG(W1,W2,N2,'Przebieg napiecia w wybranym punkcie linii x='+
                         LAN,'','t[miksek]','u(t) [A]');
             END
           END { U };
      'G': BEGIN
             REPEAT
               WRITELN; WRITELN(TE3); WRITELN;
               WRITE('napieciowej           t='); READ(t2);
               TAK:=(t2>0) AND (t2<=t1*1E+6);
               IF NOT TAK THEN
               BEGIN
                 CLRSCR; WRITE(TE4+' (0,',LAN2,') w [mikro sek]')
               END
             UNTIL TAK;
             STR(t2:5:1,LAN); t2:=t2/1E+6;
             S0:=LN2P2/(t2+dt);
             FOR k:=0 TO N DO
             BEGIN
               GOTOXY(35,12); WRITE(N-k:5);
               x:=k*dx1; W1[k]:=x;
               OBORMSFT(TRAN_NAP_LIN,t2,u,24,u20,S0,0,BLAD);
               W2[k]:=u;
             END;
             FOR k:=0 TO N DO
                W1[k]:=W1[k]/1000;
             WYKRESXYG(W1,W2,N,' Rozklad fali napieciowej w chwili t= '+
                       LAN+' [mikrosek]','','x [km]','u(x,t) [V]')
           END {G};
      'F': BEGIN
             REPEAT
               WRITELN;  WRITE(TE3);  WRITELN;
               WRITE('pradowej          t='); READ(t2);
               TAK:=(t2>0) AND (t2<=t1*1E+6);
               IF NOT TAK THEN
               BEGIN
                 CLRSCR; WRITE(TE4+' (0,',LAN2,') w [mikrosek]')
               END
             UNTIL TAK;
             STR(t2:5:1,LAN);  t2:=t2/1E+6;
             S0:=LN2P2/(t2+dt);
             FOR k:=0 TO N DO
             BEGIN
               GOTOXY(35,12); WRITE(N-k:5);
               x:=k*dx1; W1[k]:=x;
               OBORMSFT(TRAN_PRAD_LIN,t2,u,24,i20,S0,0,BLAD);
               W2[k]:=u;
             END;
             FOR k:=0 TO N DO
               W1[k]:=W1[k]/1000;
              WYKRESXYG(W1,W2,N,'Rozklad fali pradowej w chwili t='+
                        LAN+' [mikrosek]','','x [km]','i(x,t) [A]')
            END
    END;
    IF BLAD<>0 THEN
    BEGIN
      PISZ_KOM_BLAD(BLAD);
      CH:=READKEY
    END
  UNTIL WYB='K';
  DISPOSE(UT); DISPOSE(TX)
END.
