PROGRAM PRZY8_1;
  {$F+}
  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
   USES  CRT,TFLOAT,LAPLACE,WYKRESY,KOM_BLAD;
   CONST LA  ='  Transf. odwrotna Laplace a dla ';
         US1 =' U(s)=1000/SQR(s+100*PI)';
         US2 =' U(s)=100*(s+20*PI)/(SQR(s+20*PI)+SQR(100*PI))';
         UT1 =' u(t)=1000*t*EXP(-100*PI*t) ';
         UT2 =' u(t)=100*EXP(-20*PI*t)*COS(100*PI*t) ';
         LAL ='   -   metoda szeregu Laguerre ';
         LAL1='metoda szeregu Laguerre dla obrazu';
         LAF ='   -   metoda szeregu Fouriera ';
         LAF1='metoda szeregu Fouriera dla obrazu';
   VAR   k,i,N,M                              :WORD;
         u0,S0,a,t1,t,dt                      :FLOAT;
         TX,FY                                :WEKD1;
         W1,W2                                :WEKI;
         WYB,CH                               :CHAR;
         BLAD                                 :BYTE;

   FUNCTION  ORYGI_EXPCOS(t:FLOAT):FLOAT;
     BEGIN
       ORYGI_EXPCOS:=100*EXP(-20*PI*t)*COS(100*PI*t)
     END { ORYGI_EXPCOS };

   FUNCTION TRAN_EXPCOS(s:FLOAT):FLOAT;
      BEGIN
        TRAN_EXPCOS:=100*(s+20*PI)/(SQR(s+20*PI)+SQR(100*PI))
      END { TRAN_EXPCOS };

   FUNCTION  ORYGI_TEXP(t:FLOAT):FLOAT;
     BEGIN
       ORYGI_TEXP:=1000*t*EXP(-100*PI*t)
     END { ORYGI_TEXP };

   FUNCTION TRAN_TEXP(s:FLOAT):FLOAT;
      BEGIN
        TRAN_TEXP:=1000/SQR(s+100*PI)
      END { TRAN_TEXP };

   PROCEDURE PODSTAW;
     BEGIN
       FOR i:=0 TO N DO
       BEGIN
         W1[i]:=TX^[i];
         W2[i]:=FY^[i]
       END
     END { PODSTAW };

   PROCEDURE DRUKUJ(    FUNKCJA       :FUNUS;
                    VAR TX,FY         :WEKD1;
                        N             :WORD;
                        NAZWA_FUNKCJI :STRING);
     VAR i,k,M        :WORD;
         t,Ft,pFt,dFt :FLOAT;
         CH           :CHAR;
     BEGIN
       M:=N div 16;
       CLRSCR;
       WRITELN('    Porownanie oryginalu u(t) z przyblizeniem numerycznym');
       WRITELN(NAZWA_FUNKCJI);WRITELN;
       WRITELN('      Czas     ','       Oryginal   ','    Przyblizenie    Blad bezwzgledny');
       WRITELN('        t      ','         u(t)      ','       pu(t)         u(t)-pu(t)');
       FOR i:=0 TO 16 DO
       BEGIN
         k:=M*i; t:=TX^[k]; pFt:=FY^[k];
         Ft:=FUNKCJA(t);  dFt:=Ft-pFt;
         WRITELN(t:15:10,'  ',Ft:15:10,'  ',pFt:15:10,'  ',dFt:15:10);
       END;
       CH:=READKEY
     END { DRUKUJ };

   PROCEDURE MENU;
     BEGIN
      CLRSCR;
      WRITELN(' Obliczenia testujace - transformacje odwrotnea Laplace a');
      WRITELN;
      WRITELN('    L - '+LAL1); WRITELN('           '+US1);
      WRITELN('    F - '+LAF1); WRITELN('           '+US1);
      WRITELN('    M - '+LAL1); WRITELN('           '+US2);
      WRITELN('    G - '+LAF1); WRITELN('           '+US2);
      WRITELN;
      WRITELN('    K - koniec wyboru');
    END { MENU };

BEGIN  { Blok glowny programu }
  t1:=0.02; N:=320; dt:=t1/N;
  NEW(TX); NEW(FY);
  FOR k:=0 TO N DO TX^[k]:=k*dt;
  REPEAT
    MENU;
    WYB:=UPCASE(READKEY);
    CASE WYB OF
     'L': BEGIN
            CLRSCR;
            S0:=5/TX^[N]; u0:=0; a:=0;
            OBORMSL(TRAN_TEXP,TX,FY,N,20,u0,S0,a,BLAD);
            IF BLAD=0 THEN
            BEGIN
              DRUKUJ(ORYGI_TEXP,TX,FY,N,LAL1+US1);
              PODSTAW;
              WYKRESXYG(W1,W2,N,LA+US1,LAL,'t','u(t)    ')
            END
          END {L};
     'F': BEGIN
            CLRSCR; S0:=0.5*SQRT(2)/TX^[N]; u0:=0; a:=0;
            OBORMSF(TRAN_TEXP,TX,FY,N,24,u0,S0,a,BLAD);
            IF BLAD=0 THEN
            BEGIN
              DRUKUJ(ORYGI_TEXP,TX,FY,N,LAF1+US1);
              PODSTAW;
              WYKRESXYG(W1,W2,N,LA+US1,LAF,'t','u(t)    ')
            END
          END {F};
     'M': BEGIN
            CLRSCR; S0:=5/TX^[N]; u0:=100; a:=0;
            OBORMSL(TRAN_EXPCOS,TX,FY,N,20,u0,S0,a,BLAD);
            IF BLAD=0 THEN
            BEGIN
              DRUKUJ(ORYGI_EXPCOS,TX,FY,N,LAL1+US2);
              PODSTAW;
              WYKRESXYG(W1,W2,N,LA+US2,LAL,'t','u(t)    ')
            END
          END {M};
     'G': BEGIN
            CLRSCR; S0:=0.2/TX^[N]; u0:=100; a:=0;
            OBORMSF(TRAN_EXPCOS,TX,FY,N,24,u0,S0,a,BLAD);
            IF BLAD=0 THEN
            BEGIN
              DRUKUJ(ORYGI_EXPCOS,TX,FY,N,LAF1+US2);
              PODSTAW;
              WYKRESXYG(W1,W2,N,LA+US2,LAF,'t','u(t)   ')
            END
          END {G}
    END;
    IF BLAD<>0 THEN
    BEGIN
      PISZ_KOM_BLAD(BLAD);
      CH:=READKEY
    END
  UNTIL WYB='K';
  DISPOSE(FY); DISPOSE(TX)
END.
