PROGRAM PRZ7_6;
  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
USES CRT,TFLOAT,ALGEZES,FOURIER,WYKRESY,KOM_BLAD;
VAR  w,RR,R,R1,L1,IW,ZM,dZ,dw,ZZ,F1,F2,P1,Hzp,Hrp :REAL;
     b,N,N1,j,k                                   :INTEGER;
     F                                            :WEKZD2;
     SI,CO                                        :WEKD2;
     Hz,Hr,Z                                      :WEKI;
     WYB,CH                                       :CHAR;
     BLAD                                         :BYTE;
     LAN,LAN1,LAN2,LAN3,LAN4,LAN5                 :STRING;

  PROCEDURE DANE;
    BEGIN
      b:=7 ; N:=POTEGA2(b); N1:=N SHR 1;
      R1:=0.05;  { Promien solenoidu w [m] }
      L1:=0.5;   { Dlugosc solenoidu w [m] }
      IW:=500;   { Amperozwoje solenoidu w [A] }
      R:=0.01;
      { Promien na ktorym badany jest rozklad pola magnetycznego}
      ZM:=2*L1; dZ:=ZM/N; dw:=2*PI/ZM;
    END;

  FUNCTION POTEGA(N:INTEGER;X:REAL):REAL;
    VAR W :REAL;
        I :INTEGER;
    BEGIN
      IF N=0
        THEN W:=1.0
        ELSE BEGIN
               W:=X;
               FOR I:=2 TO N DO
                 W:=W*X
             END;
      POTEGA:=W
    END { POTEGA };

   FUNCTION IZ(N:INTEGER;X:REAL):REAL;
     { Zmodyfikowana funkcja Bessela rzedu N wzor (3.160) }
     VAR Z,S,WYR,SIL :REAL;
         L,N2,I      :INTEGER;
    BEGIN
      IF X<15
        THEN BEGIN
               SIL:=1.0;
               FOR I:=1 TO N DO
                 SIL:=SIL*I;
               Z:=X*X; WYR:=1.0/(POTEGA(N,2.0)*SIL);
               S:=WYR; I:=1;
               WHILE ABS(WYR)>1E-20 DO
               BEGIN
                 WYR:=WYR*Z/(I*(N+I)*4);
                 S:=S+WYR;
                 INC(I)
               END;
               IZ:=POTEGA(N,X)*S
             END
        ELSE BEGIN
               N2:=4*N*N;
               Z:=8.0*X;
               WYR:=1.0/Z;
               WYR:=-WYR*(N2-1);
               S:=1.0+WYR;
               FOR I:=2 TO 10 DO
               BEGIN
                 L:=2*I-1; L:=L*L;
                 WYR:=-WYR*(N2-L)/(I*Z); S:=S+WYR
               END;
               IZ:=EXP(X)*S/SQRT(ABS(2.0*PI*X))
             END
    END {IZ};

   FUNCTION KN(N:INTEGER;X:REAL):REAL;
   { Funkcja MacDonalda rzedu N wzor (3.161) }
     VAR S1,SIL,R1,Z,WYR,S,S2,SL,SP,S3 :REAL;
         N2,L,I,J :INTEGER;
     BEGIN
      IF X<2.0
        THEN BEGIN
               SIL:=1.0;
               FOR I:=1 TO N DO
                 SIL:=SIL*I;
               Z:=X*X;
               WYR:=1.0/(POTEGA(N,2.0)*SIL);
               S:=WYR;
               IF N=0
                 THEN S3:=0
                 ELSE BEGIN
                        SP:=0;
                        FOR J:=1 TO N DO
                          SP:=SP+1/J;
                        S3:=WYR*SP
                      END;
               I:=1; SL:=1; SP:=0;
               FOR J:=1 TO N+1 DO
                 SP:=SP+1/J;
               WHILE ABS(WYR)>1E-20 DO
               BEGIN
                 WYR:=WYR*Z/(I*(N+I)*4.0);
                 IF I>1 THEN
                 BEGIN
                   SL:=SL+1/I;
                   SP:=SP+1/(N+I)
                 END;
                 S3:=S3+WYR*(SL+SP); S:=S+WYR; I:=I+1
               END;
               L:=-1;
               FOR J:=0 TO N DO
                 L:=-L;
               S3:=0.5*POTEGA(N,X)*L*S3;
               S:=POTEGA(N,X)*S;
               S1:=-L*S*(0.577156649+LN(0.5*X));
               IF N=0
                 THEN S2:=0
                 ELSE IF N=1
                        THEN S2:=1.0/X
                        ELSE BEGIN
                               Z:=0.25*X*X;
                               WYR:=-Z/(N-1);
                               S:=1.0+WYR;
                               FOR I:=2 TO N-1 DO
                               BEGIN
                                 WYR:=-WYR*Z/(I*(N-I));
                                 S:=S+WYR
                               END;
                               SIL:=SIL/N;
                               R1:=0.5*SIL*POTEGA(N,2.0/X);
                               S2:=R1*S
                             END;
               KN:=S1+S2+S3
             END
        ELSE BEGIN
               N2:=4*N*N; Z:=8*X;
               WYR:=(N2-1)/Z; S:=1+WYR;
               IF (X>=2) AND (X<=3)
                 THEN J:=3
                 ELSE J:=4;
               FOR I:=2 TO J DO
               BEGIN
                 L:=2*I-1; L:=L*L;
                 WYR:=WYR*(N2-L)/(I*Z); S:=S+WYR
               END;
               S1:=PI*0.5/X;
               KN:=SQRT(S1)*EXP(-X)*S
             END
    END { KN };

   PROCEDURE FUN(VAR F1,F2:REAL;w,R,R1,L1,IW:REAL);
     { Generacja funkcji zespolonej argumentu rzeczywistego w }
     { wzor (3.182) }
     VAR X,Y,A,P,SI,K1,I1,MM :REAL;
     BEGIN
       Y:=w*R1; X:=w*R; A:=w*L1/2;
       SI:=SIN(w*L1/2); P:=2*IW/(PI*L1);
       IF w=0.0
         THEN BEGIN { warunek wg (3.196) i (3.197) }
                IF R<=R1
                  THEN F1:=IW/(2*PI)
                  ELSE F1:=0.0;
                F2:=0.0
              END
         ELSE BEGIN
                K1:=KN(1,Y); I1:=IZ(1,Y);
                MM:=w*(IZ(0,Y)*K1+I1*KN(0,Y));
                IF R<=R1
                  THEN BEGIN
                         F1:=P*K1*IZ(0,X)*SI/MM;
                         F2:=P*K1*IZ(1,X)*SI/MM
                       END
                  ELSE BEGIN
                         F1:=-P*I1*KN(0,X)*SI/MM;
                         F2:=P*I1*KN(1,X)*SI/MM
                       END
              END
     END { FUN };

   PROCEDURE TABSINCOS(VAR SI,CO:WEKD2; Z:REAL; N:INTEGER);
     VAR k            :INTEGER;
         FI,SIN1,COS1 :REAL;
     BEGIN
       SI^[0]:=0.0; CO^[0]:=1.0;
       FI:=dw*Z; SIN1:=SIN(FI); COS1:=COS(FI);
       SI^[1]:=SIN1; CO^[1]:=COS1;
       FOR k:=2 TO N-1 DO
       BEGIN
         SI^[k]:=SIN1*CO^[k-1]+COS1*SI^[k-1];
         CO^[k]:=COS1*CO^[k-1]-SIN1*SI^[k-1]
       END
     END { TABSINCOS };

   PROCEDURE MENU;
     BEGIN
       CLRSCR;
       GOTOXY(1, 5);  WRITE('            Wybor opcji:');
       GOTOXY(1, 7);  WRITE('klawisz H - rozklad skladowej Hz pola magnetycznego');
       GOTOXY(1, 9);  WRITE('        R - rozklad skladowej Hr pola magnetycznego');
       GOTOXY(1,11);  WRITE('        P - pole w wybranym punkcie ');
       GOTOXY(1,13);  WRITE('        K - koniec wyboru')
     END { MENU };

BEGIN { Blok glowny programu }
  NEW(F);  NEW(SI); NEW(CO);
  DANE;
  CLRSCR;
  { Probkowanie funkcji zespolonej (3.182) dla zadanego r }
  { dla ciagu wk wg. wzoru (3.188)      }
  FOR k:=0 TO N-1 DO
  BEGIN
    w:=k*dw;
    FUN(F1,F2,w,R,R1,L1,IW);
    F^[k].RE:=F1*dw; F^[k].IM:=F2*dw
  END {k};
  { Obliczanie sumy wg dyskretnej transformacji Fouriera }
  FFTST(F,b,-1,BLAD);
  IF BLAD<>0 THEN
  BEGIN
    PISZ_KOM_BLAD(BLAD);
    HALT
  END;
  { Wyznaczanie pola magnetycznego wg. wzorow (3.194)(3.195) }
  Hz[0]:=F^[0].RE;  Hr[0]:=0; Z[0]:=0;
  FOR k:=1 TO N1-1 DO
  BEGIN
    Hz[k]:=(F^[k].RE+F^[N-k].RE)/2;
    Hr[k]:=(F^[k].RE-F^[N-k].RE)/2;
    Z[k]:=k*dZ
  END;
  STR(L1:6:4,LAN1); LAN1:='dlugosc L ='+LAN1+' [m]';
  STR(R1:6:4,LAN2); LAN2:=', promien R ='+LAN2+' [m]';
  STR(IW:5:1,LAN3); LAN3:=', amperozwoje Iw ='+LAN3+' [A]';
  STR(R:6:4,LAN4); LAN4:=LAN4+'[m]';
  LAN:=LAN1+LAN2+LAN3;
  LAN5:=' Rozklad skladowej pola magnetycznego solenoidu dla danych';
  REPEAT
    MENU;
    WYB:=UPCASE(READKEY);
    CASE WYB OF
      'H': WYKRESXYG(Z,Hz,N1-1,'Rys.1'+LAN5,LAN,'z [m]','Hz(r,z) [A/m] dla r='+LAN4);
      'R': WYKRESXYG(Z,Hr,N1-1,'Rys.2 '+LAN5,LAN,'z [m]','Hr(z,r) [A/m] dla r='+LAN4);
      'P': BEGIN
             CLRSCR;
             WRITELN('Podaj wspolrzedne (z,r) w ktorym nalezy'+
                     ' obliczyc natezenie pola magnetycznego');
             WRITE('z='); READ(ZZ);
             WRITE('r='); READ(RR);
             TABSINCOS(SI,CO,ZZ,N);
             Hzp:=0; Hrp:=0;
             FOR k:=0 TO N-1 DO
             BEGIN
               w:=k*dw;  FUN(F1,F2,w,RR,R1,L1,IW);
               Hzp:=Hzp+F1*CO^[k];
               Hrp:=Hrp+F2*SI^[k]
             END {k};
             Hzp:=Hzp*dw; Hrp:=Hrp*dw;
             WRITELN;
             WRITELN('Skladowe wektora natezenia pola magnetycznego wynosza');
             WRITELN('Hz=',Hzp:10:5,'     Hr=',Hrp:10:5);
             CH:=READKEY
           END {P}
      END;
  UNTIL WYB='K';
  DISPOSE(F) ;DISPOSE(SI); DISPOSE(CO)
END.
