PROGRAM PRZ7_5;
  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
USES CRT,TFLOAT,ALGEZES,FOURIER,WYKRESY,KOM_BLAD;
VAR  k,i,N                             :WORD;
     b                                 :BYTE;
     T0,T2,t,dt,Um,Us,Is,P,Q,D,Pm,w,
     R,L,C,Ls,Rs                       :FLOAT;
     Ip                                :WEKD2;
     W1,W2                             :WEKI;
     WYB,CH                            :CHAR;
     BLAD                              :BYTE;
     UT1,UT2,UT3                       :STRING;

   PROCEDURE DWOJNIK_SNU(    U          :FUNX;
                             ADMITANCJA :PROCYW;
                             T0         :FLOAT;
                             b          :BYTE;
                         VAR Ip         :WEKD2;
                         VAR BLAD       :BYTE);
{-----------------------------------------------------------------}
{ Analiza dwojnika liniowego w stanie nieustalonym przy dowolnym  }
{ wymuszeniu napieciowym i zerowych warunkach poczatkowych metoda }
{ transformacji Fouriera z zastosowaniem FFT                      }
{ U - funkcja U(t) typu FUNX okreslajaca                          }
{     napiece wymuszajace prad dwojnika                           }
{ ADMITANCJA(VAR Y:ZESPOL;w:FLOAT) - procedura typu PROCYW        }
{     wyznaczajaca admitancje zespolona Y dla dowolnej pulsacji w }
{ T0  - przedzial calkowania                                      }
{ Ip^ - wektor probek czasowych pradu zasilania  Ip^[k]           }
{      b                                                          }
{ N = 2   -  liczba skladowych powyzszych wektorow                }
{-----------------------------------------------------------------}
     VAR N,N1,k,l          : INTEGER;
         h,t,U0,I0,AX,w    : FLOAT;
         S0,Iss,S,Z,Y      : ZESPOL;
         Ih,Uh             : WEKZD2;
     BEGIN
       BLAD:=0;
       IF (b<5) OR (b>10)
       THEN BLAD:=255
       ELSE BEGIN
              N:=POTEGA2(b); N1:=N SHR 1;
              h:=T0/N; w:=2*PI/T0;
              NEW(Ih); NEW(Uh);
              FOR k:=0 TO N-1 DO
              BEGIN
                t:=k*h;
                Uh^[k].RE:=U(t) ; Uh^[k].IM:=0;
              END;
              FFTST(Uh,b,-1,BLAD);
              IF BLAD=0 THEN
              BEGIN
                FOR k:=0 TO N1 DO
                BEGIN
                  ADMITANCJA(Y,k*w);
                  MUL(Ih^[k],Uh^[k],Y);
                  IF (k>0) AND (k<N1) THEN SPRZ(Ih^[N-k],Ih^[k])
                END;
                FFTST(Ih,b,1,BLAD);
                IF BLAD=0 THEN
                  FOR k:=0 TO N-1 DO
                    Ip^[k]:=Ih^[k].RE/N
              END;
              DISPOSE(Ih); DISPOSE(Uh)
            END
    END { DWOJNIK_SNU };

   PROCEDURE DANE;
     BEGIN      { Przykladowe dane liczbowe }
       T0:=0.02 {sek};{ Okres obserwacji funkcji }
       T2:=T0/10;
       Um:=100; { Amplituda zadanej funkcji   }
                {                        b    }
       b:=9;    { Wykladnik potegi  N = 2     }
       w:=2*PI/T0;
       R:=10 {OM};  L:=10/w {H};  C:=1/(10*w);
       Rs:=1 {OM}; Ls:=1/w {H}
     END;

   FUNCTION  U(t:FLOAT):FLOAT; FAR;
     BEGIN
       IF (t>=0) AND (t<T2)
         THEN U:=Um
         ELSE IF t>=T2 THEN
                U:=0
     END { U };

   PROCEDURE ADMITANCJA(VAR Y:ZESPOL; w:FLOAT); FAR;
     VAR Z:ZESPOL;
     BEGIN
       Z.RE:=R; Z.IM:=w*L; ODW(Z,Z); Z.IM:=Z.IM+w*C;
       ODW(Z,Z); Z.RE:=Z.RE+Rs; Z.IM:=Z.IM+w*Ls;
       ODW(Y,Z)
     END { ADMITANCJA1 };

    PROCEDURE TEKSTY;
      BEGIN
        UT1:='u(t)=Um dla (t>=0)and(t<T0/20) oraz '+
             'u(t)=0 dla t>T0/20 ';
        UT2:='Y(w) = 1/(Rs+j*w*Ls+1/(j*w*C+1/(R+j*w*L)))';
      END { TEKSTY };

   PROCEDURE MENU;
     BEGIN
      CLRSCR;
      WRITE('Analiza dwojnika liniowego z zastosowaniem '+
            'dyskretnej transformacji Fouriera-FFT');
      WRITE('o wymuszeniu '+UT1);
      WRITE('i admitancji '+UT2,' w stanie nieustalonym');
      WRITELN;
      WRITELN;
      WRITELN('    U - napiecie wymuszajace ');
      WRITELN;
      WRITELN('    I -  odpowiedz pradowa dwojnika ');
      WRITELN;
      WRITELN('    K - koniec wyboru')
    END { MENU };

BEGIN  { Blok glowny programu }
  CLRSCR;
  DANE; TEKSTY;
  NEW(Ip);
  DWOJNIK_SNU(U,ADMITANCJA,T0,b,Ip,BLAD);
  IF BLAD=0
    THEN REPEAT
           MENU;
           WYB:=UPCASE(READKEY);
           CLRSCR;
           CASE WYB OF
             'I': BEGIN
                    N:=POTEGA2(b); dt:=T0/N;
                    FOR i:=0 TO N-1 DO
                    BEGIN
                      W1[i]:=i*dt;
                      W2[i]:=Ip^[i];
                    END;
                    WYKRESXYG(W1,W2,N-1,'  Przebieg pradu dwojnika ',
                              '','t [sek]','i(t) [A]')
                  END {I};
             'U': BEGIN
                    N:=POTEGA2(b); dt:=T0/N;
                    FOR i:=0 TO N-1 DO
                    BEGIN
                      W1[i]:=i*dt;
                      W2[i]:=U(W1[i]);
                    END;
                    WYKRESXYG(W1,W2,N-1,' Przebieg napiecia zasilajacego dwojnik ',
                              '','t [sek]','u(t) [V]')
                  END {U}
           END
         UNTIL WYB='K'
    ELSE BEGIN
           PISZ_KOM_BLAD(BLAD);
           CH:=READKEY
         END;
  DISPOSE(Ip)
END.
