PROGRAM PRZ7_3;
  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
USES CRT,TFLOAT,ALGEZES,FOURIER,WYKRESY,KOM_BLAD;
VAR  k,i,N                             :WORD;
     b                                 :BYTE;
     T0,T2,t,dt,Um,Us,Is,P,Q,D,Pm,w,
     R,L,C,Ls,Rs                       :FLOAT;
     Ip                                :WEKD2;
     W1,W2                             :WEKI;
     WYB,CH                            :CHAR;
     BLAD                              :BYTE;
     UT1,UT2,UT3                       :STRING;

   PROCEDURE DWOJNIK_SU(    U              :FUNX;
                            ADMITANCJA     :PROCYW;
                            T0             :FLOAT;
                            b              :BYTE;
                        VAR Us,Is,P,Q,D,Pm :FLOAT;
                        VAR Ip             :WEKD2;
                        VAR BLAD           :BYTE);
{-----------------------------------------------------------------}
{ Analiza dwojnika liniowego w stanie ustalonym przy dowolnym     }
{ wymuszeniu okresowym metoda szeregu Fouriera z zastosowaniem FFT}
{ U - funkcja U(t) typu FUNX okreslajaca                          }
{     napiece wymuszajace prad dwujnika                           }
{ ADMITANCJA(VAR Y:ZESPOL;w:FLOAT) - procedura typu PROCYW        }
{     wyznaczajaca admitancje zespolona Y dla dowolnej pulsacji w }
{ T0  - okres napiecia zasilania                                  }
{ Ip^ - wektor probek czasowych pradu zasilania  Ip^[k]           }
{      b                                                          }
{ N = 2   -  liczba skladowych powyzszych wektorow                }
{ Us - warosc skutecna napiecia zasilania                         }
{ Is - pradu zasilania                                            }
{ P  - moc czynna odbiornika                                      }
{ Q  - moc bierna odbiornika wg Budeanu                           }
{ D  - moc deformacji                                             }
{ Pm - moc modulowa                                               }
{-----------------------------------------------------------------}
     VAR N,N1,k,l          : INTEGER;
         la,h,t,w,U0,I0,AX : FLOAT;
         S0,Iss,S,Z,Y      : ZESPOL;
         Ih1,Ih,Uh         : WEKZD2;
     BEGIN
       BLAD:=0;
       IF (b<5) OR (b>10)
         THEN BLAD:=255
         ELSE BEGIN
                N:=POTEGA2(b);
                N1:=N SHR 1;
                h:=T0/N; la:=2/N; w:=2*PI/T0;
                NEW(Ih1);  NEW(Ih); NEW(Uh);
                FOR k:=0 TO N-1 DO
                BEGIN
                  t:=k*h;
                  Uh^[k].RE:=U(t)*la; Uh^[k].IM:=0
                END;
                FFTST(Uh,b,-1,BLAD);
                IF BLAD=0 THEN
                BEGIN
                  ADMITANCJA(Y,0);  MUL(Ih1^[0],Uh^[0],Y);
                  FOR k:=1 TO N1 DO
                  BEGIN
                    ADMITANCJA(Y,k*w);
                    MUL(Ih1^[k],Uh^[k],Y);
                    SPRZ(Ih1^[N-k],Ih1^[k])
                  END;
                  Ih^:=Ih1^;
                  FFTST(Ih1,b,1,BLAD);
                  IF BLAD=0 THEN
                  BEGIN
                    FOR k:=0 TO N-1 DO
                      Ip^[k]:=Ih1^[k].RE/2;
                    Us:=0; Is:=0; S.RE:=0; S.IM:=0;
                    FOR K:=1 TO N1 DO
                    BEGIN
                      I0:=KWMODUL(Ih^[k]); Is:=Is+I0;
                      U0:=KWMODUL(Uh^[k]); Us:=Us+U0;
                      SPRZ(Iss,Ih^[k]); MUL(S0,Uh^[k],Iss); ADD(S,S,S0)
                    END;
                    Is:=Is/2; Us:=Us/2; MULRZ(S,S,0.5);
                    I0:=KWMODUL(Ih^[0]); Is:=Is+I0/4; Is:=SQRT(Is);
                    U0:=KWMODUL(Uh^[0]); Us:=Us+U0/4; Us:=SQRT(Us);
                    SPRZ(Iss,Ih^[0]); MUL(S0,Uh^[0],Iss);
                    MULRZ(S0,S0,0.25); ADD(S,S,S0);
                    P:=S.RE; Q:=S.IM; Pm:=Us*Is;
                    D:=SQRT(SQR(Pm)-SQR(P)-SQR(Q))
                  END
                END;
                DISPOSE(Ih1); DISPOSE(Ih);  DISPOSE(Uh)
              END
    END { DWOJNIK_SU };

   PROCEDURE DANE;
     BEGIN  { Przykladowe dane liczbowe }
       T0:=0.02 {sek};{ Okres zadanej funkcji }
       T2:=T0/2;
       Um:=100; { Amplituda zadanej funkcji }
              {                        b    }
       b:=8;  { Wykladnik potegi  N = 2     }
       w:=2*PI/T0;
       R:=10 {OM};  L:=10/w {H};  C:=1/(10*w);
       Rs:=1 {OM}; Ls:=1/w {H};
     END;

   FUNCTION  U(t:FLOAT):FLOAT; FAR;
   { Napiecie w postaci fali prostokatnej ,wzor (7.122) }
     BEGIN
       IF (t>=0) AND (t<T2)
         THEN U:=Um
         ELSE IF (t>=T2) AND (t<=T0) THEN
                U:=-Um
     END { U };

   PROCEDURE ADMITANCJA(VAR Y:ZESPOL; w:FLOAT); FAR;
    { Admitancja dwojnika wg wzoru (7.123) }
     VAR Z:ZESPOL;
     BEGIN
       Z.RE:=R; Z.IM:=w*L; ODW(Z,Z); Z.IM:=Z.IM+w*C;
       ODW(Z,Z); Z.RE:=Z.RE+Rs; Z.IM:=Z.IM+w*Ls;
       ODW(Y,Z)
     END { ADMITANCJA1 };

    PROCEDURE TEKSTY;
      BEGIN
        UT1:='u(t)=Um dla (t>=0)and(t<T0/2) oraz '+
             'u(t)=-Um dla (t>T0/2)and(t<=T0) ';
        UT3:='Y(w) = 1/(Rs+j*w*Ls+1/(j*w*C+1/(R+j*w*L)))';
      END { TEKSTY };

   PROCEDURE MENU;
     BEGIN
      CLRSCR;
      WRITE('Analiza dwojnika liniowego z zastosowaniem '+
            'dyskretnej transformacji Fouriera-FFT');
      WRITE('o wymuszeniu '+UT1);
      WRITE('i admitancji '+UT3);  WRITELN;
      WRITELN;
      WRITELN('  U - okresowe napiecie wymuszajace o okresie T0');
      WRITELN;
      WRITELN('  I -  odpowiedz pradowa dwojnika ');
      WRITELN;
      WRITELN('  P -  warosci skuteczne pradu i napiecia oraz moce dwojnika ');
      WRITELN;
      WRITELN('  K - koniec wyboru');
    END { MENU };

BEGIN  { Blok glowny programu }
  CLRSCR;
  DANE; TEKSTY;
  NEW(Ip);
  DWOJNIK_SU(U,ADMITANCJA,T0,b,Us,Is,P,Q,D,Pm,Ip,BLAD);
  IF BLAD=0
    THEN REPEAT
           MENU;
           WYB:=UPCASE(READKEY);
           CLRSCR;
           CASE WYB OF
            'I': BEGIN
                   N:=POTEGA2(b); dt:=T0/N;
                   FOR i:=0 TO N-1 DO
                   BEGIN
                     W1[i]:=i*dt;
                     W2[i]:=Ip^[i]
                   END;
                   W1[N]:=W1[N-1]+dt;
                   W2[N]:=W2[0];
                   WYKRESXYG(W1,W2,N,'  Przebieg pradu dwojnika ',
                             '','t [sek]','i(t) [A]')
                 END {I};
            'U': BEGIN
                   N:=POTEGA2(b); dt:=T0/N;
                   FOR i:=0 TO N-1 DO
                   BEGIN
                     W1[i]:=i*dt;
                     W2[i]:=U(W1[i])
                   END;
                   WYKRESXYG(W1,W2,N-1,'  Przebieg napiecia zasilajacego dwojnik ',
                             '','t [sek]','u(t) [V]')
                 END {U};
            'P': BEGIN
                   WRITELN('Warosci skuteczne pradu i napiecia oraz moce dwojnika ');
                   WRITELN('napieciowe '+UT1);
                   WRITELN('admitancja '+UT3);
                   WRITELN('Wartosc skuteczna napiecia zasilajacego ',
                           '  U = ',Us:8:3,' [V]');
                   WRITELN('Wartosc skuteczna pradu zasilajacego    ',
                           '  I = ',Is:8:3,' [A]');
                   WRITELN('Moc czynna pobierana przez dwojnik      ',
                           '  P = ',P:8:3,' [W]');
                   WRITELN('Moc bierna pobierana przez dwojnik      ',
                           '  Q = ',Q:8:3,' [VA]');
                   WRITELN('Moc deformacji pobierana przez dwojnik  ',
                           '  D = ',D:8:3,' [VA]');
                   WRITELN('Moc modulowa pobierana przez dwojnik    ',
                           '  Pm = ',Pm:8:3,' [VA]');
                   CH:=READKEY
                 END {P}
           END
         UNTIL WYB='K'
    ELSE BEGIN
           PISZ_KOM_BLAD(BLAD);
           CH:=READKEY
         END;
  DISPOSE(Ip);
END.
