PROGRAM PRZYK4_2;

{$F+}
{$M 60000,2000,650000}
{$IFDEF CPU87} {$N+}
       {$ELSE} {$N-}
{$ENDIF}

USES CRT,TFLOAT,ALGELIN,RONIELIN;
TYPE
     { Typ funkcyjny do zapisu rezystancji nieliniowej }
     { uzaleznionej napieciowo                         }
     FUNU = FUNCTION(U:FLOAT):FLOAT;
     { Typ galeziowy do zapisu danych }
     { w poszczegolnych galeziach     }
     GALAZNIELIN = RECORD
                     Wp,      { wezel poczatkowy galezi       }
                     Wk       { wezel koncowy galezi          }
                        :BYTE;
                     E        { sila elektromotoryczna galezi }
                        :FLOAT;
                     G  :FUNU { G(U) - rezystancja nieliniowa }
                              {        uzalezniona napieciowo }
                   END;
     { Zapis danych galeziowych w postaci wektora }
     { o elementach typu GALAZNIELIN              }
     DANEGALAZ = ARRAY[PMAX] OF GALAZNIELIN;

VAR  k,l,m,Lg,Lw :PMAX;
     Ig,Ug,a1,a2,a3,a4,a5,a6,a7,a8,b3,b4,b5,b7,c7,b8
                 :FLOAT;
     D           :DANEGALAZ;
     V           :WEK;
     BLAD        :BYTE;
     WYB,CH,RODZ :CHAR;

FUNCTION SGN(U:FLOAT):FLOAT;
  BEGIN
    IF U>0
      THEN SGN:=1
      ELSE IF U<0
             THEN SGN:=-1
             ELSE SGN:=0
  END; { SGN }

FUNCTION G1(U:FLOAT):FLOAT;
  BEGIN
    G1:=a1*U
  END; { G1 }

FUNCTION G2(U:FLOAT):FLOAT;
  BEGIN
    G2:=a2*U*U*U
  END; { G2 }

FUNCTION G3(U:FLOAT):FLOAT;
  BEGIN
    G3:=a3*U+b3*U*U*U
  END; { G3 }

FUNCTION G4(U:FLOAT):FLOAT;
  VAR S:FLOAT;
  BEGIN
    S:=EXP(-b4*ABS(U));
    G4:=a4*SGN(U)*(1-S)
  END; { G4 }

FUNCTION G5(U:FLOAT):FLOAT;
  BEGIN
    G5:=a5*SGN(U)*LN(1+b5*ABS(U))
  END; { G5 }

FUNCTION G6(U:FLOAT):FLOAT;
  BEGIN
    G6:=a6*SGN(U)*SQRT(SQRT(ABS(U)))
  END; { G6 }

FUNCTION G7(U:FLOAT):FLOAT;
  BEGIN
    G7:=a7*U+b7*ARCTAN(c7*U)
  END; { G7 }

FUNCTION G8(U:FLOAT):FLOAT;
  BEGIN
    G8:=U/(a8+b8*ABS(U))
  END; { G8 }

PROCEDURE RODZAJREZYSTANCJI(k:BYTE);
  BEGIN
    WRITELN('Wybor rezystancji nieliniowych galezi nr=',k,
            ' uzaleznionych napieciowo ');
    WRITELN(' o charakterystykach');
    WRITELN(' klawisz  1 -  G1(u) = a1*u ');
    GOTOXY(11,WHEREY); WRITELN('2 -  G2(u) = a2*u*u*u ');
    GOTOXY(11,WHEREY); WRITELN('3 -  G3(u) = a3*u+b3*u*u*u ');
    GOTOXY(11,WHEREY);
    WRITELN('4 -  G4(u) = a4*SGN(u)*(1-EXP(-b4*ABS(u))) ');
    GOTOXY(11,WHEREY);
    WRITELN('5 -  G5(u) = a5*SGN(u)*LN(1+b5*ABS(u)) ');
    GOTOXY(11,WHEREY);
    WRITELN('6 -  G6(u) = a6*SGN(u)*SQRT(SQRT(ABS(u)))');
    GOTOXY(11,WHEREY);
    WRITELN('7 -  G7(u) = a7*u+b7*ARCTAN(c7*u) ');
    GOTOXY(11,WHEREY);
    WRITELN('8 -  G8(u) = u/(a8+b8*ABS(u)) ')
  END { RODZAJREZYSTANCJI };

PROCEDURE PISZ_DANE_UKLADU;
{ W postaci zmiennej D dla poszczegolnych galezi }
  VAR k:PMAX;
  BEGIN
    CLRSCR;
    WRITELN('      Pisz dane galeziowe ukladu elektrycznego ');
    WRITELN('     ------------------------------------------');
    WRITELN;
    WRITE('Podaj liczbe galezi ukladu Lg='); READ(Lg);
    WRITE('Podaj liczbe wezlow ukladu Lw='); READ(Lw);
    FOR k:=1 TO Lg DO
    BEGIN
      CLRSCR;
      WRITE('Galaz nr=',k,'        - orientacja od wezla nr=');
      READ(D[k].Wp);
      WRITE('----------                     do wezla nr=');
      READ(D[k].Wk);
      WRITE('  -  sila elektromotoryczna w woltach E(',k,')=');
      READ(D[k].E);
      WRITELN; RODZAJREZYSTANCJI(k); WRITELN;
      RODZ:=READKEY; RODZ:=UPCASE(RODZ);
      CASE RODZ OF
        '1': BEGIN
               WRITE('a1='); READ(a1); D[k].G:=G1
             END;
        '2': BEGIN
               WRITE('a2='); READ(a2); D[k].G:=G2
             END;
        '3': BEGIN
               WRITE('a3='); READ(a3);
               WRITE('b3='); READ(b3); D[k].G:=G3
             END;
        '4': BEGIN
               WRITE('a4='); READ(a4);
               WRITE('b4='); READ(b4); D[k].G:=G4
             END;
        '5': BEGIN
               WRITE('a5='); READ(a5);
               WRITE('b5='); READ(b5); D[k].G:=G5
             END;
        '6': BEGIN
               WRITE('a6='); READ(a6); D[k].G:=G6
             END;
        '7': BEGIN
               WRITE('a7='); READ(a7);
               WRITE('b7='); READ(b7);
               WRITE('c7='); READ(c7); D[k].G:=G7
             END;
        '8': BEGIN
               WRITE('a8='); READ(a8);
               WRITE('b8='); READ(b8); D[k].G:=G8
             END
      END
    END
  END { PISZ_DANE_UKLADU };

PROCEDURE NIELIN(VAR F:WEK; V:WEK; N:BYTE);
  { Generacja funkcji wektorowej nieliniowej F(X) (4.101)     }
  { rownan nieliniowych (4.99) lub (4.100) metoda potencjalow }
  { Coltriego                                                 }
  VAR k,l,m :PMAX;
      U,FU  :FLOAT;
  BEGIN
    FOR k:=1 TO N DO
      F[k]:=0;
    FOR m:=1 TO Lg DO
    BEGIN
      k:=D[m].Wp;  l:=D[m].Wk;
      IF k=Lw
        THEN BEGIN { warunek (1.90c) }
               U:=-V[l]+D[m].E;
               F[l]:=F[l]+D[m].G(U)
             END
        ELSE IF l=Lw
               THEN BEGIN { warunek (1.90d) }
                      U:=V[k]+D[m].E;
                      F[k]:=F[k]-D[m].G(U);
                    END
               ELSE BEGIN { warunki (1.90a,b) }
                      U:=V[k]-V[l]+D[m].E;
                      FU:=D[m].G(U);
                      F[k]:=F[k]-FU;  F[l]:=F[l]+FU;
                    END
    END
  END { NIELIN };

PROCEDURE MENU;
  BEGIN
    CLRSCR;
    WRITELN('        Analiza ukladu elektrycznego'); WRITELN;
    WRITELN('             V - rozklad potencjalow');
    WRITELN('             I - rozplyw pradow');
    WRITELN('             K - koniec wyboru')
  END { MENU };

BEGIN { Blok glowny programu }
  PISZ_DANE_UKLADU;
  FOR k:=1 TO Lw DO
    V[k]:=0;
  METNEW(NIELIN,V,Lw-1,1E-5,1E-4,500,BLAD);
  REPEAT
    CLRSCR;
    MENU;
    WYB:=UPCASE(READKEY);
    CASE WYB OF
      'V': BEGIN
             CLRSCR;
             WRITELN('Rozklad potencjalow ukladu');
             FOR k:=1 TO Lw DO
               WRITELN('V[',k,']=',V[k]:12:6);
             CH:=READKEY;
           END { V };
      'I': BEGIN
             CLRSCR;
             WRITELN('Rozplyw pradow ukladu');
             FOR m:=1 TO Lg DO
             BEGIN
               k:=D[m].Wp;  l:=D[m].Wk;
               Ug:=(V[k]-V[l]+D[m].E);  Ig:=D[m].G(Ug);
               WRITELN('I[',m,']=',Ig:12:6)
             END;
             CH:=READKEY;
           END { I }
    END
  UNTIL WYB='K'
END.
