PROGRAM PRZ2_3;

{$IFDEF CPU87} {$N+}
       {$ELSE} {$N-}
{$ENDIF}

USES CRT,TFLOAT,ALGEZES,ALGMZESD,KOM_BLAD;
TYPE
  { Typ galeziowy do zapisu danych w poszczegolnych galeziach }
    GALAZZES = RECORD Wp, { wezel poczatkowy galezi      }
                      Wk  { wezel koncowy galezi         }
                        :BYTE;
                      Y,  { admitancja  zespolona galezi }
                      E   { SEM zespolona galezi         }
                       :ZESPOL
               END;
    { Zapis danych galeziowych w postaci wektora }
    DANEGALAZZES = ARRAY[PMAXD] OF GALAZZES;

VAR k,l,m,Lg,Lw :PMAXD;
    Ug,Ig       :ZESPOL;
    D           :DANEGALAZZES;
    G,B,V       :MACZD;
    BLAD        :BYTE;
    WYB,CH      :CHAR;

PROCEDURE PISZ_DANE_UKLADU;
{ W postaci zmiennej D dla poszczegolnych galezi }
  VAR k:PMAXD;
  BEGIN
    CLRSCR;
    WRITELN('       Pisz dane galeziowe ukladu elektrycznego');
    WRITELN('       ----------------------------------------');
    WRITELN;
    WRITE('Podaj liczbe galezi ukladu Lg= '); READ(Lg);
    WRITE('Podaj liczbe wezlow ukladu Lw= '); READ(Lw);
    FOR k:=1 TO Lg DO
    BEGIN
      WRITELN('Galaz nr=',k);
      WRITELN('--------------');
      WRITE('   - orientacja od wezla nr=');
      READ(D[k].Wp);
      WRITE('                do wezla nr=');
      READ(D[k].Wk);
      WRITELN('   - SEM w woltach E(',k,')');
      WRITE('             czesc rzeczywista RE{E(',k,')}=');
      READ(D[k].E.RE);
      WRITE('             czesc urojona     IM{E(',k,')}=');
      READ(D[k].E.IM);
      WRITE('   - konduktancja w simensach G(',k,')=');
      READ(D[k].Y.RE);
      WRITE('   - susceptancja w simensach B(',k,')=');
      READ(D[k].Y.IM)
    END
  END { PISZ_DANE_UKLADU };

PROCEDURE GENERACJA_ROWNANIA(VAR G,B:MACZD);
{ G*V=B  metoda potencjalow Coltriego wg wzoru (1.107), (1.108) }
  VAR k,l,m :PMAXD;
      Z     :ZESPOL;
  BEGIN
    FOR k:=1 TO Lw-1 DO
    BEGIN
      B[1]^[k]:=Z0;   { Zerowanie wektora B }
      FOR l:=1 TO Lw-1 DO
        G[k]^[l]:=Z0  { Zerowanie macierzy G }
    END;
    FOR m:=1 TO Lg DO
    BEGIN
      k:=D[m].Wp;  l:=D[m].Wk;
      IF k=Lw
        THEN BEGIN            { warunek (1.109c) }
               MUL(Z,D[m].E,D[m].Y);
               ADD(B[1]^[l],B[1]^[l],Z);
               ADD(G[l]^[l],G[l]^[l],D[m].Y)
             END
        ELSE IF l=Lw
               THEN BEGIN     { warunek (1.109d) }
                      MUL(Z,D[m].E,D[m].Y);
                      SUB(B[1]^[k],B[1]^[k],Z);
                      ADD(G[k]^[k],G[k]^[k],D[m].Y)
                    END
               ELSE BEGIN   { warunki (1.109a,b) }
                      MUL(Z,D[m].E,D[m].Y);
                      SUB(B[1]^[k],B[1]^[k],Z);
                      ADD(B[1]^[l],B[1]^[l],Z);
                      ADD(G[k]^[k],G[k]^[k],D[m].Y);
                      ADD(G[l]^[l],G[l]^[l],D[m].Y);
                      MULRZ(G[k]^[l],D[m].Y,-1);
                      MULRZ(G[l]^[k],D[m].Y,-1);
                    END
      END
  END { GENERACJA_ROWNANIA };

PROCEDURE MENU;
  BEGIN
    CLRSCR;
    WRITELN('        Obliczenia ukladu elektrycznego');
    WRITELN;
    WRITELN('             V - rozklad potencjalow');
    WRITELN('             I - rozplyw pradow');
    WRITELN('             K - koniec wyboru')
  END { MENU };

BEGIN { Blok glowny programu }
  PISZ_DANE_UKLADU;
  NEWMACZD(G,Lw-1,BLAD); { Tworzenie macierzy dynamicznej G }
  IF BLAD=0 THEN
  BEGIN
    NEWMACZD(B,1,BLAD);    { Tworzenie wektora dnamicznego B  }
    IF BLAD=0 THEN
    BEGIN
      NEWMACZD(V,1,BLAD);    { Tworzenie wektora dnamicznego V  }
      IF BLAD=0 THEN
      BEGIN
        GENERACJA_ROWNANIA(G,B);
        { Rozwiazywanie ukladu rownan pkt 2.29 }
        RRMAZD(G,B,V,Lw-1,1,1E-16,BLAD);
        IF BLAD=0 THEN
        BEGIN
          { Potencjal wezla o numerze Lw przyjmuje sie jako zerowy }
          V[1]^[Lw]:=Z0;
          REPEAT
            CLRSCR;
            MENU;
            WYB:=UPCASE(READKEY);
            CASE WYB OF
              'V': BEGIN
                     CLRSCR;
                     WRITELN('Rozklad potencjalow ukladu');
                     FOR k:=1 TO Lw DO
                       IF V[1]^[k].IM>=0
                         THEN WRITELN('V[',k,']=',V[1]^[k].RE:12:6,
                                      '+j',V[1]^[k].IM:12:6)
                         ELSE WRITELN('V[',k,']=',V[1]^[k].RE:12:6,
                                      '-j',ABS(V[1]^[k].IM):12:6);
                     CH:=READKEY
                   END;
              'I': BEGIN
                     CLRSCR;
                     WRITELN('Rozplyw pradow ukladu');
                     FOR m:=1 TO Lg DO
                     BEGIN
                       k:=D[m].Wp;  l:=D[m].Wk;
                       SUB(Ug,V[1]^[k],V[1]^[l]);
                       ADD(Ug,Ug,D[m].E);
                       MUL(Ig,Ug,D[m].Y);
                       IF Ig.IM>=0
                         THEN WRITELN('I[',m,']=',Ig.RE:12:6,
                                      '+j',Ig.IM:12:6)
                         ELSE WRITELN('I[',m,']=',Ig.RE:12:6,
                                      '-j',ABS(Ig.IM):12:6)
                     END;
                     CH:=READKEY
                   END
              END
          UNTIL WYB='K'
        END
      END;
      DISMACZD(V,1)  { Odwolanie wektora dnamicznego V }
    END;
    DISMACZD(B,1)    { Odwolanie wektora dnamicznego B }
  END;
  DISMACZD(G,Lw-1);  { Odwolanie macierzy dynamicznej G }
  IF BLAD<>0
    THEN PISZ_KOM_BLAD(BLAD)
END.
