PROGRAM PRZ1_6;
{ Interpolacja funkcji f(x) funkcja sklejana trzeciego stopnia}

{$IFDEF CPU87} {$N+}
       {$ELSE} {$N-}
{$ENDIF}

USES CRT,GRAPH,TFLOAT,ALGELIND,KOM_BLAD;
CONST SCIEZKA ='C:\BP\BGI'; { Sciezka sterownikow karty graficznej }
VAR   N       :BYTE;        { Liczba punktow wezlowych             }
      X,F,                  { Wartosci probek                      }
      A,B,C,D :WEKD;        { Wektory wspolczynnikow wielomianu    }
      XP,XK   :FLOAT;       { Przedzial probkowania                }
      KEY     :CHAR;
      BLAD    :BYTE;

   FUNCTION FUNK(X:REAL):REAL;     { Funkcja interpolowana }
     BEGIN
       FUNK:=X*SIN(X)
     END; { F }

   PROCEDURE PROBKUJ;              { Probkowanie funkcji   }
     VAR H:REAL;
         I:BYTE;
     BEGIN
       H:=(XK-XP)/N;
       FOR I:=0 TO N DO
       BEGIN
         X[I]:=XP+I*H;
         F[I]:=FUNK(X[I])
       END
     END; { PROBKUJ }

   PROCEDURE SKLEJ;
   { Obliczanie wartosci wspolczynnikow funkcji sklejanej  }
     VAR U,W2,W,V :WEKD;
         HI,HI1   :REAL;
         I        :BYTE;
     BEGIN
       { Obliczanie macierzy wspolczynnikow i wektora
         wyrazow wolnych ukladu rownan (1.114)         }
       FOR I:=1 TO N-1 DO
       BEGIN
         W2[I]:=2;
         HI:=X[I+1]-X[I]; HI1:=X[I]-X[I-1];
         IF I<=N-2 THEN
           W[I]:=HI/(HI1+HI);
         IF I>=2 THEN
           U[I]:=HI1/(HI1+HI);
         V[I]:=3/(HI1+HI)*((F[I+1]-F[I])/HI-(F[I]-F[I-1])/HI1)
       END;
       { Wyliczenie wspolczynnikow c[i] funkcji (1.110) }
       RRALWTPD(W2,U,W,V,C,N-1,1E-18,BLAD);
       C[0]:=0;
       IF BLAD<>0
         THEN PISZ_KOM_BLAD(BLAD)
         ELSE
              { Obliczenie wspolczynnikow a[i], b[i], d[i]
                funkcji (1.110) wg wzorow (1.111), (1.112), (1.113) }
              FOR I:=0 TO N-1 DO
              BEGIN
                HI:=X[I+1]-X[I];
                A[I]:=F[I];
                B[I]:=(F[I+1]-F[I])/HI-HI/3*(C[I+1]+2*C[I]);
                D[I]:=(C[I+1]-C[I])/(3*HI)
              END
     END; { SKLEJ }

   PROCEDURE RYSUJ;
     VAR WX,WY,           { Wspolczynniki skalowania wykresow }
         DX,              { Przyrost argumentu na piksel      }
         X1,X2,
         MINF,MAXF  :REAL;    { Wartosc minimalna i maksymalna
                                wykreslanych funkcji          }
         I,SI       :BYTE;
         MAXX,MAXY  :WORD;    { Rozmiar okienka graficznego   }
         KARTA,TRYB :INTEGER; { Parametry trybu graficznego   }

       FUNCTION PX(X:REAL):WORD;
         { Przeliczenie wspolrzednej X ukladu kartezjanskiego
           na wspolrzedna X piksela ekranu graficznego        }
         BEGIN
           PX:=ROUND((X-XP)*WX)
         END; { PX }

       FUNCTION PY(F:REAL):WORD;
         { Przeliczenie wspolrzednej Y ukladu kartezjanskiego
           na wspolrzedna Y piksela ekranu graficznego        }
         BEGIN
           PY:=MAXY-ROUND((F-MINF)*WY)
         END; { PY }

       FUNCTION S(X1:REAL; I:BYTE):REAL;
         { Obliczenie wartosci funkcji sklejanej (1.91)       }
         VAR H:REAL;
         BEGIN
           H:=X1-X[I];
           S:=A[I]+B[I]*H+C[I]*H*H+D[I]*H*H*H
         END; { S }

     BEGIN
       { Inicjacja trybu graficznego wysokiej rozdzielczosci  }
       KARTA:=DETECT;
       INITGRAPH(KARTA,TRYB,SCIEZKA);
       MAXX:=GETMAXX; MAXY:=GETMAXY;
       DX:=(XK-XP)/GETMAXX;
       X1:=XP;
       { Obliczenie wartosci ekstremalnych funkcji zadanej    }
       MAXF:=FUNK(X1); MINF:=MAXF;
       WHILE X1<XK DO
       BEGIN
         X1:=X1+DX;
         IF MINF>FUNK(X1)
           THEN MINF:=FUNK(X1)
           ELSE IF MAXF<FUNK(X1) THEN
                  MAXF:=FUNK(X1)
       END;
       IF BLAD=0 THEN
       BEGIN
         { Obliczenie wartosci ekstremalnych funkcji sklejanej}
         I:=0; X1:=XP;
         REPEAT
           IF MINF>S(X1,I)
             THEN MINF:=S(X1,I)
             ELSE IF MAXF<S(X1,I) THEN
                    MAXF:=S(X1,I);
           X1:=X1+DX;
           IF X1>X[I+1] THEN
             INC(I)
         UNTIL I=N
       END;
       WX:=MAXX/(XK-XP); WY:=MAXY/(MAXF-MINF);
       SETLINESTYLE(SOLIDLN,0,NORMWIDTH);
       { Rysowanie punktow wezlowych }
       FOR I:=0 TO N DO
         CIRCLE(PX(X[I]),PY(F[I]),3);
       { Rysowanie funkcji zadanej }
       X1:=XP;
       REPEAT
         X2:=X1;
         X1:=X2+DX;
         LINE(PX(X2),PY(FUNK(X2)),PX(X1),PY(FUNK(X1)))
       UNTIL X1>=XK;
       IF BLAD=0 THEN
       BEGIN
         { Rysowanie funkcji sklejanej }
         SETLINESTYLE(SOLIDLN,0,THICKWIDTH);
         I:=0; X1:=XP;
         REPEAT
           X2:=X1;
           X1:=X2+DX;
           SI:=I;
           IF X1>X[I+1] THEN
             INC(I);
           LINE(PX(X2),PY(S(X2,SI)),PX(X1),PY(S(X1,I)))
         UNTIL X1>(XK-DX)
       END;
       KEY:=READKEY;
       CLOSEGRAPH
     END; { RYSUJ }

BEGIN
  REPEAT
    CLRSCR;
    REPEAT
      WRITE('Podaj liczbe punktow probkowania (N>2)  N= ');
      READ(N);
      WRITE('Podaj poczatek przedzialu XP= '); READ(XP);
      WRITE('Podaj koniec przedzialu   XK= '); READ(XK)
    UNTIL (N>2) AND (XP<XK);
    PROBKUJ;
    SKLEJ;
    RYSUJ
  UNTIL UPCASE(KEY)='K'
END.
