{***************************************************************************}
{                          Modul MINFUNBO                                   }
{                     BADANIE FUNKCJI NIELINIOWYCH                          }
{                     Turbo Pascal  wersja 7.0                              }
{                       autor Bernard Baron                                 }
{***************************************************************************}
UNIT MINFUNBO;

  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
  {$F+}


INTERFACE

USES TFLOAT,ALGELIN;

TYPE FUNX   = FUNCTION(X:FLOAT):FLOAT;
     FUNWEK = FUNCTION(X:WEK;
                       N:BYTE):FLOAT;


   PROCEDURE MINFUNHJ(F           :FUNWEK;
                      VAR X       :WEK;
                          N       :BYTE;
                          tau,eps :FLOAT;
                      VAR minF    :FLOAT;
                          maxit   :WORD;
                      VAR BLAD    :BYTE);
{---------------------------------------------------------------------------}
{    Metoda Hooke'a - Jeevsa                                                }
{    Wyznaczanie minimum funkcji F(X) wielu zmiennych X[i] i=1,2,..,N       }
{    F   - badana funkcja jako parametr procedury, typu FUNWEK              }
{    X   - wektor rozwiazania, ktorego wartosc nalezy wstepnie okreslic;    }
{    N   - ilosc zmiennych niezaleznych;                                    }
{    tau - wstepny krok iteracji;                                           }
{    eps - dokladnosc iteracji;                                             }
{    minF - obliczone minimum funkcji F(X);                                 }
{    maxit- ustalona maksymalna ilosc iteracji konczaca oblicznia;          }
{    BLAD - nr bledu; 0 - brak bledu.                                       }
{---------------------------------------------------------------------------}

     PROCEDURE MINKIERZP(    F          :FUNWEK;
                         VAR X,D        :WEK;
                             N,maxob    :BYTE;
                             taumax,del :FLOAT;
                         VAR qmin,taumin:FLOAT;
                             WARIANT    :INTEGER;
                         VAR BLAD       :BYTE);
{---------------------------------------------------------------------------}
{ Poszukiwanie minimum funkcji  F(X+tau*D) w kierunku D metoda zlotego      }
{   podzialu                                                                }
{ F      - badana funkcja jako parametr procedury typu FUNWEK;              }
{ X      - wektor okreslajacy punkt dla ktorego poszukuje sie minimum       }
{          funkcji w kierunku wektora D;                                    }
{ N      - ilosc zmiennych niezaleznych;                                    }
{ maxob  - dopuszczalna liczba obliczen wartosci funkcji;                   }
{ del    - dopuszczalna minimalna wartosc wspolczynnika kroku np.del:=1e-30;}
{ taumax - poczatkowy punkt graniczny przedzialu;                           }
{ qmin   - wartosc minimalna w kierunku wektora D;                          }
{ taumin - wspolczynnik kroku odpowiadajacy minimum w kierunku wektora D    }
{ wariant- 0-minimum poszukiwane jest w przedziale otwartym (-taumax,taumax)}
{        1-minimum poszukiwane jest w przedziale domknietym [-taumax,taumax]}
{ BLAD   - nr bledu; 0 - brak bledu.                                        }
{ --------------------------------------------------------------------------}

   PROCEDURE MINFUNPO(    F              :FUNWEK;
                      VAR X              :WEK;
                          N,maxob        :BYTE;
                          taumax,del,eps :FLOAT;
                      VAR minF           :FLOAT;
                          maxit          :WORD;
                      VAR BLAD           :BYTE);
{---------------------------------------------------------------------------}
{    Metoda Powella                                                         }
{    Wyznaczanie minimum funkcji F(X) wielu zmiennych X[i] i=1,2,..,N       }
{    F   - badana funkcja jako parametr procedury typu FUNWEK;              }
{    X   - wektor rozwiazania ,ktorego wartosc nalezy wstepnie okreslic;    }
{    N   - ilosc zmiennych niezaleznych;                                    }
{    maxob  - maksymalna ilosc obliczen wartosci funkcji F(X);              }
{    taumax - maksymalny przedzial poszukiwania minimum w kierunku metoda   }
{             Powella;                                                      }
{    del    - wymagana dokladnosc bezwzgledna przy poszukiwaniu minimu      }
{             w kierunku metoda Powella;                                    }
{    eps - dokladnosc iteracji;                                             }
{    minF- wyznaczone minimum funkcji;                                      }
{    maxit- ustalona maksymalna ilosc iteracji konczaca oblicznia;          }
{    BLAD - nr bledu; 0 - brak bledu.                                       }
{---------------------------------------------------------------------------}

     FUNCTION NORMAWEK(X:WEK; N:BYTE):FLOAT;
{   Norma wektora X zdefiniowana   max ( |X[i]| )                           }
{                                   i                                       }

    PROCEDURE GRADF(    F   :FUNWEK;
                        X   :WEK;
                    VAR GF  :WEK;
                        N   :BYTE;
                        eps :FLOAT);
{---------------------------------------------------------------------------}
{        Obliczanie gradientu funkcji F(X) w punkcie X                      }
{ F   - badana funkcja jako parametr procedury typu FUNWEK;                 }
{ GF  - gradient badanej funkcji GF[i]=dF(X)/dX[I],i=1,2,..,N;              }
{ X   - wektor okreslajacy punkt w ktorym oblicza sie gradient;             }
{ N   - ilosc zmiennych niezaleznych;                                       }
{ eps - wzgledny krok rozniczkowania     h=eps*NORMAWEK(X,N).               }
{---------------------------------------------------------------------------}

     PROCEDURE MINKIER1(F                   :FUNWEK;
                        VAR X,D             :WEK;
                            N,maxob,maxkoob :BYTE;
                            bet,kap,del,ni  :FLOAT;
                        VAR q,tau           :FLOAT;
                        VAR BLAD            :BYTE);
{---------------------------------------------------------------------------}
{ Poszukiwanie minimum funkcji  F(X+tau*D) w kierunku D metoda ekspanji     }
{ i kontrakcji geometrycznej                                                }
{ F      - badana funkcja jako parametr procedury typu FUNWEK;              }
{ X      - wektor okreslajacy punkt dla ktorego poszukuje sie minimum       }
{          funkcji w kierunku wektora D;                                    }
{ N      - ilosc zmiennych niezaleznych;                                    }
{ maxob  - dopuszczalna liczba obliczen wartosci funkcji;                   }
{ maxkoob- dopuszczalna liczba korzystnych obliczen wartosci funkcji;       }
{ bet    - wspolczynnik testu kroku  0 < bet < 0.5;                         }
{ kap    - wspolczynnik ekspansji kroku  kap > 1;                           }
{ del    - dopuszczalna minimalna wartosc wspolczynnika kroku np.del:=1e-30;}
{ q      - minimalna wartosc funkcji w kierunku wektora D                   }
{ tau    - WE: poczatkowy wspolczynnik kroku moze przyjmowac wartosc z      }
{              poprzedniej minimalizacji w kierunku,                        }
{        - WY: wspolczynnik odpowiadajacy uzyskanemu minmum w kierunku      }
{ ni     - wzgledny krok rozniczkowania     h=ni*NORMAWEK(X,N);             }
{ BLAD   - nr bledu; 0 - brak bledu.                                        }
{ --------------------------------------------------------------------------}

     PROCEDURE MINKIER2(    F                 :FUNWEK;
                        VAR X,D               :WEK;
                            N,maxob,maxkoob   :BYTE;
                            bet,del,taumax,ni :FLOAT;
                        VAR q,tau             :FLOAT;
                        VAR BLAD              :BYTE);
{-------------------------------------------------------------------------- }
{ Poszukiwanie minimum funkcji  F(X+tau*D) w kierunku D metoda              }
{ dwupunktowej aproksymacji parabolicznej z jednym testem poprawy wsp.kroku }
{ F      - badana funkcja jako parametr procedury typu FUNWEK               }
{ X      - wektor okreslajacy punkt dla ktorego poszukuje sie minimum       }
{        - funkcji w kierunku wektora D                                     }
{ N      - ilosc zmiennych niezaleznych;                                    }
{ maxob  - dopuszczalna liczba obliczen wartosci funkcji                    }
{ maxkoob- dopuszczalna liczba korzystnych obliczen wartosci funkcji        }
{ bet    - wspolczynnik testu kroku  0 < bet < 0.5                          }
{ del    - dopuszczalna minimalna wartosc wspolczynnika kroku np.del:=1e-30 }
{ taumax - maksymalny wspolczynnik kroku                                    }
{ ni     - wzgledny krok rozniczkowania     h=ni*NORMAWEK(X,N);             }
{ q      - minimalna wartosc funkcji w kierunku wektora D                   }
{ tau    - WE: poczatkowy wspolczynnik kroku moze przyjmowac wartosc z      }
{              poprzedniej minimalizacji w kierunku,                        }
{        - WY: wspolczynnik odpowiadajacy uzyskanemu minmum w kierunku      }
{ BLAD   - nr bledu; 0 - brak bledu.                                        }
{ --------------------------------------------------------------------------}

    PROCEDURE MINFUNNS1(F:FUNWEK;
                        VAR X                      :WEK;
                            N,maxob,maxkoob        :BYTE;
                            bet,kap,del,tau,ni,eps :FLOAT;
                        VAR minF                   :FLOAT;
                            maxit                  :WORD;
                        VAR BLAD                   :BYTE);
{---------------------------------------------------------------------------}
{ Metoda najwiekszego spadku (gradientowa) z minimalizacja kierunkowa metoda}
{ ekspanji i kontrakcji geometrycznej                                       }
{ Wyznaczanie minimum funkcji F(X) wielu zmiennych X[i] i=1,2,..,N          }
{ F      - badana funkcja jako parametr procedury typu FUNWEK;              }
{ X      - wektor rozwiazania, ktorego wartosc nalezy wstepnie okreslic;    }
{ N      - ilosc zmiennych niezaleznych;                                    }
{ maxob  - dopuszczalna liczba obliczen wartosci funkcji;                   }
{ maxkoob- dopuszczalna liczba korzystnych obliczen wartosci funkcji;       }
{ bet    - wspolczynnik testu kroku  0 < bet < 0.5;                         }
{ kap    - wspolczynnik ekspansji kroku  kap > 1;                           }
{ del    - dopuszczalna minimalna wartosc wspolczynnika kroku np.del:=1e-30 }
{ tau    - poczatkowy wspolczynnik kroku;                                   }
{ ni     - wzgledny krok rozniczkowania     h=ni*NORMAWEK(X,N);             }
{ eps    - zadana dokladnosc iteracji;                                      }
{ minF   - wyznaczone minimum funkcji;                                      }
{ maxit  - ustalona maksymalna ilosc iteracji konczaca oblicznia;           }
{ BLAD   - nr bledu; 0 - brak bledu.                                        }
{---------------------------------------------------------------------------}

    PROCEDURE MINFUNNS2(    F                     :FUNWEK;
                        VAR X                     :WEK;
                            N,maxob,maxkoob       :BYTE;
                            bet,del,taumax,ni,eps :FLOAT;
                        VAR minF                  :FLOAT;
                            maxit                 :WORD;
                        VAR BLAD                  :BYTE);
{---------------------------------------------------------------------------}
{ Metoda najwiekszego spadku (gradientowa) z minimalizacja kierunkowa metoda}
{ dwupunktowej aproksymacji parabolicznej z jednym testem poprawy wsp.kroku }
{ Wyznaczanie minimum funkcji F(X) wielu zmiennych X[i] i=1,2,..,N          }
{ F      - badana funkcja jako parametr procedury typu FUNWEK;              }
{ X      - wektor rozwiazania, ktorego wartosc nalezy wstepnie okreslic;    }
{ N      - ilosc zmiennych niezaleznych;                                    }
{ maxob  - dopuszczalna liczba obliczen wartosci funkcji;                   }
{ maxkoob- dopuszczalna liczba korzystnych obliczen wartosci funkcji;       }
{ bet    - wspolczynnik testu kroku  0 < bet < 0.5;                         }
{ del    - dopuszczalna minimalna wartosc wspolczynnika kroku np.del:=1e-30 }
{ taumax - maksymalny wspolczynnik kroku;                                   }
{ ni     - wzgledny krok rozniczkowania     h=ni*NORMAWEK(X,N);             }
{ eps    - zadana dokladnosc iteracji;                                      }
{ minF   - wyznaczone minimum funkcji;                                      }
{ maxit  - ustalona maksymalna ilosc iteracji konczaca oblicznia;           }
{ BLAD   - nr bledu; 0 - brak bledu.                                        }
{---------------------------------------------------------------------------}

      PROCEDURE HESJANF(    F   :FUNWEK;
                            X   :WEK;
                            N   :BYTE;
                        VAR A   :MAC;
                            eps :FLOAT);
{---------------------------------------------------------------------------}
{ Generacja macierzy A hesjanu funkcji F(X) w punkcie X                     }
{ F  - badana funkcja jako parametr procedury typu FUNWEK                   }
{                          2                                                }
{                         d U(X)                                            }
{              A[i,j] = ----------    ;   i,j = 1,2,...,N                   }
{                       dX[j]dX[i]                                          }
{ eps - wzgledny krok rozniczkowania     h=eps*NORMAWEK(X,N)                }
{---------------------------------------------------------------------------}

    PROCEDURE MINFUNZN1(    F:FUNWEK;
                        VAR X:WEK;
                            N,maxob,maxkoob:BYTE;
                            bet,kap,del,tau,ni,eps:FLOAT;
                        VAR minF:FLOAT;
                            maxit:WORD;
                        VAR BLAD:BYTE);
{---------------------------------------------------------------------------}
{ Zmodyfikowana metoda Newton z minimalizacja kierunkowa metoda ekspanji    }
{ i kontrakcji geometrycznej                                                }
{ Wyznaczanie minimum funkcji F(X) wielu zmiennych X[i] i=1,2,..,N          }
{ F      - badana funkcja jako parametr procedury typu FUNWEK;              }
{ X      - wektor rozwiazania, ktorego wartosc nalezy wstepnie okreslic;    }
{ N      - ilosc zmiennych niezaleznych;                                    }
{ maxob  - dopuszczalna liczba obliczen wartosci funkcji;                   }
{ maxkoob- dopuszczalna liczba korzystnych obliczen wartosci funkcji;       }
{ bet    - wspolczynnik testu kroku  0 < bet < 0.5;                         }
{ kap    - wspolczynnik ekspansji kroku  kap > 1;                           }
{ del    - dopuszczalna minimalna wartosc wspolczynnika kroku np.del:=1e-30 }
{ tau    - poczatkowy wspolczynnik kroku;                                   }
{ ni     - wzgledny krok rozniczkowania     h=ni*NORMAWEK(X,N);             }
{ eps    - zadana dokladnosc iteracji;                                      }
{ minF   - wyznaczone minimum funkcji;                                      }
{ maxit  - ustalona maksymalna ilosc iteracji konczaca oblicznia;           }
{ BLAD   - nr bledu; 0 - brak bledu.                                        }
{---------------------------------------------------------------------------}

    PROCEDURE MINFUNZN2(    F                     :FUNWEK;
                        VAR X                     :WEK;
                            N,maxob,maxkoob       :BYTE;
                            bet,del,taumax,ni,eps :FLOAT;
                        VAR minF                  :FLOAT;
                            maxit                 :WORD;
                        VAR BLAD                  :BYTE);
{---------------------------------------------------------------------------}
{ Zmodyfikowana metoda Newtona z minimalizacja kierunkowa metoda            }
{ dwupunktowej aproksymacji parabolicznej z jednym testem poprawy wsp.kroku }
{ Wyznaczanie minimum funkcji F(X) wielu zmiennych X[i] i=1,2,..,N          }
{ F      - badana funkcja jako parametr procedury typu FUNWEK;              }
{ X      - wektor rozwiazania, ktorego wartosc nalezy wstepnie okreslic;    }
{ N      - ilosc zmiennych niezaleznych;                                    }
{ maxob  - dopuszczalna liczba obliczen wartosci funkcji;                   }
{ maxkoob- dopuszczalna liczba korzystnych obliczen wartosci funkcji;       }
{ bet    - wspolczynnik testu kroku  0 < bet < 0.5;                         }
{ del    - dopuszczalna minimalna wartosc wspolczynnika kroku np.del:=1e-30 }
{ taumax - maksymalny wspolczynnik kroku;                                   }
{ ni     - wzgledny krok rozniczkowania     h=ni*NORMAWEK(X,N);             }
{ eps    - zadana dokladnosc iteracji;                                      }
{ minF   - wyznaczone minimum funkcji;                                      }
{ maxit  - ustalona maksymalna ilosc iteracji konczaca oblicznia            }
{ BLAD   - nr bledu; 0 - brak bledu.                                        }
{---------------------------------------------------------------------------}


IMPLEMENTATION


PROCEDURE MINFUNHJ;
  VAR F2,F1,F0,ni,tau1 :FLOAT;
      k,l,m            :WORD;
      X1,X0            :WEK;
      CZY              :BOOLEAN;

  PROCEDURE KROK(j:INTEGER);
    VAR i:INTEGER;
    BEGIN
      X1:=X;
      X1[k]:=X[k]+j*ni;
      F1:=F(X1,N)
    END { KROK };

BEGIN { Czesc operacyjna procedury MINFUNHJ }
  BLAD:=0;
  F2:=F(X,N);  X0:=X;  F0:=F2;
  CZY:=FALSE;  m :=0;  ni:=tau;
  REPEAT
    INC(m);
    tau1:=ni;
    FOR k:=1 TO N DO
    BEGIN
      KROK(1);
      IF F1<F2
        THEN BEGIN
               X[k]:=X1[k];
               F2:=F1
             END
        ELSE BEGIN
               KROK(-1);
               IF F1<F2 THEN
               BEGIN
                 X[k]:=X1[k];
                 F2:=F1
               END
             END
    END;
    IF F2<F0
      THEN BEGIN
             FOR k:=1 TO N DO
             BEGIN
               X1[k]:=X0[k];
               X0[k]:=X[k];
               X[k]:=X0[k]+1.4*(X[k]-X1[k])
             END;
             F0:=F2;
             F2:=F(X,N);
             ni:=1.2*ni;
             CZY:=TRUE
           END
      ELSE IF CZY
             THEN BEGIN
                    X:=X0;
                    F2:=F0;
                    CZY:=FALSE
                  END
             ELSE IF tau1>eps THEN
                    ni:=0.2*ni
  UNTIL (tau1<=eps) OR (m>maxit);
  minF:=F(X,N);
  IF m>maxit THEN
    BLAD:=60
END; { MINFUNHJ }


PROCEDURE MINKIERZP;
  VAR j,k,l        :WORD;
      q0,q1,q2,q3,q4,q,
      tau,tau1,tau2,tau3,tau4,
      deltau,alfa  :FLOAT;
      TAK1,KONIEC  :BOOLEAN;

      FUNCTION QQ(tau:FLOAT):FLOAT;
        VAR i :BYTE;
            Y :WEK;
        BEGIN
          FOR i:=1 TO N DO
            Y[i]:=X[i]+tau*D[i];
          QQ:=F(Y,N)
        END; { QQ }

      FUNCTION MIN(q1,q2,q3:FLOAT):FLOAT;
        BEGIN
          IF (q1<=q2) AND (q1<=q3)
            THEN MIN:=q1
            ELSE IF (q2<=q1) AND (q2<=q3)
                   THEN MIN:=q2
                   ELSE IF (q3<=q1) AND (q3<=q2) THEN
                          MIN:=q3
        END; { MIN }

  BEGIN { Poczatek procedury MINKIERZP }
    BLAD:=0;
    IF taumax<=0 THEN
    BEGIN
      BLAD:=61;
      EXIT
    END;
    alfa:=(SQRT(5)-1)/2;
    deltau:=2*(1-alfa)*taumax;
    tau1:=-taumax;     tau4:=taumax;
    tau2:=tau1+deltau; tau3:=tau4-deltau;
    tau :=tau1;
    j:=0;   l:=0;
    KONIEC:=FALSE;
    REPEAT
      q:=QQ(tau); TAK1:=FALSE;
      IF tau<>tau1
        THEN BEGIN
               TAK1:=TRUE;
               IF tau=tau2
                 THEN q2:=q
                 ELSE IF tau=tau3
                        THEN q3:=q
                        ELSE q4:=q
             END
        ELSE BEGIN
               q1:=q;
               IF j<4 THEN
               BEGIN
                 qmin:=q1;    q0 :=q1;
                 taumin:=tau; tau:=tau2;
                 j:=1;
                 KONIEC:=FALSE
               END
             END;
      IF (j>=4) OR TAK1 THEN
      BEGIN
        IF q<qmin THEN
        BEGIN
          qmin:=q;
          taumin:=tau;
          INC(l)
        END;
        INC(j);
        IF j<4
          THEN BEGIN
                 IF tau=tau2
                   THEN tau:=tau3
                   ELSE tau:=tau4;
                 KONIEC:=FALSE
               END
          ELSE IF j=maxob
                 THEN BEGIN
                        taumin:=0;
                        KONIEC:=TRUE
                      END
                 ELSE IF (ABS(deltau)<=del)
                        THEN KONIEC:=TRUE
                        ELSE IF WARIANT=0
                               THEN IF q1<MIN(q2,q3,q4)
                                      THEN BEGIN
                                             tau3:=tau2; q3:=q2;
                                             tau2:=tau1; q2:=q1;
                                             deltau:=(1+alfa)*deltau;
                                             tau1:=tau1-deltau;
                                             tau:=tau1;
                                             KONIEC:=FALSE
                                           END
                                      ELSE IF q4<MIN(q1,q2,q3)
                                             THEN BEGIN
                                                    tau2:=tau3; q2:=q3;
                                                    tau3:=tau4; q3:=q4;
                                                    deltau:=(1+alfa)*deltau;
                                                    tau4:=tau4+deltau;
                                                    tau:=tau4;
                                                    KONIEC:=FALSE
                                                  END
                                             ELSE IF q2<=q3
                                                    THEN BEGIN
                                                           tau4:=tau3; q4:=q3;
                                                           tau3:=tau2; q3:=q2;
                                                           deltau:=alfa*del;
                                                           tau2:=tau1+del;
                                                           tau:=tau2;
                                                           KONIEC:=FALSE
                                                         END
                                                    ELSE BEGIN
                                                           tau1:=tau2; q1:=q2;
                                                           tau2:=tau3; q2:=q3;
                                                           deltau:=alfa*del;
                                                           tau3:=tau4-del;
                                                           tau:=tau3;
                                                           KONIEC:=FALSE
                                                         END
                               ELSE IF q2<=q3
                                      THEN BEGIN
                                             tau4:=tau3; q4:=q3;
                                             tau3:=tau2; q3:=q2;
                                             deltau:=alfa*del;
                                             tau2:=tau1+del;
                                             tau:=tau2;
                                             KONIEC:=FALSE
                                           END
                                      ELSE BEGIN
                                             tau1:=tau2;q1:=q2;
                                             tau2:=tau3; q2:=q3;
                                             deltau:=alfa*del;
                                             tau3:=tau4-del;
                                             tau:=tau3;
                                             KONIEC:=FALSE
                                           END
      END
    UNTIL KONIEC;
    FOR l:=1 TO N DO
      X[l]:=X[l]+taumin*D[l]
  END; { MINKIERZP }


PROCEDURE MINFUNPO;
  VAR  i,j,k,m        :BYTE;
       taumin,qmin,wyznacznik,
       alfa,delta,c,s :FLOAT;
       D,A            :MAC;
       Xp,tau         :WEK;
  BEGIN
    { Baza poczatkowa jako wersory kartezjanskiego ukladu wspolrzednych }
    MACJEDEN(D,N);
    k:=0;   wyznacznik:=1;
    Xp:=X;  BLAD:=0;
    REPEAT
      INC(k);
      FOR i:=1 TO N DO
      BEGIN
        { Minimalizacja w kierunku D[i] metoda zlotego podzialu }
        MINKIERZP(F,X,D[i],N,maxob,taumax,del,qmin,taumin,1,BLAD);
        IF BLAD<>0 THEN
          EXIT;
        tau[i]:=taumin
      END;
      c:=0;
      FOR i:=1 TO N DO
        IF c<ABS(X[i]-Xp[i]) THEN
          c:=ABS(X[i]-Xp[i]);
      FOR i:=1 TO N DO
        D[N+1][i]:=(X[i]-Xp[i])/c;
      MINKIERZP(F,X,D[N+1],N,maxob,taumax,del,qmin,taumin,1,BLAD);
      IF BLAD<>0 THEN
        EXIT;
      alfa:=0;
      FOR i:=1 TO N DO
        IF alfa<ABS(X[i]-Xp[i]) THEN
          alfa:=ABS(X[i]-Xp[i]);
      IF alfa>eps THEN
      BEGIN
        Xp:=X;  s:=0;
        FOR i:=1 TO N DO
          IF s<ABS(tau[i]) THEN
          BEGIN
            s:=ABS(TAU[i]);
            m:=i
          END;
        delta:=s*wyznacznik/alfa;
        IF delta>=0.8 THEN { Modyfikacja bazy }
        BEGIN
          D[m]:=D[N+1];
          FOR i:=1 TO N DO
            FOR j:=1 TO N DO A[i,j]:=D[I,J];
              wyznacznik:=ABS(DET(A,N,eps))
        END
      END
    UNTIL alfa<=eps;
    minF:=F(X,N);
    IF k>maxit THEN
      BLAD:=62
  END; { MINFUZPO }


FUNCTION NORMAWEK(X:WEK; N:BYTE):FLOAT;
  VAR i   :BYTE;
      r,s :FLOAT;
  BEGIN
    s:=0;
    FOR i:=1 TO N DO
    BEGIN
      r:=ABS(X[i]);
      IF r > s THEN
        s:=r
    END;
    NORMAWEK:=s
  END; { NORMAWEK }


PROCEDURE GRADF;
  VAR i          :BYTE;
      FX,FX1,h,g :FLOAT;
      X1         :WEK;
  BEGIN
    g:=NORMAWEK(X,N);
    IF g>eps
      THEN h:=eps*g
      ELSE h:=eps;
    FX:=F(X,N);
    FOR i:=1 TO N DO
    BEGIN
      X1:=X; X1[i]:=X[i]+h;
      FX1:=F(X1,N);
      GF[i]:=(FX1-FX)/h
    END
  END; { GRADF }


PROCEDURE MINKIER1;
  VAR j,k,l             :BYTE;
      q0,q1,q2,dq0,tau1 :FLOAT;
      GF                :WEK;
      TAK,TAK1,TAK2     :BOOLEAN;

  FUNCTION QQ(tau:FLOAT):FLOAT;
    VAR i :BYTE;
        Y :WEK;
    BEGIN
      FOR i:=1 TO N DO
        Y[i]:=X[i]+tau*D[i];
      QQ:=F(Y,N)
    END; { QQ }

  BEGIN { Poczatek procedury MINKIER1 }
    BLAD:=0;
    IF (bet<=0) OR (bet>0.5) THEN
    BEGIN
      BLAD:=63;
      EXIT
    END;
    IF kap<=1 THEN
    BEGIN
      BLAD:=64;
      EXIT
    END;
    q0:=F(X,N);  { q0 - wartosc funkcji F w punkcie poczatkowym X }
    GRADF(F,X,GF,N,ni);
    { dq0 -pochodna kierunkowa czyli rozniczka Gateaux w punkcie X }
    dq0:=0;
    FOR j:=1 TO N DO
      dq0:=dq0+GF[j]*D[j];
    q1:=q0; j:=0;
    k:=0;   tau1:=0;
    TAK1:=FALSE; TAK2:=FALSE;  TAK:=FALSE;
    REPEAT
      q:=QQ(tau);
      IF q<q1 THEN
      BEGIN
        q1:=q;
        tau1:=tau
      END;
      IF q<=q0
        THEN j:=j+1
        ELSE k:=k+1;
      IF (k+j)>=maxob
        THEN IF j=0
               THEN BEGIN
                      BLAD:=65;
                      EXIT
                    END
               ELSE TAK:=TRUE
        ELSE IF j<maxkoob THEN
             BEGIN
               q2:=q0+bet*dq0*tau;
               IF q<q2
                 THEN IF TAK1
                        THEN TAK:=TRUE
                        ELSE BEGIN
                               TAK2:=TRUE;
                               tau:=kap*tau
                             END
                 ELSE IF TAK2
                        THEN TAK:=TRUE
                        ELSE BEGIN
                               TAK1:=TRUE;
                               tau:=tau/kap
                             END
             END
    UNTIL TAK;
    q:=q1;
    tau:=tau1;
    FOR l:=1 TO N DO
      X[l]:=X[l]+tau*D[l];
    IF q>=q0
      THEN BLAD:=66
      ELSE IF ABS(tau)<=del THEN
             BLAD:=67
  END; { MINKIER1 }


PROCEDURE MINKIER2;
  VAR j,k,l         :BYTE;
      q0,q1,q2,dq0,
      tau1,tau2,h   :FLOAT;
      GF            :WEK;
      TAK,TAK1      :BOOLEAN;

      FUNCTION QQ(tau:FLOAT):FLOAT;
        VAR i:BYTE; Y:WEK;
        BEGIN
          FOR i:=1 TO N DO
            Y[i]:=X[i]+tau*D[i];
          QQ:=F(Y,N)
        END; { QQ }

      FUNCTION MINIMUM(X1,X2:FLOAT):FLOAT;
        BEGIN
          IF X1<X2
            THEN MINIMUM:=X1
            ELSE MINIMUM:=X2
        END; { MINIMUM }

  BEGIN { Poczatek procedury MINKIER2 }
    BLAD:=0;
    IF (bet<=0) OR (bet>0.5) THEN
    BEGIN
      BLAD:=68;
      EXIT
    END;
    q0:=F(X,N); { q0 - wartosc funkcji F w punkcie poczatkowym X }
    GRADF(F,X,GF,N,ni);
    { dq0 -pochodna kierunkowa czyli rozniczka Gateaux w punkcie X }
    dq0:=0;
    FOR j:=1 TO N DO
      dq0:=dq0+GF[j]*D[j];
    q1:=q0; j:=0; k:=0;
    TAK:=FALSE;
    tau:=taumax;  tau1:=0;
    REPEAT
      q:=QQ(tau);
      IF q<=q0
        THEN BEGIN
               INC(j);
               IF q<q1 THEN
               BEGIN
                 q1:=q;
                 tau1:=tau
               END;
               IF j<maxkoob
                 THEN BEGIN
                        q2:=q0+bet*dq0*tau;
                        IF q>q2
                          THEN BEGIN
                                 h:=-dq0*SQR(tau)/(2*(q-q0-dq0*tau));
                                 tau:=MINIMUM(h,taumax);
                                 IF tau>=taumax THEN
                                   TAK:=TRUE
                               END
                          ELSE IF (j+k)<>1
                                 THEN TAK:=TRUE
                                 ELSE BEGIN
                                        q2:=q0+dq0*tau;
                                        IF q>q2
                                          THEN BEGIN
                                                 h:=-dq0*SQR(tau)/(2*(q-q0-dq0*tau));
                                                 tau2:=MINIMUM(h,taumax);
                                                 IF tau>=taumax THEN
                                                   TAK:=TRUE
                                               END
                                          ELSE TAK:=TRUE
                                      END
                      END
                 ELSE TAK:=TRUE
             END
        ELSE BEGIN
               INC(k);
               IF (k+j)>=maxob
                 THEN IF j=0
                        THEN BEGIN
                               BLAD:=69;
                               EXIT
                             END
                        ELSE TAK:=TRUE
                 ELSE BEGIN
                        h:=-dq0*SQR(tau)/(2*(q-q0-dq0*tau));
                        tau:=MINIMUM(h,taumax);
                        IF tau>=taumax THEN
                          TAK:=TRUE
                      END
             END
    UNTIL TAK;
    q:=q1;
    tau:=tau1;
    FOR l:=1 TO N DO
      X[l]:=X[l]+tau*D[l];
    IF q>=q0
      THEN BLAD:=70
      ELSE IF ABS(tau)<=del THEN
             BLAD:=71
  END; { MINKIER2 }


PROCEDURE MINFUNNS1;
  VAR k               :WORD;
      i               :BYTE;
      q,tau1,ni1,alfa :FLOAT;
      D,GF            :WEK;
  BEGIN
    k:=0;      BLAD:=0;
    tau1:=tau; ni1:=ni;
    REPEAT
      INC(k);
      IF ni1>tau1 THEN
        ni1:=tau1*bet;
      GRADF(F,X,GF,N,ni1);
      alfa:=0;
      FOR i:=1 TO N DO
        alfa:=alfa+SQR(GF[i]); { kwadrat modulu gradientu F(X) }
      IF alfa>eps THEN
      BEGIN
        FOR i:=1 TO N DO
          D[i]:=-GF[i];
        MINKIER1(F,X,D,N,maxob,maxkoob,bet,kap,del,ni1,q,tau1,BLAD);
      END
    UNTIL (alfa<eps) OR (k>maxit) OR (BLAD<>0);
    IF BLAD=0 THEN
    BEGIN
      minF:=q;
      IF k>maxit THEN
        BLAD:=72
    END
  END; { MINFUNS1 }


PROCEDURE MINFUNNS2;
  VAR k               :WORD;
      i               :BYTE;
      q,tau1,ni1,alfa :FLOAT;
      D,GF            :WEK;
  BEGIN
    k:=0;  BLAD:=0;
    tau1:=taumax; ni1:=ni;
    REPEAT
      INC(k);
      IF ni1>tau1 THEN
        ni1:=tau1*bet;
      GRADF(F,X,GF,N,ni1);
      alfa:=0;
      FOR i:=1 TO N DO
        alfa:=alfa+SQR(GF[i]); { kwadrat modulu gradientu F(X) }
      IF alfa>eps THEN
      BEGIN
        FOR i:=1 TO N DO
          D[i]:=-GF[i];
        MINKIER2(F,X,D,N,maxob,maxkoob,bet,del,taumax,ni1,q,tau1,BLAD);
      END
    UNTIL (alfa<eps) OR (k>maxit) OR (BLAD<>0);
    IF BLAD=0 THEN
    BEGIN
      minF:=q;
      IF k>maxit THEN
        BLAD:=73
    END
  END; { MINFUNS2 }


PROCEDURE HESJANF;
  VAR i,j                :BYTE;
      g,h,F0,F1,F2,F3,F4 :FLOAT;
      X1                 :WEK;

  BEGIN
    g:=NORMAWEK(X,N);
    IF g>eps
      THEN h:=eps*g
      ELSE h:=eps;
    F0:=F(X,N);
    FOR i:=1 TO N DO
    BEGIN
      X1:=X; X1[i]:=X[i]+h;
      F1:=F(X1,N);
      X1:=X; X1[i]:=X[i]-h;
      F2:=F(X1,N);
      A[i,i]:=( F1-2*F0+F2)/SQR(h);
      FOR j:=1 TO N DO
        IF i<>j THEN
        BEGIN
          X1:=X; X1[i]:=X[i]+h; X1[j]:=X[j]+h;
          F1:=F(X1,N);
          X1:=X; X1[i]:=X[i]-h; X1[j]:=X[j]-h;
          F2:=F(X1,N);
          X1:=X; X1[i]:=X[i]+h; X1[j]:=X[j]-h;
          F3:=F(X1,N);
          X1:=X; X1[i]:=X[i]-h; X1[j]:=X[j]+h;
          F4:=F(X1,N);
          A[i,j]:=(F1+F2-F3-F4)/(4*SQR(h))
        END
    END
  END; { HESJANF }


PROCEDURE MINFUNZN1;
  VAR k                 :WORD;
      i,j               :BYTE;
      s,tau1,alfa,ni1,q :FLOAT;
      D,GF              :WEK;
      A                 :MAC;
  BEGIN
    k:=0; BLAD:=0;
    tau1:=tau; ni1:=ni;
    REPEAT
      INC(k);
      IF ni1>tau1
        THEN ni1:=tau1*bet;
      GRADF(F,X,GF,N,ni1);
      alfa:=0;
      FOR i:=1 TO N DO
        alfa:=alfa+SQR(GF[i]); { kwadrat modulu gradientu F(X) }
      HESJANF(F,X,N,A,ni1);
      ODWMAC1(A,N,eps,BLAD);
      IF (BLAD=0) AND (alfa>eps) THEN
      BEGIN
        { Wyznaczanie kierunku poszukiwan }
        FOR i:=1 TO N DO
        BEGIN
          s:=0;
          FOR j:=1 TO N DO
            s:=s+A[i,j]*GF[j];
          D[i]:=-s
        END;
        MINKIER1(F,X,D,N,maxob,maxkoob,bet,kap,del,ni1,q,tau1,BLAD);
      END
    UNTIL (alfa<eps) OR (k>maxit) OR (BLAD<>0);
    minF:=q;
    IF k>maxit THEN
      BLAD:=74
  END; { MINFUZN1 }


PROCEDURE MINFUNZN2;
  VAR k                 :WORD;
      i,j               :BYTE;
      s,tau1,alfa,q,ni1  :FLOAT;
      D,GF              :WEK;
      A                 :MAC;
  BEGIN
    k:=0;  BLAD:=0; tau1:=taumax; ni1:=ni;
    REPEAT
      INC(k);
      IF ni1>tau1
        THEN ni1:=tau1*bet;
      GRADF(F,X,GF,N,ni1);
      alfa:=0;
      FOR i:=1 TO N DO
        alfa:=alfa+SQR(GF[i]); { kwadrat modulu gradientu F(X) }
      HESJANF(F,X,N,A,ni1);
      ODWMAC1(A,N,eps,BLAD);
      IF (BLAD=0) AND (alfa>eps) THEN
      BEGIN
        { Wyznaczanie kierunku poszukiwan }
        FOR i:=1 TO N DO
        BEGIN
          s:=0;
          FOR j:=1 TO N DO
            s:=s+A[i,j]*GF[j];
          D[i]:=-s
        END;
        MINKIER2(F,X,D,N,maxob,maxkoob,bet,del,taumax,ni1,q,tau1,BLAD);
      END
    UNTIL (alfa<eps) OR (k>maxit) OR (BLAD<>0);
    minF:=q;
    IF k>maxit THEN
      BLAD:=75
  END; { MINFUZN2 }

END.


