{**************************************************************************}
{            OBLICZANIE TRANSFORMACJI ODWROTNEJ LAPLACE'A                  }
{                          Modul  LAPLACE                                  }
{                       Turbo Pascal  wersja 7.0                           }
{                       autor Bernard Baron                                }
{**************************************************************************}
UNIT LAPLACE;
  {$F+}
  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
  INTERFACE

USES CRT,TFLOAT,ALGELIN,ALGELIND,ALGEZES,ALGMZES,RONIELIN;

CONST LN2   =6.93147180559945E-1;
      LN2P2 =3.46573590279973E-1;
      PIP4  =7.85398163397448E-1;
      P2P2  =7.07106781186548E-1;
      MAXP  =1024;

TYPE  WEK1      = ARRAY[0..MAXP] OF FLOAT;
      WEKD1     = ^WEK1;
      FUNUS     = FUNCTION(s:FLOAT):FLOAT;
      ZBIORBIEG = SET OF 1..MAX;
      MACZRES   = ARRAY[0..1] OF WEKZ;     { Mmacierz pozostalosci funkcji wymiernych  }
      WEKKB     = ARRAY[1..MAX] OF 0..MAX; { Wektor krotnosci biegunow }


   PROCEDURE OBORMSF(    FUOP    :FUNUS;
                     VAR TX,FY   :WEKD1;
                         N,M     :WORD;
                         u0,S0,a :FLOAT;
                     VAR BLAD    :BYTE);
{--------------------------------------------------------------------------}
{ Obliczanie oryginalu funkcji operatorowej metoda iteracyjna              }
{   z zastosowaniem szeregu Fouriera                                       }
{  FUOP - funkcja typu FUNUS okreslajaca funkcje operatorowa U(s) na osi   }
{           rzeczywistej                                                   }
{  TX - wektor N chwil czasowych w ktorych poszukujemy oryginalu           }
{  FY - wektor rozwiazan w wybranych N chwilach                            }
{  M  - rzad aproksymacji metody, dla typu FLOAT=EXTENDED nie wiecej niz 24}
{  u0 - wartosc poczatkowa orginalu tj. Lim s*U(s) gdy s zmierza do niesk. }
{  S0 - krok rospisania funkcji operatorowej U(s) na osi dodatniej S0>0    }
{       dla malych chwil czasowych t, S0 duze i odwrotnie                  }
{  a  - wartosc rzeczywista dodatnia dobierana tak azeby na prawo od  tej  }
{       wartosci funkcja operatorowa byla analityczna                      }
{ BLAD- nr bledu; 0 - brak bledu                                           }
{--------------------------------------------------------------------------}

   PROCEDURE OBORMSFT(    FUOP    :FUNUS;
                          t       :FLOAT;
                      VAR ut      :FLOAT;
                          M       :WORD;
                          u0,S0,a :FLOAT;
                      VAR BLAD    :BYTE);
{--------------------------------------------------------------------------}
{ Obliczanie oryginalu funkcji operatorowej metoda iteracyjna              }
{ z zastosowaniem szeregow Fouriera w wybranej chwili t                    }
{ FUOP - funkcja typu FUNUS okreslajaca funkcje operatorowa U(s)           }
{        na osi rzeczywistej                                               }
{  t  -  chwila czasowa w ktorej poszukujemy oryginalu                     }
{  ut -  rozwiazanie orginalu w wybranej chwili u(t)                       }
{  M  - rzad aproksymacji metody,dla typu FLOAT=EXTENDED nie wiecej niz 24 }
{  u0 - wartosc poczatkowa orginalu tj. Lim s*U(s) gdy s zmierza do niesk. }
{  S0 - krok rospisania funkcji operatorowej U(s) na osi dodatniej S0>0    }
{       dla malych chwil czasowych t, S0 duze i odwrotnie                  }
{  a  - wartosc rzeczywista dodatnia dobierana tak azeby na prawo od  tej  }
{       wartosci funkcja operatorowa byla analityczna                      }
{ BLAD- nr bledu; 0 - brak bledu                                           }
{--------------------------------------------------------------------------}

   PROCEDURE OBORMSL(    FUOP     :FUNUS;
                     VAR TX,FY    :WEKD1;
                         N,M      :WORD;
                         u0,S0,a  :FLOAT;
                     VAR BLAD     :BYTE);
{--------------------------------------------------------------------------}
{ Obliczanie oryginalu funkcji operatorowej metoda iteracyjna              }
{ z zastosowaniem szeregow Laguerre'a w wybranej chwili t                  }
{ FUOP - funkcja typu FUNUS okreslajaca funkcje operatorowa U(s)           }
{        na osi rzeczywistej                                               }
{  t  -  chwila czasowa w ktorej poszukujemy oryginalu                     }
{  ut -  rozwiazanie orginalu w wybranej chwili u(t)                       }
{  M  - rzad aproksymacji metody,dla typu FLOAT=EXTENDED nie wiecej niz 24 }
{  u0 - wartosc poczatkowa orginalu tj. Lim s*U(s) gdy s zmierza do niesk. }
{  S0 - krok rospisania funkcji operatorowej U(s) na osi dodatniej S0>0    }
{       dla malych chwil czasowych t, S0 duze i odwrotnie                  }
{  a  - wartosc rzeczywista dodatnia dobierana tak azeby na prawo od  tej  }
{       wartosci funkcja operatorowa byla analityczna                      }
{ BLAD- nr bledu; 0 - brak bledu                                           }
{--------------------------------------------------------------------------}

   PROCEDURE OBORMSLT(    FUOP    :FUNUS;
                          t       :FLOAT;
                      VAR ut      :FLOAT;
                          M       :WORD;
                          u0,S0,a :FLOAT;
                      VAR BLAD    :BYTE);
{--------------------------------------------------------------------------}
{ Obliczanie oryginalu funkcji operatorowej metoda iteracyjna              }
{ z zastosowaniem szeregu Laguerre'a                                       }
{ FUOP - funkcja typu FUNUS okreslajaca funkcje operatorowa U(s)           }
{        na osi rzeczywistej                                               }
{  TX - wektor N chwil czasowych w ktorych poszukujemy oryginalu           }
{  FY - wektor rozwiazan w wybranych N chwilach                            }
{  M  - rzad aproksymacji metody,dla typu FLOAT=EXTENDED nie wiecej niz 30 }
{  u0 - wartosc poczatkowa orginalu tj. Lim s*U(s) gdy s zmierza do niesk. }
{  S0 - krok rospisania funkcji operatorowej U(s) na osi dodatniej S0>0    }
{       dla malych chwil czasowych t, S0 duze i odwrotnie                  }
{  a  - wartosc rzeczywista dodatnia dobierana tak azeby na prawo od  tej  }
{       wartosci funkcja operatorowa byla analityczna                      }
{ BLAD- nr bledu; 0 - brak bledu                                           }
{--------------------------------------------------------------------------}

   PROCEDURE OBLPOMRES(    NL,NM   :BYTE;
                       VAR WL,WM   :WEK;
                           eps,alf :FLOAT;
                           maxit   :WORD;
                       VAR W       :MACZRES;
                       VAR M       :WEKKB;
                       VAR Y       :WEKZ;
                       VAR k,BLAD  :BYTE);
{-------------------------------------------------------------------------}
{ Obliczanie pozostalosci funkcji wymiernej w biegunach jednokrotnych     }
{ i dwukrotnych                                                           }
{ WL  - wielomian licznika stopnia NL                                     }
{ WM  - wielomian mianownika stopnia NM  ( NM>NL )                        }
{ eps - dokladnosc iteracji wyznaczania zer mianownika metoda Laguerre'a  }
{ alf - dokladnosc wzgledna rozroznienia polozenia biegunow               }
{ maxit - maksymalna liczba iteracji po ktorej zostanie przerwane oblicza-}
{         nie biegunow nie osiagnawszy zadanej dokladnosci eps            }
{ W - tablica pozostalosci funkcji wymiernej WL/WM w biegunach            }
{ M - wektor okreslajacy krotnosc biegunow np. biegun Y[i] krotny M[i]    }
{ Y - wektor biegunow                                                     }
{ k - ilosc biegunow liczona z pominieciem biegunow sprzezonych           }
{ BLAD - nr bledu; 0 - brak bledu                                         }
{-------------------------------------------------------------------------}

   FUNCTION TRANODWLAPFW(VAR W      :MACZRES;
                         VAR Y      :WEKZ;
                         VAR M      :WEKKB;
                             K      :BYTE;
                             alfa,t :FLOAT;
                         VAR BLAD   :BYTE):FLOAT;
{-------------------------------------------------------------------------}
{  Obliczanie transformacji odwrotnej Laplace'a dla funkcji wymiernych    }
{ metoda uwzgledniajaca pozostalosci funkcji w biegunach w chwili t       }
{  -wymaga sie pierwotnie  wywolania procedury OBLPOMRES                  }
{ W - tablica pozostalosci funkcji wymiernej WL/WM w biegunach            }
{ Y - wektor biegunow                                                     }
{ M - wektor okreslajacy krotnosc biegunow np. biegun Y[i] krotny M[i]    }
{ k - ilosc biegunow liczona z pominieciem biegunow sprzezonych           }
{ alf - dokladnosc wzgledna rozroznienia polozenia biegunow               }
{ t - chwila t w ktorej oblicza sie transformacje odwrotna                }
{ BLAD - nr bledu; 0 - brak bledu                                         }
{-------------------------------------------------------------------------}

  IMPLEMENTATION


    PROCEDURE WSPOLSF(    FUOP    :FUNUS;
                      VAR F       :WEKD;
                          M       :WORD;
                          u0,S0,a :FLOAT);
{----------------------------------------------------------------}
{ FUOP - funkcja typu FUNUS okreslajaca funkcje operatorowa      }
{        U(s) na osi rzeczywistej                                }
{ F - wektor wspolczynnikow szeregu Fouriera wzoru (8.11)        }
{     generowany wzorem rekurencyjnym (8.15)                     }
{ M - ilosc elementow szeregu Fouriera (8.11)                    }
{ u0- wartosc poczatkowa orginalu tj. Lim s*U(s) gdy s zmierza   }
{     do nieskonczonosci                                         }
{ S0- krok rozpisania funkcji operatorowej U(s) na osi dodatniej }
{     S0>0 dla malych chwil czasowych t,S0 duze i odwrotnie      }
{ a - wartosc rzeczywista dodatnia dobierana tak azeby na prawo  }
{     od  tej wartosci funkcja operatorowa byla analityczna      }
{----------------------------------------------------------------}
      VAR i,k,k2                 :WORD;
          U,D1,D2,G,FK,SK,SX,UX  :FLOAT;
      BEGIN
        UX:=4*S0/PI;
        FOR k:=0 TO M DO
        BEGIN
          k2:=2*k; SX:=(k2+1)*S0+a;
          U:=FUOP(SX);
          FK:=(U-U0/SX)*UX;
          FOR i:=1 TO k DO
            FK:=FK*4;
          D1:=1;
          FOR i:=1 TO k DO
          BEGIN
            D2:=D1*(k2-i+1)/i; G :=D2-D1;
            FK:=FK-G*F[k-i];   D1:=D2
          END;
          F[k]:=FK
        END
      END { WSPOLSF };

     FUNCTION WARORFOU(VAR F    :WEKD;
                           teta :FLOAT;
                           M    :WORD):FLOAT;
{----------------------------------------------------------------}
{ Wyznaczanie sumy szeregu Fouriera wg wzoru (8.11)              }
{ F - wektor wspolczynnikow szeregu Fouriera  generowany wzorem  }
{     rekurencyjnym (8.15)                                       }
{ teta- parametr wyznaczony  z wzoru (8.6) dla danego t          }
{ M   - ilosc elementow szeregu Fouriera (8.11)                  }
{----------------------------------------------------------------}
       VAR k,j                      :WORD;
           SI,CO,SI1,CO1,SI2,CO2,WA :FLOAT;
       BEGIN
         IF teta<>PIP4
           THEN BEGIN
                  SI1:=SIN(teta); CO2:=SQR(SI1); CO1:=SQRT(1-CO2);
                  SI2:=2*SI1*CO1; CO2:=1-2*CO2;
                  WA:=F[0]*SI1;
                  FOR k:=1 TO M DO
                  BEGIN
                    SI:=SI1*CO2+CO1*SI2; CO:=CO1*CO2-SI1*SI2;
                    SI1:=SI; CO1:=CO;
                    WA:=WA+F[k]*SI
                  END
                END
           ELSE BEGIN
                  SI:=0;  WA:=0;
                  FOR k:=0 TO M DO
                  BEGIN
                   j:=k mod 4;
                   CASE j OF
                     0,1: SI:=SI+F[k];
                     2  : SI:=SI-F[k];
                     3  : BEGIN
                            SI:=SI-F[k];
                            WA:=WA+SI; SI:=0
                          END
                   END
                 END;
                 WA:=WA*P2P2
               END;
         WARORFOU:=WA
       END { WARORFOU };

   PROCEDURE OBORMSF;
     VAR i,k        :WORD;
         ut,X,teta  :FLOAT;
         F          :WEKD;
     BEGIN
       BLAD:=0;
       IF M>24 THEN
       BEGIN
         BLAD:=140;
         EXIT
       END;
       IF TX^[0]<0 THEN
       BEGIN
         BLAD:=141;
         EXIT
       END;
       WSPOLSF(FUOP,F,M,u0,S0,a);
       FOR k:=0 TO N DO
         IF TX^[k]=0
           THEN FY^[k]:=u0
           ELSE BEGIN
                  X:=EXP(-S0*TX^[k]);
                  teta:=ARCTAN(SQRT(1/SQR(X)-1));
                  FY^[k]:=(WARORFOU(F,teta,M)+u0)*EXP(a*TX^[k])
                END
     END { OBORMSF };

   PROCEDURE OBORMSFT;
     VAR X,teta  :FLOAT;
         F       :WEKD;
     BEGIN
       BLAD:=0;
       IF (S0<=0) OR (a<0) OR (t<0)THEN
       BEGIN
         BLAD:=142;
         EXIT
       END;
       IF M>24 THEN
       BEGIN
         BLAD:=143;
         EXIT
       END;
       IF t=0
         THEN ut:=u0
         ELSE BEGIN
                WSPOLSF(FUOP,F,M,u0,S0,a);
                IF S0<>LN2P2/t
                  THEN BEGIN
                         X:=EXP(-S0*t);
                         teta:=ARCTAN(SQRT(1/SQR(X)-1));
                       END
                  ELSE teta:=PIP4;
                ut:=(WARORFOU(F,teta,M)+u0)*EXP(a*t)
              END
     END { OBORMSFT };

   PROCEDURE MACLAG(    FUOP    :FUNUS;
                    VAR B       :MACD;
                    VAR W       :WEKD;
                        M       :BYTE;
                        u0,S0,a :FLOAT);
{-----------------------------------------------------------------}
{ FUOP - funkcja typu FUNUS okreslajaca funkcje operatorowa       }
{        U(s) na osi rzeczywistej                                 }
{ B - macierz ukladu rownan algebraicznych (8.30)                 }
{ W - wektor wyrazow wolnych ukladu rownan algebraicznych (8.30)  }
{ M - ilosc elementow szeregu Laguerre'a (8.27)                   }
{ u0- wartosc poczatkowa orginalu tj. Lim s*U(s) gdy s zmierza    }
{     do nieskonczonosci                                          }
{ S0- krok rospisania funkcji operatorowej U(s) na osi dodatniej  }
{     S0>0 dla malych chwil czasowych t,S0 duze i odwrotnie       }
{ a - wartosc rzeczywista dodatnia dobierana tak azeby na prawo   }
{     od  tej wartosci funkcja operatorowa byla analityczna       }
{-----------------------------------------------------------------}
     VAR i,k        :WORD;
         tau,R,U,SX :FLOAT;
     BEGIN
       FOR k:=1 TO M DO
       BEGIN
         tau:=k/(k+1);  { albo tau:=(M-k+1)/(M+1);}
         SX:=1/(1-tau)*S0+a;
         U:=FUOP(SX);
         W[k]:=(SX-a)*(U-u0/SX);
         FOR i:=1 TO M DO
         BEGIN
           IF i>1
             THEN BEGIN
                    R:=R*tau;
                    B[k]^[i]:=R;
                  END
             ELSE BEGIN
                    R:=1;
                    B[k]^[1]:=1
                  END;
             END
         END
     END { MACLAG };

    FUNCTION WARORLAG(VAR G    :WEKD;
                          M    :BYTE;
                          S0,t :FLOAT):FLOAT;
{----------------------------------------------------------------}
{ G - wektor wspolczynnikow szeregu Laguerre'a (8.27)            }
{ M - ilosc elementow wektora G                                  }
{ S0- krok rospisania funkcji operatorowej U(s) na osi dodatniej }
{     S0>0 dla malych chwil czasowych t,S0 duze i odwrotnie      }
{ t - wartosc chwili czasowej dla ktorej dokonano obliczen       }
{     zgodnie z wzorem (8.27) podstawiajac X=S0*t                }
{----------------------------------------------------------------}
      VAR i                 :WORD;
          LNX1,LNX2,LNX,X,S :FLOAT;
      BEGIN
        X:=S0*t;
        LNX2:=1;
        LNX1:=1-X;
        IF M=2
          THEN WARORLAG:=G[2]*(1-X)
          ELSE BEGIN
                 S:=G[1]+G[2]*(1-X);
                 FOR i:=2 TO M-1 DO
                 BEGIN
                   LNX:=((-X+2*i-1)*LNX1-(i-1)*LNX2)/i;
                   S:=S+G[i+1]*LNX;
                   LNX2:=LNX1;
                   LNX1:=LNX
                 END;
                 WARORLAG:=S
               END
      END { WARORLAG };

   PROCEDURE OBORMSL;
     VAR k   :WORD;
         B   :MACD;
         G,W :WEKD;

     BEGIN
       BLAD:=0;
       IF M>60 THEN
       BEGIN
         BLAD:=144;
         EXIT
       END;
       IF TX^[0]<0 THEN
       BEGIN
         BLAD:=145;
         EXIT
       END;
       NEWMACD(B,M,BLAD);
       IF BLAD=0 THEN
       BEGIN
         MACLAG(FUOP,B,W,M,u0,S0,a);
         RRALD(B,W,G,M,1E-38,BLAD);
         IF BLAD=0 THEN
           FOR k:=0 TO N DO
             IF TX^[k]=0
               THEN FY^[k]:=u0
               ELSE FY^[k]:=(WARORLAG(G,M,S0,TX^[k])+u0)*EXP(a*TX^[k]);
         DISMACD(B,M);
       END;
     END { OBORMSL };

   PROCEDURE OBORMSLT;
     VAR X,tau   :FLOAT;
         W,G     :WEKD;
         B       :MACD;
     BEGIN
       BLAD:=0;
       IF (S0<=0) OR (a<0) OR (t<0) THEN
       BEGIN
         BLAD:=146;
         EXIT
       END;
       IF M>60 THEN
       BEGIN
         BLAD:=147;
         EXIT
       END;
       IF t=0
         THEN ut:=u0
         ELSE BEGIN
                NEWMACD(B,M,BLAD);
                IF BLAD=0 THEN
                BEGIN
                  MACLAG(FUOP,B,W,M,u0,S0,a);
                  RRALD(B,W,G,M,1E-38,BLAD);
                  IF BLAD=0 THEN
                    ut:=(WARORLAG(G,M,S0,t)+u0)*EXP(a*t);
                  DISMACD(B,M)
                END
              END;
     END { OBORMSLT };

   PROCEDURE OBLPOMRES;
     VAR i,j,N            :BYTE;
         alf1,maxS,mS,P,Q :FLOAT;
         Z,WA,WB          :WEKZ;
         A                :WEK;
         ZB               :ZBIORBIEG;
         Y1,Y2,Y3,Y4      :ZESPOL;

     PROCEDURE WARWIELIPOCH(    IP,N :BYTE;
                                S    :ZESPOL;
                                A    :WEK;
                            VAR WW   :WEKZ);
      {----------------------------------------------------------------}
      { Obliczanie wartosci wielomianow i ich pochodnej metoda Hornera }
      { A - wektor wspolczynnikow wielomianu rzedu N                   }
      { WW[0] - wartosc wielomianu w punkcie zespolonym S              }
      { WW[1] - wartosc pochodnej wielomianu w punkcie zespolonym S    }
      { IP=0 - oblicz tylko wartosc wielomianu w punkcie S             }
      { IP=1 - oblicz wartosc wielomianu i jego pochodna w S           }
      {----------------------------------------------------------------}
        VAR i  :BYTE;
            ZA :ZESPOL;
        BEGIN
          IF N>0
            THEN FOR i:=0 TO IP DO
                 BEGIN
                   WW[i]:=Z0;
                   WW[i].RE:=A[0]
                 END
            ELSE BEGIN
                   WW[0]:=Z0;
                   WW[0].RE:=A[0];
                   WW[1]:=Z0
                 END;
          FOR i:=1 TO N DO
            CASE IP OF
              0: BEGIN
                   MUL(ZA,WW[0],S);
                   ZA.RE:=ZA.RE+A[i];
                   WW[0]:=ZA
                 END;
              1: IF i<=N-1
                   THEN BEGIN
                          MUL(ZA,WW[0],S); ZA.RE:=ZA.RE+A[i]; WW[0]:=ZA;
                          MUL(ZA,WW[1],S); ADD(WW[1],ZA,WW[0])
                        END
                   ELSE BEGIN
                          MUL(ZA,WW[0],S); ZA.RE:=ZA.RE+A[i]; WW[0]:=ZA;
                        END
            END
        END { WARWIELIPOCH };

     BEGIN
       BLAD:=0;
       IF NL>=NM THEN
       BEGIN
         BLAD:=148;
         EXIT
       END;
       A:=WM;
       { Wyznaczenie polozenia biegunow metoda Laguerre }
       ZWLAGUERRE(NM,A,eps,maxit,BLAD,Z);
       IF BLAD<>0 THEN
       BEGIN
         BLAD:=149;
         EXIT
       END;
       { Zmiana kolejnosci biegunow i ustalenie ich krotnosci }
       ZB:=[1..NM]; k:=0; maxS:=0;
       FOR i:=1 TO NM DO
       BEGIN
         M[i]:=0;
         mS:=MODUL(Z[i]);
         IF maxS<mS THEN
           maxS:=mS
       END;
       alf1:=maxS*alf; { Bezwzgledna dokladnosc rozrozniania biegunow }
       FOR i:=1 TO NM DO
         IF i IN ZB THEN
         BEGIN
           INC(k);
           Y[k]:=Z[i]; M[k]:=M[k]+1; ZB:=ZB-[i];
           FOR j:=i+1 TO NM DO
             IF j IN ZB THEN
               IF (ABS(Z[i].RE-Z[j].RE)<=alf1) AND (ABS(Z[i].IM-Z[j].IM)<=alf1)
                 THEN BEGIN
                        M[k]:=M[k]+1;
                        ZB:=ZB-[j]
                      END
                 ELSE IF (ABS(Z[i].RE-Z[j].RE)<=alf1) AND (ABS(Z[i].IM+Z[j].IM)<=alf1) THEN
                        ZB:=ZB-[j]
         END;
       FOR i:=1 TO k DO
         IF M[i]=1
           THEN BEGIN { Biegun jednokrotny }
                  WARWIELIPOCH(1,NM,Y[i],WM,WA);
                  WARWIELIPOCH(0,NL,Y[i],WL,WB);
                  DIW(W[0][i],WB[0],WA[1])
                END
           ELSE IF M[i]=2
                  THEN IF ABS(Y[i].IM)<alf1 { Biegun dwukrotny }
                         THEN BEGIN { Dla bieguna rezeczywistego podwojnego}
                                A:=WM;
                                P:=2*Y[i].RE;
                                Q:=SQR(Y[i].RE);
                                N:=NM;
                                DIV2(N,A,P,Q);
                                WARWIELIPOCH(1,N,Y[i],A,WA);
                                WARWIELIPOCH(1,NL,Y[i],WL,WB);
                                DIW(W[0][i],WB[0],WA[0]);
                                MUL(Y1,WB[1],WA[0]);
                                MUL(Y2,WB[0],WA[1]);
                                SUB(Y3,Y1,Y2);
                                MUL(Y1,WA[0],WA[0]);
                                DIW(W[1][i],Y3,Y1)
                              END
                         ELSE BEGIN { Dla bieguna zespolonego podwojnego }
                                A:=WM;
                                P:=2*Y[i].RE;
                                Q:=KWMODUL(Y[i]);
                                N:=NM;
                                DIV2(N,A,P,Q);
                                DIV2(N,A,P,Q);
                                WARWIELIPOCH(1,N,Y[i],A,WA);
                                WARWIELIPOCH(1,NL,Y[i],WL,WB);
                                MUL(Y1,WB[1],WA[0]);
                                MUL(Y2,WB[0],WA[1]);
                                SUB(Y3,Y1,Y2);
                                MUL(Y1,WB[0],WA[0]);
                                MULRZ(Y1,Y1,2);
                                Y4.RE:=0; Y4.IM:=2*Y[i].IM;
                                MUL(Y2,Y4,Y3);
                                SUB(Y3,Y2,Y1);
                                Y4.RE:=0; Y4.IM:=-8*Y[i].IM*SQR(Y[i].IM);
                                MUL(Y1,WA[0],WA[0]);
                                MUL(Y2,Y4,Y1);
                                DIW(W[1][i],Y3,Y2);
                                P:=-4*SQR(Y[i].IM);
                                MULRZ(Y1,WA[0],P);
                                DIW(W[0][i],WB[0],Y1)
                              END
                  ELSE BLAD:=150
     END { OBLPOMRES };

   FUNCTION TRANODWLAPFW;
     VAR i,j          :BYTE;
         omega,sigma,
         fi,fi0,fi1,X :FLOAT;
     BEGIN
       X:=0;
       FOR i:=1 TO K DO
         IF M[i]=1
           THEN IF ABS(Y[i].IM)<alfa
                  THEN X:=X+W[0][i].RE*EXP(Y[i].RE*t)
                  ELSE BEGIN
                         fi:=ARG(W[0][i]); sigma:=Y[i].RE; omega:=Y[i].IM;
                         X:=X+2*MODUL(W[0][i])*EXP(sigma*t)*COS(omega*t+fi)
                       END
           ELSE IF M[i]=2
                  THEN IF ABS(Y[i].IM)<alfa
                         THEN X:=X+(W[1][i].RE+W[0][i].RE*t)*EXP(Y[i].RE*t)
                         ELSE BEGIN
                                fi0:=ARG(W[0][i]); fi1:=ARG(W[1][i]);
                                sigma:=Y[i].RE; omega:=Y[i].IM;
                                X:=X+(2*MODUL(W[1][i])*COS(omega*t+fi1)+
                                      2*MODUL(W[0][i])*t*COS(omega*t+fi0))*EXP(sigma*t)
                              END
                  ELSE BLAD:=151;
       TRANODWLAPFW:=X
     END { TRANODWLAPFW };

END.
