{*******************************************************************}
{                      Modul ALGMZES                                }
{               ROWNANIA MACIERZOWE ZESPOLONE                       }
{                  dla macierzy statycznych                         }
{                  Turbo Pascal  wersja 7.0                         }
{                    autor Bernard Baron                            }
{*******************************************************************}
UNIT ALGMZES;

{$IFDEF CPU87} {$N+}
       {$ELSE} {$N-}
{$ENDIF}

INTERFACE

USES  TFLOAT,ALGEZES;

CONST MAX =25;

TYPE  PMAX =-1..MAX;
      WEKZ =ARRAY[PMAX]OF ZESPOL;
      MACZ =ARRAY[PMAX]OF WEKZ;


PROCEDURE TRANMACZ(VAR A,AT :MACZ;
                       M,N  :BYTE);
  { Wyznaczanie macierzy transponowanej At wzgledem macierzy  }
  { zespolonej A gdzie  M,N - odpowiednio liczba wierszy      }
  { i kolumn macierzy A                                       }

PROCEDURE ADDMACZ(VAR C,A,B :MACZ;
                      M,N   :BYTE);
  { Wyznaczanie sumy macierzy zespolonych C=A+B               }
  {  o M - wierszach i N - kolumnach                          }

PROCEDURE SUBMACZ(VAR C,A,B :MACZ;
                      M,N   :BYTE);
  { Wyznaczanie roznicy macierzy zespolonych C=A-B            }
  {  o M - wierszach i N - kolumnach                          }

PROCEDURE MULMACZ(VAR D,A,B :MACZ;
                      M,P,N :BYTE);
  { Wyznaczanie iloczynu macierzy  zespolonych D=A*B          }
  { macierze: D - posiada M - wierszy i P - kolumn;           }
  {           A - posiada M - wierszy i N - kolumn;           }
  {           B - posiada N - wierszy i P - kolumn            }

PROCEDURE MULMACZZ(VAR A,B :MACZ;
                       z   :ZESPOL;
                       M,N :BYTE);
  { Iloczyn macierzy zespolonej B przez liczbe zespolona z    }

PROCEDURE MACZEROZ(VAR A0  :MACZ;
                       N,M :BYTE);
  { Generacja macierzy zerowej zespolonej A0                  }
  { o N wierszach i M kolumnach                               }

PROCEDURE MACJEDENZ(VAR A1 :MACZ;
                        N  :BYTE);
  { Generacja macierzy jednostkowej zespolonej A1 rzedu N     }

PROCEDURE SKALROWZ(VAR A   :MACZ;
                       b   :WEKZ;
                       N   :BYTE);
  { Skalowanie macierzy zespolonej wg wzoru (1.30)            }

PROCEDURE RRALZ(VAR A    :MACZ;
                VAR b,x  :WEKZ;
                    N    :BYTE;
                    EPS  :FLOAT;
                VAR BLAD :BYTE);
  { Rozwiazywanie ukladu rownan liniowych zespolonych A*x=b;  }
  {  A - macierz kwadratowa zespolona rzedu N                 }
  {  b - zespolony wektor wyrazow wolnych                     }
  {  x - zespolony wektor rozwiazania                         }
  {  EPS - dokladnosc rozroznienia zerowej kolumny, detA=0    }
  {  BLAD - nr bledu; 0 - brak bledu                          }

PROCEDURE SKALROWMACZ(VAR A,B :MACZ;
                          N,M :BYTE);
  { Skalowanie macierzy zespolonych wg wzoru (1.30)           }

PROCEDURE RRMAZ(VAR A,B,X :MACZ;
                    N,M   :BYTE;
                    EPS   :FLOAT;
                VAR BLAD  :BYTE);
  { Rozwiazywanie rownania macierzowego zespolonego A*X=B;    }
  {  A - macierz zespolona wspolczynnikow NxN                 }
  {  B - macierz zespolona wyrazow wolnych NxM                }
  {  X - macierz zespolona rozwiazania NxM                    }
  {  EPS - dokladnosc rozroznienia zerowej kolumny, detA=0    }
  {  BLAD - nr bledu; 0 - brak bledu                          }

PROCEDURE ODWMACZ(VAR A,B :MACZ;
                      N   :BYTE;
                      EPS :FLOAT;
                  VAR BLAD  :BYTE);
  {  Odwracanie macierzy kwadratowej zespolonej rzedu N       }
  {                                                      -1   }
  {  B - macierz zespolona odwrotna wzgledem A; tj. B = A     }
  {  EPS - dokladnosc rozroznienia zerowej kolumny, detA=0    }
  {  BLAD - nr bledu; 0 - brak bledu                          }

PROCEDURE ODWMACZ1(VAR A   :MACZ;
                       N   :BYTE;
                       EPS :FLOAT;
                   VAR BLAD  :BYTE);
  {  Odwracanie macierzy kwadratowej zespolonej rzedu N       }
  {  i zapisanie jej na miejscu oryginalnej                   }
  {                                                      -1   }
  {  A - macierz zespolona odwrotna wzgledem A; tj. A = A     }
  {  EPS - dokladnosc rozroznienia zerowej kolumny, detA=0    }
  {  BLAD - nr bledu; 0 - brak bledu                          }

PROCEDURE DETZA(VAR DETA :ZESPOL;
                VAR A    :MACZ;
                    N    :BYTE;
                    EPS  :FLOAT);
  {  Wyznacznik DETA macierzy kwadratowej zespolonej A rzedu N}
  {  EPS - dokladnosc rozroznienia zerowej kolumny, DETA=0    }

FUNCTION NORMACZ(VAR A :MACZ;
                     N :BYTE):FLOAT;
   {  Norma macierzy zespolonej kwadratowej A rzedu N         }

FUNCTION WUMACZ(VAR A    :MACZ;
                    N    :BYTE;
                    EPS  :FLOAT;
                    BLAD :BYTE):FLOAT;
  { Wspolczynnik uwarunkowania macierzy zespolonej A rzedu N  }
  { EPS - dokladnosc rozroznienia zerowego wiersza            }
  {       (np. EPS=1E-16)                                     }
  { BLAD - nr bledu; 0 - brak bledu                           }

FUNCTION MWWMZ(VAR A     :MACZ;
                   N     :BYTE;
                   EPS   :FLOAT;
                   maxit :WORD;
               VAR BLAD  :BYTE):FLOAT;
  { Wartosc wlasna macierzy zespoloej A o najwiekszym module  }
  { A     - macierz zespolona kwadratowa rzedu N              }
  { EPS   - zadana dokladnosc bezwzgledna wyznaczania wartosci}
  {         wlasnej                                           }
  { maxit - maksymalna liczba iteracji konczaca procedure     }
  { BLAD  - nr bledu; 0 - brak bledu                          }

FUNCTION MWWMZA(VAR A        :MACZ;
                    N        :BYTE;
                    EPS,ALFA :FLOAT;
                    maxit    :WORD;
                VAR BLAD     :BYTE):FLOAT;
  { Wartosc wlasna macierzy A1-ALFA*A o najwiekszym module    }
  { A    - macierz zespolona kwadratowa rzedu N               }
  { A1   - macierz jednostkowa                                }
  { ALFA - parametr wiekszy od zera                           }
  { EPS  - zadana dokladnosc bezwzgledna wyznaczania wartosci }
  {        wlasnej                                            }
  { maxit- maksymalna liczba iteracji konczaca procedure      }
  { BLAD - nr bledu; 0 - brak bledu                           }

PROCEDURE RRMAZIGS(VAR A,B,X     :MACZ;
                       N,M       :BYTE;
                       EPS,OMEGA :FLOAT;
                       maxit     :WORD;
                   VAR BLAD      :BYTE);
  { Rozwiazywanie rownania macierzowego A*X=B metoda iteracji }
  { Gaussa-Seidela OMEGA=1 oraz                               }
  { nadrelaksacji  0<OMEGA<>1 wzor (1.68), (1.69)             }
  { A - macierz zespolona wspolczynnikow rzedu N              }
  { B - macierz zespolona wyrazow wolnych NxM                 }
  { X - macierz zespolona rozwiazania NxM                     }
  { EPS - dokladnosc bezwzgledna iteracji (np. EPS=1E-8)      }
  { OMEGA - parametr relaksacji                               }
  { maxit - maksymalna liczba iteracji konczaca procedure     }
  { BLAD - nr bledu; 0 - brak bledu                           }


IMPLEMENTATION

PROCEDURE TRANMACZ;
  VAR i,j:BYTE;
  BEGIN
    FOR i:=1 TO M DO
      FOR j:=1 TO N DO
        At[j,i]:=A[i,j]
  END { TRANMACZ };

PROCEDURE ADDMACZ;
  VAR i,j:BYTE;
  BEGIN
    FOR i:=1 TO M DO
      FOR j:=1 TO N DO
        ADD(C[i,j],A[i,j],B[i,j])
  END { ADDMACZ };

PROCEDURE SUBMACZ;
  VAR i,j:BYTE;
  BEGIN
    FOR i:=1 TO M DO
      FOR j:=1 TO N DO
        SUB(C[i,j],A[i,j],B[i,j])
  END { SUBMACZ };

PROCEDURE MULMACZ;
  VAR i,j,k :BYTE;
      U,S   :ZESPOL;
      D0    :WEKZ;
  BEGIN
    FOR i:=1 TO M DO
    BEGIN
      FOR k:=1 TO P DO
      BEGIN
        S:=Z0;
        FOR j:=1 TO N DO
        BEGIN
          MUL(U,A[i,j],B[j,k]);
          ADD(S,S,U)
        END;
        D0[i]:=S
      END;
      D[i]:=D0
    END
  END { MULMACZ };

PROCEDURE MULMACZZ;
  VAR i,j:BYTE;
  BEGIN
    FOR i:=1 TO M DO
      FOR j:=1 TO N DO
        MUL(A[i,j],B[i,j],z)
  END { MULMACZZ };

PROCEDURE MACZEROZ;
  VAR i,j:BYTE;
  BEGIN
    FillChar(A0,SizeOf(A0),0)
  END { MACZEROZ };

PROCEDURE MACJEDENZ;
  VAR i:BYTE;
  BEGIN
    MACZEROZ(A1,N,N);
    FOR i:=1 TO N DO
      A1[i,i]:=Z1
  END { MACJEDENZ };

PROCEDURE SKALROWZ;
  VAR i,j         :BYTE;
      S,SX,S1,LN2 :FLOAT;
  BEGIN
    LN2:=LN(2);
    { Skalowanie ukladu rownan wg wzoru (1.30) }
    FOR i:=1 TO N DO
    BEGIN
      S:=0;
      FOR j:=1 TO N DO
      BEGIN
        SX:=MODUL(A[i,j]);
        S:=S+SX
      END;
      S1:=LN(S)/LN2+1;
      IF (S<0.5) OR (S>1.0) THEN
      BEGIN
        IF S1>=0
          THEN S:=EXP(-TRUNC(S1)*LN2)
          ELSE IF S1-TRUNC(S1)=0.0
                 THEN S:=EXP(-TRUNC(S1)*LN2)
                 ELSE S:=EXP(-TRUNC(S1-1)*LN2);
        FOR j:=1 TO N DO
          MULRZ(A[i,j],A[i,j],S);
        MULRZ(b[i],b[i],S)
      END
    END
  END; { SKALROWZ }

PROCEDURE RRALZ;
  VAR i,j,k                 :BYTE;
      T,MA                  :FLOAT;
      ZT,ZT1,ZT2,ZS,ZS1,ZS2 :ZESPOL;
  BEGIN
    BLAD:=0;
    SKALROWZ(A,b,N);
    { Konstrukcja ciagu macierzy A(i) wzory (1.20), (1.21), }
    { (1.23) oraz ciagu wektorow b(i) wzory (1.22)          }
    FOR i:=1 TO N DO
    BEGIN
      { Wybor elementu glownego wg wzoru (1.24) }
      T:=MODUL(A[i,i]);
      k:=i;
      FOR j:=i+1 TO N DO
      BEGIN
        MA:=MODUL(A[j,i]);
        IF MA>T THEN
        BEGIN
          T:=MA;
          k:=j
        END
      END;
      IF T<EPS THEN
      { Warunek przerwania poszukiwania elementu glownego   }
      { wg (1.27) nie istnieje rozwiazanie rownania, detA=0 }
      BEGIN
        BLAD:=40;
        EXIT
      END;
      IF i=k
        THEN ZT:=A[i,i]
        ELSE BEGIN
               { Zamiana elementu k-tego z i-tym wektora b }
               ZT:=b[k]; b[k]:=b[i]; b[i]:=ZT;
               { Zamiana wiersza k-tego z i-tym macierzy A }
               FOR j:=N DOWNTO i DO
               BEGIN
                 ZT:=A[k,j]; A[k,j]:=A[i,j]; A[i,j]:=ZT
               END
             END;
      ODW(ZT,ZT); A[i,i]:=ZT;
      FOR j:=i+1 TO N DO
      BEGIN
        MULRZ(ZT1,ZT,-1);  MUL(ZS,A[j,i],ZT1); { wzor (1.23) }
        MUL(ZS1,b[i],ZS);  ADD(b[j],b[j],ZS1); { wzor (1.22) }
        FOR k:=i+1 TO N DO
        BEGIN
          MUL(ZS2,A[i,k],ZS);
          ADD(A[j,k],A[j,k],ZS2) { wzor (1.21) }
        END
      END
    END;
    { Rozwiazywanie ukladu trojkatnego metoda }
    { postepowania wstecz wzor (1.26)         }
    FOR i:=N DOWNTO 1 DO
    BEGIN
      ZT:=b[i];
      FOR j:=i+1 TO N DO
      BEGIN
        MUL(ZS,A[i,j],X[j]); SUB(ZT,ZT,ZS)
      END;
      MUL(X[i],ZT,A[i,i])
    END
  END { RRALZ };

PROCEDURE SKALROWMACZ;
  VAR LN2,S,SX,S1 :FLOAT;
      i,j         :BYTE;
  BEGIN
    LN2:=LN(2);
    { Skalowanie ukladu rownan wg wzoru (1.30) }
    FOR i:=1 TO N DO
    BEGIN
      S:=0;
      FOR j:=1 TO N DO
      BEGIN
        SX:=MODUL(A[i,j]);
        S:=S+SX
      END;
      S1:=LN(S)/LN2+1;
      IF (S<0.5) OR (S>1.0) THEN
      BEGIN
        IF S1>=0
          THEN S:=EXP(-TRUNC(S1)*LN2)
          ELSE IF S1-TRUNC(S1)=0.0
                 THEN S:=EXP(-TRUNC(S1)*LN2)
                 ELSE S:=EXP(-TRUNC(S1-1)*LN2);
        FOR j:=1 TO N DO
          MULRZ(A[i,j],A[i,j],S);
        FOR j:=1 TO M DO
          MULRZ(B[i,j],B[i,j],S);
      END
    END;
  END; { SKALROWMACZ }

PROCEDURE RRMAZ;
  VAR  i,j,k                 :BYTE;
       T,MA                  :FLOAT;
       ZT,ZT1,ZT2,ZS,ZS1,ZS2 :ZESPOL;
  BEGIN
    BLAD:=0;
    SKALROWMACZ(A,B,N,M);
    { Konstrukcja ciagu macierzy A(i) wzory (1.20), (1.21), }
    { (1.23) oraz ciagu macierzy B(i) wg wzoru (1.32)       }
    FOR i:=1 TO N DO
    BEGIN
      { Wybor elementu glownego wg wzoru (1.24) }
      T:=MODUL(A[i,i]); k:=i;
      FOR j:=i+1 TO N DO
      BEGIN
        MA:=MODUL(A[j,i]);
        IF MA>T THEN
        BEGIN
          T:=MA; k:=j
        END
      END;
      IF T<EPS THEN
        { Warunek przerwania poszukiwania elementu glownego  }
        { wg (1.27) nie istnieje rozwiazanie rownania        }
        { macierzowego (1.31), detA=0                        }
      BEGIN
        BLAD:=41;
        EXIT
      END;
      IF i=k
        THEN ZT:=A[i,i]
        ELSE BEGIN
               FOR j:=1 TO M DO
               BEGIN
                 { Zamiana wiersza k-tego z i-tym macierzy B }
                 ZT:=B[k,j]; B[k,j]:=B[i,j]; B[i,j]:=ZT
               END;
               FOR j:=N DOWNTO i DO
               BEGIN
                 { Zamiana wiersza k-tego z i-tym macierzy A }
                 ZT:=A[k,j]; A[k,j]:=A[i,j]; A[i,j]:=ZT
               END
             END;
      ODW(ZT,ZT); A[i,i]:=ZT;
      FOR j:=i+1 TO N DO
      BEGIN
        MULRZ(ZT1,ZT,-1); MUL(ZS,A[j,i],ZT1);  { wzor (1.23) }
        FOR k:=1 TO M DO
        BEGIN
          MUL(ZS1,B[i,k],ZS);
          ADD(B[j,k],B[j,k],ZS1) { wzor (1.32) }
        END;
        FOR k:=i+1 TO N DO
        BEGIN
          MUL(ZS2,A[i,k],ZS);
          ADD(A[j,k],A[j,k],ZS2) { wzor (1.21) }
        END
      END
    END;
    { Rozwiazywanie ukladu trojkatnego (1.33) metoda }
    { postepowania wstecz wzor (1.34)                }
    FOR k:=1 TO M DO
      FOR i:=N DOWNTO 1 DO
      BEGIN
        ZT:=B[i,k];
        FOR j:=i+1 TO N DO
        BEGIN
          MUL(ZS,A[i,j],X[j,k]);SUB(ZT,ZT,ZS)
        END;
        MUL(X[i,k],ZT,A[i,i])
      END
  END { RRMAZ };

PROCEDURE ODWMACZ;
  VAR A1:MACZ;
  BEGIN
    { Generacja macierzy jednostkowej zespolonej A1 }
    MACJEDENZ(A1,N);
    RRMAZ(A,A1,B,N,N,EPS,BLAD)
  END { ODWMACZ };

PROCEDURE ODWMACZ1;
VAR i,j,l,k  :BYTE;
    MmaxA,d  :FLOAT;
    maxA,e,f :ZESPOL;
    M        :ARRAY[PMAX] OF BYTE;
BEGIN
  BLAD:=0;
  FOR i:=1 TO N DO
  BEGIN
    { Czesciowy wybor elementu glownego wg wzoru (1.49)}
    MmaxA:=0;
    FOR j:=i TO N DO
    BEGIN
      d:=MODUL(A[j,i]);
      IF MmaxA<d THEN
      BEGIN
        MmaxA:=d;
        maxA:=A[j,i];
        k:=j
      END
    END;
    { Zapisywanie wskaznikow wierszy wystepowania elementu
      ekstremalnego w i-tej iteracji w postaci wektora M[i] }
    M[i]:=k;
    A[k,i]:=Z1;
    FOR j:=1 TO N DO
    BEGIN
      IF MmaxA<EPS THEN
      BEGIN
        BLAD:=42;
        EXIT
      END;
      { Przestawienie i-tego wiersz z k-tym }
      DIW(e,A[k,j],maxA);  A[k,j]:=A[i,j];  A[i,j]:=e
    END;
    { Generacja ciagu macierzy (1.42) wg wzoru rekurencyjnego (1.41) }
    FOR j:=1 TO N DO
      IF j<>i THEN
      BEGIN
        f:=A[j,i];  A[j,i]:=Z0;
        FOR l:=1 TO N DO
        BEGIN
          MUL(e,f,A[i,l]);
          SUB(A[j,l],A[j,l],e);
        END
      END
  END;
  { Przestawianie kolumn macierzy zgodnie z wektorem wskaznikow M[i] (1.46) }
  FOR i:=N DOWNTO 1 DO
  BEGIN
    k:=M[i];
    IF k<>i THEN
      FOR j:=1 TO N DO
      BEGIN
        e:=A[j,i];
        A[j,i]:=A[j,k];
        A[j,k]:=e
      END
  END
END; { ODWMACZ1 }


PROCEDURE DETZA;
  VAR  M,i,j,k                 :BYTE;
       T,MA                    :FLOAT;
       S,ZT,ZT1,ZT2,ZS,ZS1,ZS2 :ZESPOL;
  BEGIN
    M:=0;
    { Konstrukcja ciagu macierzy A(i) wzory (1.20), (1.21), }
    { (1.23) oraz (2.29)                                    }
    FOR i:=1 TO N DO
    BEGIN
      { Wybor elementu glownego wg wzoru (1.24) }
      T:=MODUL(A[i,i]); k:=i;
      FOR j:=i+1 TO N DO
      BEGIN
        MA:=MODUL(A[j,i]);
        IF MA>T THEN
        BEGIN
          T:=MA; k:=j
        END
      END;
      IF T<EPS THEN
      { Warunek przerwania poszukiwania elementu glownego    }
      { wg (1.27) nie istnieje rozwiazanie rownania, DETA=0  }
      BEGIN
        DETA:=Z0; { zero zespolone Z0 }
        EXIT
      END;
      IF i=k
        THEN ZT:=A[i,i]
        ELSE BEGIN
               { Zliczanie ilosci M przestawien wierszy    }
               INC(M);
               { Zamiana wiersza k-tego z i-tym macierzy A }
               FOR j:=N DOWNTO i DO
               BEGIN
                 ZT:=A[k,j]; A[k,j]:=A[i,j]; A[i,j]:=ZT
               END
             END;
      ODW(ZT,ZT);
      FOR j:=i+1 TO N DO
      BEGIN
        MULRZ(ZT1,ZT,-1);  MUL(ZS,A[j,i],ZT1); { wzor (1.23) }
        FOR k:=i+1 TO N DO
        BEGIN
          MUL(ZS2,A[i,k],ZS);
          ADD(A[j,k],A[j,k],ZS2) { wzor (1.21) }
        END
      END
    END;
    S:=Z1;
    { Obliczanie wyznacznika }
    FOR i:=1 TO N DO
      MUL(S,S,A[i,i]);
    IF FRAC(M/2)=0.0
      THEN DETA:=S
      ELSE MULRZ(DETA,S,-1)
  END { DETZA };

FUNCTION NORMACZ;
  VAR i,j :BYTE;
      RR,S:FLOAT;
  BEGIN
    RR:=0;
    FOR j:=1 TO N DO
    BEGIN
      S:=0;
      FOR i:=1 TO N DO
        S:=S+MODUL(A[i,j]);
      IF RR<S THEN
        RR:=S
    END;
    NORMACZ:=RR
  END { NORMACZ };

FUNCTION WUMACZ;
  VAR KM1,KM2 :FLOAT;
  BEGIN
    BLAD:=0;
    { Norma macierzy  pkt 2.28  }
    KM1:=NORMACZ(A,N);
    { Odwracanie macierzy A  pkt 2.24 }
    ODWMACZ1(A,N,EPS,BLAD);
    IF BLAD<>0
      THEN WUMACZ:=1/EPS
      ELSE BEGIN
             { Norma macierzy pkt 2.28 }
             KM2:=NORMACZ(A,N);
             WUMACZ:=KM1*KM2
           END
  END { WUMACZ };

FUNCTION MWWMZ;
  VAR i,j             :BYTE;
      k               :WORD;
      MS,P,R,T,WW1,WW2:FLOAT;
      S,S1            :ZESPOL;
      W,U             :WEKZ;
  BEGIN
    BLAD:=0;
    FOR i:=1 TO N DO
    BEGIN
      P:=0.02*i;
      MULRZ(W[i],Z1,P)
    END;   { wektor poczatkowy (1.56) }
    P:=1.0; WW2:=100.0; k:=0;
    REPEAT
      R:=0.0; k:=k+1;
      { wzor 1.50) }
      FOR i:=1 TO N DO
      BEGIN
        S:=Z0;
        FOR j:=1 TO N DO
        BEGIN
          MUL(S1,A[i,j],W[j]);
          ADD(S,S,S1)
        END;
        U[i]:=S;  MS:=MODUL(S);
        IF MS>R THEN
          R:=MS { wyznaczanie normy wektora wzor (1.57) }
      END;
      WW1:=R/P;  { przyblizanie granicy (1.55) }
      P:=R; W:=U; T:=ABS(WW1-WW2); WW2:=WW1
    UNTIL (T<EPS) OR (k>maxit);
    IF k>maxit
      THEN BLAD:=43
      ELSE MWWMZ:=WW1
  END { MWWMZ };

FUNCTION MWWMZA;
  VAR i,j             :BYTE;
      k               :WORD;
      P,R,MS,T,WW1,WW2:FLOAT;
      S,S1            :ZESPOL;
      W,U             :WEKZ;
  BEGIN
    BLAD:=0;
    FOR i:=1 TO N DO
    BEGIN
      P:=0.02*i;
      MULRZ(W[i],Z1,P)
    END;   { wektor poczatkowy (1.56) }
    P:=1.0; WW2:=100.0; k:=0;
    REPEAT
      R:=0.0; k:=k+1;
      { wzor 1.58) }
      FOR i:=1 TO N DO
      BEGIN
        S:=Z0;
        FOR j:=1 TO N DO
        BEGIN
          MUL(S1,A[i,j],W[j]);
          ADD(S,S,S1)
        END;
        MULRZ(S,S,ALFA); SUB(U[i],W[i],S); MS:=MODUL(U[i]);
        IF MS>R THEN
          R:=MS { wyznaczanie normy wektora wzor (1.57) }
      END;
      WW1:=R/P;  { przyblizanie granicy (1.55) }
      P:=R; W:=U; T:=ABS(WW1-WW2); WW2:=WW1
    UNTIL (T<EPS) OR (k>maxit);
    IF k>maxit
      THEN BLAD:=44
      ELSE MWWMZA:=WW1
  END { MWWMZA };

PROCEDURE RRMAZIGS;
 VAR i,j,l,k     :BYTE;
     p           :WORD;
     R,R1,MS,MA,T:FLOAT;
     S,S1,ZT     :ZESPOL;
     y           :WEKZ;
 BEGIN
   SKALROWMACZ(A,B,N,M); {Skalowanie macierzy wg wzoru (1.30)}
   { Poszukiwanie maksymalnych co do modulu elementow glownych}
   FOR i:=1 TO N DO
   BEGIN
     T:=MODUL(A[i,i]); k:=i;
     FOR j:=i+1 TO N DO
     BEGIN
       MA:=MODUL(A[j,i]);
       IF MA>T THEN
       BEGIN
         T:=MA;
         k:=j
       END
     END;
     IF i<>k THEN
     BEGIN
       FOR j:=1 TO M DO
       BEGIN
         ZT:=B[k,j]; B[k,j]:=B[i,j]; B[i,j]:=ZT
       END;
       FOR j:=1 TO N DO
       BEGIN
         ZT:=A[k,j]; A[k,j]:=A[i,j]; A[i,j]:=ZT
       END
     END
   END;
   R:=MWWMZA(A,N,1E-4,OMEGA,maxit,BLAD);
   {Najwieksza co do modulu wartosc wlasna macierzy A1-OMEGA*A}
   IF R>=1 THEN
   BEGIN
     BLAD:=45;
     EXIT
   END;
   p:=0;
   REPEAT
     R1:=0; p:=p+1;
     FOR l:=1 TO M DO
     BEGIN
       FOR i:=1 TO N DO
         y[i]:=X[i,l] ;
       R:=0.0;
       FOR i:=1 TO N DO
       BEGIN
         S:=B[i,l];
         FOR j:=1 TO i-1 DO
         BEGIN
           MUL(S1,A[i,j],X[j,l]); SUB(S,S,S1)
         END;
         FOR j:=i TO N DO
         BEGIN
           MUL(S1,A[i,j],y[j]); SUB(S,S,S1)
         END;
         MULRZ(S1,S,OMEGA);
         ADD(X[i,l],y[i],S1);
         MS:=MODUL(S);
         IF MS>R THEN
           R:=MS
       END;
       IF R>R1 THEN
         R1:=R
     END
   UNTIL (R1<EPS) OR (p>maxit);
   IF p>maxit THEN
     BLAD:=46;
 END { RRMAZIGS };

END.
