PROGRAM PRZ8_4;
  {$F+}
  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
   USES CRT,TFLOAT,LAPLACE,WYKRESY,KOM_BLAD;
   VAR  k,i,N,M                  :WORD;
        gama,mi,T0,H0,u0,S0,
        a,beta,r,r0,dr,t,dt,t1,H :FLOAT;
        TX,HT                    :WEKD1;
        W1,W2                    :WEKI;
        WYB,CH                   :CHAR;
        LAN,LAN1,LAN2            :STRING;
        TAK                      :BOOLEAN;
        BLAD                     :BYTE;

   PROCEDURE DANE;
   { Przykladowe dane }
     BEGIN
       gama:=5.6*1E+7;
       mi:=4*PI*1E-7;
       beta:=SQRT(gama*mi);
       r0:=0.05; {m}
       T0:=1E-3; {sek}
       H0:=1;    {A/m}
       N:=100;
       dr:=r0/N;
       t1:=100*T0;  dt:=t1/N;
       M:=24
    END { DANE };

   FUNCTION I0(X:FLOAT):FLOAT;
     { Zmodyfikowana funkcja Bessela argumentu rzeczywistego }
     { wzor (8.81)                                           }
     VAR Z,S,WYR,SIL:FLOAT;
        L,N2,i:WORD;
     BEGIN
       IF X<15
         THEN BEGIN
                SIL:=1.0;  Z:=X*X;  WYR:=1.0;
                S:=WYR;    i:=1;
                WHILE ABS(WYR)>1E-20 DO
                BEGIN
                  WYR:=WYR*Z/(i*i*4);
                  S:=S+WYR;
                  INC(i)
                END;
                I0:=S
              END
         ELSE BEGIN
                Z:=8.0*X;  WYR:=1.0/Z;  S:=1.0+WYR;
                FOR i:=2 TO 10 DO
                BEGIN
                  L:=2*i-1; L:=L*L;
                  WYR:=WYR*L/(i*Z); S:=S+WYR
                END;
                I0:=EXP(X)*S/SQRT(ABS(2.0*PI*X))
              END
     END {I0};

   FUNCTION TRAN_H(s:FLOAT):FLOAT;
   { Postac operatorowa pola magnetycznego w walcu wzor (8.80) }
     VAR ps,I01,I02,z:FLOAT;
     BEGIN
       ps:=sqrt(s);  ps:=ps*beta;
       z:=ps*r;  I01:=I0(z);
       z:=ps*r0; I02:=I0(z);
       TRAN_H:=H0*I01/(s*(s*T0+1)*I02)
     END { TRAN_H };

   PROCEDURE MENU;
     BEGIN
       CLRSCR;
       WRITELN('     Dyfuzja pola magnetycznego do walca przewodzacego');
       WRITELN;
       WRITELN('klawisz  H - przebieg czasowy pola dla danego promienia r ');
       WRITELN('             z przedzialu (0,',LAN2,') w [mm] ');
       WRITELN;
       WRITELN('         G - rozklad pola magnetycznego wzdluz promienia ');
       WRITELN('             dla danej chwili czasu t z przedzialu (0,',LAN1,') w [msek] ');
       WRITELN;
       WRITELN('         K - koniec wyboru')
     END { MENU };

BEGIN
  NEW(TX); NEW(HT); { Inicjacja wektorow dynamcznych }
  DANE;
  STR(t1*1000:5:0,LAN1);  STR(r0*1000:5:0,LAN2);
  FOR k:=0 TO N DO
    TX^[k]:=k*dt;
  REPEAT
    MENU;
    WYB:=UPCASE(READKEY);
    CLRSCR;
    CASE WYB OF
      'H': BEGIN
             REPEAT
               WRITELN;
               WRITE('Wybierz promien  w [mm] na ktorym chcesz'+
                     ' znac rozklad pola r=');
               READ(r);
               TAK:=(r>=0) AND (r<=r0*1000);
               IF NOT TAK THEN
               BEGIN
                 CLRSCR;
                 WRITE('Promien z poza przedzialu (0,',LAN2,') w [mm]')
               END;
             UNTIL TAK;
             STR(r:6:2,LAN); r:=r/1000;
             S0:=LN2P2/TX^[N];
             OBORMSF(TRAN_H,TX,HT,N,M,0,S0,0,BLAD);
             IF BLAD=0 THEN
             BEGIN
               FOR i:=0 TO N DO
               BEGIN
                 W1[i]:=TX^[i]*1000;
                 W2[i]:=HT^[i]
               END;
               WYKRESXYG(W1,W2,N,' Przebieg pola magnetycznego na wybranym ',
                         'promieniu przewodu  r= '+LAN+'[mm]','t [msek]','H(r,t) [A/m]');
             END
          END {H} ;
     'G': BEGIN
            REPEAT
              WRITELN;
              WRITELN('Wybierz chwile czasowa w milisekundach '+
                      ' dla ktorej chcesz znac');
              WRITE('rozkld pola magnetycznego t='); READ(t);
              TAK:=(t>=0) AND (t<=t1*1000);
              IF NOT TAK THEN
              BEGIN
                CLRSCR;
                WRITE('Czas z poza przedzialu (0,',LAN1,') w [milisek]')
              END;
            UNTIL TAK;
            STR(t:6:2,LAN); t:=t/1000;
            S0:=LN2P2/(t1);
            FOR k:=0 TO N DO
            BEGIN
              GOTOXY(35,12); WRITE(N-k:5);
              r:=k*dr; W1[k]:=r;
              OBORMSFT(TRAN_H,t,H,M,0,S0,0,BLAD);
              W2[k]:=H;
            END;
            FOR k:=0 TO N DO
              W1[k]:=W1[k]*1000;
            WYKRESXYG(W1,W2,N,' Rozklad pola magnetycznego w chwili',
                      '   t= '+LAN+' [msek]  wzdluz promienia przewodu',
                      'r [mm]','H(r,t) [A/m]');
          END {G};
    END;
    IF BLAD<>0 THEN
    BEGIN
      PISZ_KOM_BLAD(BLAD);
      CH:=READKEY
    END
  UNTIL WYB='K';
  DISPOSE(HT); DISPOSE(TX)
END.
