{***************************************************************************}
{                       Modul PLIK_ZO                                       }
{                   Turbo Pascal  wersja 7.0                                }
{                   autor Adam Gawlowski                                    }
{***************************************************************************}
UNIT PLIK_ZO;

INTERFACE

USES  DOS,CRT,TFLOAT,ALGELIN;

CONST NORM_WIERSZ_SAVE=10;
      NazwaPliku : string = '';

TYPE  DANE_NAZWY_PLIKU=RECORD
                         SCIEZKA : STRING;
                         NAZWA   : STRING[13]
                       END;

VAR   OSTATNIA_SCIEZKA:STRING;
      LAST_DRIVE      :BYTE;
      PLIK_D          :FILE OF FLOAT;

  PROCEDURE INIC_PLIK(VAR PLIK :DANE_NAZWY_PLIKU);
  { Inicjacja zmiennej plikowej PLIK }

  PROCEDURE ZAPIS_D(VAR X       :WEK;
                        N       :BYTE;
                    VAR M       :WORD;
                        CH      :CHAR;
                    VAR PLIK    :DANE_NAZWY_PLIKU;
                    VAR BLAD    :BYTE);
  { Zapis wektorow wynikow kolejnych iteracji do pliku }
  { X  - wektor zmiennych stanu w kolejnej chwili t    }
  {      oraz X[0]=t                                   }
  { N  - ilosc ukladow rownan                          }
  { M  - nr iteracji                                   }
  { CH - zmienna pomocnicza:                           }
  {      'B' - poczatek zapisu na dysk,                }
  {      'C' - kontynuacja zapisu na dysk,             }
  {      'R' - zerowanie pliku                         }
  {            i zapis pierwszej iteracji              }
  {      'E' - koniec zapisu.                          }
  { PLIK - nazwa pliku                                 }
  { BLAD - nr zidentyfikowanego bladu,                 }
  {        BLAD=0 oznacza brak bladu                   }


  PROCEDURE ODCZYT_D(VAR X      :FLOAT;
                         N      :BYTE;
                     VAR M      :WORD;
                         CH     :CHAR;
                     VAR PLIK   :DANE_NAZWY_PLIKU;
                         I,J    :INTEGER;
                     VAR BLAD   :BYTE);
  { Odczyt wartosci rozwiazania z pliku                }
  { X  - odczytana wspolrzedna rozwiazania             }
  { N  - ilosc ukladow rownan                          }
  { M  - ilosc iteracji                                }
  { CH - zmienna pomocnicza:                           }
  {      'B' - odczytanie wartosci N i M,              }
  {      'C' - odczytanie wspolrzednej rozwiazania,    }
  {      'E' - koniec odczytu.                         }
  { PLIK - nazwa pliku                                 }
  { I    - nr wspolrzednej                             }
  { J    - nr iteracji                                 }
  { BLAD - nr zidentyfikowanego bladu,                 }
  {        BLAD=0 oznacza brak bladu                   }

IMPLEMENTATION

  VAR R:REGISTERS;

CONST ZERO     = #0;       { Kody znakow ASCII }
      GONG     = #7;
      TAB      = #9;
      Shift_TAB= #143;
      Esc      = #27;
      CR       = #13;
      BS       = #8;
      LF       = #10;
      F1       = #187;
      F2       = #188;
      F3       = #189;
      F4       = #190;
      F5       = #191;
      F6       = #192;
      F7       = #193;
      F8       = #194;
      F9       = #195;
      F10      = #196;
      UPKEY    = #200;
      DOWNKEY  = #208;
      LEFTKEY  = #203;
      RIGHTKEY = #205;
      PGUPKEY  = #201;
      PGDNKEY  = #209;
      HOMEKEY  = #199;
      ENDKEY   = #207;
      INSKEY   = #210;
      DELKEY   = #211;

TYPE  PLIKSTRING =STRING[13];
      STRING_DATA=STRING[14];
      PARAM_OKNA =ARRAY[0..1,0..1]OF WORD;
      MEMSCR     =ARRAY[1..4000]OF BYTE;
      WMEMSCR    =^MEMSCR;

CONST ON =TRUE;
      OFF=FALSE;
      NORM_WIND:PARAM_OKNA=((1,1),(80,25));
      POJEDYNCZA=1;     PODWOJNA=2;

     { GraphCard }      { Cursor }
      CGA = 0;           NORM  = 0;
      EGA = 1;           OUT   = 1;
      HGC = 2;           THICK = 2;

      SEGMENT_EKRANU           :ARRAY[0..7]OF WORD
                               =($B800,$B800,$B800,$B800,$B800,$B800,$B800,$B000);

VAR   TRYB_EKRANU              :BYTE ABSOLUTE $0000:$0449;


TYPE  STRING80 = STRING[80];
      CHARSET  = SET OF CHAR;

CONST ZNAKI_KONCZACE  : CHARSET = [CR,Esc,UPKEY,DOWNKEY];
      STRING_CHAR     : CHARSET = [' '..'~'];

VAR   WSTAW           : BOOLEAN;

  FUNCTION ANYCHAR:CHAR;
    VAR CH:CHAR;
    BEGIN
      CH:=READKEY;
      IF CH=ZERO THEN
        CH:=CHR(ORD(READKEY) + 128);
      ANYCHAR:=CH
    END; { ANYCHAR }


    PROCEDURE INVERS;
{           Zmienna TEXTATTR: mtttpppp                                      }
{                             m- migotanie,                                 }
{                             t- tlo,                                       }
{                             p- pierwszy plan.                             }
      VAR PLAN,TLO:BYTE;
      BEGIN
        PLAN:=TEXTATTR AND $7;  { maska: 00000111 }
        TLO:=TEXTATTR AND $70;  { maska: 01110000 }
        PLAN:=PLAN SHL 4;
        TLO:=TLO SHR 4;
        TEXTATTR:=TEXTATTR AND $88; { maska: 10001000 }
        TEXTATTR:=TEXTATTR OR PLAN;
        TEXTATTR:=TEXTATTR OR TLO
      END; { INVERS }

    PROCEDURE FLASH(ON:BOOLEAN);
      BEGIN
        IF ON THEN TEXTATTR:=TEXTATTR OR $80
              ELSE TEXTATTR:=TEXTATTR AND $7F
      END; { FLASH }

    FUNCTION GRAPHMODE: INTEGER;
      VAR REG :REGISTERS;
      BEGIN
        REG.AH:=$0F;
        INTR($10,REG);
        GRAPHMODE:=REG.AL
      END; { GRAPHMODE }

    FUNCTION GRAPHCARD:BYTE;
      VAR CARD :BYTE;
      BEGIN
        CASE GRAPHMODE OF
               1..6   : CARD:=CGA;
                  7   : CARD:=HGC;
          10,13..15   : CARD:=EGA
        END;
        GRAPHCARD:=CARD
      END; { GRAPHCARD }

    PROCEDURE LOAD_SCR(VAR SCR:WMEMSCR);
      VAR EKR:WMEMSCR;
      BEGIN
        EKR:=PTR(SEGMENT_EKRANU[TRYB_EKRANU],0);
        EKR^:=SCR^;
        DISPOSE(SCR)
      END; { LOAD_SCR }

    PROCEDURE SAVE_SCR(VAR SCR:WMEMSCR);
      VAR EKR:WMEMSCR;
      BEGIN
        NEW(SCR);
        EKR:=PTR(SEGMENT_EKRANU[TRYB_EKRANU],0);
        SCR^:=EKR^
      END; { SAVE_SCR }


    PROCEDURE CURSOR( STATUS:BYTE);
      VAR REG :REGISTERS;
      BEGIN
        CASE STATUS OF
          NORM  : CASE GRAPHCARD OF
                    CGA    : REG.CX:=$0607;
                    HGC,EGA: REG.CX:=$0B0C;
                    ELSE     EXIT
                  END;
          OUT   : REG.CX:=$0E00;
          THICK : REG.CX:=$000E;
          ELSE    EXIT
        END;
        REG.AX:=$0100;
        INTR($10,REG)
      END; { CURSOR }

    PROCEDURE WINDOWP(O:PARAM_OKNA);
      BEGIN
        WINDOW(O[0,0],O[0,1],O[1,0],O[1,1])
      END; { WINDOWP }

    PROCEDURE OKNO(VAR O:PARAM_OKNA);
      BEGIN
        O[0,0]:=LO(WINDMIN)+1; O[0,1]:=HI(WINDMIN)+1;
        O[1,0]:=LO(WINDMAX)+1; O[1,1]:=HI(WINDMAX)+1
      END; { OKNO }

    PROCEDURE WOKNO(VAR O,P:PARAM_OKNA);
      BEGIN
        P[0,0]:=O[0,0]-1; P[0,1]:=O[0,1]-1;
        P[1,0]:=O[1,0]+1; P[1,1]:=O[1,1]+1
      END; { WOKNO }

    PROCEDURE RAMKA(O:PARAM_OKNA; WIND:BOOLEAN; RR:BYTE);
      CONST L:ARRAY[1..2,1..6]OF CHAR=(('','','','','',''),
                                       ('','','','','',''));
      VAR   I,J,X1,Y1,X2,Y2:BYTE;
            SO             :PARAM_OKNA;
      BEGIN
        OKNO(SO);
        WINDOWP(O);
        CLRSCR;
        IF WIND
          THEN BEGIN
                 WINDOW(O[0,0],O[0,1],O[1,0],O[1,1]+1);
                 X1:=1; Y1:=1;
                 X2:=O[1,0]-O[0,0]+1;
                 Y2:=O[1,1]-O[0,1]+1
               END
          ELSE BEGIN
                 X1:=O[0,0]; Y1:=O[0,1];
                 X2:=O[1,0]; Y2:=O[1,1];
                 WINDOWP(SO)
               END;
        GOTOXY(X1,Y1); WRITE(L[RR,1]);
        FOR I:=X1+1 TO X2-1 DO
          WRITE(L[RR,2]);
        WRITE(L[RR,3]);
        FOR I:=Y1+1 TO Y2-1 DO
        BEGIN
          GOTOXY(X1,I);  WRITE(L[RR,4]);
          GOTOXY(X2,I);  WRITE(L[RR,4])
        END;
        GOTOXY(X1,Y2); WRITE(L[RR,5]);
        FOR I:=X1+1 TO X2-1 DO
          WRITE(L[RR,2]);
        WRITE(L[RR,6]);
        IF WIND THEN WINDOW(O[0,0]+1,O[0,1]+1,O[1,0]-1,O[1,1]-1)
      END; { RAMKA }

  PROCEDURE BEEP;
    BEGIN
      WRITE(GONG)
    END; { BEEP }

  PROCEDURE CZYT_STRING( VAR S     : STRING;
                             L,X,Y : BYTE;
                             ZNAKI_LEG,
                             TERM  : CHARSET;
                         VAR TC    : CHAR    );
{ Wprowadzenie lancucha S o maksymalnej dlugosci L z pozycji (X,Y).  }
{ Jezeli KEY<>#0 to wczytano juz znak KEY.                           }
{ Zbior ZNAKI_LEG zawiera znaki dozwolone do wprowadzenia. TERM jest }
{ zbiorem zawierajacym znaki konczace wprowadzanie. TC jest aktual-  }
{ nym znakiem, ktory konczy wprowadzanie.                            }

    VAR P     : INTEGER;
        CH    : CHAR;
        ST    : STRING;
        CZYT  : BOOLEAN;
    BEGIN
      IF WSTAW
        THEN CURSOR(NORM)
        ELSE CURSOR(THICK);
      ST:=S;
      INVERS;
      GOTOXY(X,Y); WRITE(S);
      INVERS;
      CH:=ANYCHAR;
      CZYT:=FALSE;
      GOTOXY(X,Y); WRITE(' ':L);
      IF CH IN ZNAKI_LEG
        THEN S:=''
        ELSE BEGIN
               GOTOXY(X,Y); WRITE(S)
             END;
      P:=LENGTH(S);
      REPEAT
        GOTOXY(X+P,Y);
        IF CZYT THEN
          CH:=ANYCHAR;
        CZYT:=TRUE;
        IF NOT (CH IN TERM) THEN
          CASE CH OF
            #32..#126    : IF (CH IN ZNAKI_LEG)
                             THEN BEGIN
                                    IF (NOT WSTAW) AND (P<>L)
                                      THEN BEGIN
                                             P := SUCC(P); S[P]:=CH;
                                             WRITE(COPY(S,P,L))
                                           END
                                      ELSE IF LENGTH(S) = L
                                             THEN IF S[1]=' '
                                                    THEN BEGIN
                                                           DELETE(S,1,1);
                                                           INSERT(CH,S,P);
                                                           GOTOXY(X,Y); WRITE(S:L)
                                                         END
                                                    ELSE BEEP
                                             ELSE BEGIN
                                                    P:=SUCC(P); INSERT(CH,S,P);
                                                    WRITE(COPY(S,P,L))
                                                  END;
                                  END
                             ELSE BEEP;
            ^S, LEFTKEY  : IF P > 0
                             THEN P := PRED(P)
                             ELSE BEEP;
            ^D, RIGHTKEY : IF P < LENGTH(S)
                             THEN P := SUCC(P)
                             ELSE BEEP;
            ^A, HOMEKEY  : P := 0;
            ^F, ENDKEY   : P := LENGTH(S);
                INSKEY   : BEGIN
                             WSTAW:=NOT WSTAW;
                             IF WSTAW
                               THEN CURSOR(NORM)
                               ELSE CURSOR(THICK)
                           END;
            ^G, DELKEY   : IF P < LENGTH(S) THEN
                           BEGIN
                             DELETE(S,P + 1,1);
                             WRITE(COPY(S,P + 1,L),' ');
                           END;
            BS           : IF P > 0
                             THEN BEGIN
                                    DELETE(S,P,1);
                                    WRITE(^H,COPY(S,P,L),' ');
                                    P := PRED(P);
                                  END
                             ELSE BEEP;
            ^Y           : BEGIN
                             GOTOXY(X,Y); WRITE(' ':L); GOTOXY(X,Y);
                             S:=''; P:=0
                           END
        END  { OF CASE }
      UNTIL CH IN TERM;
      IF CH=ESC THEN
        S:=ST;
      TC := CH;
      CURSOR(OUT)
    END; { CZYT_STRING }

    PROCEDURE INIT_OBD;
    BEGIN
      GETDIR(0,OSTATNIA_SCIEZKA);
      IF OSTATNIA_SCIEZKA[LENGTH(OSTATNIA_SCIEZKA)]<>'\' THEN
        OSTATNIA_SCIEZKA:=OSTATNIA_SCIEZKA+'\';
      R.AH:=$19; MSDOS(R);
      R.AH:=$0E; R.DL:=R.AL; MSDOS(R);
      LAST_DRIVE:=R.AL;
      WSTAW:=TRUE
    END; { INIT_OBD }

    PROCEDURE INIC_PLIK;
      BEGIN
        init_OBD;
        PLIK.SCIEZKA:=OSTATNIA_SCIEZKA;
        PLIK.NAZWA:=''
      END; { INIC_PLIK }

  PROCEDURE LOAD_F(    MASKA:STRING;
                   VAR PLIK :DANE_NAZWY_PLIKU;
                   VAR ENT:BOOLEAN);
      CONST O :PARAM_OKNA=((13, 9),(69,20)); { Okno zbiorow. }
            MAXFILE=200;
            MAXDIR =50;
      VAR   F:ARRAY[1..MAXFILE]OF ^PLIKSTRING;
            D:ARRAY[1..MAXDIR]OF ^PLIKSTRING;
            IL,IL_KAT,
            PIERWSZY,KOL,WIER,
            K,J,
            DK,IO                :INTEGER;
            STOS                 :POINTER;
            PLIK_EW              :DANE_NAZWY_PLIKU;
            PODRZEDNY_KATALOG,
            WYJSCIE              :BOOLEAN;
            KEY                  :CHAR;

          PROCEDURE LOAD_DIR;
            VAR INFOREC:SEARCHREC;
            BEGIN
              IL:=0;
              FINDFIRST(PLIK_EW.SCIEZKA+MASKA,0,INFOREC);
              MARK(STOS);
              WHILE DOSERROR=0 DO
              BEGIN
                INC(IL);
                NEW(F[IL]);
                F[IL]^:=INFOREC.NAME;
                FINDNEXT(INFOREC)
              END;
              IL_KAT:=0; PODRZEDNY_KATALOG:=FALSE;
              FINDFIRST(PLIK_EW.SCIEZKA+'*',DIRECTORY,INFOREC);
              WHILE DOSERROR<>18 DO
              BEGIN
                IF INFOREC.NAME<>'.' THEN
                  IF INFOREC.NAME='..'
                    THEN PODRZEDNY_KATALOG:=TRUE
                    ELSE IF INFOREC.ATTR=DIRECTORY THEN
                           BEGIN
                             INC(IL_KAT);
                             NEW(D[IL_KAT]);
                             D[IL_KAT]^:=INFOREC.NAME+'\'
                           END;
                FINDNEXT(INFOREC)
              END
            END; { LOADDIR }

          PROCEDURE NAPIS(X,Y:BYTE);
            BEGIN
              GOTOXY(X*14+1,Y+1);
              IF IL>0 THEN
                WRITE(F[(PIERWSZY+Y)*4+X+1]^)
            END; { NAPIS }

          PROCEDURE NOWA_LINIA;
            VAR I:BYTE;
            BEGIN
              FOR I:=0 TO 3 DO
              IF (PIERWSZY+WIER)*4+I+1<=IL THEN NAPIS(I,WIER)
            END; { NOWA_LINIA }

          PROCEDURE ODWROC_NAPIS;
            BEGIN
              INVERS;
              NAPIS(KOL,WIER);
              INVERS
            END; { ODWROC_NAPIS }

          PROCEDURE CALA_RAMKA;
            VAR   I,J:INTEGER;
            BEGIN
              CLRSCR;
              FOR I:=0 TO 9 DO
                FOR J:=0 TO 3 DO
                  IF (PIERWSZY+I)*4+J+1<=IL THEN
                    NAPIS(J,I);
              IF IL>0 THEN
                ODWROC_NAPIS
            END; { CALA_RAMKA }

          PROCEDURE OSTATNIA_POZYCJA;
            BEGIN
              KOL:=IL MOD 4-1;
              IF KOL=-1 THEN
                KOL:=3;
              IF IL>40
                THEN BEGIN
                       WIER:=9;
                       PIERWSZY:= (IL-KOL-1) DIV 4-WIER
                     END
                ELSE BEGIN
                       PIERWSZY:=0;
                       WIER:=(IL-KOL) DIV 4
                     END
            END; { OSTATNIA_POZYCJA }

      PROCEDURE BELKA;
        BEGIN
          INVERS; GOTOXY(2,25);
          WRITE(' ',#27,#24,#25,#26,
                ' - wybor   < - potwierdzenie    F8 - zmiana stacji   Esc - zaniechanie ');
          INVERS
        END; { BELKA }

      PROCEDURE SORTOWANIE;
        VAR WSK:BOOLEAN;
            I,N:WORD;
            R  :POINTER;
        BEGIN
          N:=IL;
          REPEAT
            WSK:=TRUE;
            FOR I:=2 TO N DO
              IF F[I]^<F[I-1]^ THEN
              BEGIN
                R:=F[I];
                F[I]:=F[I-1];
                F[I-1]:=R;
                WSK:=FALSE
              END;
            DEC(N)
          UNTIL WSK;
          N:=IL_KAT;
          REPEAT
            WSK:=TRUE;
            FOR I:=2 TO N DO
              IF D[I]^<D[I-1]^ THEN
              BEGIN
                R:=D[I];
                D[I]:=D[I-1];
                D[I-1]:=R;
                WSK:=FALSE
              END;
            DEC(N)
          UNTIL WSK;
          FOR I:=1 TO IL_KAT DO
          BEGIN
            NEW(F[I+IL]);
            F[I+IL]^:=D[I]^;
            DISPOSE(D[I])
          END;
          INC(IL,IL_KAT);
          IF PODRZEDNY_KATALOG THEN
          BEGIN
            INC(IL);
            NEW(F[IL]);
            F[IL]^:='..\'
          END
        END; { SORTOWANIE }

      PROCEDURE ZMIANA_STACJI;
        CONST OZS :PARAM_OKNA=((30,13),(50,16));
        VAR   OZS1             :PARAM_OKNA;
              STACJA,PSTACJA,I :BYTE;
              KEY              :CHAR;
              WYJSCIE          :BOOLEAN;

            PROCEDURE PISZ(I:BYTE);
              BEGIN
                GOTOXY((OZS[1,0]-OZS[0,0]) DIV 2-3*LAST_DRIVE DIV 2+(I-1)*3+1,2);
                WRITE(CHR(I+64),':')
              END; { PISZ }

            PROCEDURE ODWROC;
              BEGIN
                INVERS; PISZ(STACJA); INVERS
              END; { ODWROC }

            PROCEDURE BELKA;
              BEGIN
                WINDOWP(NORM_WIND);
                INVERS; GOTOXY(2,25);
                WRITE('      ',#27,#26,
                      ' - wybor          < - potwierdzenie          Esc - zaniechanie      ');
                INVERS;
                WINDOW(OZS[0,0]+1,OZS[0,1]+1,OZS[1,0]-1,OZS[1,1]-1)
              END; { BELKA }

            PROCEDURE BLAD_ODCZYTU;
              BEGIN
                WINDOWP(NORM_WIND);
                GOTOXY(2,25);
                FLASH(ON);
                WRITE('                            Blad odczytu stacjii !!!                          ');
                WRITE(#7);
                FLASH(OFF); DELAY(5000);
                INVERS; BELKA; INVERS
              END; { BLAD_ODCZYTU }

        BEGIN
          WYJSCIE:=FALSE;
          BELKA;
          INVERS;
          OZS1[0,0]:=OZS[0,0]-1; OZS1[0,1]:=OZS[0,1]; OZS1[1,0]:=OZS[1,0]+1; OZS1[1,1]:=OZS[1,1];
          WINDOWP(OZS1); CLRSCR;
          RAMKA(OZS,ON,PODWOJNA);
          WRITE('   Wybierz stacje');
          STACJA:=ORD(PLIK_EW.SCIEZKA[1])-64;
          FOR I:=1 TO LAST_DRIVE DO
            PISZ(I);
          REPEAT
            ODWROC;
            KEY:=ANYCHAR;
            PISZ(STACJA);
              CASE KEY OF
                 CR     : IF DISKFREE(STACJA)<>-1
                            THEN WYJSCIE:=TRUE
                            ELSE BLAD_ODCZYTU;
                ESC     : WYJSCIE:=TRUE;
                LEFTKEY : IF STACJA>1 THEN
                           DEC(STACJA);
                RIGHTKEY: IF STACJA<LAST_DRIVE THEN
                            INC(STACJA);
                'A'..'Z','a'..'z':
                          BEGIN
                            PSTACJA:=ORD(UPCASE(KEY))-64;
                            IF PSTACJA<=LAST_DRIVE THEN
                            BEGIN
                              STACJA:=PSTACJA;
                              IF DISKFREE(STACJA)<>-1
                                THEN WYJSCIE:=TRUE
                                ELSE BLAD_ODCZYTU
                            END
                          END
              END;
            ODWROC
          UNTIL WYJSCIE;
          IF KEY<>ESC THEN
          BEGIN
            GETDIR(STACJA,PLIK_EW.SCIEZKA);
            IF PLIK_EW.SCIEZKA[LENGTH(PLIK_EW.SCIEZKA)]<>'\' THEN
              PLIK_EW.SCIEZKA:=PLIK_EW.SCIEZKA+'\';
            PLIK_EW.SCIEZKA:=PLIK_EW.SCIEZKA
          END;
          INVERS;
          WINDOWP(O)
        END; { ZMIANA_STACJI }

      BEGIN
        PLIK_EW:=PLIK; WYJSCIE:=FALSE;
        REPEAT
          WINDOWP(NORM_WIND);
          KEY:=ZERO;
          LOAD_DIR;
          BELKA;
          INVERS; RAMKA(O,ON,POJEDYNCZA); INVERS;
          WINDOWP(O);
          DK:=LENGTH(PLIK_EW.SCIEZKA+MASKA);
          GOTOXY((O[1,0]-O[0,0]-DK+2) DIV 2,1);
          INVERS; WRITE(PLIK_EW.SCIEZKA+MASKA); INVERS;
          WINDOW(O[0,0]+1,O[0,1]+1,O[1,0]-1,O[1,1]-1);
          SORTOWANIE;
          PLIK_EW.NAZWA:='';
          KOL:=0; WIER:=0; PIERWSZY:=0;
          INVERS;
          CALA_RAMKA;
          REPEAT
            KEY:=ANYCHAR;
            CASE KEY OF
              UPKEY:    IF WIER=0
                          THEN IF PIERWSZY<>0
                                 THEN BEGIN
                                        NAPIS(KOL,WIER);
                                        DEC(PIERWSZY);
                                        INSLINE;
                                        NOWA_LINIA;
                                        ODWROC_NAPIS
                                      END
                                  ELSE
                          ELSE BEGIN
                                 NAPIS(KOL,WIER);
                                 DEC(WIER);
                                 ODWROC_NAPIS
                               END;
              DOWNKEY:  IF ((WIER+PIERWSZY+1)*4+KOL+1)<=IL
                          THEN IF WIER=9
                                 THEN BEGIN
                                        NAPIS(KOL,WIER);
                                        GOTOXY(O[1,0],O[1,1]);
                                        WRITELN;
                                        INC(PIERWSZY);
                                        NOWA_LINIA;
                                        ODWROC_NAPIS
                                      END
                                 ELSE BEGIN
                                        NAPIS(KOL,WIER);
                                        INC(WIER);
                                        ODWROC_NAPIS
                                      END
                          ELSE BEGIN
                                 OSTATNIA_POZYCJA;
                                 CALA_RAMKA
                               END;
              LEFTKEY:  IF KOL=0
                          THEN IF (PIERWSZY+WIER)*4+5<=IL
                                 THEN BEGIN
                                        NAPIS(0,WIER);
                                        KOL:=3;
                                        ODWROC_NAPIS
                                      END
                                 ELSE BEGIN
                                        NAPIS(0,WIER);
                                        OSTATNIA_POZYCJA;
                                        ODWROC_NAPIS
                                      END
                          ELSE BEGIN
                                 NAPIS(KOL,WIER);
                                 DEC(KOL);
                                 ODWROC_NAPIS
                               END;
              RIGHTKEY: IF (KOL=3) OR ((PIERWSZY+WIER)*4+KOL+2>IL)
                          THEN BEGIN
                                 NAPIS(KOL,WIER);
                                 KOL:=0;
                                 ODWROC_NAPIS
                               END
                          ELSE BEGIN
                                 NAPIS(KOL,WIER);
                                 INC(KOL);
                                 ODWROC_NAPIS
                               END;
              HOMEKEY:  BEGIN
                          KOL:=0; WIER:=0; PIERWSZY:=0;
                          CALA_RAMKA
                        END;
              ENDKEY:   BEGIN
                          OSTATNIA_POZYCJA;
                          CALA_RAMKA
                        END;
              PGUPKEY:  BEGIN
                          IF PIERWSZY-9>=0 THEN DEC(PIERWSZY,9)
                                           ELSE BEGIN
                                                  PIERWSZY:=0;
                                                  WIER:=0
                                                END;
                          CALA_RAMKA
                        END;
              PGDNKEY:  BEGIN
                          IF (PIERWSZY+WIER+9)*4+KOL+1>IL
                            THEN OSTATNIA_POZYCJA
                            ELSE INC(PIERWSZY,9);
                          CALA_RAMKA
                        END
            END { CASE KEY }
          UNTIL KEY IN [CR,ESC,F8];  { RETURN, ESC lub ZMIANA_STACJI }
          INVERS;
          RELEASE(STOS);
          CASE KEY OF
            CR : IF IL>0 THEN
                 BEGIN
                   PLIK_EW.NAZWA:=F[(PIERWSZY+WIER)*4+KOL+1]^;
                   IF PLIK_EW.NAZWA[LENGTH(PLIK_EW.NAZWA)]='\'
                     THEN IF PLIK_EW.NAZWA[LENGTH(PLIK_EW.NAZWA)-1]='.'
                            THEN REPEAT
                                   DELETE(PLIK_EW.SCIEZKA,LENGTH(PLIK_EW.SCIEZKA),1)
                                 UNTIL PLIK_EW.SCIEZKA[LENGTH(PLIK_EW.SCIEZKA)]='\'
                            ELSE PLIK_EW.SCIEZKA:=PLIK_EW.SCIEZKA+PLIK_EW.NAZWA
                     ELSE BEGIN
                            PLIK:=PLIK_EW;
                            OSTATNIA_SCIEZKA:=PLIK.SCIEZKA;
                            WYJSCIE:=TRUE
                          END
                 END;
            ESC: BEGIN
                   WYJSCIE:=TRUE;
                   PLIK.SCIEZKA:=PLIK_EW.SCIEZKA
                 END;
            F8 : ZMIANA_STACJI
          END
        UNTIL WYJSCIE;
        ENT:=KEY=CR;
        WINDOW(1,1,80,25)
      END; { LF }

  PROCEDURE LOAD_FILE(    MASKA:STRING;
                      VAR PLIK :DANE_NAZWY_PLIKU;
                      VAR ENT  :BOOLEAN);
{   Procedura LOADFILE pozwala wybrac wg zadanej maski zbior o nazwie PLIK. }
      VAR PLIK_EW:DANE_NAZWY_PLIKU;
      BEGIN
        PLIK_EW:=PLIK;
        LOAD_F(MASKA,PLIK_EW,ENT);
        IF ENT THEN
          PLIK:=PLIK_EW
      END; { LOAD_FILE }

  PROCEDURE SAVE_FILE(    WIERSZ:BYTE;
                          MASKA :STRING;
                      VAR PLIK  :DANE_NAZWY_PLIKU;
                      VAR ENT   :BOOLEAN);

      CONST NAPIS       ='Nazwa zbioru: ';
      VAR   SCR         :WMEMSCR;
            ZL          :CHARSET;
            PLIK_EW     :DANE_NAZWY_PLIKU;
            NAZWA       :STRING;
            DL_NAZWY    :BYTE;
            WYJSCIE,OK,JEST_ROZSZERZENIE
                        :BOOLEAN;
            TC          :CHAR;
            ROZSZERZENIE:STRING[4];
            I           :BYTE;
            OSF         :PARAM_OKNA;
      BEGIN
        OSF[0,0]:=3; OSF[0,1]:=WIERSZ-1; OSF[1,0]:=78; OSF[1,1]:=WIERSZ+1;
        RAMKA(OSF,ON,POJEDYNCZA);
        JEST_ROZSZERZENIE:=MASKA<>'*.*';
        IF JEST_ROZSZERZENIE
          THEN BEGIN
                 DL_NAZWY:=8;
                 ZL:=['A'..'Z','a'..'z','0'..'9','_'];
                 I:=1;
                 WHILE (PLIK.NAZWA[I]<>'.') AND (I<=LENGTH(PLIK.NAZWA)) DO
                   INC(I);
                 PLIK.NAZWA:=COPY(PLIK.NAZWA,1,I-1)
               END
          ELSE BEGIN
                 DL_NAZWY:=12;
                 ZL:=['A'..'Z','a'..'z','0'..'9','.','_']
               END;
        PLIK_EW:=PLIK;
        WYJSCIE:=FALSE;
        REPEAT
          WRITE(NAPIS,PLIK_EW.SCIEZKA);
          IF JEST_ROZSZERZENIE THEN
          BEGIN
            ROZSZERZENIE:=COPY(MASKA,2,4);
            GOTOXY(LENGTH(NAPIS+PLIK_EW.SCIEZKA)+9,1); WRITE(ROZSZERZENIE)
          END;
          NAZWA:=PLIK_EW.NAZWA;
          CZYT_STRING(NAZWA,DL_NAZWY,LENGTH(NAPIS+PLIK_EW.SCIEZKA)+1,1,ZL,[CR,ESC],TC);
          PLIK_EW.NAZWA:=NAZWA;
          IF TC=ESC
            THEN WYJSCIE:=TRUE
            ELSE IF PLIK_EW.NAZWA=''
                   THEN BEGIN
                          SAVE_SCR(SCR);
                          LOAD_F(MASKA,PLIK_EW,OK);
                          IF OK AND JEST_ROZSZERZENIE THEN
                          BEGIN
                            I:=1;
                            WHILE (PLIK_EW.NAZWA[I]<>'.') AND (I<=LENGTH(PLIK_EW.NAZWA)) DO
                              INC(I);
                            PLIK_EW.NAZWA:=COPY(PLIK_EW.NAZWA,1,I-1)
                          END;
                          LOAD_SCR(SCR);
                          RAMKA(OSF,ON,POJEDYNCZA)
                        END
                   ELSE BEGIN
                          PLIK:=PLIK_EW;
                          WYJSCIE:=TRUE
                        END
        UNTIL WYJSCIE;
        IF JEST_ROZSZERZENIE THEN
          PLIK.NAZWA:=PLIK.NAZWA+ROZSZERZENIE;
        ENT:=TC=CR;
        WINDOWP(NORM_WIND)
      END; { SAVE_FILE }


  PROCEDURE ODCZYT_D;
    VAR ENT   :BOOLEAN;
        rz    :LongInt;
        ror   :FLOAT;
    BEGIN
      CASE CH of
        'B': BEGIN
               BLAD:=0;
               ENT:=TRUE;
               IF Plik.Nazwa='' THEN
                 LOAD_FILE('*.DAT',plik,ENT);
               NazwaPliku:=Plik.sciezka+Plik.nazwa;
               ASSIGN(plik_d,NazwaPliku);
               {$I-} RESET(plik_d); {$I+}
               IF IORESULT=0
                 THEN BEGIN
                        rz:=FileSize(plik_d);
                        IF rz <> 0
                        THEN BEGIN
                               Seek(plik_d,rz-2);
                               Read(plik_d,ror);
                               N:=Trunc(ror);
                               Read(plik_d,ror);
                               M:=Trunc(ror);
                               IF (M+1)*(N+1)<>(rz-2) THEN
                                 BLAD:=115
                             END
                      END
                 ELSE BLAD:=115
             END;
        'C': BEGIN
               Seek(plik_d,J*(N+1)+I);
               Read(plik_d,X)
             END;
        'E': Close(plik_d)
      END
    END; { ODCZYT_D }

  PROCEDURE Zapis_d;
    VAR ENT    : BOOLEAN;
        wr,wr1 : FLOAT;

      PROCEDURE WPIS;
        VAR j:byte;
        BEGIN
          FOR j:=0 TO N DO
            WRITE(plik_d,X[j]);
        END; { WPIS }

    BEGIN
      CASE CH OF
      'B': BEGIN
             ENT:=true;
             SAVE_FILE(7,'*.DAT',plik,ENT);
             IF ENT
               THEN BEGIN
                      NazwaPliku:=Plik.sciezka+Plik.nazwa;
                      Assign(plik_d,NazwaPliku);
                      {$I-} Rewrite(plik_d); {$I+}
                      IF IORESULT=0
                        THEN wpis
                        ELSE BLAD:=116
                    END
               ELSE BLAD:=116
           END;
      'C': wpis;
      'R': BEGIN
            seek(plik_d,0);
            Truncate(plik_d);
            wpis
           END;
      'E': BEGIN
            wr:=M; wr1:=N;
            write(plik_d,wr1,wr);
            Close(plik_d)
           END
      END
    END; { Zapis_d }

END.