{******************************************************************}
{                            Modul ALGEZES                         }
{                          ALGEBRA ZESPOLONA                       }
{                       Turbo Pascal  wersja 7.0                   }
{                       autor Bernard Baron                        }
{******************************************************************}
UNIT ALGEZES;

{$IFDEF CPU87} {$N+}
       {$ELSE} {$N-}
{$ENDIF}

INTERFACE

USES  TFLOAT;

TYPE  ZESPOL =RECORD         { Typ zespolony                }
                RE,IM :FLOAT {   czes rzeczywista i urojona }
              END;

CONST Z0     :ZESPOL=(RE:0; IM:0);
      Z1     :ZESPOL=(RE:1; IM:0);
      ZJ     :ZESPOL=(RE:0; IM:1);




PROCEDURE ADD(VAR Z     :ZESPOL;
                  Za,Zb :ZESPOL);
  { Suma dwoch liczb zespolonych Z = Za + Zb (wzor (2.1))     }

PROCEDURE MUL(VAR Z     :ZESPOL;
                  Za,Zb :ZESPOL);
  { Iloczyn dwoch liczb zespolonych Z = Za * Zb (wzor (2.2))  }

PROCEDURE SUB(VAR Z     :ZESPOL;
                  Za,Zb :ZESPOL);
  { Roznica dwoch liczb zespolonych Z = Za - Zb (wzor (2.10)) }


PROCEDURE DIW(VAR Z     :ZESPOL;
                  Za,Zb :ZESPOL);
  { Iloraz liczb zespolonych Z = Za/Zb (wzor (2.12))          }

PROCEDURE MULRZ(VAR Z  :ZESPOL;
                    Za :ZESPOL;
                    a  :FLOAT);
  { Iloczyn liczby zespolonej Za przez liczbe rzeczywista a   }
  { Z = Za * a (wzor (2.13))                                  }

PROCEDURE DIWZR(VAR Z  :ZESPOL;
                    Za :ZESPOL;
                    a  :FLOAT);
  { Iloraz liczby zespolonej Za przez liczbe rzeczywista a    }
  { Z = Za/a (wzor (2.14))                                    }

PROCEDURE DIWRZ(VAR Z  :ZESPOL;
                    b  :FLOAT;
                    Zb :ZESPOL);
  { Iloraz liczby rzeczywistej b przez liczbe zespolona Zb    }
  { Z = b/Zb  (wzor (2.15))                                   }

PROCEDURE ODW(VAR Za :ZESPOL;
                  Zb :ZESPOL);
  { Odwrotnosc liczby zespolonej Zb                           }
  { tj. Za=1/Zb  (wzor (2.16))                                }

PROCEDURE SPRZ(VAR Z  :ZESPOL;
                   Za :ZESPOL);
  { Liczba sprzezona Z liczby zespolonej Za (wzor (2.17))     }

FUNCTION MODUL(Z:ZESPOL):FLOAT;
  { Modul liczby zespolonej Z (wzor (2.18))                   }

FUNCTION ARG(Z:ZESPOL):FLOAT;
  { Argument liczby zespolonej Z (wzor (2.19))                }

FUNCTION KWMODUL(Z:ZESPOL):FLOAT;
  { Kwadrat modulu liczby zespolonej Z (wzor (2.20))          }


IMPLEMENTATION


PROCEDURE ADD;
  BEGIN
    Z.RE:=Za.RE+Zb.RE;
    Z.IM:=Za.IM+Zb.IM
  END { ADD };

PROCEDURE MUL;
  BEGIN
    Z.RE:=Za.RE*Zb.RE-Za.IM*Zb.IM;
    Z.IM:=Za.RE*Zb.IM+Za.IM*Zb.RE
  END { MUL };

PROCEDURE SUB;
  BEGIN
    Z.RE:=Za.RE-Zb.RE;
    Z.IM:=Za.IM-Zb.IM
  END { SUB };

PROCEDURE DIW;
  VAR S:FLOAT;
  BEGIN
    S:=SQR(Zb.RE)+SQR(Zb.IM);
    Z.RE:=(Za.RE*Zb.RE+Za.IM*Zb.IM)/S;
    Z.IM:=(Za.IM*Zb.RE-Za.RE*Zb.IM)/S
  END { DIW };

PROCEDURE MULRZ;
  BEGIN
    Z.RE:=Za.RE*a;
    Z.IM:=Za.IM*a
  END { MULRZ };

PROCEDURE DIWZR;
  BEGIN
    Z.RE:=Za.RE/a;
    Z.IM:=Za.IM/a
  END { DIWZR };

PROCEDURE DIWRZ;
  VAR S:FLOAT;
  BEGIN
    S:=SQR(Zb.RE)+SQR(Zb.IM);
    Z.RE:=b*Zb.RE/S;
    Z.IM:=-b*Zb.IM/S
  END { DIWRZ };

PROCEDURE ODW;
  VAR S:FLOAT;
  BEGIN
    S:=SQR(Zb.RE)+SQR(Zb.IM);
    Za.RE:=Zb.RE/S;
    Za.IM:=-Zb.IM/S
  END { ODW };

PROCEDURE SPRZ;
  BEGIN
    Z.RE:=Za.RE;
    Z.IM:=-Za.IM
  END { SPRZ };

FUNCTION MODUL;
  BEGIN
    MODUL:=SQRT(SQR(Z.RE)+SQR(Z.IM))
  END { MODUL };

FUNCTION ARG;
  VAR FI:FLOAT;
  BEGIN
    IF Z.RE=0
      THEN IF Z.IM>0
             THEN ARG:=PI*0.5
             ELSE IF Z.IM<0
                    THEN ARG:=1.5*PI
                    ELSE ARG:=0.0
      ELSE BEGIN
             FI:=ARCTAN(Z.IM/Z.RE);
             IF Z.RE<0
               THEN ARG:=PI+FI
               ELSE IF Z.IM>0
                      THEN ARG:=FI
                      ELSE ARG:=2*PI+FI
           END
  END { ARG };

FUNCTION KWMODUL;
  BEGIN
    KWMODUL:=SQR(Z.RE)+SQR(Z.IM)
  END { KWMODUL };

END.
