classdef LampSuperclass
    % superklasa, czyli przodek innych klas np. trafficLamp
    % clear, close, obj=LampSuperclass(3,4), axis equal % wywoanie konstruktora
    properties
        diametr=[0.8 0.8] % diametr of lamp / ?rednica lampy
        color05=[0.5 0.5 0.5] % gray color / kolor szary
        Lg, Ly, Lr % green, yellow and red lamp / zielona, ?ta i czerwona
    end
    properties (Access=private)
        edge=2.5 % edge width / szeroko? kraw?dzi lampy
    end
    methods
        function obj=LampSuperclass(x,y)
            % konstruktor, tworzy obiekty obj nale??ce do tej klasy
            % constructor method, creates object obj, instance of this class
            obj.Lr= rectangle('Position',[x,y+2,obj.diametr],...
            'Curvature',[1,1],'FaceColor',obj.color05,...
            'LineWidth',obj.edge,'LineStyle','-'); % red lamp /lampa czerwona
            obj.Ly= rectangle('Position',[x,y+1,obj.diametr],...
            'Curvature',[1,1],'FaceColor',obj.color05,...
            'LineWidth',obj.edge,'LineStyle','-'); % yellow lamp / lampa ?ta
            obj.Lg= rectangle('Position',[x,y,obj.diametr],...
            'Curvature',[1,1],'FaceColor',obj.color05,...
            'LineWidth',obj.edge,'LineStyle','-'); %green lamp / lampa zielona
        end
    end
end