package entropia;

import java.math.*;
import java.util.concurrent.*;

/**
 * Klasa do obliczania symbolu Newtona w wątku
 * @author Jacek Piechota
 *
 */
public class Npok implements Callable<BigInteger>{
	private BigInteger k;
	private BigInteger n;

	public Npok(BigInteger n, BigInteger k){
		this.n = n;
		this.k = k;
	}

	@Override
	public BigInteger call() throws Exception {
		return npok(this.n, this.k);
	}

	/**
	 * Oblicza symbol Newtona (n po k) dla podanych liczb (n!/(k!(n-k)!)
	 * @param n - liczba elementów
	 * @param k - liczba stanów elementu
	 * @return - n po k, czyli n nad k 
	 */
	public static BigInteger npok(BigInteger n, BigInteger k) {
		if(BigsUtil.wiekszy(k, n)){
			return BigInteger.ZERO;
		}
		else if(BigsUtil.rowny(k, BigInteger.ZERO) || BigsUtil.rowny(k, n)){
			return BigInteger.ONE;
		}
		else if(BigsUtil.rowny(k, BigInteger.ONE)
				|| BigsUtil.rowny(k, n.subtract(BigInteger.ONE))){
			return n;
		}
		else{
			BigInteger b = Factorial.factorial(k);
			BigInteger c = Factorial.factorial(n.subtract(k));
			BigInteger a = b;
			BigInteger i = k.add(BigInteger.ONE);
			while(BigsUtil.mniejszy(i, n.add(BigInteger.ONE))){
				a = a.multiply(i);
				i = i.add(BigInteger.ONE);
			}
			return a.divide(b.multiply(c));
		}
	}

	/**
	 * Oblicza symbol Newtona (n po k) dla podanych liczb (n!/(k!(n-k)!)
	 * @param n - liczba elementów
	 * @param k - liczba stanów elementu
	 * @return - n po k, czyli n nad k 
	 */
	public static long npok(int n, int k) {
		if(k > n){
			return 0;
		}
		else if(k == 0 || k == n){
			return 1;
		}
		else if(k == 1 || k == (n - 1)){
			return n;
		}
		else{
			long b = Factorial.factorial(k);
			long c = Factorial.factorial(n - k);
			long a = b;
			for(long i = k + 1; i < n + 1; i++){
				a *= i;
			}
			return a / (b * c);
		}
	}

	/**
	 * Oblicza symbol Newtona (n po k) dla podanych liczb (n!/(k!(n-k)!)
	 * @param n - liczba elementów
	 * @param k - liczba stanów elementu
	 * @return - n po k, czyli n nad k 
	 */
	public static BigInteger npok(long n, long k) {
		if(k > n){
			return BigInteger.ZERO;
		}
		else if(k == 0 || k == n){
			return BigInteger.ONE;
		}
		else if(k == 1 || k == (n - 1)){
			return new BigInteger(String.valueOf(n));
		}
		else{
			BigInteger b = Factorial.factorial(k);
			BigInteger c = Factorial.factorial(n - k);
			BigInteger a = b;
			for(long i = k + 1; i < n + 1; i++){
				a = a.multiply(new BigInteger(String.valueOf(i)));
			}
			return a.divide((b.multiply(c)));
		}
	}

	/**
	 * Oblicza symbol Newtona (n po k) dla podanych liczb (n!/(k!(n-k)!)
	 * @param n - liczba elementów
	 * @param k - liczba stanów elementu
	 * @return - n po k, czyli n nad k 
	 */
	public static long npok2(int n, int k) {
		long wynik = 1L;
		if(k > n){
			return 0L;
		}
		else if(k == 0 || k == n){
			return 1L;
		}
		else if(k == 1 || k == (n - 1)){
			return n;
		}
		else{
			for(long i = 1; i < k; i++){
				wynik = wynik * (n - i + 1) / i;
			}
			return wynik;
		}
	}

	/**
	 * Oblicza symbol Newtona (n po k) dla podanych liczb (n!/(k!(n-k)!)
	 * @param n - liczba elementów
	 * @param k - liczba stanów elementu
	 * @return - n po k, czyli n nad k 
	 */
	public static BigInteger npok2(long n, long k) {
		BigInteger wynik = BigInteger.ONE;
		if(k > n){
			return BigInteger.ZERO;
		}
		else if(k == 0 || k == n){
			return BigInteger.ONE;
		}
		else if(k == 1 || k == (n - 1)){
			return new BigInteger(String.valueOf(n));
		}
		else{
			for(long i = 1; i < k; i++){
				wynik = wynik
						.multiply(new BigInteger(String.valueOf(n - i + 1)))
						.divide(new BigInteger(String.valueOf(i)));
			}
			return wynik;
		}
	}

	/**
	 * Oblicza symbol Newtona (n po k) dla podanych liczb (n!/(k!(n-k)!)
	 * @param n - liczba elementów
	 * @param k - liczba stanów elementu
	 * @return - n po k, czyli n nad k 
	 */
	public static BigInteger npok2(BigInteger n, BigInteger k) {
		BigInteger wynik = BigInteger.ONE;
		if(BigsUtil.wiekszy(k, n)){
			return BigInteger.ZERO;
		}
		else if(BigsUtil.rowny(k, BigInteger.ZERO) || BigsUtil.rowny(k, n)){
			return BigInteger.ONE;
		}
		else if(BigsUtil.rowny(k, BigInteger.ONE)
				|| BigsUtil.rowny(k, n.subtract(BigInteger.ONE))){
			return n;
		}
		else{
			BigInteger i = BigInteger.ONE;
			while(BigsUtil.mniejszy(i, k)){
				wynik = wynik.multiply(n.subtract(i).add(BigInteger.ONE))
						.divide(i);
				i = i.add(BigInteger.ONE);
			}
			return wynik;
		}
	}
}
