package entropia;

import java.math.*;
import java.util.*;
import java.util.concurrent.*;

public class KombiUtil{
	private KombiUtil(){}

	//Oblicza liczbę kombinacji bez powtórzeń
	public static long kbp(int n, int k) {
		return Npok.npok(n, k);
	}

	public static BigInteger kbp(long n, long k) {
		return Npok.npok(n, k);
	}

	public static BigInteger kbp(BigInteger n, BigInteger k) {
		ExecutorService es = Executors.newFixedThreadPool(1);
		Future<BigInteger> f = null;
		f = es.submit(new Npok(new BigInteger(String.valueOf(n)),
				new BigInteger(String.valueOf(k))));
		BigInteger npok = null;
		try{
			npok = f.get();
		} catch (InterruptedException e){
			e.printStackTrace();
		} catch (ExecutionException e){
			e.printStackTrace();
		}
		es.shutdown();
		return npok;
	}

	//Oblicza liczbe kombinacji z powtorzeniami
	public static long kzp(int n, int k) {
		return Npok.npok(n + k - 1, k);
	};

	public static BigInteger kzp(long n, long k) {
		return Npok.npok(n + k - 1, k);
	};

	public static BigInteger kzp(BigInteger n, BigInteger k) {
		ExecutorService es = Executors.newFixedThreadPool(1);
		BigInteger nn = n.add(k).subtract(BigInteger.ONE);
		Future<BigInteger> f = null;
		f = es.submit(new Npok(nn, k));
		BigInteger npok = null;
		try{
			npok = f.get();
		} catch (InterruptedException e){
			e.printStackTrace();
		} catch (ExecutionException e){
			e.printStackTrace();
		}
		es.shutdown();
		return npok;
	}

	//oblicza liczbe wariacji bez powtorzen
	public static long wbp(int n, int k) {
		long b = Factorial.factorial(n);
		long c = Factorial.factorial(n - k);
		return b / c;
	};

	public static BigInteger wbp(long n, long k) {
		BigInteger b = Factorial.factorial(n);
		BigInteger c = Factorial.factorial(n - k);
		return b.divide(c);
	};

	public static BigInteger wbp(BigInteger n, BigInteger k) {
		BigInteger nk = kbp(n, k);
		return nk.multiply(new BigInteger(String.valueOf(2)));
	}

	//oblicza liczbe wariacji z powtorzeniami
	public static long wzp(int n, int k) {
		return (long)Math.pow(n, k);
	};

	public static BigInteger wzp(long n, int k) {
		BigInteger res = new BigInteger(String.valueOf(n));
		return res.pow(k);
	};

	public static BigInteger wzp(BigInteger n, int k) {
		return n.pow(k);
	};

	//oblicza liczbe permutacje bez powtorzen
	public static long pbp(int n) {
		return Factorial.factorial(n);
	};

	public static BigInteger pbp(long n) {
		return Factorial.factorial(n);
	};

	public static BigInteger pbp(BigInteger n) {
		ExecutorService es = Executors.newFixedThreadPool(1);
		Future<BigInteger> f = null;
		f = es.submit(new Factorial(n));
		BigInteger np = null;
		try{
			np = f.get();
		} catch (InterruptedException e){
			e.printStackTrace();
		} catch (ExecutionException e){
			e.printStackTrace();
		}
		es.shutdown();
		return np;
	}
	//oblicza liczbe permutacji z powtorzeniami
	//w tablicy liczba powtórzeń każdego z elementów
	// {t,a,t,a} n=4, array={t,a}={2,2}
	//{m,a,t,a},n=4, array={m,a,t}={1,2,1}

	public static long pzp(int n, int[] array) {
		long ilo = 1;
		for(int i = 0; i < array.length; i++){
			ilo = ilo * Factorial.factorial(array[i]);
		}
		return Factorial.factorial(n) / ilo;
	};

	public static BigInteger pzp(long n, long[] array) {
		BigInteger ilo = BigInteger.ONE;
		for(int i = 0; i < array.length; i++){
			ilo = ilo.multiply(Factorial.factorial(array[i]));
		}
		return Factorial.factorial(n).divide(ilo);
	};

	public static BigInteger pzp(BigInteger n, BigInteger[] array) {
		BigInteger ilo = BigInteger.ONE;
		ExecutorService es = Executors.newFixedThreadPool(array.length + 1);
		Future<BigInteger> f = null;
		f = es.submit(new Factorial(n));
		BigInteger res = null;
		try{
			res = f.get();
		} catch (InterruptedException | ExecutionException e1){
			e1.printStackTrace();
		}
		for(int i = 0; i < array.length; i++){
			f = es.submit(new Factorial(array[i]));
			try{
				ilo = ilo.multiply(f.get());
			} catch (InterruptedException | ExecutionException e){
				e.printStackTrace();
			}
		}
		es.shutdown();
		return res.divide(ilo);
	}

	
}
