/*
 * Jeżeli nie podano żadnych parametrow tworzona jest macierz 3x3 wypelniona
 * zerami.
 * Jezeli podano jeden argument to moze to byc tablica dwuwymiarowa albo 
 * macierz klasy Matrix. Dane z nich sa przejmowane do tej macierzy.
 * Jesli sa dwa argumenty:
 * albo podana jest tablica 1-wymiarowa, a jako drugi argument - liczba kolumn
 * albo podae sa m i n oznaczajace kolejno liczbe rzedow i liczbe kolumn
 * w macierzy. Macierz wypelniana jest zerami.
 */
var Matrix = function() {
	switch (arguments.length) {
	case 0:
		this.m = 3;
		this.n = 3;
		this.array = new Array(this.m);
		for ( var i = 0; i < this.m; i++) {
			this.array[i] = new Array(this.n);
		}
		this.setToValue(0);
		break;
	case 1:
		if (arguments[0] instanceof Array) {
			this.array = arguments[0];
			this.m = this.array.length;
			this.n = this.array[0].length;
		} else if (arguments[0] instanceof Matrix) {
			this.array = arguments[0].array;
			this.m = arguments[0].m;
			this.n = arguments[0].n;
		}
		break;
	case 2:
		if (arguments[0] instanceof Array) {
			this.array = oneToTwo(arguments[0], arguments[1]);
			this.m = this.array.length;
			this.n = this.array[0].length;
		}
		if (typeof arguments[0] === "number") {
			this.m = arguments[0];
			this.n = arguments[1];
			this.array = new Array(this.m);
			for ( var i = 0; i < this.m; i++) {
				this.array[i] = new Array(this.n);
			}
			this.setToValue(0);
		}
		break;
	}

};
/*
 * Ustawia wszystkie wartości w macierzy na wartość s. Najczęściej jest to 0.
 */
Matrix.prototype.setToValue = function(s) {
	for ( var i = 0; i < this.m; i++) {
		for ( var j = 0; j < this.n; j++) {
			this.array[i][j] = s;
		}
	}
};
Matrix.prototype.setToIdentity = function() {
	if (this.isSquared()) {
		for ( var i = 0; i < this.m; i++) {
			for ( var j = 0; j < this.n; j++) {
				this.array[i][j] = (i === j ? 1.0 : 0.0);
			}
		}
	}
};

Matrix.prototype.equals = function(matrix) {
	if (!(matrix instanceof Matrix)) {
		return false;
	}
	if ((this.m !== matrix.m) || (this.n !== matrix.n)) {
		return false;
	}

	for ( var i = 0; i < this.m; i++) {
		for ( var j = 0; j < this.n; j++) {
			if (this.array[i][j] !== matrix.array[i][j]) {
				return false;
			}
		}
	}
	return true;
};
Matrix.prototype.toString = function() {
	var st = "";
	for ( var i = 0; i < this.m; i++) {
		for ( var j = 0; j < this.n; j++) {
			st = st + this.array[i][j] + "\n";
		}
	}
	return st;
};
Matrix.prototype.getArray = function() {
	return this.array;
};

Matrix.prototype.setArray = function(array) {
	if (array instanceof Array) {
		this.array = array;
		this.m = this.array.length;
		this.n = this.array[0].length;
	}
};
// kopiuje tablice tej macierzy i zwraca nowa identyczna tablcie
Matrix.prototype.cloneArray = function() {
	var ar = new Array(this.m);
	for ( var k = 0; k < this.m; k++) {
		ar[k] = new Array(this.n);
	}
	for ( var i = 0; i < this.m; i++) {
		for ( var j = 0; j < this.n; j++) {
			ar[i][j] = this.array[i][j];
		}
	}
	return ar;
};

Matrix.prototype.getM = function() {
	return this.m;
};

Matrix.prototype.getN = function() {
	return this.n;
};

Matrix.prototype.getMN = function(m, n) {
	return this.array[m][n];
};

Matrix.prototype.setMN = function(m, n, s) {
	this.array[m][n] = s;
};
Matrix.prototype.isSquared = function() {
	if (this.m === this.n) {
		return true;
	}
	return false;
};

Matrix.prototype.checkSize = function(matrix) {
	if (matrix instanceof Matrix) {
		if (matrix.m !== this.m || matrix.n !== this.n) {
			throw new Error("Nieprawidłowe wymiary.");
		}
	}

};
Matrix.prototype.transpose = function() {
	var temp1 = new Array(this.n);
	for ( var k = 0; k < this.n; k++) {
		temp1[k] = new Array(this.m);
	}
	for ( var i = 0; i < this.m; i++) {
		for ( var j = 0; j < this.n; j++) {
			temp1[j][i] = this.array[i][j];
		}
	}
	this.setArray(temp1);
};

Matrix.prototype.transpose2 = function() {
	var temp = new Matrix(this.n, this.m);
	var temp1 = temp.getArray();
	for ( var i = 0; i < this.m; i++) {
		for ( var j = 0; j < this.n; j++) {
			temp1[j][i] = this.array[i][j];
		}
	}
	return temp;
};
Matrix.prototype.add = function(matrix) {
	this.checkSize(matrix);
	for ( var i = 0; i < this.m; i++) {
		for ( var j = 0; j < this.n; j++) {
			this.array[i][j] += matrix.array[i][j];
		}
	}
};

Matrix.prototype.add2 = function(matrix) {
	this.checkSize(matrix);
	var temp = new Matrix(this.m, this.n);
	var temp1 = temp.getArray();
	for ( var i = 0; i < this.m; i++) {
		for ( var j = 0; j < this.n; j++) {
			temp1[i][j] = this.array[i][j] + matrix.array[i][j];
		}
	}
	return temp;
};

Matrix.prototype.subtract = function(matrix) {
	this.checkSize(matrix);
	for ( var i = 0; i < this.m; i++) {
		for ( var j = 0; j < this.n; j++) {
			this.array[i][j] = this.array[i][j] - matrix.array[i][j];
		}
	}
};

Matrix.prototype.subtract2 = function(matrix) {
	this.checkSize(matrix);
	var temp = new Matrix(this.m, this.n);
	var temp1 = temp.getArray();
	for ( var i = 0; i < this.m; i++) {
		for ( var j = 0; j < this.n; j++) {
			temp1[i][j] = this.array[i][j] - matrix.array[i][j];
		}
	}
	return temp;
};

Matrix.prototype.multiplys = function (s) {
    for (var i = 0; i < this.m; i++) {
        for (var j = 0; j < this.n; j++) {
            this.array[i][j] = s * this.array[i][j];
        }
    }
};

Matrix.prototype.multiplys2 = function(s) {
	var temp = new Matrix(this.m, this.n);
	var temp1 = temp.getArray();
	for ( var i = 0; i < this.m; i++) {
		for ( var j = 0; j < this.n; j++) {
			temp1[i][j] = s * this.array[i][j];
		}
	}
	return temp;
};

Matrix.prototype.multiply = function(matrix) {
	if (matrix.m !== this.n) {
		throw new Error("Nieprawidłowe wymiary macierzy.");
	}
	var temp1 = new Array(this.m);
	for ( var p = 0; p < this.m; p++) {
		temp1[p] = new Array(matrix.n);
	}
	var bc = new Array(this.n);
	for ( var j = 0; j < matrix.n; j++) {
		for ( var k = 0; k < this.n; k++) {
			bc[k] = matrix.array[k][j];
		}
		for ( var i = 0; i < this.m; i++) {
			var ai = this.array[i];
			var s = 0.0;
			for ( var r = 0; r < this.n; r++) {
				s += ai[r] * bc[r];
			}
			temp1[i][j] = s;
		}
	}
	this.array = temp1;
	this.n = matrix.n;
};

Matrix.prototype.multiply2 = function(matrix) {
	if (matrix.m !== this.n) {
		throw new Error("Nieprawidłowe wymiary macierzy");
	}
	var temp = new Matrix(this.m, matrix.n);
	var temp1 = new Array(this.m);
	for ( var p = 0; p < this.m; p++) {
		temp1[p] = new Array(matrix.n);
	}
	var bc = new Array(this.n);
	for ( var j = 0; j < matrix.n; j++) {
		for ( var k = 0; k < this.n; k++) {
			bc[k] = matrix.array[k][j];
		}
		for ( var i = 0; i < this.m; i++) {
			var ai = this.array[i];
			var s = 0.0;
			for ( var r = 0; r < this.n; r++) {
				s += ai[r] * bc[r];
			}
			temp1[i][j] = s;
		}
	}
	temp.array = temp1;
	return temp;
};
var oneToTwo = function(tab, cols) {
	var rows = tab.length / cols;
	var temparr = new Array(rows);
	for ( var k = 0; k < rows; k++) {
		temparr[k] = new Array(cols);
	}
	for ( var i = 0; i < tab.length; i++) {
		var x = cutDecimal(i / cols);
		var y = i % cols;
		temparr[x][y] = tab[i];
	}
	return temparr;
};
var cutDecimal = function(nr) {
	var temp = nr.toString();
	var temp1 = temp.indexOf(".");
	var temp2 = "";
	if (temp1 > -1) {
		temp2 = temp.substr(0, temp1);
	} else {
		temp2 = temp;
	}
	return parseInt(temp2);
};
Matrix.prototype.setToTranslate = function(dx, dy) {
	this.array[0][2] = dx;
	this.array[1][2] = dy;
};
var setToTranslate = function(matrix, dx, dy) {
	matrix.array[0][2] = dx;
	matrix.array[1][2] = dy;
	return matrix;
};
Matrix.prototype.setToScale = function(sx, sy) {
	this.array[0][0] = sx;
	this.array[1][1] = sy;
};
var setToScale = function(matrix, sx, sy) {
	matrix.array[0][0] = sx;
	matrix.array[1][1] = sy;
	return matrix;
};
Matrix.prototype.setToRotation = function(angleDeg) {
	var angleRad = degToRad(angleDeg);
	var t1 = Math.cos(angleRad);
	var t2 = Math.sin(angleRad);
	this.array[0][0] = t1;
	this.array[0][1] = t2;
	this.array[1][0] = -t2;
	this.array[1][1] = t1;
};
var setToRotation = function(matrix, angleDeg) {
	var angleRad = degToRad(angleDeg);
	var t1 = Math.cos(angleRad);
	var t2 = Math.sin(angleRad);
	matrix.array[0][0] = t1;
	matrix.array[0][1] = t2;
	matrix.array[1][0] = -t2;
	matrix.array[1][1] = t1;
	return matrix;
};
// oblicza wyznacznik tej macierzy
Matrix.prototype.detSarrus = function() {
	var a = this.array[0][0];
	var b = this.array[0][1];
	var e = this.array[0][2];
	var c = this.array[1][0];
	var d = this.array[1][1];
	var f = this.array[1][2];
	var g = this.array[2][0];
	var h = this.array[2][1];
	var i = this.array[2][2];
	return ((a * d * i + b * f * g + e * c * h) - (e * d * g + a * f * h + b
			* c * i));
};
// oblicza wyznacznik podanej macierzy
var detSarrus = function(matrix) {
	var sarrus = 0.0;
	switch (matrix.m) {
	case 1:
		sarrus = matrix.array[0][0];
		break;
	case 2:
		sarrus = matrix.array[0][0] * matrix.array[1][1] - matrix.array[0][1]
				* matrix.array[1][0];
		break;
	case 3:
		var a = matrix.array[0][0];
		var b = matrix.array[0][1];
		var e = matrix.array[0][2];
		var c = matrix.array[1][0];
		var d = matrix.array[1][1];
		var f = matrix.array[1][2];
		var g = matrix.array[2][0];
		var h = matrix.array[2][1];
		var i = matrix.array[2][2];
		sarrus = ((a * d * i + b * f * g + e * c * h) - (e * d * g + a * f * h + b
				* c * i));
		break;

	}
	return sarrus;
};
// Oblicza podmacierz macierzy. row i col
// zaczynaja sie od 1
var submatrix = function(matrix, row, col) {
	var i1 = row - 1;
	var i2 = col - 1;
	var ar = matrix.cloneArray();
	ar = shortenArray(ar, i1);
	for ( var i = 0; i < ar.length; i++) {
		ar[i] = shortenArray(ar[i], i2);
	}
	var mat = new Matrix(ar);
	return mat;
};
// row, col zaczynaja sie od 1
var minor = function(matrix, row, col) {
	var sub = submatrix(matrix, row, col);
	return detSarrus(sub);
};
// skraca tablice pojedyncza wycinajac z niej podany element
var shortenArray = function(array, index) {
	for ( var i = index + 1; i < array.length; i++) {
		array[i - 1] = array[i];
	}
	array.pop();
	return array;
};
// row, col zaczynaja sie od 1
var algComplement = function(matrix, row, col) {
	return ac = minor(matrix, row, col) * Math.pow(-1, row + col);
};
// klonuje pojedyncza tablice
var cloneArray = function(array) {
	var b = new Array();
	return b.concat(array);
};
function cosDeg(angleDeg) {
	return Math.cos(angleDeg * Math.PI / 180);
};
function sinDeg(angleDeg) {
	return Math.sin(angleDeg * Math.PI / 180);
}
Matrix.prototype.setToReflection = function(line) {
	var slope = line.slope();
	var angle = atanDeg(slope);
	var dangle = 2 * angle;
	var cosa = cosDeg(dangle);
	var sina = sinDeg(dangle);
	this.array[0][0] = cosa;
	this.array[0][1] = sina;
	this.array[1][0] = sina;
	this.array[1][1] = -cosa;
};
var setToReflection = function(matrix, line) {
	var slope = line.slope();
	var angle = atanDeg(slope);
	var dangle = 2 * angle;
	var cosa = cosDeg(dangle);
	var sina = sinDeg(dangle);
	matrix.array[0][0] = cosa;
	matrix.array[0][1] = sina;
	matrix.array[1][0] = sina;
	matrix.array[1][1] = -cosa;
	return matrix;
};
Matrix.prototype.setToShear = function(shx, shy) {
	this.array[0][1] = shx;
	this.array[1][0] = shy;
};
var setToShear = function(matrix, shx, shy) {
	matrix.array[0][1] = shx;
	matrix.array[1][0] = shy;
	return matrix;
};
Matrix.prototype.reverse = function() {
	var matrixac = new Matrix(3, 3);
	for ( var i = 0; i < 3; i++) {
		for ( var j = 0; j < 3; j++) {
			ac = algComplement(this, i + 1, j + 1);
			matrixac.setMN(i, j, ac);
		}
	}
	var matrix1 = matrixac.transpose2();
	var det = this.detSarrus();
	var matrixt = matrix1.multiplys2(1.0 / det);
	return matrixt;
};