var cv = document.getElementById('canvas');
var ctx = cv.getContext('2d');
var width = cv.width;
var height = cv.height;
var Ax = function(sx, sy, sw, sh, rx, ry, rw, rh,  rxunit, ryunit, offset) {
	this.rx = rx;
	this.ry = ry;
	this.rw = rw;
	this.rh = rh;
	this.sx = sx;
	this.sy = sy;
	this.sw = sw;
	this.sh = sh;
	this.rxunit = rxunit;
	this.ryunit = ryunit;
	this.offset = offset;
	this.rzut = new Rzutowanie(sx, sy, sw, sh, rx, ry, rw, rh);
	this.maxrx = rx + rw;
	if (rx >= 0) {
		this.sx0 = sx;
		this.rx0 = rx;
	} else if (rx < 0 && this.maxrx < 0) {
		this.sx0 = sx + sw;
		this.rx0 = rx + rw;
	} else if (rx < 0 && this.maxrx >= 0) {
		this.rx0 = 0;
		this.sx0 = sw * Math.abs(rx / rw);
	}
	this.maxry = ry + rh;
	if (ry >= 0) {
		this.sy0 = sy;
		this.ry0 = ry;
	} else if (ry < 0 && this.maxry < 0) {
		this.sy0 = sh + sy;
		this.ry0 = ry + rh;
	} else if (ry < 0 && this.maxry >= 0) {
		this.ry0 = 0;
		this.sy0 = sh * Math.abs(ry / rh);
	}
	var size1 = Math.round(12 + (sw / 200.0));
	this.titleFont = "bold " + size1.toString() + "px " + "Dialog";
	var size2 = Math.round(10 + (sw / 200.0));
	this.axFont = size2.toString() + "px " + "Dialog";
};
Ax.prototype.drawGrid = function(color) {
	var actColor = ctx.strokeStyle;
	ctx.strokeStyle = color;
	this.drawVertLines();
	this.drawHorizLines();
	ctx.strokeStyle = actColor;
};
Ax.prototype.line = function(x1, y1, x2, y2) {
	ctx.beginPath();
	ctx.moveTo(x1, y1);
	ctx.lineTo(x2, y2);
	ctx.stroke();
};
Ax.prototype.fillCircle = function(x, y, w, h) {
	ctx.beginPath();
	ctx.arc(x + w / 2, y + h / 2, w / 2, 0, 2 * Math.PI, false);
	ctx.fill();
};
Ax.prototype.drawCircle = function(x, y, w, h) {
	ctx.beginPath();
	ctx.arc(x + w / 2, y + h / 2, w / 2, 0, 2 * Math.PI, false);
	ctx.stroke();
};
Ax.prototype.drawHorizLines = function() {
	if (this.sy0 === this.sy) {
		for (var i = this.ry; i <= this.ry + this.rh; i += this.ryunit) {
			var y = this.rzut.getSY(round(i, this.ryunit));
			this.line(this.offset + this.sx, y + this.offset, this.sx + this.sw + this.offset, y + this.offset);
		}
	} else if (this.sy0 === this.sy + this.sh) {
		for (var i = this.ry; i <= this.ry + this.rh; i += this.ryunit) {
			var y = this.rzut.getSY(round(i, this.ryunit));
			this.line(this.sx + this.offset, y + this.offset, this.sx + this.offset + this.sw, y + this.offset);
		}
	} else {
		for (var i = this.ry; i <= this.ry + this.rh; i += this.ryunit) {
			var y = this.rzut.getSY(round(i, this.ryunit));
			this.line(this.sx + this.offset, y + this.offset, this.sx + this.offset + this.sw, y + this.offset);
		}
	}
};
Ax.prototype.drawVertLines = function() {
	if (this.sy0 === this.sy) {
		for (var i = this.rx; i <= this.rx + this.rw; i += this.rxunit) {
			var x = this.rzut.getSX(round(i, this.rxunit));
			this
					.line(x + this.offset, 0 + this.offset + this.sy, x + this.offset, this.sh + this.offset
							+ this.sy);
		}
	} else if (this.sy0 === this.sy + this.sh) {
		for (var i = this.rx; i <= this.rx + this.rw; i += this.rxunit) {
			var x = this.rzut.getSX(round(i, this.rxunit));
			this
					.line(x + this.offset, 0 + this.offset + this.sy, x + this.offset, this.sh + this.offset
							+ this. sy);
		}
	} else {
		for (var i = this.rx; i <= this.rx + this.rw; i += this.rxunit) {
			var x = this.rzut.getSX(round(i, this.rxunit));
			this
					.line(x + this.offset, 0 + this.offset + this.sy, x + this.offset, this.sh + this.offset
							+ this.sy);
		}
	}
};
Ax.prototype.fillPoint = function(rx, ry, diam, pshape, kolor) {
	var xe = this.rzut.getSX(rx);
	var ye = this.rzut.getSY(ry);
	var r = diam / 2.0;
	var acolor = ctx.fillStyle;
	ctx.fillStyle = kolor;
	switch (pshape) {
	case "Circle":
		this.fillCircle(xe - r + this.offset, this.sh - ye - r + this.offset + 2 * this.sy, diam,
				diam);
		break;
	case "Square":
		ctx.beginPath();
		ctx.rect(xe - r + this.offset, this.sh - ye - r + this.offset + 2 * this.sy, diam, diam);
		ctx.fill();
		break;
	case "Cross":
		this.line(xe - r + this.offset, this.sh - ye + this.offset + 2 * this.sy, xe + r + this.offset,
				this.sh - ye + this.offset + 2 * this.sy);
		this.line(xe + this.offset, this.sh - ye - r + this.offset + 2 * this.sy, xe + this.offset, this.sh
				- ye + r + this.offset + 2 * this.sy);
		break;
	}
	ctx.fillStyle = acolor;
};
Ax.prototype.drawPoint = function(rx, ry, diam, pshape, kolor){
	var xe = this.rzut.getSX(rx);
	var ye = this.rzut.getSY(ry);
	var r = diam / 2.0;
	var acolor = ctx.strokeStyle;
	ctx.strokeStyle = kolor;
	switch (pshape) {
	case "Circle":
		this.drawCircle(xe - r + this.offset, this.sh - ye - r + this.offset + 2 * this.sy, diam,
				diam);
		break;
	case "Square":
		ctx.beginPath();
		ctx.rect(xe - r + this.offset, this.sh - ye - r + this.offset + 2 * this.sy, diam, diam);
		ctx.stroke();
		break;
	case "Cross":
		this.line(xe - r + this.offset, this.sh - ye + this.offset + 2 * this.sy, xe + r + this.offset,
				this.sh - ye + this.offset + 2 * this.sy);
		this.line(xe + this.offset, this.sh - ye - r + this.offset + 2 * this.sy, xe + this.offset, this.sh
				- ye + r + this.offset + 2 * this.sy);
		ctx.stroke();
		break;
	}
	ctx.strokeStyle = acolor;
};
Ax.prototype.drawLine = function(rx1, ry1, rx2, ry2, color) {
	var actColor = ctx.strokeStyle;
	ctx.strokeStyle = color;
	this.line(this.rzut.getSX(rx1) + this.sx + this.offset,
			this.sh - this.rzut.getSY(ry1) + this.sy + this.offset, this.rzut.getSX(rx2) + this.sx + this.offset,
			this.sh - this.rzut.getSY(ry2) + this.sy + this.offset);
	ctx.strokeStyle = actColor;
};
Ax.prototype.drawString = function(napis, realx, realy) {
	ctx.fillText(napis, this.rzut.getSX(realx) + this.offset, this.sh - this.rzut.getSY(realy)
			+ this.offset + 2 * this.sy);	


};
Ax.prototype.drawXLegend = function(h) {
	var actFont = ctx.font;
	ctx.font = this.axFont;
	var w = 0;
	var y = 0;
	if(this.ry >= 0){
		y = this.sh + this.sy0 + this.offset;
		for(var i = this.rx; i <= this.rx + this.rw; i += this.rxunit){
			var str = round(i, this.rxunit).toString();				
			var metr = ctx.measureText(str);		
			w = metr.width;			
			var x = this.rzut.getSX(round(i, this.rxunit)) - w / 2.0;
			ctx.fillText(str, x+ this.offset, y + 0.75 * h);
		}
	}
	else if(this.ry < 0 && this.maxry < 0){
		y = this.sy + this.offset;
		for(var i = this.rx; i <= this.rx + this.rw; i += this.rxunit){
			var str = round(i, this.rxunit).toString();			
			var metr = ctx.measureText(str);
			w = metr.width;
			var x = this.rzut.getSX(round(i, this.rxunit)) - w / 2.0;
			ctx.fillText(str, x + this.offset, y - 0.2 * h);
		}
	}
	else if(this.ry < 0 && this.maxry > 0){
		y = this.sh - this.sy0 + this.offset + this.sy;
		if(this.sh / 2.0 < this.sy0){
			for(var i = this.rx; i <= this.rx + this.rw; i += this.rxunit){
				var str = round(i, this.rxunit).toString();			
				var metr = ctx.measureText(str);
				w = metr.width;
				var x = this.rzut.getSX(round(i, this.rxunit)) - w / 2.0;
				ctx.fillText(str, x + this.offset, y - 0.2 * h);
			}
		}
		else{
			for(var i = this.rx; i <= this.rx + this.rw; i += this.rxunit){
				var str = round(i, this.rxunit).toString();
				var metr = ctx.measureText(str);
				w = metr.width;
				var x = this.rzut.getSX(round(i, this.rxunit)) - w / 2.0;
				ctx.fillText(str, x + this.offset, y + 0.75 * h);
			}
		}
	}
	ctx.font = actFont;
};
Ax.prototype.drawYLegend = function (h) {
	var actFont = ctx.font;
	ctx.font = this.axFont;
	var w = 0;
	var y = 0;
	if(this.ry >= 0){
		for(var i = this.ry; i <= this.ry + this.rh; i += this.ryunit){
			var str = round(i, this.ryunit).toString();	
			var metr = ctx.measureText(str);
			w = metr.width;			
			y = this.sh - this.rzut.getSY(round(i, this.ryunit)) + 0.25 * h;
			ctx.fillText(str, this.sx + this.offset - w, y + this.offset + 2 * this.sy);
		}
	}
	else if(this.ry < 0 && this.maxry < 0){
		for(var i = this.ry; i <= this.ry + this.rh; i += this.ryunit){
			var str = round(i, this.ryunit).toString();
			var metr = ctx.measureText(str);
			w = metr.width;			
			y = this.sh - this.rzut.getSY(round(i, this.ryunit)) + this.offset + 2 * this.sy + 0.25
					* h;
			ctx.fillText(str, this.sx + this.sw + this.offset + 0.3 * w, y);
		}
	}
	else if(this.ry < 0 && this.maxry > 0){
		if(this.sh / 2.0 < this.sy0){
			for(var i = this.ry; i <= this.ry + this.rh; i += this.ryunit){
				var str = round(i, this.ryunit).toString();
				var metr = ctx.measureText(str);
				w = metr.width;				
				y = this.sh - this.rzut.getSY(round(i, this.ryunit)) + this.offset + 2 * this.sy
						+ 0.25 * h;
				ctx.fillText(str, this.sx + this.sx0 + this.offset + 0.3 * w, y);
			}
		}
		else{
			for(var i = this.ry; i <= this.ry + this.rh; i += this.ryunit){
				var str = round(i, this.ryunit).toString();
				var metr = ctx.measureText(str);
				w = metr.width;				
				y = this.sh - this.rzut.getSY(round(i, this.ryunit)) + 0.25 * h + this.sy;
				ctx.fillText(str, this.sx0 + this.sx + +this.offset - w, y + this.offset + this.sy);
			}
		}
	}
	ctx.font = actFont;
};
Ax.prototype.drawTitle = function(tytul, h) {
	var actFont = ctx.font;
	ctx.font = this.titleFont;	
	var w = ctx.measureText(tytul).width;
	var x = this.sx + (this.sw - w) / 2;	
	var y = this.sy + h;
	ctx.fillText(tytul, x + this.offset, y + this.offset - 1.7 * h);
	ctx.font = actFont;
};
function roundToDecimal(num, dec) {
	var multi = Math.round(Math.pow(10, dec));
	var temp = Math.round(num * multi);
	var temp1 = temp * 1.0 / multi;
	return temp1;
};
// zwraca liczbę znaków po przecinku
function getFractLen(num) {
	var temp = num.toString();
	var temp2 = temp.substring(temp.indexOf(".", 0) + 1);
	return temp2.length;
};
function round(value, comp) {
	var dec = getFractLen(comp);
	return roundToDecimal(value, dec);
};