// Przeliczanie kąta w stopniach na kąt w radianach
var degToRad = function(deg) {
	return Math.PI * deg / 180.0;
};
// Przeliczanie kąta w radianach na kąt w stopniach
var radToDeg = function(rad) {
	return rad * 180.0 / Math.PI;
};
// sinus dla wartości w stopniach
var sinDeg = function(angleDeg) {
	return Math.sin(angleDeg * Math.PI / 180);

};
// cosinus dla wartości w stopniach
var cosDeg = function(angleDeg) {
	return Math.cos(angleDeg * Math.PI / 180);

};
// tangens dla wartości w stopniach
var tanDeg = function(angleDeg) {
	return Math.tan(angleDeg * Math.PI / 180);
};
// arcus tangens dla wartości w stopniach
var atanDeg = function(ratio) {
	return Math.atan(ratio) * 180 / Math.PI;
};
// arcus tangens dla wartości w stopniach
/*
 * zwraca kat w stopniach, a nie w radianach, dla podanego ratio = y/x, gdzie y
 * i x są długościami odpowiednich boków, albo współrzędnymi punktu. Mierzymy
 * kąt miedzy linią A przebiegającą przez punkt (x, y) i punkt (0, 0) oraz osią
 * x (B). Jezeli linia A nie przebiega przez srodek układu współrzędnych, a
 * przez punkty (x1, y1) i (x2, y2) to jako argumenty poniższej funkcji
 * przyjmujemy (y2 - y1, x2 - x1) i otrzymujemy kąt między linią przebiegającą
 * przez te punkty, a osią x
 */
var atan2Deg = function(yy, xx) {
	return Math.atan2(yy, xx) * 180 / Math.PI;
};
// arcus sinus dla wartości w stopniach
var asinDeg = function(ratio) {
	return Math.asin(ratio) * 180 / Math.PI;
};
// arcus cosinus dla wartości w stopniach
var acosDeg = function(ratio) {
	return Math.acos(ratio) * 180 / Math.PI;
};
// tangens hiperboliczny dla wartości w radianach
var tanh = function(u) {
	var a = Math.exp(u);
	var b = Math.exp(-u);
	var c = (a - b) / (a + b);
	return c;
};