var kolor = function(rgba1, rgba2, rule) {
	var adst = rgba1.split(",");
	var asrc = rgba2.split(",");
	var src = parseFloat(asrc[3]);
	var dst = parseFloat(adst[3]);
	var fs = 0;
	var fd = 0;
	switch (rule) {
	case "copy":
		fs = 0;
		fd = 1.0;
		break;
	case "destination-atop":
		fs = 1.0 - dst;
		fd = src;
		break;
	case "destination-in":
		fs = 0;
		fd = src;
		break;
	case "destination-out":
		fs = 0;
		fd = 1.0 - src;
		break;
	case "destination-over":
		fs = 1.0 - dst;
		fd = 1.0;
		break;
	case "lighter":
		fs = 1.0;
		fd = 0;
		break;
	case "source-atop":
		fs = dst;
		fd = 1.0 - src;
		break;
	case "source-in":
		fs = dst;
		fd = 0;
		break;
	case "source-out":
		fs = 1.0 - dst;
		fd = 0;
		break;
	case "source-over":
		fs = 1.0;
		fd = 1.0 - src;
		break;
	case "xor":
		fs = 1.0 - dst;
		fd = 1.0 - src;
		break;
	}
	var a = fs * src + fd * dst;
	var r = fs * parseInt(asrc[0].substring(5)) * src + fd
			* parseInt(adst[0].substring(5)) * dst;
	var g = fs * parseInt(asrc[1]) * src + fd * parseInt(adst[1]) * dst;
	var b = fs * parseInt(asrc[2]) * src + fd * parseInt(adst[2]) * dst;
	return "rgba(" + Math.round(r) + "," + Math.round(g) + "," + Math.round(b)
			+ "," + a + ")";

};