var factorial = function (n) {
    if (n > 18) {
        throw new Error("zbyt duża liczba");
    }
    if (n === 0) {
        return 1;
    }
    var sum = 1;
    for (var i = 1; i < n + 1; i++) {
        sum *= i;
    }
    return sum;
};
// oblicza liczbę kombinacji bez powtórzeń
var npok = function (n, k) {
    if (k > n) {
        return 0;
    } else if (k === 0 || k === n) {
        return 1;
    } else if (k === 1 || k === (n - 1)) {
        return n;
    } else {
        var b = factorial(k);
        var c = factorial(n - k);
        var a = b;
        for (var i = k + 1; i < n + 1; i++) {
            a *= i;
        }
        return a / (b * c);
    }
};
// oblicza liczbę kombinacji bez powtórzeń
var cbp = function(n, k){
    return npok(n,k);
};
// Oblicza liczbę kombinacji z powtórzeniami
var czp = function (n, k) {
    return (npok(n + k - 1, k));
};
// oblicza liczbę wariacji bez powtórzeń
var wbp = function (n, k) {
    var b = factorial(n);
    var c = factorial(n - k);
    return b / c;
};
// oblicza liczbę wariacji z powtórzeniami
var wzp = function (n, k) {
    return Math.pow(n, k);
};
// oblicza liczbę permutacji bez powtórzeń
var pbp = function (n) {
    return factorial(n);
};
// oblicza liczbę permutacji z powtórzeniami
// w tablicy liczba powtórzeń każdego z elementów
// {t,a,t,a} n=4, array={t,a}={2,2}
// {m,a,t,a},n=4, array={m,a,t}={1,2,1}
// kolejność elementów w tablicy jest nieistotna
var pzp = function (n, array) {
    var ilo = 1;
    for (var i = 0; i < array.length; i++) {
        ilo = ilo * factorial(array[i]);
    }
    return factorial(n) / ilo;
};
// oblicza liczbę Stirlinga II rodzaju (dla podzbiorów)
// czyli k podzbiorów n
var stir2 = function (k, n) {
    if (n === 0 && k === 0) {
        return 1;
    } else if (n === 0 && k === 1) {
        return 0;
    } else if (n > 0) {
        if (k === 0) {
            return 0;
        } else if (k === 1) {
            return 1;
        } else if (n < k) {
            return 0;
        } else if (n === k) {
            return 1;
        } else {
            return stir2(k - 1, n - 1) + k * stir2(k, n - 1);
        }
    }
};
// Kule rozróżnialne
// urny rozróżnialne
// urna może być pusta
// n liczba kul, k - liczba urn
// przykład: r1
var r111 = function (n, k) {
    return Math.pow(k, n);
};
// Kule rozrożnialne
// urny nierozróżnialne
// urna może byc pusta
// n - liczba kul, k - liczba urn
// przyklad: r2
var r101 = function (n, k) {
    var sum = 0;
    for (var i = 1; i < k + 1; i++) {
        sum += stir2(i, n);
    }
    return sum;
};
// Kule rozróżnialne
// urny rozróżnialne
// urna nie może być pusta
// n - liczba kul, k - liczba urn
// przykład: r3
var r110 = function (n, k) {
    var t = factorial(k);
    var stir = stir2(k, n);
    return t * stir;
};
// Kule rozróżnialne
// urny nierozróżnialne
// urna nie może być pusta
// n - liczba kul, k - liczba urn
// przykład: r4
var r100 = function (n, k) {
    return stir2(k, n);
};
// Kule nieroróżnialne
// urny rozróżnialne
// urna może być pusta
// n - liczba kul, k - liczba urn
// przykład: r5
var r011 = function (n, k) {
    return npok(n + k - 1, n);
};
// Kule nierozróżnialne
// urny rozróżnialne
// urna nie może być pusta
// n - liczba kul, k - liczba urn
// przykład: r6
var r010 = function (n, k) {
    return npok(n - 1, k - 1);
};
// Kule nierozróżnialne
// urny nierozróżnialne
// urna nie może być pusta
// n - liczba kul, k - liczba urn
// przykład: r7
var r000 = function (k, n) {
    if (n === 0 || k === 0) {
        return 0;
    } else if (n > 0) {
        if (k === 1) {
            return 1;
        } else if (n < k) {
            return 0;
        } else if (n === k) {
            return 1;
        } else {
            return r000(k - 1, n - 1) + r000(k, n - k);
        }
    }
};
// Kule nierozróżnialne
// urny nierozróżnialne
// urna może być pusta
// n - liczba kul, k - liczba urn
// przykład: r8
// zwróć uwagę, ze pierwszym argumentem jest k
var r001 = function (k, n) {
    var sum = 0;
    for (var i = 1; i < k + 1; i++) {
        sum += r000(i, n);
    }
    return sum;
};
var inversion = function (n) {
    var t1 = factorial(n);
    var sum = 0;
    for (var i = 0; i < n + 1; i++) {
        sum += Math.pow(-1, i) / factorial(i);
    }
    return t1 * sum;
};

var catalan = function (n) {
    return npok(2 * n, n) / (n + 1);
};
var bell = function (n) {
    var sum = 0;
    for (var i = 0; i < n + 1; i++) {
        sum += stir2(i, n);
    }
    return sum;
};
