var cv = document.getElementById('canvas');
var ctx = cv.getContext('2d');
var width = cv.width;
var height = cv.height;
var factorial = function(n) {
	if (n > 20) {
		throw new Error("zbyt duża liczba");
	}
	if (n === 0) {
		return 1;
	}
	var sum = 1;
	for ( var i = 1; i < n + 1; i++) {
		sum *= i;
	}
	return sum;
};
var npok = function(n, k) {
	if (k > n) {
		return 0;
	} else if (k === 0 || k === n) {
		return 1;
	} else if (k === 1 || k === (n - 1)) {
		return n;
	} else {
		var b = factorial(k);
		var c = factorial(n - k);
		var a = b;
		for ( var i = k + 1; i < n + 1; i++) {
			a *= i;
		}
		return a / (b * c);
	}
};
var index = function(row, col, cols) {
	return row * cols + col;
};
var cutDecimal = function(nr) {
	var temp = nr.toString();
	var temp1 = temp.indexOf(".");
	var temp2 = "";
	if (temp1 > -1) {
		temp2 = temp.substr(0, temp1);
	} else {
		temp2 = temp;
	}
	return parseInt(temp2);
};
var bernsteinTValue = function(n, k, t) {
	var btv = npok(n, k) * Math.pow(t, k) * Math.pow(1.0 - t, n - k);
	if (btv < 0) {
		btv = 0;
	}
	return btv;
};
var bernstein = function(n, k, liczbaPunktow) {
	var t;
	var b;
	var img1 = ctx.getImageData(0, 0, width, height);
	var idata = img1.data;
	var a = npok(n, k);
	for ( var i = 0; i < liczbaPunktow; i++) {
		t = i * 1.0 / liczbaPunktow;
		b = a * Math.pow(t, k) * Math.pow(1.0 - t, n - k);
		if (b <= 0) {
			b = 0;
		}
		var j = 4 * index(cutDecimal(height - b * liczbaPunktow), cutDecimal(t
				* liczbaPunktow), width);
		idata[j] = 0;
		idata[j + 1] = 0;
		idata[j + 2] = 255;
		idata[j + 3] = 255;
	}
	ctx.putImageData(img1, 0, 0);
};
var Point = function(x, y) {
	this.x = x;
	this.y = y;
};
Point.prototype.toString = function() {
	return "[" + this.x + ", " + this.y + "]";
};
var qBezierValue1 = function(points, t) {
	var ax = points[0].x;
	var ay = points[0].y;
	var bx = points[1].x;
	var by = points[1].y;
	var cx = points[2].x;
	var cy = points[2].y;
	var x1 = ax - 2 * bx + cx;
	var x2 = -2 * ax + 2 * bx;
	var y1 = ay - 2 * by + cy;
	var y2 = -2 * ay + 2 * by;
	var pt = t * t;
	var x = pt * x1 + t * x2 + ax;
	var y = pt * y1 + t * y2 + ay;
	return new Point(x, y);
};
var qBezierValue2 = function(points, t) {
	var ax = points[0].x;
	var ay = points[0].y;
	var bx = points[1].x;
	var by = points[1].y;
	var cx = points[2].x;
	var cy = points[2].y;
	var vx = [ ax, bx, cx ];
	var vy = [ ay, by, cy ];
	var coeffs = [ 1, -2, 1, -2, 2, 0, 1, 0, 0 ];
	var ts = [ Math.pow(t, 2), t, 1 ];
	var mvx = new Matrix(vx, 1);
	var mvy = new Matrix(vy, 1);
	var mcoeffs = new Matrix(coeffs, 3);
	var mts = new Matrix(ts, 3);
	var x = (mts.multiply2(mcoeffs.multiply2(mvx))).getMN(0, 0);
	var y = (mts.multiply2(mcoeffs).multiply2(mvy)).getMN(0, 0);
	return new Point(x, y);
};
var qBezierValue3 = function(points, t) {
	var ax = points[0].x;
	var ay = points[0].y;
	var bx = points[1].x;
	var by = points[1].y;
	var cx = points[2].x;
	var cy = points[2].y;
	var pt1 = 1.0 - t;
	var pt2 = 2 * t * pt1;
	var pt3 = pt1 * pt1;
	var pt4 = t * t;
	var x = pt3 * ax + pt2 * bx + pt4 * cx;
	var y = pt3 * ay + pt2 * by + pt4 * cy;
	return new Point(x, y);
};
var cBezierValue1 = function(points, t) {
	var ax = points[0].x;
	var ay = points[0].y;
	var bx = points[1].x;
	var by = points[1].y;
	var cx = points[2].x;
	var cy = points[2].y;
	var dx = points[3].x;
	var dy = points[3].y;
	var x1 = -ax + 3 * bx - 3 * cx + dx;
	var y1 = -ay + 3 * by - 3 * cy + dy;
	var x2 = 3 * ax - 6 * bx + 3 * cx;
	var y2 = 3 * ay - 6 * by + 3 * cy;
	var x3 = -3 * ax + 3 * bx;
	var y3 = -3 * ay + 3 * by;
	var pt2 = t * t;
	var pt3 = pt2 * t;
	var x = pt3 * x1 + pt2 * x2 + t * x3 + ax;
	var y = pt3 * y1 + pt2 * y2 + t * y3 + ay;
	return new Point(x, y);
};
var cBezierValue2 = function(points, t) {
	var ax = points[0].x;
	var ay = points[0].y;
	var bx = points[1].x;
	var by = points[1].y;
	var cx = points[2].x;
	var cy = points[2].y;
	var dx = points[3].x;
	var dy = points[3].y;
	var vx = [ ax, bx, cx, dx ];
	var vy = [ ay, by, cy, dy ];
	var coeffs = [ -1, 3, -3, 1, 3, -6, 3, 0, -3, 3, 0, 0, 1, 0, 0, 0 ];
	var ts = [ Math.pow(t, 3), Math.pow(t, 2), t, 1 ];
	var mvx = new Matrix(vx, 1);
	var mvy = new Matrix(vy, 1);
	var mcoeffs = new Matrix(coeffs, 4);
	var mts = new Matrix(ts, 4);
	var x = (mts.multiply2(mcoeffs.multiply2(mvx))).getMN(0, 0);
	var y = (mts.multiply2(mcoeffs).multiply2(mvy)).getMN(0, 0);
	return new Point(x, y);
};
var cBezierValue3 = function(points, t) {
	var ax = points[0].x;
	var ay = points[0].y;
	var bx = points[1].x;
	var by = points[1].y;
	var cx = points[2].x;
	var cy = points[2].y;
	var dx = points[3].x;
	var dy = points[3].y;
	var pt1 = 1.0 - t;
	var pt2 = pt1 * pt1;
	var pt3 = pt2 * pt1;
	var t2 = t * t;
	var t3 = t2 * t;
	var x = pt3 * ax + 3 * t * pt2 * bx + 3 * t2 * pt1 * cx + t3 * dx;
	var y = pt3 * ay + 3 * t * pt2 * by + 3 * t2 * pt1 * cy + t3 * dy;
	return new Point(x, y);
};
var drawQBezier = function(points, strokeStyle, visible) {
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = strokeStyle;
	ctx.moveTo(points[0].x, points[0].y);
	ctx.quadraticCurveTo(points[1].x, points[1].y, points[2].x, points[2].y);
	ctx.stroke();
	ctx.restore();
	if (visible) {
		drawPoints(points, strokeStyle);
	}
};
var drawCBezier = function(points, strokeStyle, visible) {
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = strokeStyle;
	ctx.moveTo(points[0].x, points[0].y);
	ctx.bezierCurveTo(points[1].x, points[1].y, points[2].x, points[2].y,
			points[3].x, points[3].y);
	ctx.stroke();
	ctx.restore();
	if (visible) {
		drawPoints(points, strokeStyle);
	}
};
var drawPoints = function(points, style) {
	ctx.save();
	ctx.beginPath();
	ctx.fillStyle = style;
	for ( var i = 0; i < points.length; i++) {
                ctx.beginPath();
		ctx.arc(points[i].x, points[i].y, 3, 0, 2 * Math.PI, true);
                ctx.fill();
	}	
	ctx.restore();
};
// -

var tValue = function(points) {
	var maxx = -1000000;
	var maxy = -1000000;
	var minx = 1000000;
	var miny = 1000000;
	for ( var i = 0; i < points.length; i++) {
		var val = points[i];
		maxx = Math.max(val.x, maxx);
		maxy = Math.max(val.y, maxy);
		minx = Math.min(val.x, minx);
		miny = Math.min(val.y, miny);
	}
	return Math.max(Math.abs(maxx) - Math.abs(minx), Math.abs(maxy)
			- Math.abs(miny));
};
var drawMyQBezier1 = function(points, style, visible) {
	var x1 = points[0].x - 2 * points[1].x + points[2].x;
	var x2 = -2 * points[0].x + 2 * points[1].x;
	var y1 = points[0].y - 2 * points[1].y + points[2].y;
	var y2 = -2 * points[0].y + 2 * points[1].y;
	var extr = tValue(points);
	var te = 1.0 / extr;
	var img1 = ctx.getImageData(0, 0, width, height);
	var idata = img1.data;
	var t = 0;
	for ( var i = 0; i < extr; i++) {
		t = i * te;
		var pt = t * t;
		var ptx = pt * x1;
		var pty = pt * y1;
		var x = ptx + t * x2 + points[0].x;
		var y = pty + t * y2 + points[0].y;
		var j = 4 * index(cutDecimal(y), cutDecimal(x), width);
		idata[j] = 0;
		idata[j + 1] = 0;
		idata[j + 2] = 255;
		idata[j + 3] = 255;
	}
	ctx.putImageData(img1, 0, 0);
	if (visible) {
		drawPoints(points, style);
	}
};
var drawMyQBezier2 = function(points, style, visible) {
	var x1 = points[0].x - 2 * points[1].x + points[2].x;
	var x2 = -2 * points[0].x + 2 * points[1].x;
	var y1 = points[0].y - 2 * points[1].y + points[2].y;
	var y2 = -2 * points[0].y + 2 * points[1].y;
	var extr = tValue(points);
	var te = 1.0 / extr;
	var t = 0;
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = style;
	ctx.moveTo(points[0].x, points[0].y);
	for ( var i = 0; i < extr; i++) {
		t = i * te;
		var pt = t * t;
		var ptx = pt * x1;
		var pty = pt * y1;
		var x = ptx + t * x2 + points[0].x;
		var y = pty + t * y2 + points[0].y;
		ctx.lineTo(x, y);
	}
	ctx.stroke();
	ctx.restore();
	if (visible) {
		drawPoints(points, style);
	}
};
var drawMyCBezier1 = function(points, style, visible) {
	var x1 = -points[0].x + 3 * points[1].x - 3 * points[2].x + points[3].x;
	var y1 = -points[0].y + 3 * points[1].y - 3 * points[2].y + points[3].y;
	var x2 = 3 * points[0].x - 6 * points[1].x + 3 * points[2].x;
	var y2 = 3 * points[0].y - 6 * points[1].y + 3 * points[2].y;
	var x3 = -3 * points[0].x + 3 * points[1].x;
	var y3 = -3 * points[0].y + 3 * points[1].y;
	var extr = tValue(points);
	var te = 1.0 / extr;
	var img1 = ctx.getImageData(0, 0, width, height);
	var idata = img1.data;
	var t = 0;
	for ( var i = 0; i < extr; i++) {
		t = i * te;
		var pt2 = t * t;
		var pt3 = pt2 * t;
		var x = pt3 * x1 + pt2 * x2 + t * x3 + points[0].x;
		var y = pt3 * y1 + pt2 * y2 + t * y3 + points[0].y;
		var j = 4 * index(cutDecimal(y), cutDecimal(x), width);
		idata[j] = 0;
		idata[j + 1] = 0;
		idata[j + 2] = 255;
		idata[j + 3] = 255;
	}
	ctx.putImageData(img1, 0, 0);
	if (visible) {
		drawPoints(points, style);
	}
};
var drawMyCBezier2 = function(points, style, visible) {
	var x1 = -points[0].x + 3 * points[1].x - 3 * points[2].x + points[3].x;
	var y1 = -points[0].y + 3 * points[1].y - 3 * points[2].y + points[3].y;
	var x2 = 3 * points[0].x - 6 * points[1].x + 3 * points[2].x;
	var y2 = 3 * points[0].y - 6 * points[1].y + 3 * points[2].y;
	var x3 = -3 * points[0].x + 3 * points[1].x;
	var y3 = -3 * points[0].y + 3 * points[1].y;
	var extr = tValue(points);
	var te = 1.0 / extr;
	var t = 0;
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = style;
	ctx.moveTo(points[0].x, points[0].y);
	for ( var i = 0; i < extr; i++) {
		t = i * te;
		var pt2 = t * t;
		var pt3 = pt2 * t;
		var x = pt3 * x1 + pt2 * x2 + t * x3 + points[0].x;
		var y = pt3 * y1 + pt2 * y2 + t * y3 + points[0].y;
		ctx.lineTo(x, y);
	}
	ctx.stroke();
	ctx.restore();
	if (visible) {
		drawPoints(points, style);
	}
	ctx.restore();
};
var rotateBezier = function(points, angle) {
	var points1 = new Array();
	for ( var i = 0; i < points.length; i++) {
		points1.push(new Point(points[i].x * Math.cos(angle) + points[i].y
				* Math.sin(angle), -points[i].x * Math.sin(angle) + points[i].y
				* Math.cos(angle)));
	}
	return points1;
};
var drawNBezier = function(points, style, visible) {
	var n = points.length - 1;
	var extr = tValue(points);
	var te = 1.0 / extr;
	var t = 0;
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = style;
	ctx.moveTo(points[0].x, points[0].y);
	for ( var i = 0; i < extr; i++) {
		t = i * te;
		var x = 0;
		var y = 0;
		for ( var k = 0; k < points.length; k++) {
			var np = npok(n, k) * Math.pow(t, k) * Math.pow(1 - t, n - k);
			x += np * points[k].x;
			y += np * points[k].y;
		}
		ctx.lineTo(x, y);
	}
	ctx.stroke();
	ctx.restore();
	if (visible) {
		drawPoints(points, style);
	}
	ctx.restore();
};

var cloneArray2 = function(array) {
	var len = array.length;
	var arr = new Array(len);
	for ( var i = 0; i < len; i++) {
		arr[i] = new Point(array[i].x, array[i].y);
	}
	return arr;
};
var casteljauTValue = function(points, t) {
	var temp = cloneArray2(points);
	var len = points.length;
	var t1 = 1.0 - t;
	for ( var i = 0; i < len - 1; i++) {
		for ( var j = 0; j < len - 1 - i; j++) {
			temp[j].x = temp[j].x * t1 + t * temp[j + 1].x;
			temp[j].y = temp[j].y * t1 + t * temp[j + 1].y;
		}
	}
	return temp[0];
};
var divideCasteljau = function(points) {
	var temp = cloneArray2(points);
	var temp1 = cloneArray2(points).reverse();
	var len = points.length;
	var t = 0.3;
	var t1 = 1.0 - t;
	for ( var i = 0; i < len - 1; i++) {
		for ( var j = 0; j < len - 1 - i; j++) {
			temp[j].x = temp[j].x * t1 + t * temp[j + 1].x;
			temp[j].y = temp[j].y * t1 + t * temp[j + 1].y;
			temp1[j].x = temp1[j + 1].x * t1 + t * temp1[j].x;
			temp1[j].y = temp1[j + 1].y * t1 + t * temp1[j].y;
		}
	}
	var arr = new Array(2);
	arr[0] = temp1.reverse();
	arr[1] = temp;
	return arr;
};
var drawCircle = function(startX, startY, r, style) {
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = style;
	ctx.moveTo(startX + r, startY);
	ctx.quadraticCurveTo(startX + r, startY + r * Math.tan(Math.PI / 8), startX
			+ r * Math.cos(Math.PI / 4), startY + r * Math.cos(Math.PI / 4));
	ctx.quadraticCurveTo(startX + r * Math.tan(Math.PI / 8), startY + r,
			startX, startY + r);
	ctx.quadraticCurveTo(startX - r * Math.tan(Math.PI / 8), startY + r, startX
			- r * Math.cos(Math.PI / 4), startY + r * Math.cos(Math.PI / 4));
	ctx.quadraticCurveTo(startX - r, startY + r * Math.tan(Math.PI / 8), startX
			- r, startY);
	ctx.quadraticCurveTo(startX - r, startY - r * Math.tan(Math.PI / 8), startX
			- r * Math.cos(Math.PI / 4), startY - r * Math.cos(Math.PI / 4));
	ctx.quadraticCurveTo(startX - r * Math.tan(Math.PI / 8), startY - r,
			startX, startY - r);
	ctx.quadraticCurveTo(startX + r * Math.tan(Math.PI / 8), startY - r, startX
			+ r * Math.cos(Math.PI / 4), startY - r * Math.cos(Math.PI / 4));
	ctx.quadraticCurveTo(startX + r, startY - r * Math.tan(Math.PI / 8), startX
			+ r, startY);
	ctx.stroke();
	ctx.restore();
};
var rBezierTValue = function(n, k, t, weights) {
	var arr = new Array();
	var mian = 0.0;
	var sum = 0.0;
	for ( var i = 0; i < n + 1; i++) {
		var a = npok(n, i) * Math.pow(t, i) * Math.pow(1.0 - t, n - i)
				* weights[i];
		if (a < 0) {
			a = 0;
		}
		arr.push(a);
		mian += a;
	}
	sum = arr[k] / mian;
	return sum;
};
var rBezierTValue2 = function(np, n, k, t, weights) {
	var arr = new Array();
	var mian = 0.0;
	var sum = 0.0;
	for ( var i = 0; i < n + 1; i++) {
		var a = np * Math.pow(t, i) * Math.pow(1.0 - t, n - i) * weights[i];
		if (a < 0) {
			a = 0;
		}
		arr.push(a);
		mian += a;
	}
	sum = arr[k] / mian;
	return sum;
};
var rBezier = function(n, k, weights, liczbaPunktow) {
	var t;
	var img1 = ctx.getImageData(0, 0, width, height);
	var idata = img1.data;
	var np = npok(n, k);
	for ( var i = 0; i < liczbaPunktow; i++) {
		t = i * 1.0 / liczbaPunktow;
		var b = rBezierTValue2(np, n, k, t, weights);
		if (b < 0) {
			b = 0;
		}
		var j = 4 * index(cutDecimal(height - b * liczbaPunktow), cutDecimal(t
				* liczbaPunktow), width);
		idata[j] = 0;
		idata[j + 1] = 0;
		idata[j + 2] = 255;
		idata[j + 3] = 255;
	}
	ctx.putImageData(img1, 0, 0);
};
var drawRatBezier2 = function(points, weights, style, visible) {
	var extr = tValue(points);
	var te = 1.0 / extr;
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = style;
	ctx.moveTo(points[0].x, points[0].y);
	for ( var i = 0; i < extr + 1; i++) {
		var t = i * te;
		var t1 = 1.0 - t;
		var m0 = t1 * t1 * weights[0];
		var m1 = 2 * t * t1 * weights[1];
		var m2 = t * t * weights[2];
		var mian = m0 + m1 + m2;
		var w0 = m0 / mian;
		var w1 = m1 / mian;
		var w2 = m2 / mian;
		var x = w0 * points[0].x + w1 * points[1].x + w2 * points[2].x;
		var y = w0 * points[0].y + w1 * points[1].y + w2 * points[2].y;
		ctx.lineTo(x, y);
	}
	ctx.lineTo(points[2].x, points[2].y);
	ctx.stroke();
	ctx.restore();
	if (visible) {
		drawPoints(points, style);
	}
};
var drawRatBezier3 = function(points, weights, style, visible) {
	var extr = tValue(points);
	var te = 1.0 / extr;
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = style;
	ctx.moveTo(points[0].x, points[0].y);
	for ( var i = 0; i < extr; i++) {
		var t = i * te;
		var t1 = 1.0 - t;
		var m0 = t1 * t1 * t1 * weights[0];
		var m1 = 3 * t * t1 * t1 * weights[1];
		var m2 = 3 * t * t * t1 * weights[2];
		var m3 = t * t * t * weights[3];
		var mian = m0 + m1 + m2 + m3;
		var w0 = m0 / mian;
		var w1 = m1 / mian;
		var w2 = m2 / mian;
		var w3 = m3 / mian;
		var x = w0 * points[0].x + w1 * points[1].x + w2 * points[2].x + w3
				* points[3].x;
		var y = w0 * points[0].y + w1 * points[1].y + w2 * points[2].y + w3
				* points[3].y;
		ctx.lineTo(x, y);
	}
	ctx.lineTo(points[3].x, points[3].y);
	ctx.stroke();
	ctx.restore();
	if (visible) {
		drawPoints(points, style);
	}
};

var drawRatBezierN = function(points, weights, style, visible) {
	var extr = tValue(points);
	var te = 1.0 / extr;
	var n = points.length - 1;
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = style;
	ctx.moveTo(points[0].x, points[0].y);
	for ( var i = 0; i < extr + 1; i++) {
		var t = i * te;
		var t1 = 1.0 - t;
		var ms = new Array();
		for ( var j = 0; j < points.length; j++) {
			ms.push(npok(n, j) * Math.pow(t, j) * Math.pow(t1, n - j)
					* weights[j]);
		}
		var mian = 0.0;
		for ( var k = 0; k < ms.length; k++) {
			mian += ms[k];
		}
		var x = 0.0;
		var y = 0.0;
		for ( var m = 0; m < points.length; m++) {
			x += ms[m] * points[m].x;
			y += ms[m] * points[m].y;
		}
		x = cutDecimal(x / mian);
		y = cutDecimal(y / mian);
		ctx.lineTo(x, y);
		// x = 0.0;
		// y = 0.0;
	}
	ctx.lineTo(points[points.length - 1].x, points[points.length - 1].y);
	ctx.stroke();
	ctx.restore();
	if (visible) {
		drawPoints(points, style);
	}
};
var bezierDegreeUp = function(points) {
	var len = points.length;// 4
	var arr = new Array();
	arr[0] = new Point(points[0].x, points[0].y);
	for ( var i = 1; i < len; i++) {
		var a = i / len;
		var b = 1.0 - a;
		arr.push(new Point(a * points[i - 1].x + b * points[i].x, a
				* points[i - 1].y + b * points[i].y));
	}
	arr.push(new Point(points[len - 1].x, points[len - 1].y));
	return arr;
};
var connectBezier = function(points, qoints) {
	var n = points.length - 1;
	var m = qoints.length - 1;
	points[n - 1].x = ((m + n) * qoints[0].x - m * qoints[1].x) / n;
	points[n - 1].y = ((m + n) * qoints[0].y - m * qoints[1].y) / n;
};