function Kleene(value) {
	switch (value) {
	case -1:
	case 0:
	case 1:
		this.value = value;
		break;
	default:
		throw new Error("wartość może być wyłącznie -1, 0 albo 1");
	}
}
Kleene.prototype.getValue = function() {
	return this.value;
};
Kleene.prototype.setValue = function(value) {
	this.value = value;
};
Kleene.prototype.equals = function(tbool) {
	if (this.value === tbool.getValue()) {
		return true;
	} else {
		return false;
	}
};
Kleene.prototype.toString = function() {
	switch (this.value) {
	case -1:
		return "undefined";
	case 0:
		return "false";
	case 1:
		return "true";
	}
};
function not(p) {
	var val = p.getValue();
	if (val === 0) {
		return new Kleene(1);
	} else if (val === 1) {
		return new Kleene(0);
	} else if (val === -1) {
		return new Kleene(-1);
	}

};

function and(p, q) {
	var a = p.getValue();
	var b = q.getValue();
	if ((a === 0) && (b === 0)) {
		return new Kleene(0);
	}
	if ((a === 0) && (b === -1)) {
		return new Kleene(0);
	}
	if ((a === 0) && (b === 1)) {
		return new Kleene(0);
	}
	if ((a === -1) && (b === 0)) {
		return new Kleene(0);
	}
	if ((a === -1) && (b === -1)) {
		return new Kleene(-1);
	}
	if ((a === -1) && (b === 1)) {
		return new Kleene(-1);
	}
	if ((a === 1) && (b === 0)) {
		return new Kleene(0);
	}
	if ((a === 1) && (b === -1)) {
		return new Kleene(-1);
	}
	if ((a === 1) && (b === 1)) {
		return new Kleene(1);
	}

};

function or(p, q) {
	var a = p.getValue();
	var b = q.getValue();
	if ((a === 0) && (b === 0)) {
		return new Kleene(0);
	}
	if ((a === 0) && (b === -1)) {
		return new Kleene(-1);
	}
	if ((a === 0) && (b === 1)) {
		return new Kleene(1);
	}
	if ((a === -1) && (b === 0)) {
		return new Kleene(-1);
	}
	if ((a === -1) && (b === -1)) {
		return new Kleene(-1);
	}
	if ((a === -1) && (b === 1)) {
		return new Kleene(1);
	}
	if ((a === 1) && (b === 0)) {
		return new Kleene(1);
	}
	if ((a === 1) && (b === -1)) {
		return new Kleene(1);
	}
	if ((a === 1) && (b === 1)) {
		return new Kleene(1);
	}
};

function imp(p, q) {
	var a = p.getValue();
	var b = q.getValue();

	if ((a === 0) && (b === 0)) {
		return new Kleene(1);
	}
	if ((a === 0) && (b === -1)) {
		return new Kleene(1);
	}
	if ((a === 0) && (b === 1)) {
		return new Kleene(1);
	}
	if ((a === -1) && (b === 0)) {
		return new Kleene(-1);
	}
	if ((a === -1) && (b === -1)) {
		return new Kleene(-1);
	}
	if ((a === -1) && (b === 1)) {
		return new Kleene(1);
	}
	if ((a === 1) && (b === 0)) {
		return new Kleene(0);
	}
	if ((a === 1) && (b === -1)) {
		return new Kleene(-1);
	}
	if ((a === 1) && (b === 1)) {
		return new Kleene(1);
	}

};

function row(p, q) {
	var a = p.getValue();
	var b = q.getValue();

	if ((a === 0) && (b === 0)) {
		return new Kleene(1);
	}
	if ((a === 0) && (b === -1)) {
		return new Kleene(-1);
	}
	if ((a === 0) && (b === 1)) {
		return new Kleene(0);
	}
	if ((a === -1) && (b === 0)) {
		return new Kleene(-1);
	}
	if ((a === -1) && (b === -1)) {
		return new Kleene(-1);
	}
	if ((a === -1) && (b === 1)) {
		return new Kleene(-1);
	}
	if ((a === 1) && (b === 0)) {
		return new Kleene(0);
	}
	if ((a === 1) && (b === -1)) {
		return new Kleene(-1);
	}
	if ((a === 1) && (b === 1)) {
		return new Kleene(1);
	}
};

