var L_MIN = 350.0;
var L_MAX = 700.0;
var L_WIDTH = L_MAX - L_MIN;
var spectrum = new Array(
		new Array(0, 28, 160), new Array(0, 40, 200), new Array(0, 60, 244), 
		new Array(0, 124, 248), new Array(0, 160, 252), new Array(0, 212, 200),
		new Array(0, 252, 80), new Array(124, 252, 40), new Array(252, 252, 0), 
		new Array(252, 188, 0), new Array(252, 124, 0), new Array(252, 60, 0), 
		new Array(252, 0, 0), new Array(204, 0, 0), new Array(160, 0, 0));

var lapunow = function(rx, ry, tabl, n) {
	var r, w, lapun;
	var N = 0.1;
	var suma = 0.0;
	var sum2 = 0;
	var index = 0;
	for(var i = 0; i < n; i++){
		if(tabl[index] === 0){
			r = rx;
		}
		else{
			r = ry;
		}
		index++;
		if(index === tabl.length){
			index = 0;
		}
		N = N * r * (1 - N);
		w = Math.abs(r - 2 * r * N);
		if(w > 0){
			suma = suma + Math.log(w);
			sum2++;
		}
	}
	if(sum2 > 0)
		lapun = suma / sum2;
	else
		lapun = 0;
	return lapun;
};
var setPixel = function(data, iwidth, x, y, r, g, b, a){
	data[((iwidth * y) + x) * 4] = r;
    data[((iwidth * y) + x) * 4 + 1] = g;
    data[((iwidth * y) + x) * 4 + 2] = b;
    data[((iwidth * y) + x) * 4 + 3] = a;
};
var randomInRange = function(min, max) {
	var random = -1;
	if (min > max) {
		return new Error('Pierwsza liczba musi być mniejsza od drugiej');
	} else {
		random = cutDecimal(Math.floor(Math.random() * (max - min + 1)) + min);
	}
	return random;
};
var cutDecimal = function(nr) {
	var temp = nr.toString();
	var temp1 = temp.indexOf(".");
	var temp2 = "";
	if (temp1 > -1) {
		temp2 = temp.substr(0, temp1);
	} else {
		temp2 = temp;
	}
	return parseInt(temp2);
};
var lambdaToColor =function(lambda) {
	var c4, r, g, b;
	var c5, c6, d1, d2;
	lambda += (1.0 - randomInRange(0, 2000) / 1000.0);
	if(lambda <= L_MIN || lambda >= L_MAX){
		return new Array(0,0,0,255);
	}
	c5 = 0.04 * lambda - 14.0;
	c4 = cutDecimal(c5);
	c6 = c5 - c4;
	d1 = spectrum[c4][0];
	d2 = spectrum[c4 + 1][0];
	r = cutDecimal(d1 + c6 * (d2 - d1));
	d1 = spectrum[c4][1];
	d2 = spectrum[c4 + 1][1];
	g = cutDecimal(d1 + c6 * (d2 - d1));
	d1 = spectrum[c4][2];
	d2 = spectrum[c4 + 1][2];
	b = cutDecimal(d1 + c6 * (d2 - d1));
	var col = new Array(r, g, b, 255);
	return col;
};
