/* funkcja zmieniajaca liczbe heksadecymalna na wartosci RGB
 * Liczba może być podana jako 0x np "0xFFFFFF" lub "#FFFFFF"
 * lub "FFFFFF"
 */
var HexToRGB = function(hexa) {
	var R = -1;
	var G = -1;
	var B = -1;
	if (((hexa.indexOf("x") === -1) && (hexa.indexOf("#") === -1))) {
		R = parseInt(hexa.substr(0, 2), 16);
		G = parseInt(hexa.substr(2, 2), 16);
		B = parseInt(hexa.substr(4, 2), 16);
	} else {
		if (hexa.indexOf("#") > 0) {
			R = parseInt(hexa.substr(1, 2), 16);
			G = parseInt(hexa.substr(3, 2), 16);
			B = parseInt(hexa.substr(5, 2), 16);
		} else if (hexa.indexOf("x") > 0) {
			R = parseInt(hexa.substr(2, 2), 16);
			G = parseInt(hexa.substr(4, 2), 16);
			B = parseInt(hexa.substr(6, 2), 16);
		}
	}
	return [ R, G, B ];
};

/*
 * funkcja zmieniajaca wartosci RGB na licybe heksdecymalna. Liczby musza być
 * podane jako inty od 0 do 255 włącznie
 */
var RGBToHex = function(r, g, b) {
	var r1 = parseInt(r).toString(16).toUpperCase();
	var g1 = parseInt(g).toString(16).toUpperCase();
	var b1 = parseInt(b).toString(16).toUpperCase();
	if (r1.length === 1) {
		r1 = "0" + r1;
	}
	if (g1.length === 1) {
		g1 = "0" + g1;
	}
	if (b1.length === 1) {
		b1 = "0" + b1;
	}
	return "0x" + r1 + g1 + b1;
};
// zwraca tablice R,G,B,A gdzie A jest liczbą float pomiedzy 0.0 - 1.0
var HexToRGBA = function(hexa) {
	var R = -1;
	var G = -1;
	var B = -1;
	var A = -1;
	if (((hexa.indexOf("x") === -1) && (hexa.indexOf("#") === -1))) {
		R = parseInt(hexa.substr(0, 2), 16);
		G = parseInt(hexa.substr(2, 2), 16);
		B = parseInt(hexa.substr(4, 2), 16);
		A = parseInt(hexa.substr(6, 2), 16);
	} else {
		if (hexa.indexOf("#") > 0) {
			R = parseInt(hexa.substr(1, 2), 16);
			G = parseInt(hexa.substr(3, 2), 16);
			B = parseInt(hexa.substr(5, 2), 16);
			A = parseInt(hexa.substr(7, 2), 16);
		} else if (hexa.indexOf("x") > 0) {
			R = parseInt(hexa.substr(2, 2), 16);
			G = parseInt(hexa.substr(4, 2), 16);
			B = parseInt(hexa.substr(6, 2), 16);
			A = parseInt(hexa.substr(8, 2), 16);
		}
	}
	return [ R, G, B, Math.roundToDecimal((A - 0.5) / 255, 4) ];
};
// a jest typu float pomiędzy 0.0 - 1.0
var RGBAToHex = function(r, g, b, a) {
	var r1 = parseInt(r).toString(16).toUpperCase();
	var g1 = parseInt(g).toString(16).toUpperCase();
	var b1 = parseInt(b).toString(16).toUpperCase();
	var a1 = parseInt(Math.roundToDecimal(a * 255 + 0.5), 4).toString(16)
			.toUpperCase();
	if (r1.length === 1) {
		r1 = "0" + r1;
	}
	if (g1.length === 1) {
		g1 = "0" + g1;
	}
	if (b1.length === 1) {
		b1 = "0" + b1;
	}
	if (a1.length === 1) {
		a1 = "0" + a1;
	}
	return "0x" + r1 + g1 + b1;
};

// Przyjmuje wartości RGB
// zwraca tablicę HSL (h w stopniach od 0.0 - 360, pozostałe
// w %)
var RGBToHSL = function(r, g, b) {
	r /= 255, g /= 255, b /= 255;
	var max = Math.max(r, g, b), min = Math.min(r, g, b);
	var sm = max + min;
	var h = sm / 2;
	var s = sm / 2;
	var l = sm / 2;

	if (max === min) {
		h = s = 0; // achromatic
	} else {
		var d = max - min;
		s = l > 0.5 ? d / (2 - sm) : d / sm;
		switch (max) {
		case r:
			h = (g - b) / d + (g < b ? 6 : 0);
			break;
		case g:
			h = (b - r) / d + 2;
			break;
		case b:
			h = (r - g) / d + 4;
			break;
		}
		h *= 60.0;
	}

	return [ roundToDecimal(h, 4), roundToDecimal(s, 4), roundToDecimal(l, 4) ];
};

// h - barwa w stopniach 0.0 - 360.0
// s - nasycenie w % od 0.0 - 100%
// l - jasność w % od 0.0 - 100%
// zwraca tablice wartości RGB
var HSLToRGB = function(h, s, l) {
	var r, g, b;
	h /= 360.0;
	if (s === 0) {
		r = g = b = l; // achromatic
	} else {
		var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
		var p = 2 * l - q;
		r = HueToRGB(p, q, h + 1.0 / 3.0);
		g = HueToRGB(p, q, h);
		b = HueToRGB(p, q, h - 1.0 / 3.0);
	}

	return [ roundToDecimal(r * 255, 0), roundToDecimal(g * 255, 0),
			roundToDecimal(b * 255, 0) ];
};
// funkcja pomocnicza do obliczania nasycenia
var HueToRGB = function(a, b, c) {
	if (c < 0)
		c += 1;
	if (c > 1)
		c -= 1;
	if (c < 1.0 / 6.0)
		return a + (b - a) * 6 * c;
	if (c < 1.0 / 2.0)
		return b;
	if (c < 2.0 / 3.0)
		return a + (b - a) * (2. / 3.0 - c) * 6;
	return a;
};

var roundToDecimal = function(num, dec) {
	var multi = Math.pow(10, dec);
	return Math.round(num * multi) / multi;
};

/**
 * Zamienia wartosci R, G, B na liczbę int stosowaną w Javie
 * 
 * @param r
 *            int - składnik czerwony;
 * @param g
 *            int - składnik zielony
 * @param b
 *            int - składnik niebieski
 * @return int - wartość RGB przeliczona na int;
 */

var RGBToInt = function(r, g, b) {
	var r1 = parseInt(r).toString(16);
	var g1 = parseInt(g).toString(16);
	var b1 = parseInt(b).toString(16);
	if (r1.length === 1) {
		r1 = "0" + r1;
	}
	if (g1.length === 1) {
		g1 = "0" + g1;
	}
	if (b1.length === 1) {
		b1 = "0" + b1;
	}
	var cont = "" + r1 + g1 + b1;
	var i = parseInt(cont, 16);
	return i;
};

/**
 * Przelicza liczbę int na R, G, B
 * 
 * @param rgb
 *            int - liczba int oznaczająca kolor;
 * @return String - wartość RGB
 */

var IntToRGB = function(rgb) {
	var R = (rgb >> 16) & 0xff;
	var G = (rgb >> 8) & 0xff;
	var B = (rgb >> 0) & 0xff;
	return new Array(R, G, B);
};
