var cv = document.getElementById('canvas');
var ctx = cv.getContext('2d');
var w = cv.width;
var h = cv.height;
/**
 * Rysuje asteroidę 
 * @param strokeStyle - kolor krzywej 
 * @param r promień krzywej 
 * @param points - liczba punktów rysujących krzywą
 */
var asteroida = function(r, points, strokeStyle) {
	ctx.save();
	ctx.beginPath();
	ctx.translate(w / 2, h / 2);
	ctx.strokeStyle = strokeStyle;
	var x1 = r;
	var y1 = 0;
	var x2;
	var y2;
	for ( var i = 0; i < points; i++) {
		var t = i * Math.PI / 360.0;
		x2 = r * Math.pow(Math.cos(t), 3);
		y2 = r * Math.pow(Math.sin(t), 3);
		ctx.moveTo(x1, y1);
		ctx.lineTo(x2, y2);
		x1 = x2;
		y1 = y2;
	}
	ctx.stroke();
	ctx.restore();
};
var index = function(row, col, cols) {
	return row * cols + col;
};
var asteroida2 = function(r, points) {
	var x2;
	var y2;
	var img1 = ctx.getImageData(0, 0, w, h);
	var idata = img1.data;
	for ( var i = 0; i < points; i++) {
		var t = i * Math.PI / 360.0;
		x2 = r * Math.pow(Math.cos(t), 3) + w / 2;
		y2 = r * Math.pow(Math.sin(t), 3) + h / 2;
		var j = 4 * index(Math.floor(x2), Math.floor(y2), w);
		idata[j] = 0;
		idata[j + 1] = 0;
		idata[j + 2] = 255;
		idata[j + 3] = 255;
	}
	ctx.putImageData(img1, 0, 0);
};
/**
 * Rysuje epicykloidę 
 * @param strokeStyle - kolor krzywej 
 * @param AA - promień większego koła 
 * @param aa - promień mniejszego koła 
 * @param  lambda > 1 epicykloida wydłużona, lambda = 1
 * epicykloida normalna, lambda < 1 epicykloida skrócona 
 * @param points - liczba punktów rysujących krzywą
 */
var epicykloida = function(AA, aa, lambda, points, strokeStyle) {
	ctx.save();
	ctx.beginPath();
	ctx.translate(w / 2, h / 2);
	ctx.strokeStyle = strokeStyle;
	var x1 = AA - (lambda - 1) * aa;
	var y1 = 0;
	var x2;
	var y2;
	for ( var i = 0; i < points; i++) {
		var t = i * Math.PI / 360.0;
		x2 = (AA + aa) * Math.cos(t) - lambda * aa
				* Math.cos((AA + aa) * t / aa);
		y2 = (AA + aa) * Math.sin(t) - lambda * aa
				* Math.sin((AA + aa) * t / aa);
		ctx.moveTo(Math.floor(x1), Math.floor(y1));
		ctx.lineTo(Math.floor(x2), Math.floor(y2));
		x1 = x2;
		y1 = y2;
	}
	ctx.stroke();
	ctx.restore();
};
/**
 * Rysuje hipocykloidę 
 * @param strokeStyle - kolor krzywej 
 * @param AA - promień większego koła
 * @param aa - promień mniejszego koła 
 * @param lambda > 1 hipocykloida wydłużona, lambda = 1 hipocykloida normalna,  
 * lambda < 1 hipocykloida skrócona 
 * @param points - liczba punktów rysujących krzywą
 */
var hipocykloida = function(AA, aa, lambda, points, strokeStyle) {
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = strokeStyle;
	ctx.translate(w / 2, h / 2);
	var x1 = AA + (lambda - 1) * aa;
	var y1 = 0;
	var x2;
	var y2;
	aa = -aa;
	for ( var i = 0; i < points; i++) {
		var t = i * Math.PI / 360;
		x2 = (AA + aa) * Math.cos(t) - lambda * aa
				* Math.cos((AA + aa) * t / aa);
		y2 = (AA + aa) * Math.sin(t) - lambda * aa
				* Math.sin((AA + aa) * t / aa);
		ctx.moveTo(Math.floor(x1), Math.floor(y1));
		ctx.lineTo(Math.floor(x2), Math.floor(y2));
		x1 = x2;
		y1 = y2;
	}
	ctx.stroke();
	ctx.restore();
};
/**
 * Rysuje rozetę czterolistną 
 * @param strokeStyle - kolor krzywej 
 * @param size - promień krzywej
 * @param points - liczba punktów rysujących krzywą
 */
var rozeta4listna = function(size, points, strokeStyle) {
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = strokeStyle;
	ctx.translate(w / 2, h / 2);
	var x1 = 0;
	var y1 = 0;
	var x2;
	var y2;
	for ( var i = 0; i < points; i++) {
		var t = i * Math.PI / 360;
		x2 = 2 * size * Math.sin(t) * Math.pow(Math.cos(t), 2);
		y2 = 2 * size * Math.cos(t) * Math.pow(Math.sin(t), 2);
		ctx.moveTo(Math.floor(x1), Math.floor(y1));
		ctx.lineTo(Math.floor(x2), Math.floor(y2));
		x1 = x2;
		y1 = y2;
	}
	ctx.stroke();
	ctx.restore();
};
/**
 * Rysuje spiralę Archimedesa 
 * @param strokeStyle - kolor spirali 
 * @param dlugosc - dlugosc spirali. Zmiana znaku przed tym parametrem zmienia 
 * kierunek skrętu spirali
 * @param ciasnosc - zmniejsza odstępy między skrętami spirali. Zmiana znaku przed tym
 * parametrem zmienia miejsce startu i zakończenia spirali 
 * @param points - liczba punktów do narysowania
 */
var spiralaArchimedesa = function(dlugosc, ciasnosc, points, strokeStyle) {
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = strokeStyle;
	ctx.translate(w / 2, h / 2);	
	var x1 = 0;
	var y1 = 0;
	var x2;
	var y2;
	for ( var i = 0; i < points; i++) {
		var t = i * dlugosc * Math.PI / points;
		x2 = ciasnosc * t * Math.cos(t);
		y2 = ciasnosc * t * Math.sin(t);
		ctx.moveTo(Math.floor(x1), Math.floor(y1));
		ctx.lineTo(Math.floor(x2), Math.floor(y2));
		x1 = x2;
		y1 = y2;
	}
	ctx.stroke();
	ctx.restore();
};

var kardioida = function(a, points, strokeStyle) {
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = strokeStyle;
	ctx.translate(w / 2, h / 2);
	var x2;
	var y2;
	for ( var i = 0; i < points; i++) {
		var t = i * Math.PI / 360;
		x2 = a * (2 * Math.cos(t) - Math.cos(2 * t));
		y2 = a * (2 * Math.sin(t) - Math.sin(2 * t));
		ctx.lineTo(Math.floor(x2), Math.floor(y2));
	}
	ctx.stroke();
	ctx.restore();
};
var lissajous = function(A1, A2, w1, w2, fi1, fi2, points, strokeStyle) {
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = strokeStyle;
	ctx.translate(w / 2, h / 2);
	var x2;
	var y2;
	for ( var i = 0; i < points; i++) {
		var t = i * Math.PI / 360;
		x2 = A1 * Math.cos(w1 * t + fi1);
		y2 = A2 * Math.cos(w2 * t + fi2);
		ctx.lineTo(Math.floor(x2), Math.floor(y2));
	}
	ctx.stroke();
	ctx.restore();
};
var drawOval = function(x, y, w, h, points, strokeStyle) {
	var a = w / 2;
	var b = h / 2;
	ctx.save();
	ctx.beginPath();
	ctx.strokeStyle = strokeStyle;
	ctx.translate(x + a, y + b);
	var x2;
	var y2;
	for ( var i = 0; i < points; i++) {
		var t = i * Math.PI / 360;
		x2 = a * Math.cos(t);
		y2 = b * Math.sin(t);
		ctx.lineTo(Math.floor(x2), Math.floor(y2));
	}
	ctx.stroke();
	ctx.restore();
};