// logarytm naturalny z b
var ln = function(b) {
	return Math.log(b);
};
/**
 * @param n -  liczba gatunków w próbie
 * @param N - łączna liczba osobników (wszystkie gatunki razem
 * @return wskażnik Margalefa
 */
var margalef = function(n, N) {
	return (n - 1) / ln(N);
};

/**
 * Oblicza wskaźnik Simpsona dla próby
 * @param n to tabela grupująca informację. Liczba gatunków jest równa
 *            długości tabeli. W każdej komórce podano liczbę osobników danego
 *            gatunku
 * @return wskaźnik Simpsona
 */
var simpsonSample = function(n) {
	var sum1 = 0;
	var sum2 = 0;
	for ( var i = 0; i < n.length; i++) {
		sum1 += n[i];
	}
	var nn = sum1 * (sum1 - 1);
	for ( var j = 0; j < n.length; j++) {
		sum2 += n[j] * (n[j] - 1.0) / nn;
	}
	return 1.0 - sum2;
};

/**
 * Oblicza wskaźnik Simpsona dla populacji generalnej
 * @param n to tabela grupująca informację. Liczba gatunków jest równa
 *            długości tabeli. W każdej komórce podano liczbę osobników danego
 *            gatunku
 * @return wskaźnik Simpsona
 */
var simpsonEnviron = function(n) {
	var sum1 = 0;
	var sum2 = 0;
	for ( var i = 0; i < n.length; i++) {
		sum1 += n[i];
	}
	for ( var j = 0; j < n.length; j++) {
		sum2 += Math.pow(n[j] / sum1, 2);
	}
	return 1.0 - sum2;
};

/**
 * Oblicza wskaźnik Shanona - Wienera dla próby oraz jego wartość maksymalną i
 * minimalną 
 * @param n to tabela grupująca informację. Liczba gatunków jest równa
 *            długości tabeli. W każdej komórce podano liczbę osobników danego
 *            gatunku
 * @return tablicę zawierającą: [0] - minimalna wartość [1] - wskaźnik Shannona -
 *         Wienera [2] - maksymalna wartość
 */
var shannonWiener = function(n) {
	var sum1 = 0;
	var sum2 = 0;
	var total = new Array(3);
	for ( var i = 0; i < n.length; i++) {
		sum1 += n[i];
	}
	for ( var j = 0; j < n.length; j++) {
		sum2 += (n[j] / sum1) * ln(n[j] / sum1);
	}
	total[1] = -1.0 * sum2;
	total[0] = hMin(n.length, sum1);
	total[2] = hMax(n.length);
	return total;
};

/**
 * Oblicza maksymalną wielkość wskaźnika Shannona -Wienera
 * @param n - liczba gatunków
 * @return wartość maksymalna wskaźnika Shannona - Wienera
 */
var hMax = function(n) {
	return ln(n);
};

/**
 * Oblicza wartość minimalną wskaźnika Shannona - Wienera
 * @param n - liczba gatunków w próbie
 * @param N - łączna liczba osobników (wszystkie gatunki razem
 * @return wartość minimalna wskaźnika Shannona - Wienera
 */
var hMin = function(n, N) {
	return ln(N) - (N - n + 1) * ln(N - n + 1) / N;
};

/**
 * Oblicza wskaźnik pielou próby oraz jego wartość maksymalną i minimalną
 * @param n to tabela grupująca informację. Liczba gatunków jest równa
 *            długości tabeli. W każdej komórce podano liczbę osobników danego
 *            gatunku
 * @return tablicę zawierającą: [0] - minimalna wartość [1] - wskaźnik Pielou
 *         [2] - maksymalna wartość
 */
var pielou = function(n) {
	var shan = shannonWiener(n);
	var total = new Array(3);
	total[0] = shan[0] / shan[2];
	total[1] = shan[1] / shan[2];
	total[2] = 1;
	return total;
};

/**
 * Określa gatunkowe podobieństwo środowisk
 * @param na - liczba gatunków w środowsku a
 * @param nb - liczba gatunków w środowisku b
 * @param nab - liczba gatunków wspolnych (występujących i w jednym i w drugim
 *            środowisku
 * @return - wskaźnik Jaccarda
 */
var jaccard = function(na, nb, nab) {
	return nab / (na + nb - nab);
};

/**
 * Określa gatunkowe podobieństwo środowisk
 * @param na - liczba gatunków w środowsku a
 * @param nb - liczba gatunków w środowisku b
 * @param nab - liczba gatunków wspolnych (występujących i w jednym i w drugim
 *            środowisku
 * @return - wskaźnik Sorensona
 */
var sorenson1 = function(na, nb, nab) {
	return 2 * nab / (na + nb);
};

/**
 * Oblicza liczbowe podobieństwo środowisk
 * @param a - tabela liczebności gatunków w środowisku a
 * @param b - tabela liczebności w środowisku b Zakłada się, że dany gatunek
 *            występuje w obu tabelach na tej samej pozycji
 * @return wskaźnik Sorensona
 */
var sorenson2 = function(a, b) {
	var suma = 0;
	var sumb = 0;
	var sumc = 0;
	for ( var i = 0; i < a.length; i++) {
		suma += a[i];
		sumb += b[i];
		sumc += Math.min(a[i], b[i]);
	}
	return 2 * sumc / (suma + sumb);
};

/**
 * Oblicza liczbowe podobieństwo środowisk
 * @param a - tabela liczebności gatunku w środowisku a
 * @param b - tabela liczebności gatunku w środowisku b Zakłada się, że dany
 *            gatunek występuje w obu tabelach na tej samej pozycji
 * @return wskaźnik Euklidesa
 */
var euklides = function(a, b) {
	var gat = a.length;
	var sum = 0;
	for ( var i = 0; i < gat; i++) {
		sum += Math.pow(a[i] - b[i], 2.0);
	}
	return Math.sqrt(sum / gat);
};
