var w = cv.width;
var h = cv.height;
var x0 = w / 2.0;
var y0 = h / 2.0;
var lw = 0.5;
var bw = 12;
var bh = 10;
var cl = true;

var Vector2d = function(x, y) {
	this.x = x;
	this.y = y;
};
var Vector3d = function(x, y, z) {
	this.x = x;
	this.y = y;
	this.z = z;
};
Vector2d.prototype.toString = function() {
	return "V=[" + this.x + ", " + this.y + "]";
};
Vector3d.prototype.toString = function() {
	return "V=[" + this.x + ", " + this.y + ", " + this.z + "]";
};
Vector2d.prototype.equals = function(vect) {
	if (vect instanceof Vector2d) {
		return this.x === vect.x && this.y === vect.y;
	}
	return false;
};
Vector3d.prototype.equals = function(vect) {
	if (vect instanceof Vector3d) {
		return this.x === vect.x && this.y === vect.y && this.z === vect.z;
	}
	return false;
};
// dodaje podany wektor do tego wektora. Nie jest tworzony nowy wektor.
Vector2d.prototype.add = function(vector) {
	if (vector instanceof Vector2d) {
		this.x += vector.x;
		this.y += vector.y;
	}
};

// dodanie dwoch wektorow
Vector3d.prototype.add = function(vect) {
	if (vect instanceof Vector3d) {
		this.x += vect.x;
		this.y += vect.y;
		this.z += vect.z;
	}
};

// dodaje ten wektor do podanego wektora. Zwraca nowy wektor
Vector2d.prototype.addN = function(vector) {
	if (vector instanceof Vector2d) {
		var xx = vector.x + this.x;
		var yy = vector.y + this.y;
		return (new Vector2d(xx, yy));
	}
	return null;
};
// dodanie dwoch wektorow z utworzeniem nowego
Vector3d.prototype.addN = function(vect) {
	if (vect instanceof Vector3d) {
	}
	var xx = vect.x + this.x;
	var yy = vect.y + this.y;
	var zz = vect.z + this.z;
	return (new Vector3d(xx, yy, zz));
};
// odejmuje podany wektor od tego wektora. Nie jest tworzony nowy wektor
Vector2d.prototype.subtract = function(vector) {
	if (vector instanceof Vector2d) {
		this.x -= vector.x;
		this.y -= vector.y;
	}
};
// odjecie dwoch wektorow
Vector3d.prototype.subtract = function(vect) {
	if (vect instanceof Vector3d) {
		this.x -= vect.x;
		this.y -= vect.y;
		this.z -= vect.z;
	}
};

// odejmuje podany wektor od wektora tworzac i zwracajac nowy wektor
Vector2d.prototype.subtractN = function(vector) {
	if (vector instanceof Vector2d) {
		var xx = this.x - vector.x;
		var yy = this.y - vector.y;
		return (new Vector2d(xx, yy));
	}
	return null;
};
// odjecie dwoch wektorow z utworzeniem nowego
Vector3d.prototype.subtractN = function(vect) {
	if (vect instanceof "Vector3d") {
		var xx = vect.x - this.x;
		var yy = vect.y - this.y;
		var zz = vect.z - this.z;
		return new Vector3d(xx, yy, zz);
	}
	return null;
};
// skaluje wektor do podanej liczby. Nie tworzy nowego wektora
Vector2d.prototype.scale = function(num) {
	this.x *= num;
	this.y *= num;
};
// skalowanie wektora do podanej liczby
Vector3d.prototype.scale = function(num) {
	this.x *= num;
	this.y *= num;
	this.z *= num;
};

// skaluje wektor do podanej liczby. Zwraca nowy wektor
Vector2d.prototype.scaleN = function(num) {
	var xx = this.x * num;
	var yy = this.y * num;
	return (new Vector2d(xx, yy));
};
// skalowanie wektora do podanej liczby z utworzeniem nowego
Vector3d.prototype.scaleN = function(num) {
	var xx = this.x * num;
	var yy = this.y * num;
	var zz = this.z * num;
	return (new Vector3D(xx, yy, zz));
};
// bada i zwraca dlugosc tego wektora
Vector2d.prototype.getLength = function() {
	var xx = Math.pow(this.x, 2);
	var yy = Math.pow(this.y, 2);
	return Math.sqrt(xx + yy);
};

// zbadanie dlugosci wektora
Vector3d.prototype.getLength = function() {
	var xx = Math.pow(this.x, 2);
	var yy = Math.pow(this.y, 2);
	var zz = Math.pow(this.z, 2);
	return Math.sqrt(xx + yy + zz);
};

// ustawia dlugosc tego wektora
Vector2d.prototype.setLength = function(length) {
	var r = this.getLength();
	if (r) {
		this.scale(length / r);
	} else {
		this.x = length;
	}
};
// ustawienie nowej dlugosci wektora i stosowne skalowanie wektora
Vector3d.prototype.setLength = function(num) {
	var rr = this.length;
	if (rr) {
		this.scale(num / rr);
	} else {
		this.x = num;
	}
};
// okresla i podaje kat tego wektora (wsp. nachylenia) w stopniach
Vector2d.prototype.getAngle = function() {
	var angle = atan2Deg(this.y, this.x);
	return angle;
};
// zmienia kat tego wektora na podany kat (oba w stopniach
Vector2d.prototype.setAngle = function(angle) {
	var r = this.getLength();
	this.x = r * cosDeg(angle);
	this.y = r * sinDeg(angle);
};
// zmienia x i y tak, aby wektor mial dlugosc = 1;
Vector2d.prototype.normalize = function() {
	var len = this.getLength();
	this.x /= len;
	this.y /= len;
};
Vector2d.prototype.normalizeN = function() {
	var len = this.getLength();
	return new Vector2d(this.x /= len, this.y /= len);
};
// normalizacja wektora
Vector3d.prototype.normalize = function() {
	var len = this.length;
	return (new Vector3d(this.x / len, this.y / len, this.z / len));
};
// tworzy iloczyn skalarny dwoch wektorow. Nie zwraca nowego wektora
// jesli iloczyn = 0 wektory są prostopadłe
Vector2d.prototype.dot = function(vector) {
	var x1 = 0;
	var x2 = 0;
	if (vector instanceof Vector2d) {
		x1 = this.x * vector.x;
		x2 = this.y * vector.y;
	}
	return (x1 + x2);
};

// obliczenie iloczynu skalarnego 2 wektorow
// jesli iloczyn = 0, wektory sa prostopadle;
Vector3d.prototype.dot = function(vect) {
	if (vect instanceof Vector3d) {
		var x1 = this.x * vect.x;
		var x2 = this.y * vect.y;
		var x3 = this.z * vect.z;
		return (x1 + x2 + x3);
	}
};
// tworzy i zwraca wektor normalny (prostopadly) do danego wektora;
// trzeba podac kierunek
Vector2d.prototype.normal = function(direction) {
	var x1 = 0;
	var y1 = 0;
	switch (direction) {
	case "left":
		x1 = -this.y;
		y1 = this.x;
		break;
	case "right":
		x1 = this.y;
		y1 = -this.x;
		break;
	}
	return (new Vector2d(x1, y1));
};

// sprawdza czy podany wektor jest (prostopadly) do wektora
Vector2d.prototype.isNormalTo = function(vector) {
	if (vector instanceof Vector2d) {
		return (this.dot(vect) === 0);
	}
	return false;
};

// podaje kat miedzy dwoma wektorami w stopniach
Vector2d.prototype.angleBetween = function(vector) {
	if (vector instanceof Vector2d) {
		var d = this.dot(vector);
		var c = d / (this.getLength() * vector.getLength());
		return acosDeg(c);
	}
};

// obliczenie kata miedzy wektorami
Vector3d.prototype.angleBetween = function(vect) {
	if (vect instanceof Vector3d) {
		var d = this.dot(vect);
		var c = d / (this.getLength() * vect.getLength());
		return acosDeg(c);
	}
};
// iloczyn wektorowy
Vector2d.prototype.cross = function(vect) {
	if (vect instanceof Vector2d) {
		var z = this.x * vect.y - this.y * vect.x;
		return (new Vector2d(0, z));
	}
	return null;
};
// iloczyn wektorowy
// wytworzenie nowego wektora z 2 wektorow
// nowy wektor jest prostopadly do kazdego z obu wektorow
Vector3d.prototype.cross = function(vect) {
	if (vect instanceof Vector3d) {
		var cx = this.y * vect.z - this.z * vect.y;
		var cy = this.z * vect.x - this.x * vect.z;
		var cz = this.x * vect.y - this.y * vect.x;
		return (new Vector3d(cx, cy, cz));
	}
	return null;
};
Vector3d.prototype.surface = function(vect) {
	if (vect instanceof Vector3d) {
		var temp1 = this.cross(vect);
		var temp2 = temp1.normalize();
		return temp2;
	}
	return null;
};
// radius = r = promien
// angle = angle = kat
var Polar = function(radius, angle) {
	this.radius = radius;
	this.angle = angle;
};

Polar.prototype.toString = function() {
	return ("[r: " + this.radius + ",  \u03C6" + ": " + this.angle + " \u00BA]");
};

Polar.prototype.equals = function(polar) {
	if (polar instanceof Polar) {
		return this.radius === polar.radius && this.angle === polar.angle;
	}
	return false;
};

/*
 * przeksztala wspolrzedne kartezjanskie na polarne (biegunowe) zwraca obiekt
 * typu Polar; katy podawane sa w stopniach Przyjmuje albo obiekt typu Vector
 * albo parę wspólrzednych kartezjanskich x, y cartToPolar(vector)
 * cartToPolar(x, y);
 */
var cartToPolar = function(args) {
	var polar = null;
	switch (arguments.length) {
	case 1:
		if (arguments[0] instanceof Vector2d) {
			var radius = Math.sqrt(Math.pow(arguments[0].y, 2)
					+ Math.pow(arguments[0].x, 2));
			var angle = atan2Deg(arguments[0].y, arguments[0].x);
			polar = new Polar(radius, angle);
		}
		break;
	case 2:
		if ((typeof arguments[0] === "number")
				&& (typeof arguments[1] === "number")) {
			var radius1 = Math.sqrt(Math.pow(arguments[1], 2)
					+ Math.pow(arguments[0], 2));
			var angle1 = atan2Deg(arguments[1], arguments[0]);
			polar = new Polar(radius1, angle1);
		}
		break;
	}
	return polar;
};

/*
 * przeksztalca wspolrzedne polarne (biegunowe) na kartezjanskie. katy podawane
 * sa w stopniach. Przyjmuje albo obiekt Polar albo pare liczb oznaczajacych
 * wspolrzedne polarne. zwraca obiekt Vector2d
 */
var polarToCart = function(args) {
	var vector = null;
	switch (arguments.length) {
	case 1:
		if (arguments[0] instanceof Polar) {
			var xx = arguments[0].radius * cosDeg(arguments[0].angle);
			var yy = arguments[0].radius * sinDeg(arguments[0].angle);
			vector = new Vector2d(xx, yy);
		}
		break;
	case 2:
		if ((typeof arguments[0] === "number")
				&& (typeof arguments[1] === "number")) {
			var xx1 = arguments[0] * cosDeg(arguments[1]);
			var yy1 = arguments[0] * sinDeg(arguments[1]);
			vector = new Vector2d(xx1, yy1);
		}
		break;
	}
	return vector;
};
// funkcje przepisane z pliku trygon.js
var atan2Deg = function(yy, xx) {
	return Math.atan2(yy, xx) * 180.0 / Math.PI;
};
var acosDeg = function(ratio) {
	return Math.acos(ratio) * 180.0 / Math.PI;
};
var sinDeg = function(angleDeg) {
	return Math.sin(angleDeg * Math.PI / 180.0);
};
var cosDeg = function(angleDeg) {
	return Math.cos(angleDeg * Math.PI / 180.0);
};
function drawVector(vector, axes, fillStyle) {
	ctx.save();
	ctx.beginPath();
	ctx.fillStyle = fillStyle;
	var radius = 0;
	var angle = 0;
	if (vector instanceof Vector2d) {
		radius = Math.sqrt(Math.pow(vector.y, 2) + Math.pow(vector.x, 2));
		angle = atan2Deg(vector.y, vector.x);
	}
	if (axes === "complex" || axes === "cartesian") {
		drawArrow(x0, y0, radius * 30, lw, angle, bw, bh, cl, fillStyle);

	}
	if (axes === "js") {
		drawArrow(15, 15, radius * 30, lw, -angle, bw, bh, cl, fillStyle);

	}
	if (axes === "norm") {
		drawArrow(0, 0, radius, lw, angle, bw, bh, cl, fillStyle);
	}
	ctx.restore();
};
function drawPolar(polar, axes, fillStyle) {
	ctx.save();
	ctx.beginPath();
	ctx.fillStyle = fillStyle;
	if (polar instanceof Polar) {
		if (axes === "complex" || axes === "cartesian") {
			drawArrow(x0, y0, polar.radius * 30, lw, polar.angle, bw, bh, cl,
					fillStyle);

		}
		if (axes === "js") {
			drawArrow(15, 15, polar.radius * 30, lw, -polar.angle, bw, bh, cl,
					fillStyle);

		}
		if (axes === "norm") {
			drawArrow(0, 0, polar.radius, lw, -polar.angle, bw, bh, cl,
					fillStyle);
		}
	}
	ctx.restore();

};

/**
 * Zaokrągla do podanej liczby miejsc po przecinku
 * @param {type} num - liczba do zaokrąglenia
 * @param {type} dec - do ilu miejsc zaokrąglić
 * @returns {Number}
 */
var roundToDecimal = function(num, dec) {
	switch (arguments.length) {
	case 1:
		dec = 0;
		num = arguments[0];
		break;
	case 2:
		dec = arguments[1];
		num = arguments[0];
		break;
	}
	var multi = Math.pow(10, dec);
	return Math.round(num * multi) / multi;
};
