package math.set;

import math.color.ColorUtil;

import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;

public class Sets14 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Sets14(new Set14()));
    }

    public Sets14(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class Set14 extends JPanel {
    private static final long serialVersionUID = 5218506428064759030L;
    private static final int w = 800;
    private static final int h = 800;

    public Set14() {
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        BufferedImage image = new BufferedImage(w, h,
                BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawRect(0, 0, w - 1, h - 1);
        g2.setColor(ColorUtil.d);
        g2.fillOval(100, 100, 150, 150);
        AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.DST_OUT);
        g2.setComposite(ac);
        g2.setColor(ColorUtil.s);
        g2.fillRect(200, 125, 100, 100);
        g2.dispose();
        g.drawImage(image, 0, 0, null);
    }
}