package math.fractals;

import math.color.ColorUtil;
import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import math.axes.*;

class Fractal33 extends JFrame{
	private static final long serialVersionUID = 431281611636634328L;
	public static final int fw = 1000;
	public static final int fh = 1000;

	public static void main(String[] args) {
		SwingUtilities.invokeLater(() -> new Fractal33(new AxPanel07()));
	}

	Fractal33(JComponent comp){
		setLayout(null);
		setPreferredSize(new Dimension(fw, fh));
		setBounds(
				(Toolkit.getDefaultToolkit().getScreenSize().width / 2)
						- (fw / 2),
				(Toolkit.getDefaultToolkit().getScreenSize().height / 2)
						- (fh / 2),
				fw, fh);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setTitle("Ramka Graficzna");
		setResizable(false);
		JPanel panel = (JPanel) comp;
		panel.setLocation((fw - panel.getWidth()) / 2,
				(fh - panel.getHeight()) / 2);
		add(panel);
		setVisible(true);
	}
}

class AxPanel07 extends JPanel{
	private static final long serialVersionUID = 5218506428064759030L;
	private static final int w = 860;
	private static final int h = 860;
	private static final int offset = 30;
	private final BufferedImage bimage;
	private final WritableRaster raster;
	private final int[] rgb;
	private final int[] tabl = {1, 0, 1, 1};

	public AxPanel07(){
		setPreferredSize(new Dimension(w, h));
		setSize(w, h);
		setBackground(Color.WHITE);
		bimage = new BufferedImage(w, h, BufferedImage.TYPE_INT_ARGB);
		raster = bimage.getRaster();
		rgb = new int[4];
	}

	@Override
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2.drawRect(offset, offset, w - 2 * offset, h - 2 * offset);
		Ax diag1 = new Ax(0, 0, w - 2 * offset, h - 2 * offset, 0, 0, 4, 4, g2,
				0.5f, 0.25f, offset);
		diag1.drawGrid(Color.LIGHT_GRAY);
		double lambda = 0f;
		float rx = 0f;
		float ry = 0f;
		double lap;
		Color color = null;
		for(int x = 0; x < w - 2 * offset; x++){
			rx = diag1.getRzut().getRX(x);
			for(int y = 0; y < h - 2 * offset; y++){
				ry = diag1.getRzut().getRY(y);
				lap = (float)FractalUtil.lapunow(rx, ry, tabl, 100);
				lambda = 550 + lap * 50;
				color = ColorUtil.lambdaToColor(lambda);
				rgb[0] = color.getRed();
				rgb[1] = color.getGreen();
				rgb[2] = color.getBlue();
				rgb[3] = color.getAlpha();
				raster.setPixel(x + offset, y + offset, rgb);
			}
		}
		g2.drawImage(bimage, 0, 0, this);
	}
}
