package math.axes;

import math.utils.Util;

import javax.swing.*;
import java.awt.*;

class Axes01 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Axes01(new CartesianAxPanel()));
    }

    private Axes01(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(Util.W1000, Util.H1000));
        setBounds(
                (Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (Util.W1000 / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (Util.H1000 / 2),
                Util.W1000, Util.H1000);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        JPanel panel = (JPanel) comp;
        panel.setLocation((Util.W1000 - panel.getWidth()) / 2,
                (Util.H1000 - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}
