package math.stat;

import math.color.ColorUtil;
import math.utils.MathUtil;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;

public class ApplePie extends JPanel {
    private static final long serialVersionUID = 1085058639034853104L;
    private static final int w = 600;
    private static final int h = 600;
    private final int len;
    private int[] colors2;
    private Rectangle2D bounds;
    private double[] angles;
    private final int diameter;
    private final double[] data;
    private final String[] labels;
    private int xx;
    private int yy;
    private Font font;

    public ApplePie(int diameter, double[] data, String[] labels) {
        this.diameter = diameter;
        this.data = data;
        this.labels = labels;
        len = data.length;
        int len1 = labels.length;
        if (len != len1) {
            throw new IllegalArgumentException(
                    "długości tablic muszą być równe");
        }
        for (double datum : data) {
            if (datum < 0) {
                throw new IllegalArgumentException("liczby nie mogą być ujemne");
            }
        }
        colors2 = MathUtil.withoutReturn(len, ColorUtil.apcolors.length, false);
        int x = (w - diameter) / 2;
        int y = (h - diameter) / 2;
        xx = x + diameter / 2;//srodek tortu
        yy = y + diameter / 2;//srodek tortu;
        bounds = new Rectangle2D.Double(x, y, diameter, diameter);
        angles = MathUtil.doubleToAngle(data);
        int fs = (int) (0.02 * diameter + 5.0);
        font = new Font(Font.SANS_SERIF, Font.PLAIN, fs);
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawRect(0, 0, w - 1, h - 1);
        Arc2D arc = null;
        Rectangle2D r2d = null;
        double kat = 0.0;
        double katS = 0.0;//kąt dla napisu
        int xxx = 10;
        int yyy = 10;
        int ww = 10;
        int hh = 10;
        g2.setFont(font);
        FontMetrics fm = g2.getFontMetrics(font);
        for (int i = 0; i < len; i++) {
            arc = new Arc2D.Double(bounds, kat, angles[i], Arc2D.PIE);
            r2d = new Rectangle2D.Double(xxx, yyy, ww, hh);
            g2.setColor(ColorUtil.apcolors[colors2[i] - 1]);
            g2.fill(arc);
            g2.fill(r2d);
            kat += angles[i];
            katS = -kat + angles[i] / 2;
            int xxS = xx
                    + (int) ((diameter / 2.5) * 0.8 * Math.cos(Math
                    .toRadians(katS)));
            int yyS = yy
                    + (int) ((diameter / 2.5) * 0.8 * Math.sin(Math
                    .toRadians(katS)));
            g2.setColor(Color.BLACK);
            g2.drawString(labels[i] + " " + data[i] + "%", xxx + 30, yyy + 10);
            g2.setXORMode(Color.WHITE);
            g2.drawString(String.valueOf(data[i]),
                    xxS - (int) (0.5 * fm.stringWidth("" + data[i])), yyS
                            + (int) (0.5 * fm.getHeight()));
            yyy += 20;
            g2.setPaintMode();
        }
    }
}
