package math.functions;

import math.axes.*;

import javax.swing.*;
import java.awt.*;

class Funct10 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Funct10(new AxPanel10()));
    }

    Funct10(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class AxPanel10 extends JPanel {
    private static final long serialVersionUID = 5218506428064759030L;
    private static final int w = 860;
    private static final int h = 860;
    private static final int offset = 40;

    public AxPanel10() {
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        //--
        //g2.drawRect(0 + offset, 0 + offset, 250, 250);
        Ax diag1 = new Ax(0, 0, 250, 250, 0, 0, 10, 200, g2, 1, 20, offset);
        diag1.drawTitle("Wyrazy ciągu: 2n^2-n+1");
        diag1.drawGrid(Color.LIGHT_GRAY);
        diag1.drawAx(Color.BLACK, Color.BLACK);
        for (float i = 0f; i < 11f; i++) {
            diag1.fillPoint(i, (2 * i * i) - i + 1, 5, PShape.Circle,
                    Color.GREEN);
        }
        diag1.drawXLegend(true);
        diag1.drawYLegend(true);
    }
}