package math.complex;

import javax.swing.*;
import java.awt.*;

public class Complex16 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            Complex c = new Complex(2, 3, CType.Normal);
            Complex c1 = c.recip();
            Complex[] tab = {c1, c};
            System.out.println(tab[0].toString(CType.Trigo));
            System.out.println(tab[1].toString(CType.Trigo));
            new Complex16(new ComplexPanel(tab, true, CType.Trigo));
        });
    }

    public Complex16(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}
