package math.complex;

import javax.swing.*;
import java.awt.*;

public class Complex07 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            Complex c1 = new Complex(2, 3, CType.Normal);
            Complex c2 = new Complex(3, -3, CType.Normal);
            Complex c = c1.div(c2);
            Complex[] tab = {new Complex(c), new Complex(c1),
                    new Complex(c2)};
            new Complex07(new ComplexPanel(tab, true, CType.Normal));
        });
    }

    public Complex07(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}
