package math.axes;

import math.shapes.Arrow;
import math.utils.Util;

import javax.swing.*;
import java.awt.*;

public class CartesianAxPanel extends JPanel {
    private static final long serialVersionUID = 5218506428064759030L;
    private static final Stroke B_STROKE = new BasicStroke(1f,
            BasicStroke.CAP_BUTT, BasicStroke.JOIN_BEVEL);
    private static final Font FONT = new Font("Dialog", Font.PLAIN, 14);
    private static final Font AX_FONT = new Font("Dialog", Font.PLAIN, 8);
    private static final float M = 30f;

    public CartesianAxPanel() {
        setPreferredSize(new Dimension(Util.W800, Util.H800));
        setSize(Util.W800, Util.H800);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawRect(0, 0, Util.W800 - 1, Util.H800 - 1);
        g2.setStroke(B_STROKE);
        g2.setColor(Color.BLACK);
        g2.setFont(FONT);
        //========================== draw XY axes
        g2.drawString("X", Util.W800 - 40f, ((Util.H800 - 30f) / 2f) + 5f);
        g2.drawString("-X", 30f, ((Util.H800 - 30f) / 2f) + 5f);
        g2.drawString("Y", (Util.W800 / 2f) - 5f, 25f);
        g2.drawString("-Y", (Util.W800 / 2f) - 9, Util.H800 - 45);
        Arrow xl = new Arrow(Util.W800 / 2f, (Util.H800 - 30f) / 2f, Util.H800 / 2.0f - 50f, 1f, 180f,
                15f, 10f, true);
        g2.fill(xl);
        Arrow xr = new Arrow(Util.W800 / 2f, (Util.H800 - 30f) / 2f, Util.H800 / 2.0f - 50f, 1f, 0f, 15f,
                10f, true);
        g2.fill(xr);
        Arrow yt = new Arrow(Util.W800 / 2f, (Util.H800 - 30f) / 2f, Util.H800 / 2.0f - 50f, 1f, 90f, 15f,
                10f, true);
        g2.fill(yt);
        Arrow yb = new Arrow(Util.W800 / 2f, (Util.H800 - 30f) / 2f, Util.H800 / 2.0f - 50f, 1f, 270f,
                15f, 10f, true);
        g2.fill(yb);
        //-------------------------- draw digits on X ax
        g2.setColor(Color.BLACK);
        g2.setFont(AX_FONT);
        for (int i = 0; i < 11; i++) {
            g2.drawString(String.valueOf(i), Util.W800 / 2f + i * M - 2f,
                    ((Util.H800 - 30f) / 2f) + 12f);
        }
        for (int i = 10; i > 0; i--) {
            g2.drawString(String.valueOf(-i), 99 + (10 - i) * M,
                    ((Util.H800 - 30f) / 2f) + 12f);
        }
        //------------------------- draw digits on ax Y
        for (int j = 0; j < 11; j++) {
            g2.drawString(String.valueOf(j), (Util.W800 / 2f) - 12, ((Util.H800 - 30) / 2f) - j
                    * M + 3f);
        }
        for (int j = 10; j > 0; j--) {
            g2.drawString(String.valueOf(-j), (Util.W800 / 2f) - 12, ((Util.H800 - 30) / 2f)
                    + j * M);
        }
        g2.setFont(new Font(Font.DIALOG, Font.PLAIN, 10));
    }
}