package math.utils;

import java.lang.reflect.InvocationTargetException;
import java.sql.*;

/**
 * @author Jacek Piechota
 * @email vollys@vollys.pl
 * @www http://vollys.pl
 * @since 19.10.2011
 * Klasa DerbyUtil do typu 'Tablica'
 */
public class DerbyUtil {
    private DerbyUtil() {
    }


    /**
     * Startuje DerbyEngine. Jeśi załadowano Embedded Driver można
     * od razu połączyć się z bazą danych. Jeśli załadowano ClientDriver
     * aby połączyć się z bazą danych należy wcześniej uruchomić NetworkServer
     * na tym lub zdalnym komputerze (w zależności gdzie znajduje się baza
     * danych). Jeśli baza danych znajduje się na innym komputerze to
     * połączenie z nią jest możliwe o ile na komputerze z bazą
     * zostaną ustawione odpowiednie prawa dostępu. Jeżeli nie zostaną
     * ustawione możliwe jest połączenie tylko z tego komputera, na którym
     * baza się znajduje
     */
    public static boolean startDerbyEngine(String driverName) {
        boolean started = false;
        loadDBDriver(driverName);
        started = true;
        return started;
    }

    /**
     * Tworzy połaczenie z bazą danych dołączając String z właściwościami
     */
    public static Connection connectLocalDB(String dbName, String properties) {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection("jdbc:derby:" + dbName + ";"
                    + properties);
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return conn;
    }

    private static boolean loadDBDriver(String driverName)
            throws IllegalArgumentException {
        if (driverName.equals("EmbeddedDriver")
                || driverName.equals("ClientDriver")) {
            try {
                try {
                    Class.forName("org.apache.derby.jdbc." + driverName).getConstructor()
                            .newInstance();
                } catch (InstantiationException | IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
                    e.printStackTrace();
                }
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
                return false;
            }
        } else {
            throw new IllegalArgumentException("Niewłaściwa nazwa sterownika");
        }
        return true;
    }

    public static boolean close(Connection conn) {
        boolean closed = false;
        if (conn != null) {
            try {
                conn.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        closed = true;
        return closed;
    }

    public static boolean close(PreparedStatement pstat) {
        boolean closed = false;
        if (pstat != null) {
            try {
                pstat.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        closed = true;
        return closed;
    }

    public static boolean close(ResultSet rs) {
        boolean closed = false;
        if (rs != null) {
            try {
                rs.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        closed = true;
        return closed;
    }

    public static boolean close(Statement stat) {
        boolean closed = false;
        if (stat != null) {
            try {
                stat.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        closed = true;
        return closed;
    }

    /**
     * Zamyka DerbyEngine i wszystkie bazy danych
     */
    public static boolean shutdownDerbyEngine() {
        boolean shutted = false;
        boolean gotSQLExc = false;
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        } catch (SQLException se) {
            if (se.getSQLState().equals("XJ015")) {
                gotSQLExc = true;
            }
        }
        shutted = gotSQLExc;
        return shutted;
    }


}
