package math.set;

import java.awt.*;
import javax.swing.*;

public class Sets08 extends JFrame{
	private static final long serialVersionUID = 431281611636634328L;
	public static final int fw = 1000;
	public static final int fh = 1000;

    public static void main(String[] args) {
		SwingUtilities.invokeLater(() -> new Sets08(new Set8()));
	}

	public Sets08(JComponent comp){
		setLayout(null);
		setPreferredSize(new Dimension(fw, fh));
		setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
				- (fw / 2),
				(Toolkit.getDefaultToolkit().getScreenSize().height / 2)
						- (fh / 2), fw, fh);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setTitle("Ramka Graficzna");
		//	setResizable(false);
        JPanel panel = (JPanel) comp;
		panel.setLocation((fw - panel.getWidth()) / 2,
				(fh - panel.getHeight()) / 2);
		add(panel);
		setVisible(true);
	}
}

class Set8 extends JPanel{
	private static final long serialVersionUID = 5218506428064759030L;
	private static final int w = 800;
	private static final int h = 800;

	public Set8(){
		setPreferredSize(new Dimension(w, h));
		setSize(w, h);
		setBackground(Color.WHITE);
	}

	@Override
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2.drawRect(0, 0, w - 1, h - 1);
		g2.setColor(new Color(51, 0, 153, 204));
		g2.fillOval(100, 100, 150, 150);
	}
}